/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.checker.core.object;

import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import org.eclipse.dd.ipxact.checker.core.object.SpiritNode;
import org.eclipse.dd.ipxact.checker.core.utils.Utilities;
import org.w3c.dom.Node;

public class ComponentSignal
extends SpiritNode {
    private String direction = this.evaluate("spirit:direction");
    private Node left;
    private Node right;
    private int width;
    private String strength;
    private String defaultValue;

    public ComponentSignal(XPath evaluator, Node node) throws XPathExpressionException {
        super(evaluator, node);
        this.left = (Node)evaluator.evaluate("spirit:left", node, XPathConstants.NODE);
        this.right = (Node)evaluator.evaluate("spirit:right", node, XPathConstants.NODE);
        this.strength = this.evaluate(".//spirit:strength");
        this.defaultValue = this.evaluate("spirit:defaultValue/spirit:value");
        this.width = Utilities.getSignalWidth(this.getLeft(), this.getRight());
    }

    public String getDirection() {
        return this.direction;
    }

    public String getLeft() {
        if (this.left == null) {
            return null;
        }
        return this.left.getTextContent().trim();
    }

    public String getRight() {
        if (this.right == null) {
            return null;
        }
        return this.right.getTextContent().trim();
    }

    public int getWidth() {
        return this.width;
    }

    public String getDefaultValue() {
        return this.defaultValue;
    }

    public String getStrength() {
        return this.strength;
    }
}

