/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.util.Set;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathFactory;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.schema.NamespaceContextHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public abstract class SpiritDocument {
    public static final String SPIRIT_NS_PREFIX = "spirit";
    public static final String SPIRIT_NS_PREFIX_COLON = "spirit:";
    protected Document base;
    private String schemaUri;
    private static XPathFactory xpathFactory = XPathFactory.newInstance();

    public abstract String getRootTagName();

    protected void setBaseDocument(Document d) {
        this.base = d;
        this.schemaUri = SpiritDocument.getSchemaURI(this.base);
    }

    public Document getBaseDocument() {
        return this.base;
    }

    public String[] attributeValueSuggestions(Node node, String attribute) {
        if (attribute.endsWith(":vendor")) {
            Set<String> vendors = SpiritLibrary.getDefault().getVendors();
            return vendors.toArray(new String[0]);
        }
        if (attribute.endsWith(":library")) {
            NamedNodeMap attributes;
            Node vendorAttribute;
            while (node != null && node.getNodeType() != 1) {
                node = node.getParentNode();
            }
            if (node != null && (vendorAttribute = (attributes = node.getAttributes()).getNamedItem(node.getPrefix() + ":vendor")) != null) {
                Set<String> libraries = SpiritLibrary.getDefault().getLibraries(vendorAttribute.getNodeValue());
                return libraries.toArray(new String[0]);
            }
        } else if (attribute.endsWith(":name")) {
            while (node != null && node.getNodeType() != 1) {
                node = node.getParentNode();
            }
            if (node != null) {
                NamedNodeMap attributes = node.getAttributes();
                Node vendorAttribute = attributes.getNamedItem(node.getPrefix() + ":vendor");
                Node libraryAttribute = attributes.getNamedItem(node.getPrefix() + ":library");
                if (vendorAttribute != null && libraryAttribute != null) {
                    Set<String> names = SpiritLibrary.getDefault().getNames(vendorAttribute.getNodeValue(), libraryAttribute.getNodeValue());
                    return names.toArray(new String[0]);
                }
            }
        } else if (attribute.endsWith(":version")) {
            while (node != null && node.getNodeType() != 1) {
                node = node.getParentNode();
            }
            if (node != null) {
                NamedNodeMap attributes = node.getAttributes();
                Node vendorAttribute = attributes.getNamedItem(node.getPrefix() + ":vendor");
                Node libraryAttribute = attributes.getNamedItem(node.getPrefix() + ":library");
                Node nameAttribute = attributes.getNamedItem(node.getPrefix() + ":name");
                if (vendorAttribute != null && libraryAttribute != null && nameAttribute != null) {
                    Set<String> versions = SpiritLibrary.getDefault().getVersions(vendorAttribute.getNodeValue(), libraryAttribute.getNodeValue(), nameAttribute.getNodeValue());
                    return versions.toArray(new String[0]);
                }
            }
        }
        return new String[0];
    }

    public Vlnv getVlnv() {
        return Vlnv.getVlnvForXmlDocument(this.base);
    }

    public void setVlnv(Vlnv vlnv) {
        Element e = this.base.getDocumentElement();
        String[] vlnv_elements = new String[]{vlnv.getVendor(), vlnv.getLibrary(), vlnv.getName(), vlnv.getVersion()};
        int ecount = 0;
        block0: for (Node n = e.getFirstChild(); n != null && ecount < 4; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            for (int i = 0; i < 4; ++i) {
                if (!n.getNodeName().equals(n.getPrefix() + Vlnv.VLNV_TAG_NAMES[i])) continue;
                Node t = n.getFirstChild();
                while (t.getNodeType() != 3) {
                    t = t.getNextSibling();
                }
                t.setNodeValue(vlnv_elements[i]);
                ++ecount;
                continue block0;
            }
        }
    }

    public String getSchemaURI() {
        if (this.schemaUri == null) {
            this.schemaUri = SpiritDocument.getSchemaURI(this.base);
        }
        return this.schemaUri;
    }

    public static String getSchemaURI(Document doc) {
        String uri = null;
        Element e = doc.getDocumentElement();
        if (e != null) {
            uri = e.getNamespaceURI();
        }
        return uri;
    }

    public Element getDocumentElement() {
        return this.base.getDocumentElement();
    }

    public XPath createXPath() {
        XPath xpath = xpathFactory.newXPath();
        NamespaceContextHelper context = new NamespaceContextHelper(SPIRIT_NS_PREFIX, this.getSchemaURI());
        xpath.setNamespaceContext(context);
        return xpath;
    }

    public static XPath createXPath(String namespaceUri) {
        XPath xpath = xpathFactory.newXPath();
        NamespaceContextHelper context = new NamespaceContextHelper(SPIRIT_NS_PREFIX, namespaceUri);
        xpath.setNamespaceContext(context);
        return xpath;
    }

    public static Element getFirstElementByTagNameNS(Element element, String namespaceURI, String localName) {
        Node node;
        NodeList nodeList = element.getElementsByTagNameNS(namespaceURI, localName);
        if (nodeList.getLength() > 0 && 1 == (node = nodeList.item(0)).getNodeType()) {
            return (Element)node;
        }
        return null;
    }

    public String toString() {
        return String.valueOf(this.getVlnv());
    }
}

