/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.document;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Comparator;
import org.eclipse.dd.ipxact.editor.core.Messages;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class Vlnv
implements Comparable {
    public static final int VENDOR = 1;
    public static final int LIBRARY = 2;
    public static final int NAME = 3;
    public static final int VERSION = 4;
    static final String[] VLNV_TAG_NAMES = new String[]{":vendor", ":library", ":name", ":version"};
    private static final String VLNV_SEPARATOR = ":";
    private final String vendor;
    private final String library;
    private final String name;
    private final String version;
    private final int hashCode;

    public Vlnv(String vlnv) {
        this(vlnv.split(VLNV_SEPARATOR));
    }

    public Vlnv(String vendor, String library, String name, String version) {
        this.vendor = vendor;
        this.library = library;
        this.name = name;
        this.version = version;
        this.hashCode = this.toString().hashCode();
    }

    public Vlnv(String[] items) {
        this(items[0], items[1], items[2], items[3]);
    }

    public Vlnv(Element componentRef) {
        String namespace = SpiritDocument.getSchemaURI(componentRef.getOwnerDocument());
        this.vendor = this.safeGetAttributeNS(componentRef, namespace, "vendor");
        this.library = this.safeGetAttributeNS(componentRef, namespace, "library");
        this.name = this.safeGetAttributeNS(componentRef, namespace, "name");
        this.version = this.safeGetAttributeNS(componentRef, namespace, "version");
        this.hashCode = this.toString().hashCode();
    }

    private String safeGetAttributeNS(Element element, String namespace, String attributeName) {
        String value = null;
        try {
            value = element.getAttributeNS(namespace, attributeName);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (value == null) {
            value = "";
        }
        return value;
    }

    public Vlnv(DataInputStream dataIn) throws IOException {
        this.vendor = dataIn.readUTF();
        this.library = dataIn.readUTF();
        this.name = dataIn.readUTF();
        this.version = dataIn.readUTF();
        this.hashCode = this.toString().hashCode();
    }

    public void write(DataOutputStream dataOut) throws IOException {
        dataOut.writeUTF(this.getVendor());
        dataOut.writeUTF(this.getLibrary());
        dataOut.writeUTF(this.getName());
        dataOut.writeUTF(this.getVersion());
    }

    public String getVlnvPartForType(int typeToGet) {
        switch (typeToGet) {
            case 1: {
                return this.vendor;
            }
            case 2: {
                return this.library;
            }
            case 3: {
                return this.name;
            }
            case 4: {
                return this.version;
            }
        }
        return this.toString();
    }

    public String getLibrary() {
        return this.library;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public String getVersion() {
        return this.version;
    }

    public boolean equals(Object other) {
        if (other instanceof Vlnv) {
            return this.hashCode == ((Vlnv)other).hashCode;
        }
        return false;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public int compareTo(Object otherObject) {
        Vlnv other = (Vlnv)otherObject;
        int result = this.vendor.compareTo(other.vendor);
        if (result == 0 && (result = this.library.compareTo(other.library)) == 0 && (result = this.name.compareTo(other.name)) == 0) {
            result = this.version.compareTo(other.version);
        }
        return result;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(this.vendor).append(VLNV_SEPARATOR);
        sb.append(this.library).append(VLNV_SEPARATOR);
        sb.append(this.name).append(VLNV_SEPARATOR);
        sb.append(this.version);
        return sb.toString();
    }

    public void addAttributesToXmlElement(Element parentElement) {
        Document ownerDoc = parentElement.getOwnerDocument();
        String namespace = SpiritDocument.getSchemaURI(ownerDoc);
        String prefix = ownerDoc.getDocumentElement().getPrefix();
        parentElement.setAttributeNS(namespace, prefix + ":version", this.version);
        parentElement.setAttributeNS(namespace, prefix + ":library", this.library);
        parentElement.setAttributeNS(namespace, prefix + ":name", this.name);
        parentElement.setAttributeNS(namespace, prefix + ":vendor", this.vendor);
    }

    public void addElementsToXmlElement(Element parentElement) {
        Document ownerDoc = parentElement.getOwnerDocument();
        String namespace = SpiritDocument.getSchemaURI(ownerDoc);
        String prefix = ownerDoc.getDocumentElement().getPrefix();
        Element e = ownerDoc.createElementNS(namespace, prefix + ":version");
        e.appendChild(ownerDoc.createTextNode(this.version));
        parentElement.appendChild(e);
        e = ownerDoc.createElementNS(namespace, prefix + ":library");
        e.appendChild(ownerDoc.createTextNode(this.library));
        parentElement.appendChild(e);
        e = ownerDoc.createElementNS(namespace, prefix + ":name");
        e.appendChild(ownerDoc.createTextNode(this.name));
        parentElement.appendChild(e);
        e = ownerDoc.createElementNS(namespace, prefix + ":vendor");
        e.appendChild(ownerDoc.createTextNode(this.vendor));
        parentElement.appendChild(e);
    }

    public static Vlnv getVlnvForXmlDocument(Document doc) {
        Element e = doc.getDocumentElement();
        String[] vlnv_elements = new String[4];
        int ecount = 0;
        block0: for (Node n = e.getFirstChild(); n != null && ecount < 4; n = n.getNextSibling()) {
            if (n.getNodeType() != 1) continue;
            for (int i = 0; i < 4; ++i) {
                Node t;
                if (vlnv_elements[i] != null || !n.getNodeName().equals(n.getPrefix() + VLNV_TAG_NAMES[i])) continue;
                for (t = n.getFirstChild(); t != null && t.getNodeType() != 3; t = t.getNextSibling()) {
                }
                vlnv_elements[i] = t != null ? t.getNodeValue() : Messages.Vlnv_Unset;
                ++ecount;
                continue block0;
            }
        }
        return ecount < 4 ? null : new Vlnv(vlnv_elements);
    }

    public static class VlnvComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            return ((Vlnv)o1).compareTo(o2);
        }
    }
}

