/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.object;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.object.AbstractBusType;
import org.eclipse.dd.ipxact.editor.core.object.MonitorType;
import org.eclipse.dd.ipxact.editor.core.object.SpiritObject;
import org.eclipse.dd.ipxact.editor.core.object.SpiritSignal;
import org.eclipse.dd.ipxact.editor.core.object.SpiritSignalName;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritBusInterface
extends SpiritObject {
    private String instanceName;
    private Vlnv componentId;
    private List<SpiritSignalName> signalMap = new ArrayList<SpiritSignalName>();
    private AbstractBusType busTypeObject;
    private boolean isConnectionRequired;
    private boolean isCreateSignalMapEnabled;
    private String componentSignalPrefix;
    private List<SpiritSignal> busDefSignals;

    @Override
    protected Element createNewNode(Document document) {
        Element newRootNode = null;
        newRootNode = document.createElement("spirit:busInterface");
        Element e = document.createElement("spirit:name");
        Text text = document.createTextNode(this.instanceName);
        e.appendChild(text);
        newRootNode.appendChild(e);
        if (this.componentId != null) {
            e = document.createElement("spirit:busType");
            this.componentId.addAttributesToXmlElement(e);
            newRootNode.appendChild(e);
        }
        if (this.busTypeObject != null) {
            e = this.busTypeObject.getXMLRootNode(document);
            newRootNode.appendChild(e);
        }
        e = document.createElement("spirit:connection");
        text = document.createTextNode(this.isConnectionRequired ? "required" : "explicit");
        e.appendChild(text);
        newRootNode.appendChild(e);
        if (this.signalMap.size() > 0 && this.busTypeObject != null) {
            Element signalMapNode = document.createElement("spirit:signalMap");
            int busType = this.busTypeObject.getBusType();
            if (3 == busType) {
                MonitorType monitorType = (MonitorType)this.busTypeObject;
                busType = monitorType.getInterfaceType().getBusType();
            }
            for (SpiritSignalName signalName : this.signalMap) {
                String direction;
                SpiritSignal busDefSignal = signalName.getBusDefSignal();
                SpiritSignal.SignalInfo signalInfo = busDefSignal.getSignalInfo(busType);
                if (signalInfo == null || signalInfo.direction != null && "illegal".equals(direction = signalInfo.direction)) continue;
                signalMapNode.appendChild(signalName.createNewNode(document));
            }
            newRootNode.appendChild(signalMapNode);
        }
        return newRootNode;
    }

    public void setInstanceName(String name) {
        this.instanceName = name;
    }

    public List<SpiritSignal> getBusDefSignals() {
        return this.busDefSignals;
    }

    public void setVlnv(Vlnv sourceDocId) {
        this.componentId = sourceDocId;
    }

    public Vlnv getVlnv() {
        return this.componentId;
    }

    public void addSignalsFromBusDefinition() {
        SpiritDocument doc;
        if (this.isCreateSignalMapEnabled && (doc = SpiritLibrary.getDefault().get(this.componentId)) instanceof SpiritBusDefinitionDocument) {
            if (this.componentSignalPrefix == null) {
                this.componentSignalPrefix = "";
            }
            SpiritBusDefinitionDocument busDoc = (SpiritBusDefinitionDocument)doc;
            this.busDefSignals = busDoc.getSignals();
            int busType = this.busTypeObject.getBusType();
            if (3 == busType) {
                MonitorType monitorType = (MonitorType)this.busTypeObject;
                busType = monitorType.getInterfaceType().getBusType();
            }
            for (SpiritSignal thisSignal : this.busDefSignals) {
                if (thisSignal.getSignalInfo(busType) == null) continue;
                this.signalMap.add(new SpiritSignalName(thisSignal, this.componentSignalPrefix));
            }
        }
    }

    public void setBusTypeObject(AbstractBusType spiritObject) {
        this.busTypeObject = spiritObject;
    }

    public AbstractBusType getBusTypeObject() {
        return this.busTypeObject;
    }

    public void setConnectionRequired(boolean connectionRequired) {
        this.isConnectionRequired = connectionRequired;
    }

    public void setCreateSignalMapEnabled(boolean isCreateSignalMapEnabled) {
        this.isCreateSignalMapEnabled = isCreateSignalMapEnabled;
    }

    public void setComponentSignalPrefix(String componentModelSignalPrefix) {
        this.componentSignalPrefix = componentModelSignalPrefix;
    }

    public String getComponentSignalPrefix() {
        return this.componentSignalPrefix;
    }
}

