/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.QualifiedName;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.ipxact.editor.core.Messages;
import org.eclipse.dd.ipxact.editor.core.SpiritCorePlugin;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.IModelChangeListener;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceChangeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritResourceLibrary
extends SpiritLibrary
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final QualifiedName EXCLUDED_RESOURCE_PROPERTY = new QualifiedName("org.eclipse.dd.ipxact.editor.core", "SpiritResourceLibrary.ExcludeResourceProperty");
    private static SpiritResourceLibrary defaultSpiritLibrary;
    private Map<String, File> resourceMap = new HashMap<String, File>();
    private transient ListenerList listeners = new ListenerList();
    private transient IResourceChangeListener resourceChangeListener = new SpiritResourceChangeListener(this);
    private int updateCount = 0;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new ListenerList();
        this.resourceChangeListener = new SpiritResourceChangeListener(this);
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    private SpiritResourceLibrary() {
        ResourcesPlugin.getWorkspace().addResourceChangeListener(this.resourceChangeListener);
    }

    public static SpiritResourceLibrary getDefault() {
        if (defaultSpiritLibrary == null) {
            defaultSpiritLibrary = new SpiritResourceLibrary();
        }
        return defaultSpiritLibrary;
    }

    public static void setDefault(SpiritResourceLibrary library) {
        defaultSpiritLibrary = library;
    }

    public synchronized void addListener(IModelChangeListener listener) {
        this.listeners.add((Object)listener);
    }

    public synchronized void removeListener(IModelChangeListener listener) {
        this.listeners.remove((Object)listener);
    }

    @Override
    protected void fireModelChanged() {
        Object[] currentListeners = this.listeners.getListeners();
        for (int i = 0; i < currentListeners.length; ++i) {
            try {
                ((IModelChangeListener)currentListeners[i]).modelChanged();
                continue;
            }
            catch (Throwable t) {
                SpiritCorePlugin.logError(t);
            }
        }
    }

    @Override
    protected void fireDuplicateAdded(FileDetails fileDetails, FileDetails primaryEntry) {
        Object[] currentListeners = this.listeners.getListeners();
        for (int i = 0; i < currentListeners.length; ++i) {
            try {
                ((IModelChangeListener)currentListeners[i]).duplicateAdded(fileDetails, primaryEntry);
                continue;
            }
            catch (Throwable t) {
                SpiritCorePlugin.logError(t);
            }
        }
    }

    @Override
    protected void fireDuplicateRemoved(FileDetails fileDetails, FileDetails primaryEntry) {
        Object[] currentListeners = this.listeners.getListeners();
        for (int i = 0; i < currentListeners.length; ++i) {
            try {
                ((IModelChangeListener)currentListeners[i]).duplicateRemoved(fileDetails, primaryEntry);
                continue;
            }
            catch (Throwable t) {
                SpiritCorePlugin.logError(t);
            }
        }
    }

    private Vlnv addResource(IResource resource) throws Exception {
        IPath location = resource.getLocation();
        if (location == null) {
            return null;
        }
        File file = location.toFile();
        Vlnv result = this.addFileInternal(file);
        this.resourceMap.put(resource.getFullPath().toString(), file);
        return result;
    }

    private IStatus recreateLibrary(IProgressMonitor monitor) {
        monitor.beginTask(Messages.SpiritLibrary_Update, -1);
        this.resourceMap.clear();
        this.fileMap.clear();
        this.emptyComponentTree();
        this.fireModelChanged();
        class RV
        implements IResourceVisitor {
            private IProgressMonitor monitor;

            public RV(IProgressMonitor m) {
                this.monitor = m;
            }

            public boolean visit(IResource resource) throws CoreException {
                if (resource.exists() && SpiritLibrary.getSpiritFileExtensionList().contains(SpiritLibrary.getExtension(resource.getName()).toLowerCase())) {
                    try {
                        this.monitor.subTask(resource.getFullPath().toString());
                        SpiritResourceLibrary.this.addResource(resource);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                if (this.monitor.isCanceled()) {
                    this.monitor.done();
                    SpiritResourceLibrary.this.decrementUpdateCount();
                    return false;
                }
                return true;
            }
        }
        RV visitor = new RV(monitor);
        try {
            ResourcesPlugin.getWorkspace().getRoot().accept((IResourceVisitor)visitor);
        }
        catch (CoreException coreException) {
            // empty catch block
        }
        if (monitor.isCanceled()) {
            monitor.done();
            this.decrementUpdateCount();
            return Status.CANCEL_STATUS;
        }
        monitor.done();
        this.decrementUpdateCount();
        return Status.OK_STATUS;
    }

    public void update() {
        this.incrementUpdateCount();
        class LibraryUpdateJob
        extends Job {
            public LibraryUpdateJob() {
                super(Messages.SpiritLibrary_LibraryUpdate);
            }

            public IStatus run(IProgressMonitor monitor) {
                return SpiritResourceLibrary.this.recreateLibrary(monitor);
            }
        }
        new LibraryUpdateJob().schedule();
    }

    void update(final List<IResourceDelta> list) {
        this.incrementUpdateCount();
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class LibraryUpdateJob
        extends Job {
            public LibraryUpdateJob() {
                super(Messages.SpiritLibrary_LibraryUpdate);
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask(Messages.SpiritLibrary_Update, list.size());
                for (IResourceDelta delta : list) {
                    IResource resource = delta.getResource();
                    String path = resource.getFullPath().toString();
                    monitor.subTask(path);
                    try {
                        switch (delta.getKind()) {
                            case 2: {
                                SpiritResourceLibrary.this.removeFile((File)SpiritResourceLibrary.this.resourceMap.get(path));
                                SpiritResourceLibrary.this.resourceMap.remove(path);
                                break;
                            }
                            case 1: {
                                SpiritResourceLibrary.this.addResource(resource);
                                break;
                            }
                            case 4: {
                                if ((delta.getFlags() & 0x20000) == 0) {
                                    File f = (File)SpiritResourceLibrary.this.resourceMap.get(path);
                                    SpiritResourceLibrary.this.removeFile(f);
                                    SpiritResourceLibrary.this.addFileInternal(f);
                                }
                                break;
                            }
                            default: {
                                SpiritCorePlugin.logErrorMessage(Messages.SpiritLibrary_Unsupported + delta + Messages.SpiritLibrary_Kind + delta.getKind());
                                break;
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                    monitor.worked(1);
                    if (!monitor.isCanceled()) continue;
                    monitor.done();
                    SpiritResourceLibrary.this.decrementUpdateCount();
                    return Status.CANCEL_STATUS;
                }
                monitor.done();
                SpiritResourceLibrary.this.decrementUpdateCount();
                return Status.OK_STATUS;
            }
        }
        new LibraryUpdateJob().schedule();
    }

    private void removeResource(IResource resource) {
        IPath location;
        if (resource instanceof IContainer) {
            try {
                IContainer c = (IContainer)resource;
                for (IResource child : c.members(true)) {
                    this.removeResource(child);
                }
            }
            catch (CoreException e) {}
        } else if (resource instanceof IFile && SpiritResourceLibrary.isSpiritResource(resource) && (location = ((IFile)resource).getLocation()) != null) {
            this.removeFile(location.toFile());
        }
    }

    void removeProject(IResource resource) {
        this.removeResource(resource);
    }

    public void waitForUpdate() {
        try {
            while (this.updateCount != 0) {
                Thread.sleep(100L);
            }
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private synchronized void incrementUpdateCount() {
        ++this.updateCount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decrementUpdateCount() {
        Thread.yield();
        SpiritResourceLibrary spiritResourceLibrary = this;
        synchronized (spiritResourceLibrary) {
            --this.updateCount;
        }
    }

    public static boolean isSpiritResource(IResource r) {
        String ext = r.getFileExtension();
        if (ext == null) {
            return false;
        }
        return SpiritResourceLibrary.getSpiritFileExtensionList().contains(r.getFileExtension().toLowerCase());
    }
}

