/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.library;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceDelta;
import org.eclipse.core.runtime.IPath;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SpiritResourceChangeListener
implements IResourceChangeListener {
    private final SpiritResourceLibrary spiritResourceLibrary;

    public SpiritResourceChangeListener(SpiritResourceLibrary spiritResourceLibrary) {
        this.spiritResourceLibrary = spiritResourceLibrary;
    }

    public void resourceChanged(IResourceChangeEvent event) {
        IResourceDelta change = event.getDelta();
        if (change != null) {
            List<IResourceDelta> list = this.getChangeList(change, null);
            if (!list.isEmpty()) {
                this.spiritResourceLibrary.update(list);
            }
        } else {
            IPath location;
            IResource resource = event.getResource();
            if (resource instanceof IProject && (location = resource.getLocation()) != null) {
                this.spiritResourceLibrary.removeProject(resource);
            }
        }
    }

    private List<IResourceDelta> getChangeList(IResourceDelta change, List<IResourceDelta> list) {
        IResource resource;
        IResourceDelta[] children;
        if (list == null) {
            list = new ArrayList<IResourceDelta>();
        }
        if ((children = change.getAffectedChildren()) != null && children.length > 0) {
            for (IResourceDelta delta : children) {
                this.getChangeList(delta, list);
            }
        }
        if (SpiritResourceLibrary.isSpiritResource(resource = change.getResource())) {
            list.add(change);
        }
        return list;
    }
}

