/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.w3c.dom.Element;

public class ComponentSignal
extends SpiritNode {
    private Long left;
    private Long right;

    public ComponentSignal(Element node) {
        super(node);
    }

    public String getDirection() {
        return this.getUniqueDescendantText("direction");
    }

    public String getInitiative() {
        return this.getUniqueDescendantText("initiative");
    }

    public long getLeft() {
        if (this.left == null) {
            SpiritNode leftElement = this.getUniqueDescendantElement("left", SpiritNode.class);
            this.left = leftElement == null ? Long.valueOf(0L) : SpiritNode.getIpXactInteger(leftElement);
        }
        return this.left;
    }

    public long getRight() {
        if (this.right == null) {
            SpiritNode rightElement = this.getUniqueDescendantElement("right", SpiritNode.class);
            this.right = rightElement == null ? Long.valueOf(0L) : SpiritNode.getIpXactInteger(rightElement);
        }
        return this.right;
    }

    public long getWidth() {
        return Math.abs(this.getLeft() - this.getRight()) + 1L;
    }

    public String getDefaultValue() {
        return this.getUniqueDescendantText("value");
    }

    public String getStrength() {
        return this.getUniqueDescendantText("strength");
    }

    public SpiritNode getSignalConstraintSets() {
        return this.getUniqueChildElement("signalConstraintSets", SpiritNode.class);
    }

    public SpiritNode getClockDriver() {
        return this.getUniqueDescendantElement("clockDriver", SpiritNode.class);
    }

    public SpiritNode getSingleShotDriver() {
        return this.getUniqueDescendantElement("singleShotDriver", SpiritNode.class);
    }

    public boolean isWireSignal() {
        if (this.schemaVersion() == SchemaInfo.IpxactVersion.BEFORE_V14) {
            return true;
        }
        return this.getUniqueDescendantElement("wire", SpiritNode.class) != null;
    }

    public boolean allLogicalDirectionsAllowed() {
        SpiritNode node = this.getUniqueDescendantElement("wire", SpiritNode.class);
        if (node == null) {
            return false;
        }
        String a = node.getSpiritAttribute("allLogicalDirectionsAllowed");
        return a != null && a.equals("true");
    }

    public boolean allLogicalInitiativesAllowed() {
        SpiritNode node = this.getUniqueDescendantElement("transactional", SpiritNode.class);
        if (node == null) {
            return false;
        }
        String a = node.getSpiritAttribute("allLogicalInitiativesAllowed");
        return a != null && a.equals("true");
    }
}

