/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.spiritnodes;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritNode;
import org.eclipse.dd.ipxact.editor.core.utils.Decode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Field
extends SpiritNode {
    private final int bitOffset;
    private final int bitWidth;
    private final String access;
    private final String description;
    private final List<Long> values = new ArrayList<Long>();

    public Field(Element node) {
        super(node);
        String value;
        NodeList nodeList = this.getDescendants("value");
        int items = nodeList.getLength();
        for (int index = 0; index < items; ++index) {
            value = Field.getTextContent(nodeList.item(index)).trim();
            this.values.add(new Long(Decode.decode(value)));
        }
        value = this.getUniqueDescendantText("bitOffset");
        this.bitOffset = value.length() > 0 ? Integer.parseInt(value) : 0;
        value = this.getUniqueDescendantText("bitWidth");
        this.bitWidth = value.length() > 0 ? Integer.parseInt(value) : 0;
        this.access = this.getUniqueDescendantText("access");
        this.description = this.getUniqueDescendantText("description");
    }

    public String getAccess() {
        return this.access;
    }

    public long getBitOffset() {
        return this.bitOffset;
    }

    public String getDescription() {
        return this.description;
    }

    public List<Long> getValues() {
        return this.values;
    }

    public int getBitWidth() {
        return this.bitWidth;
    }
}

