/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.core.utils;

import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.w3c.dom.Element;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VlnvReferences {
    private static HashMap<String, List<String>> referenceTypes = new HashMap();

    public static Boolean checkReferenceValid(Element source, SpiritDocument target) {
        String linkedType = target.getRootTagName();
        List<String> expectedReferenceTypes = VlnvReferences.getExpectedDocumentTypes(source);
        return expectedReferenceTypes != null && expectedReferenceTypes.contains(linkedType);
    }

    public static List<String> getExpectedDocumentTypes(Element source) {
        String thisType = source.getLocalName();
        List<String> expectedReferenceTypes = referenceTypes.get(thisType);
        if (expectedReferenceTypes == null) {
            String docType = source.getOwnerDocument().getDocumentElement().getLocalName();
            expectedReferenceTypes = referenceTypes.get(thisType + "_" + docType);
        }
        return expectedReferenceTypes;
    }

    public static Boolean isReferenceElement(Element element) {
        if (!referenceTypes.containsKey(element.getLocalName())) {
            return false;
        }
        if (element.getLocalName().equals("componentRef")) {
            return element.getParentNode().getLocalName().equals("componentInstance");
        }
        return true;
    }

    static {
        referenceTypes.put("busType", Arrays.asList("busDefinition"));
        referenceTypes.put("extends", null);
        referenceTypes.put("extends_abstractionDefinition", Arrays.asList("abstractionDefinition"));
        referenceTypes.put("extends_busDefinition", Arrays.asList("busDefinition"));
        referenceTypes.put("designRef", Arrays.asList("design"));
        referenceTypes.put("pmdRef", Arrays.asList("pmd"));
        referenceTypes.put("generatorChainRef", Arrays.asList("generatorChain"));
        referenceTypes.put("owner", Arrays.asList("component"));
        referenceTypes.put("fileName", Arrays.asList("generatorChain"));
        referenceTypes.put("busDefinitionFile", Arrays.asList("busDefinition"));
        referenceTypes.put("componentRef", Arrays.asList("component"));
        referenceTypes.put("hierarchyRef", Arrays.asList("design", "designConfiguration"));
        referenceTypes.put("abstractionType", Arrays.asList("abstractionDefinition"));
        referenceTypes.put("abstractorRef", Arrays.asList("abstractor"));
    }
}

