/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.views;

import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.models.VlnvReferencesModel;
import org.eclipse.dd.ipxact.editor.ui.utils.EditorHelper;
import org.eclipse.dd.ipxact.editor.ui.views.FindUsagesSearchResult;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.ISearchResultListener;
import org.eclipse.search.ui.ISearchResultPage;
import org.eclipse.search.ui.ISearchResultViewPart;
import org.eclipse.search.ui.SearchResultEvent;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.part.Page;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class FindUsagesSearchResultPage
extends Page
implements ISearchResultPage,
ISearchResultListener {
    TreeViewer treeViewer;
    private String id;
    Action gotoItemAction;

    public void createControl(Composite parent) {
        this.treeViewer = new TreeViewer(parent, 66308);
        this.treeViewer.setContentProvider((IContentProvider)new TreeContentProvider());
        this.treeViewer.setLabelProvider((IBaseLabelProvider)new TreeLabelProvider());
        this.makeActions();
        this.createContextMenu();
        this.hookDoubleClickAction();
    }

    private void makeActions() {
        this.gotoItemAction = new Action(Messages.FindUsagesSearchResultPage_GotoItem, null){

            public void run() {
                ISelection selection = FindUsagesSearchResultPage.this.treeViewer.getSelection();
                if (selection instanceof IStructuredSelection) {
                    EditorHelper.openSpecialSelectionInEditor(FindUsagesSearchResultPage.this.getSite().getPage(), ((IStructuredSelection)selection).getFirstElement());
                }
            }
        };
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                FindUsagesSearchResultPage.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.treeViewer.getControl());
        this.treeViewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(this.getID(), menuMgr, (ISelectionProvider)this.treeViewer);
    }

    void fillContextMenu(IMenuManager manager) {
        String GROUP = "content";
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.appendToGroup("content", (IAction)this.gotoItemAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.treeViewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                FindUsagesSearchResultPage.this.gotoItemAction.run();
            }
        });
    }

    public Control getControl() {
        if (this.treeViewer != null) {
            return this.treeViewer.getTree();
        }
        return null;
    }

    public void setFocus() {
        Control control = this.getControl();
        if (control != null && !control.isDisposed()) {
            control.setFocus();
        }
    }

    public Object getUIState() {
        return this.treeViewer.getSelection();
    }

    public void setInput(ISearchResult searchResult, Object uiState) {
        Object oldInput = this.treeViewer.getInput();
        if (oldInput instanceof FindUsagesSearchResult) {
            ((FindUsagesSearchResult)oldInput).removeListener(this);
            this.treeViewer.setSelection(null);
            this.treeViewer.setInput(null);
        }
        if (searchResult instanceof FindUsagesSearchResult) {
            this.treeViewer.setInput((Object)searchResult);
            ((FindUsagesSearchResult)searchResult).addListener(this);
            if (uiState instanceof ISelection) {
                this.treeViewer.setSelection((ISelection)uiState);
            }
        }
    }

    public void dispose() {
        this.setInput(null, null);
        super.dispose();
    }

    public void setViewPart(ISearchResultViewPart part) {
    }

    public void restoreState(IMemento memento) {
    }

    public void saveState(IMemento memento) {
    }

    public void setID(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        Object input = this.treeViewer.getInput();
        if (input instanceof FindUsagesSearchResult) {
            return ((FindUsagesSearchResult)input).getLabel();
        }
        return "";
    }

    public void searchResultChanged(SearchResultEvent e) {
        if (this.treeViewer != null && !this.treeViewer.getTree().isDisposed()) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    FindUsagesSearchResultPage.this.treeViewer.refresh();
                }
            });
        }
    }

    class TreeContentProvider
    extends TreeNodeContentProvider {
        TreeContentProvider() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof FindUsagesSearchResult) {
                SpiritLibrary library = SpiritLibrary.getDefault();
                Map<File, List<VlnvReferencesModel.VlnvReferencesModelElement>> items = ((FindUsagesSearchResult)inputElement).getItems();
                ArrayList<EditorHelper.ResultElement> resultElements = new ArrayList<EditorHelper.ResultElement>(items.size());
                for (Map.Entry<File, List<VlnvReferencesModel.VlnvReferencesModelElement>> entry : items.entrySet()) {
                    File file = entry.getKey();
                    String documentType = "";
                    FileDetails fileDetails = library.getFileDetailsForFile(file);
                    if (fileDetails != null) {
                        documentType = fileDetails.getSpiritDocument().getRootTagName();
                    }
                    EditorHelper.ResultElement resultElement = new EditorHelper.ResultElement(file, entry.getValue(), documentType);
                    resultElements.add(resultElement);
                }
                return resultElements.toArray();
            }
            return new Object[0];
        }

        public Object[] getChildren(Object parentElement) {
            if (parentElement instanceof EditorHelper.ResultElement) {
                return ((EditorHelper.ResultElement)parentElement).list.toArray();
            }
            return null;
        }

        public Object getParent(Object element) {
            if (element instanceof EditorHelper.ParentedList) {
                return ((EditorHelper.ParentedList)element).getParent();
            }
            return null;
        }

        public boolean hasChildren(Object element) {
            if (element instanceof EditorHelper.ResultElement) {
                return !((EditorHelper.ResultElement)element).list.isEmpty();
            }
            return false;
        }
    }

    class TreeLabelProvider
    extends LabelProvider {
        TreeLabelProvider() {
        }

        public Image getImage(Object element) {
            String imageKey = null;
            if (element instanceof EditorHelper.ResultElement) {
                EditorHelper.ResultElement resultElement = (EditorHelper.ResultElement)element;
                String documentType = resultElement.documentType;
                imageKey = "component".equals(documentType) ? "spirit_component.gif" : ("busDefinition".equals(documentType) ? "spirit_bus_def.gif" : ("design".equals(documentType) ? "spirit_design.gif" : "spirit.gif"));
            }
            if (element instanceof VlnvReferencesModel.VlnvReferencesModelElement) {
                imageKey = "element.gif";
            }
            return SpiritUiPlugin.getImage(imageKey);
        }

        public String getText(Object element) {
            if (element instanceof EditorHelper.ResultElement) {
                EditorHelper.ResultElement resultElement = (EditorHelper.ResultElement)element;
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(resultElement.file.getAbsoluteFile());
                int matches = resultElement.list.size();
                if (matches > 1) {
                    stringBuilder.append(" (");
                    stringBuilder.append(matches);
                    stringBuilder.append(Messages.FindUsagesSearchResultPage_BracketMatches);
                }
                return stringBuilder.toString();
            }
            if (element instanceof VlnvReferencesModel.VlnvReferencesModelElement) {
                Element xmlElement = ((VlnvReferencesModel.VlnvReferencesModelElement)element).element;
                String name = null;
                NodeList siblings = xmlElement.getParentNode().getChildNodes();
                int length = siblings.getLength();
                for (int index = 0; index < length; ++index) {
                    Node node = siblings.item(index);
                    String localName = node.getLocalName();
                    if (!"name".equals(localName)) continue;
                    name = node.getTextContent();
                    break;
                }
                StringBuilder stringBuilder = new StringBuilder();
                stringBuilder.append(xmlElement.getNodeName());
                if (name != null) {
                    stringBuilder.append(" [");
                    stringBuilder.append(name);
                    stringBuilder.append(']');
                }
                return stringBuilder.toString();
            }
            return "";
        }
    }
}

