/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.views;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDesignDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.ComponentGroupNode;
import org.eclipse.dd.ipxact.editor.core.library.ComponentNode;
import org.eclipse.dd.ipxact.editor.core.library.FileDetails;
import org.eclipse.dd.ipxact.editor.core.library.IModelChangeListener;
import org.eclipse.dd.ipxact.editor.core.library.LibraryNode;
import org.eclipse.dd.ipxact.editor.core.library.SpiritLibrary;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.dd.ipxact.editor.ui.dnd.LibraryViewDragSource;
import org.eclipse.dd.ipxact.editor.ui.preferences.SpiritPreferencePage;
import org.eclipse.dd.ipxact.editor.ui.utils.EditorHelper;
import org.eclipse.dd.ipxact.editor.ui.views.FindUsages;
import org.eclipse.dd.ipxact.editor.ui.views.PartListenerAdapter;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.GroupMarker;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceNode;
import org.eclipse.jface.preference.IPreferencePage;
import org.eclipse.jface.preference.PreferenceDialog;
import org.eclipse.jface.preference.PreferenceManager;
import org.eclipse.jface.preference.PreferenceNode;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITreeSelection;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeNodeContentProvider;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.IPartListener2;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchPartReference;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.editors.text.ILocationProvider;
import org.eclipse.ui.part.ISetSelectionTarget;
import org.eclipse.ui.part.ViewPart;

public class LibraryView
extends ViewPart
implements ISetSelectionTarget {
    private static final String MEMENTO_LINK_WITH_EDITOR = "linkWithEditor";
    TreeViewer viewer;
    private Action showSpiritPreferencesAction;
    Action editComponentAction;
    Action linkWithEditorAction;
    Action findUsagesAction;
    private SpiritLibrary library;
    private IModelChangeListener modelChangeListener;
    private ISelectionListener selectionListener;
    private IPartListener2 partListener;
    boolean linkWithEditor;

    public void createPartControl(Composite parent) {
        this.viewer = new TreeViewer(parent, 772);
        this.viewer.setContentProvider((IContentProvider)new LibraryTreeContentProvider());
        ILabelDecorator labelDecorator = PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator();
        this.viewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider((ILabelProvider)new ViewLabelProvider(), labelDecorator));
        this.viewer.setSorter(new ViewerSorter());
        this.library = SpiritLibrary.getDefault();
        this.viewer.setInput((Object)this.library.getRoot());
        this.modelChangeListener = new ModelChangeListener();
        this.library.addListener(this.modelChangeListener);
        this.makeActions();
        this.createContextMenu();
        this.hookDoubleClickAction();
        this.contributeToActionBars();
        this.hookDragAndDrop();
        this.getSite().setSelectionProvider((ISelectionProvider)this.viewer);
        this.selectionListener = new ISelectionListener(){

            public void selectionChanged(IWorkbenchPart part, ISelection selection) {
                Object obj;
                boolean enabled = false;
                if (!selection.isEmpty() && selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ComponentNode) {
                    enabled = true;
                }
                LibraryView.this.editComponentAction.setEnabled(enabled);
                LibraryView.this.findUsagesAction.setEnabled(enabled);
            }
        };
        this.getSite().getWorkbenchWindow().getSelectionService().addPostSelectionListener(this.selectionListener);
        this.partListener = new PartListenerAdapter(){

            public void partActivated(IWorkbenchPartReference partRef) {
                this.partChanged(partRef);
            }

            public void partOpened(IWorkbenchPartReference partRef) {
                this.partChanged(partRef);
            }

            private void partChanged(IWorkbenchPartReference partRef) {
                final IWorkbenchPart part = partRef.getPart(false);
                if (part instanceof IEditorPart) {
                    Display.getDefault().asyncExec(new Runnable(){

                        public void run() {
                            LibraryView.this.syncEditor((IEditorPart)part);
                        }
                    });
                }
            }
        };
        this.getSite().getPage().addPartListener(this.partListener);
    }

    public void dispose() {
        if (this.library != null && this.modelChangeListener != null) {
            this.library.removeListener(this.modelChangeListener);
        }
        if (this.selectionListener != null) {
            this.getSite().getWorkbenchWindow().getSelectionService().removePostSelectionListener(this.selectionListener);
        }
        if (this.partListener != null) {
            this.getSite().getPage().removePartListener(this.partListener);
        }
        super.dispose();
    }

    public void init(IViewSite site, IMemento memento) throws PartInitException {
        super.init(site, memento);
        if (memento != null) {
            this.linkWithEditor = String.valueOf(true).equals(memento.getString(MEMENTO_LINK_WITH_EDITOR));
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        memento.putString(MEMENTO_LINK_WITH_EDITOR, String.valueOf(this.linkWithEditor));
    }

    public SpiritDocument[] getSelectedItems() {
        ITreeSelection selection = (ITreeSelection)this.viewer.getSelection();
        TreePath[] selectedPaths = selection.getPaths();
        int nSelectedNodes = selection.size();
        ArrayList<SpiritDocument> selectedComponents = new ArrayList<SpiritDocument>(nSelectedNodes);
        for (int i = 0; i < nSelectedNodes; ++i) {
            TreePath thisPath = selectedPaths[i];
            LibraryNode theComponent = (LibraryNode)thisPath.getLastSegment();
            if (!(theComponent instanceof ComponentNode)) continue;
            selectedComponents.add(((ComponentNode)theComponent).getFileDetails().getSpiritDocument());
        }
        return selectedComponents.toArray(new SpiritDocument[0]);
    }

    private void hookDragAndDrop() {
        new LibraryViewDragSource(this, this.viewer);
    }

    private void makeActions() {
        this.showSpiritPreferencesAction = new Action(Messages.LibraryView_Preferences, SpiritUiPlugin.getImageDescriptor("preferences.gif")){

            public void run() {
                PreferenceManager mgr = new PreferenceManager();
                SpiritPreferencePage page1 = new SpiritPreferencePage();
                mgr.addToRoot((IPreferenceNode)new PreferenceNode("1", (IPreferencePage)page1));
                PreferenceDialog dialog = new PreferenceDialog(LibraryView.this.getViewSite().getShell(), mgr);
                dialog.create();
                dialog.open();
            }
        };
        this.showSpiritPreferencesAction.setToolTipText(Messages.LibraryView_PreferencesTip);
        this.editComponentAction = new Action(Messages.LibraryView_OpenDocument, SpiritUiPlugin.getImageDescriptor("goto_source.gif")){

            public void run() {
                Object obj;
                ISelection selection = LibraryView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ComponentNode) {
                    SpiritDocument spiritDocument = ((ComponentNode)obj).getFileDetails().getSpiritDocument();
                    EditorHelper.openSpiritDocumentInEditor(LibraryView.this.getSite().getPage(), spiritDocument);
                }
            }
        };
        this.editComponentAction.setToolTipText(Messages.LibraryView_OpenDocumentTip);
        this.editComponentAction.setEnabled(false);
        this.findUsagesAction = new Action(Messages.LibraryView_FindUsages, SpiritUiPlugin.getImageDescriptor("search.gif")){

            public void run() {
                Object obj;
                ISelection selection = LibraryView.this.viewer.getSelection();
                if (selection instanceof IStructuredSelection && (obj = ((IStructuredSelection)selection).getFirstElement()) instanceof ComponentNode) {
                    Vlnv vlnv = ((ComponentNode)obj).getFileDetails().getVlnv();
                    FindUsages.find(vlnv);
                }
            }
        };
        this.findUsagesAction.setToolTipText(Messages.LibraryView_FindUsagesTip);
        this.findUsagesAction.setEnabled(false);
        this.linkWithEditorAction = new Action(null, 2){

            public void run() {
                LibraryView.this.linkWithEditor = !LibraryView.this.linkWithEditor;
                LibraryView.this.linkWithEditorAction.setChecked(LibraryView.this.linkWithEditor);
                if (LibraryView.this.linkWithEditor) {
                    LibraryView.this.syncEditor(LibraryView.this.getActiveEditor());
                }
            }
        };
        this.linkWithEditorAction.setImageDescriptor(SpiritUiPlugin.getImageDescriptor("sync_with_editor.gif"));
        this.linkWithEditorAction.setToolTipText(Messages.LibraryView_LinkWithEditorTip);
        this.linkWithEditorAction.setChecked(this.linkWithEditor);
    }

    private void createContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                LibraryView.this.fillContextMenu(manager);
            }
        });
        Menu menu = menuMgr.createContextMenu(this.viewer.getControl());
        this.viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this.viewer);
    }

    void fillContextMenu(IMenuManager manager) {
        String GROUP = "content";
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.appendToGroup("content", (IAction)this.editComponentAction);
        manager.appendToGroup("content", (IAction)this.findUsagesAction);
        manager.appendToGroup("content", (IAction)this.showSpiritPreferencesAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void contributeToActionBars() {
        IActionBars bars = this.getViewSite().getActionBars();
        this.fillLocalToolBar(bars.getToolBarManager());
    }

    private void fillLocalToolBar(IToolBarManager manager) {
        String GROUP = "content";
        manager.add((IContributionItem)new GroupMarker("content"));
        manager.appendToGroup("content", (IAction)this.editComponentAction);
        manager.appendToGroup("content", (IAction)this.findUsagesAction);
        manager.appendToGroup("content", (IAction)this.showSpiritPreferencesAction);
        manager.appendToGroup("content", (IAction)this.linkWithEditorAction);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private void hookDoubleClickAction() {
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                LibraryView.this.editComponentAction.run();
            }
        });
    }

    public void setFocus() {
        this.viewer.getControl().setFocus();
    }

    IEditorPart getActiveEditor() {
        IWorkbenchPage workbenchPage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        if (workbenchPage != null) {
            return workbenchPage.getActiveEditor();
        }
        return null;
    }

    void syncEditor(IEditorPart editorPart) {
        IPath location;
        IEditorInput editorInput;
        ILocationProvider locationProvider;
        if (!this.linkWithEditor) {
            return;
        }
        if (editorPart != null && (locationProvider = (ILocationProvider)(editorInput = editorPart.getEditorInput()).getAdapter(ILocationProvider.class)) != null && (location = locationProvider.getPath((Object)editorInput)) != null) {
            StructuredSelection structuredSelection = new StructuredSelection((Object)location);
            this.selectReveal((ISelection)structuredSelection);
        }
    }

    public void selectReveal(ISelection selection) {
        try {
            Object element;
            if (this.viewer == null || this.viewer.getControl().isDisposed()) {
                return;
            }
            if (selection instanceof IStructuredSelection && (element = ((IStructuredSelection)selection).getFirstElement()) instanceof IPath) {
                IFile iFile = ResourcesPlugin.getWorkspace().getRoot().getFile((IPath)element);
                IPath location = iFile.getLocation();
                File file = location == null ? ((IPath)element).toFile() : location.toFile();
                Vlnv vlnv = SpiritLibrary.getDefault().getVlnvForFile(file);
                if (vlnv != null) {
                    LibraryNode node = SpiritLibrary.getDefault().getNode(vlnv);
                    this.viewer.setSelection((ISelection)new StructuredSelection((Object)node), true);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    class LibraryTreeContentProvider
    extends TreeNodeContentProvider {
        LibraryTreeContentProvider() {
        }

        public Object[] getChildren(Object parentElement) {
            return ((LibraryNode)parentElement).getChildren();
        }

        public Object[] getElements(Object parentElement) {
            return this.getChildren(parentElement);
        }

        public Object getParent(Object element) {
            return ((LibraryNode)element).getParent();
        }

        public boolean hasChildren(Object element) {
            return ((LibraryNode)element).hasChildren();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class ModelChangeListener
    implements IModelChangeListener {
        private static final String DUPLICATE_VLNV_MARKER_ID = "org.eclipse.dd.ipxact.editor.ui.vlnvDuplicateMarker";

        ModelChangeListener() {
        }

        public void modelChanged() {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    if (LibraryView.this.viewer == null || LibraryView.this.viewer.getControl().isDisposed()) {
                        return;
                    }
                    LibraryView.this.viewer.refresh();
                }
            });
        }

        public void duplicateAdded(Vlnv vlnv, File file) {
            try {
                IFile wsFile = FileDetails.getWorkspaceFile((File)file);
                if (wsFile != null) {
                    HashMap<String, Object> attributes = new HashMap<String, Object>();
                    attributes.put("message", Messages.LibraryView_DuplicateVlnv);
                    attributes.put("severity", new Integer(1));
                    attributes.put("location", MessageFormat.format(Messages.LibraryView_Duplicates, file, file));
                    this.createMarker((IResource)wsFile, attributes, DUPLICATE_VLNV_MARKER_ID);
                }
            }
            catch (Exception e) {
                SpiritUiPlugin.logError(e);
            }
        }

        public void duplicateRemoved(Vlnv vlnv, File file) {
            try {
                IFile wsFile = FileDetails.getWorkspaceFile((File)file);
                if (wsFile != null && wsFile.exists()) {
                    wsFile.deleteMarkers(DUPLICATE_VLNV_MARKER_ID, false, 0);
                }
            }
            catch (Exception e) {
                SpiritUiPlugin.logError(e);
            }
        }

        private void createMarker(final IResource resource, final Map<String, Object> attributes, final String markerType) throws CoreException {
            IWorkspaceRunnable r = new IWorkspaceRunnable(){

                public void run(IProgressMonitor monitor) throws CoreException {
                    IMarker marker = resource.createMarker(markerType);
                    marker.setAttributes(attributes);
                }
            };
            resource.getWorkspace().run(r, null, 1, null);
        }
    }

    class ViewLabelProvider
    extends LabelProvider {
        ViewLabelProvider() {
        }

        public String getText(Object obj) {
            LibraryNode node = (LibraryNode)obj;
            return node.getContent();
        }

        public Image getImage(Object obj) {
            String imageKey = null;
            if (obj instanceof ComponentGroupNode) {
                ComponentGroupNode groupNode = (ComponentGroupNode)obj;
                switch (groupNode.getNodeType()) {
                    case 1: {
                        imageKey = "vendor.gif";
                        break;
                    }
                    case 2: {
                        imageKey = "library.gif";
                        break;
                    }
                    case 3: {
                        imageKey = "name.gif";
                    }
                }
            } else if (obj instanceof ComponentNode) {
                ComponentNode componentNode = (ComponentNode)obj;
                SpiritDocument doc = componentNode.getFileDetails().getSpiritDocument();
                imageKey = doc instanceof SpiritBusDefinitionDocument ? "spirit_bus_def.gif" : (doc instanceof SpiritComponentDocument ? "spirit_component.gif" : (doc instanceof SpiritDesignDocument ? "spirit_design.gif" : "spirit.gif"));
            }
            return SpiritUiPlugin.getImage(imageKey);
        }
    }
}

