/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.wizards;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.ipxact.editor.ui.wizards.SpiritWizardsMessages;
import org.eclipse.jface.util.Assert;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolver;
import org.eclipse.wst.common.uriresolver.internal.provisional.URIResolverPlugin;
import org.eclipse.wst.common.uriresolver.internal.util.URIHelper;
import org.eclipse.wst.xml.core.internal.XMLCorePlugin;
import org.eclipse.wst.xml.core.internal.catalog.provisional.ICatalog;
import org.eclipse.wst.xml.core.internal.contentmodel.CMDocument;
import org.eclipse.wst.xml.core.internal.contentmodel.CMElementDeclaration;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNamedNodeMap;
import org.eclipse.wst.xml.core.internal.contentmodel.CMNode;
import org.eclipse.wst.xml.core.internal.contentmodel.ContentModelManager;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMContentBuilderImpl;
import org.eclipse.wst.xml.core.internal.contentmodel.util.DOMWriter;
import org.eclipse.wst.xml.core.internal.contentmodel.util.NamespaceInfo;
import org.eclipse.wst.xml.ui.internal.wizards.NamespaceInfoContentBuilder;
import org.eclipse.wst.xml.ui.internal.wizards.XMLSchemaValidationChecker;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class NewSPIRITGenerator {
    private static final String[] PRELOAD_SCHEMAS = new String[]{"http://www.spiritconsortium.org/XMLSchema/SPIRIT/1.2"};
    protected String grammarURI;
    protected CMDocument cmDocument;
    protected int buildPolicy;
    protected String rootElementName;
    protected String publicId;
    protected String systemId;
    protected String defaultSystemId;
    public List namespaceInfoList;

    public NewSPIRITGenerator() {
        this(null, null);
    }

    public NewSPIRITGenerator(String grammarURI, CMDocument cmDocument) {
        this.grammarURI = grammarURI;
        this.cmDocument = cmDocument;
    }

    public static void preloadSchemas(long delay) {
        class PreloadSchemasJob
        extends Job {
            public PreloadSchemasJob() {
                super("Preload IP-XACT Schemas");
            }

            public IStatus run(IProgressMonitor monitor) {
                monitor.beginTask("Preload", -1);
                if (monitor.isCanceled()) {
                    monitor.done();
                    return Status.CANCEL_STATUS;
                }
                ICatalog catalog = XMLCorePlugin.getDefault().getDefaultXMLCatalog();
                ContentModelManager contentModelManager = ContentModelManager.getInstance();
                for (int index = 0; index < PRELOAD_SCHEMAS.length; ++index) {
                    String schema = PRELOAD_SCHEMAS[index];
                    monitor.subTask(schema);
                    try {
                        String uri = catalog.resolveURI(schema);
                        contentModelManager.createCMDocument(uri, null);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                monitor.done();
                return Status.OK_STATUS;
            }
        }
        new PreloadSchemasJob().schedule(delay);
    }

    public static CMDocument createCMDocument(String uri, String[] errorInfo) {
        String title = null;
        String message = null;
        Vector errorList = new Vector();
        CMDocument cmDocument = null;
        if (URIHelper.isReadableURI((String)uri, (boolean)true)) {
            cmDocument = ContentModelManager.getInstance().createCMDocument(uri, null);
            if (uri.endsWith(".dtd")) {
                if (errorList.size() > 0) {
                    title = SpiritWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
                    message = SpiritWizardsMessages._UI_LABEL_ERROR_DTD_INVALID_INFO;
                }
            } else {
                int globalElementCount;
                XMLSchemaValidationChecker validator = new XMLSchemaValidationChecker();
                if (!validator.isValid(uri)) {
                    title = SpiritWizardsMessages._UI_INVALID_GRAMMAR_ERROR;
                    message = SpiritWizardsMessages._UI_LABEL_ERROR_SCHEMA_INVALID_INFO;
                } else if (cmDocument != null && (globalElementCount = cmDocument.getElements().getLength()) == 0) {
                    title = SpiritWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
                    message = SpiritWizardsMessages._UI_WARNING_MSG_NO_ROOT_ELEMENTS;
                }
            }
        } else {
            title = SpiritWizardsMessages._UI_WARNING_TITLE_NO_ROOT_ELEMENTS;
            message = SpiritWizardsMessages._UI_WARNING_URI_NOT_FOUND_COLON + " " + uri;
        }
        errorInfo[0] = title;
        errorInfo[1] = message;
        return cmDocument;
    }

    private String getUserPreferredCharset() {
        Preferences preference = XMLCorePlugin.getDefault().getPluginPreferences();
        String charSet = preference.getString("outputCodeset");
        return charSet;
    }

    public void createXMLDocument(IFile newFile, String xmlFileName) throws Exception {
        String charset = newFile.getCharset();
        ByteArrayOutputStream outputStream = this.createXMLDocument(xmlFileName, charset);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(outputStream.toByteArray());
        newFile.setContents((InputStream)inputStream, true, true, null);
        inputStream.close();
    }

    private ByteArrayOutputStream createXMLDocument(String xmlFileName, String charset) throws Exception {
        if (charset == null && (charset = this.getUserPreferredCharset()) == null) {
            charset = "UTF-8";
        }
        CMDocument localCmDocument = this.getCMDocument();
        Assert.isNotNull((Object)localCmDocument);
        Assert.isNotNull((Object)this.getRootElementName());
        CMNamedNodeMap nameNodeMap = localCmDocument.getElements();
        CMElementDeclaration cmElementDeclaration = (CMElementDeclaration)nameNodeMap.getNamedItem(this.getRootElementName());
        Document xmlDocument = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument();
        DOMContentBuilderImpl contentBuilder = new DOMContentBuilderImpl(xmlDocument);
        contentBuilder.supressCreationOfDoctypeAndXMLDeclaration = true;
        contentBuilder.setBuildPolicy(this.buildPolicy);
        contentBuilder.setExternalCMDocumentSupport((DOMContentBuilderImpl.ExternalCMDocumentSupport)new MyExternalCMDocumentSupport(this.namespaceInfoList, xmlFileName));
        contentBuilder.createDefaultRootContent(localCmDocument, cmElementDeclaration, this.namespaceInfoList);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        OutputStreamWriter outputStreamWriter = new OutputStreamWriter((OutputStream)outputStream, charset);
        DOMWriter domWriter = new DOMWriter((Writer)outputStreamWriter);
        domWriter.print(xmlDocument, charset, localCmDocument.getNodeName(), NewSPIRITGenerator.getNonWhitespaceString(this.getPublicId()), NewSPIRITGenerator.getNonWhitespaceString(this.getSystemId()));
        outputStream.flush();
        outputStream.close();
        return outputStream;
    }

    public void createNamespaceInfoList() {
        ArrayList result = new ArrayList();
        if (this.cmDocument != null) {
            List properties = (List)this.cmDocument.getProperty("http://org.eclipse.wst/cm/properties/namespaceInfo");
            result.addAll(properties);
            int size = result.size();
            for (int i = 0; i < size; ++i) {
                NamespaceInfo info = (NamespaceInfo)result.get(i);
                if (i == 0) {
                    info.locationHint = this.defaultSystemId;
                    info.setProperty("locationHint-readOnly", (Object)"true");
                }
                info.setProperty("uri-readOnly", (Object)"true");
                info.setProperty("unremovable", (Object)"true");
            }
            NamespaceInfoContentBuilder builder = new NamespaceInfoContentBuilder();
            builder.setBuildPolicy(2);
            builder.visitCMNode((CMNode)this.cmDocument);
            result.addAll(builder.list);
        }
        this.namespaceInfoList = result;
    }

    private boolean isMissingNamespaceLocation() {
        boolean result = false;
        for (NamespaceInfo info : this.namespaceInfoList) {
            if (info.locationHint != null) continue;
            result = true;
            break;
        }
        return result;
    }

    public String[] getNamespaceInfoErrors() {
        String[] errorList = null;
        if (this.namespaceInfoList != null && this.isMissingNamespaceLocation()) {
            String title = SpiritWizardsMessages._UI_LABEL_NO_LOCATION_HINT;
            String message = SpiritWizardsMessages._UI_WARNING_MSG_NO_LOCATION_HINT_1 + " " + SpiritWizardsMessages._UI_WARNING_MSG_NO_LOCATION_HINT_2 + "\n\n" + SpiritWizardsMessages._UI_WARNING_MSG_NO_LOCATION_HINT_3;
            errorList = new String[]{title, message};
        }
        return errorList;
    }

    public void setBuildPolicy(int policy) {
        this.buildPolicy = policy;
    }

    public void setDefaultSystemId(String sysId) {
        this.defaultSystemId = sysId;
    }

    public void setSystemId(String sysId) {
        this.systemId = sysId;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public void setPublicId(String pubId) {
        this.publicId = pubId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public void setGrammarURI(String gramURI) {
        this.grammarURI = gramURI;
    }

    public String getGrammarURI() {
        return this.grammarURI;
    }

    public void setCMDocument(CMDocument cmDoc) {
        this.cmDocument = cmDoc;
    }

    public CMDocument getCMDocument() {
        return this.cmDocument;
    }

    public void setRootElementName(String rootName) {
        this.rootElementName = rootName;
    }

    public String getRootElementName() {
        return this.rootElementName;
    }

    public static String getNonWhitespaceString(String string) {
        String result = null;
        if (string != null && string.trim().length() > 0) {
            result = string;
        }
        return result;
    }

    protected class MyExternalCMDocumentSupport
    implements DOMContentBuilderImpl.ExternalCMDocumentSupport {
        protected List namespaceInfoList1;
        protected URIResolver idResolver;
        protected String resourceLocation;

        protected MyExternalCMDocumentSupport(List namespaceInfoListParam, String resourceLocation) {
            this.namespaceInfoList1 = namespaceInfoListParam;
            this.resourceLocation = resourceLocation;
            this.idResolver = URIResolverPlugin.createResolver();
        }

        public CMDocument getCMDocument(Element element, String namespaceURI) {
            CMDocument result = null;
            if (namespaceURI != null && namespaceURI.trim().length() > 0) {
                String locationHint = null;
                for (NamespaceInfo info : this.namespaceInfoList1) {
                    if (!namespaceURI.equals(info.uri)) continue;
                    locationHint = info.locationHint;
                    break;
                }
                if (locationHint != null) {
                    NewSPIRITGenerator.this.grammarURI = this.idResolver.resolve(this.resourceLocation, locationHint, locationHint);
                    result = ContentModelManager.getInstance().createCMDocument(NewSPIRITGenerator.this.getGrammarURI(), null);
                }
            } else {
                result = NewSPIRITGenerator.this.cmDocument;
            }
            return result;
        }
    }
}

