/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.dnd;

import java.util.Collection;
import org.eclipse.dd.ipxact.editor.core.document.SpiritBusDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritComponentDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.ui.dnd.DragBusDefinitionCommand;
import org.eclipse.dd.ipxact.editor.ui.dnd.DragComponentCommand;
import org.eclipse.dd.ipxact.editor.ui.dnd.SpiritDocumentTransfer;
import org.eclipse.dd.ipxact.editor.ui.dnd.SpiritViewerDropAdapter;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.dnd.DragSourceListener;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropCommand;
import org.eclipse.wst.common.ui.internal.dnd.DragAndDropManager;
import org.eclipse.wst.common.ui.internal.dnd.ObjectTransfer;
import org.eclipse.wst.common.ui.internal.dnd.ViewerDragAdapter;
import org.w3c.dom.Document;

public class SpiritDragAndDropManager
implements DragAndDropManager {
    private static final String SPIRIT_COMPONENT_TYPE = "spirit:component";
    private static final String SPIRIT_DESIGN_TYPE = "spirit:design";
    private TreeViewer fViewer;

    public static void addDragAndDropSupport(TreeViewer viewer) {
        int dndOperations = 7;
        Transfer[] transfers = new Transfer[]{ObjectTransfer.getInstance(), SpiritDocumentTransfer.getInstance()};
        viewer.addDragSupport(dndOperations, transfers, (DragSourceListener)new ViewerDragAdapter((Viewer)viewer));
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new SpiritViewerDropAdapter((Viewer)viewer, new SpiritDragAndDropManager(viewer)));
    }

    public SpiritDragAndDropManager() {
    }

    public SpiritDragAndDropManager(TreeViewer viewer) {
        this.fViewer = viewer;
    }

    public DragAndDropCommand createCommand(Object target, float location, int operations, int operation, Collection source) {
        Object input;
        Object sourceItem;
        DragAndDropCommand result = null;
        if (source.size() == 1 && (sourceItem = source.toArray()[0]) instanceof SpiritDocument && (input = this.fViewer.getInput()) instanceof Document) {
            Document targetDocument = (Document)input;
            String targetDocumentType = targetDocument.getDocumentElement().getNodeName();
            SpiritDocument sourceDocument = (SpiritDocument)sourceItem;
            if (SPIRIT_COMPONENT_TYPE.equals(targetDocumentType) && sourceDocument instanceof SpiritBusDefinitionDocument) {
                return new DragBusDefinitionCommand(target, location, operations, operation, source, this.fViewer);
            }
            if (SPIRIT_DESIGN_TYPE.equals(targetDocumentType) && sourceDocument instanceof SpiritComponentDocument) {
                return new DragComponentCommand(target, location, operations, operation, source, this.fViewer);
            }
        }
        return result;
    }
}

