/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.utils;

import java.io.File;
import java.io.IOException;
import org.eclipse.dd.ipxact.editor.ui.SpiritUiPlugin;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;

public abstract class DialogSettingsHelper {
    private static final String SETTINGS_FILE = "dialog.xml";
    private static IDialogSettings dialogSettings;
    private static File dialogSettingsFile;

    public static IDialogSettings getDialogSettings() {
        if (dialogSettings == null) {
            dialogSettings = new DialogSettings("root");
            try {
                File stateLocation = SpiritUiPlugin.getDefault().getStateLocation().toFile();
                dialogSettingsFile = new File(stateLocation, SETTINGS_FILE);
                dialogSettings.load(dialogSettingsFile.getAbsolutePath());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return dialogSettings;
    }

    public static void saveDialogSettings() {
        try {
            DialogSettingsHelper.getDialogSettings().save(dialogSettingsFile.getAbsolutePath());
        }
        catch (IOException ioe) {
            SpiritUiPlugin.logError(ioe);
        }
    }

    public static IDialogSettings getSection(String sectionName) {
        IDialogSettings section = DialogSettingsHelper.getDialogSettings().getSection(sectionName);
        if (section == null) {
            section = DialogSettingsHelper.getDialogSettings().addNewSection(sectionName);
        }
        return section;
    }
}

