/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.ipxact.editor.ui.wizards;

import java.util.HashMap;
import java.util.List;
import java.util.TreeMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import org.eclipse.dd.ipxact.editor.core.document.SpiritAbstractionDefinitionDocument;
import org.eclipse.dd.ipxact.editor.core.document.SpiritDocument;
import org.eclipse.dd.ipxact.editor.core.document.Vlnv;
import org.eclipse.dd.ipxact.editor.core.library.SpiritResourceLibrary;
import org.eclipse.dd.ipxact.editor.core.object.AbstractBusType;
import org.eclipse.dd.ipxact.editor.core.object.Bridge;
import org.eclipse.dd.ipxact.editor.core.object.BusInterfaceCreator;
import org.eclipse.dd.ipxact.editor.core.object.InterfaceType;
import org.eclipse.dd.ipxact.editor.core.object.MasterType;
import org.eclipse.dd.ipxact.editor.core.object.MirroredMasterType;
import org.eclipse.dd.ipxact.editor.core.object.MirroredSlaveType;
import org.eclipse.dd.ipxact.editor.core.object.MirroredSystemType;
import org.eclipse.dd.ipxact.editor.core.object.MonitorType;
import org.eclipse.dd.ipxact.editor.core.object.SlaveType;
import org.eclipse.dd.ipxact.editor.core.object.SystemType;
import org.eclipse.dd.ipxact.editor.core.schema.SchemaInfo;
import org.eclipse.dd.ipxact.editor.core.spiritnodes.SpiritSignal;
import org.eclipse.dd.ipxact.editor.ui.Messages;
import org.eclipse.dd.ipxact.editor.ui.utils.EditorHelper;
import org.eclipse.dd.ipxact.editor.ui.utils.LayoutHelper;
import org.eclipse.dd.ipxact.editor.ui.wizards.AbstractBusTypeWizardPage;
import org.eclipse.dd.ipxact.editor.ui.wizards.AbstractWizardPage;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.w3c.dom.DOMConfiguration;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.ls.DOMImplementationLS;
import org.w3c.dom.ls.LSSerializer;

public class CreateNewBusInterfaceWizard
extends Wizard {
    private BasicInfoPage basicInfoPage;
    private Document targetDoc;
    private BusInterfaceCreator busInterface;
    private TreeMap<String, AbstractBusTypeWizardPage> busSubtypeMap = new TreeMap();
    private AbstractBusTypeWizardPage busSubTypePage;

    public static boolean addBusToComponent(Shell shell, SpiritDocument targetDoc, SpiritDocument sourceDoc) {
        CreateNewBusInterfaceWizard wizard = new CreateNewBusInterfaceWizard(sourceDoc, targetDoc);
        WizardDialog dlg = new WizardDialog(shell, (IWizard)wizard);
        return 0 == dlg.open();
    }

    public CreateNewBusInterfaceWizard(SpiritDocument sourceDoc, SpiritDocument targetDoc) {
        this.busInterface = new BusInterfaceCreator();
        this.targetDoc = targetDoc.getBaseDocument();
        Vlnv busVlnv = sourceDoc.getVlnv();
        if (sourceDoc instanceof SpiritAbstractionDefinitionDocument) {
            SpiritAbstractionDefinitionDocument absDef = (SpiritAbstractionDefinitionDocument)sourceDoc;
            this.busInterface.setBusType(absDef.getBusType().getVlnvAttribute());
            this.busInterface.setAbstractionType(busVlnv);
        } else {
            this.busInterface.setBusType(busVlnv);
            Vlnv abstractionVlnv = new Vlnv(busVlnv.getVendor(), busVlnv.getLibrary(), busVlnv.getName() + "_rtl", busVlnv.getVersion());
            this.busInterface.setAbstractionType(abstractionVlnv);
        }
    }

    public void addPages() {
        this.setWindowTitle(Messages.CreateNewBusInterfaceWizard_NewBusInterface);
        this.basicInfoPage = new BasicInfoPage();
        this.addPage((IWizardPage)this.basicInfoPage);
        this.addBusSubtype("Master", new MasterTypePage());
        this.addBusSubtype("Slave", new SlaveTypePage());
        this.addBusSubtype("System", new SystemTypePage());
        this.addBusSubtype("Mirrored Master", null);
        this.addBusSubtype("Mirrored Slave", new MirroredSlaveTypePage());
        this.addBusSubtype("Mirrored System", new MirroredSystemTypePage());
        this.addBusSubtype("Monitor", new MonitorTypePage());
    }

    private void addBusSubtype(String name, AbstractBusTypeWizardPage page) {
        this.busSubtypeMap.put(name, page);
        if (page != null) {
            this.addPage((IWizardPage)page);
        }
    }

    public IWizardPage getNextPage(IWizardPage page) {
        AbstractBusTypeWizardPage nextPage = null;
        if (page == this.basicInfoPage && this.busSubTypePage != null) {
            nextPage = this.busSubTypePage;
        }
        return nextPage;
    }

    public boolean canFinish() {
        if (this.busSubTypePage != null) {
            return this.basicInfoPage.isPageComplete() && this.busSubTypePage.isPageComplete();
        }
        return this.basicInfoPage.isPageComplete();
    }

    public boolean performFinish() {
        Object busType = this.busSubTypePage != null ? this.busSubTypePage.getModel() : new MirroredMasterType();
        this.busInterface.setBusTypeObject(busType);
        if (this.targetDoc != null) {
            this.busInterface.addSignalsFromBusDefinition();
            this.insertBusInterface();
        } else {
            try {
                DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
                factory.setNamespaceAware(true);
                DocumentBuilder builder = factory.newDocumentBuilder();
                DOMImplementationLS lsImpl = (DOMImplementationLS)((Object)builder.getDOMImplementation());
                LSSerializer serialiser = lsImpl.createLSSerializer();
                DOMConfiguration domConfig = serialiser.getDomConfig();
                domConfig.setParameter("xml-declaration", new Boolean(false));
                Document doc = builder.newDocument();
                Element e = this.busInterface.getXMLRootNode(doc);
                doc.appendChild(doc.createElement("spirit:root"));
                doc.getDocumentElement().appendChild(e);
                System.out.println(serialiser.writeToString(e));
            }
            catch (ParserConfigurationException pce) {
                pce.printStackTrace();
            }
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void insertBusInterface() {
        Element rootNode = this.targetDoc.getDocumentElement();
        String namespace = SpiritDocument.getSchemaURI((Document)this.targetDoc);
        String prefix = rootNode.getPrefix() + ':';
        SchemaInfo.IpxactVersion ipxactVersion = SchemaInfo.getIpxactVersion((String)namespace);
        EditorHelper.beginUndoRecording(rootNode, this.targetDoc, Messages.CreateNewBusInterfaceWizard_InsertBusInterface);
        Element busInterfacesElement = EditorHelper.maybeInsertElementNS(rootNode, namespace, prefix, "busInterfaces");
        try {
            switch (ipxactVersion) {
                case BEFORE_V14: {
                    if (busInterfacesElement == null) return;
                    busInterfacesElement.appendChild(this.busInterface.getXMLRootNode(this.targetDoc));
                    Element modelElement = EditorHelper.maybeInsertElementNS(rootNode, namespace, prefix, "model");
                    if (modelElement == null) return;
                    String signalOrPort = SchemaInfo.getSpiritString((String)"signal", (String)namespace);
                    Element signalsElement = EditorHelper.maybeInsertElementNS(modelElement, namespace, prefix, signalOrPort + "s");
                    if (signalsElement == null) return;
                    this.updateSignalModel(signalsElement);
                    return;
                }
                case V14: {
                    if (busInterfacesElement == null) return;
                    busInterfacesElement.appendChild(this.busInterface.getXMLRootNode(this.targetDoc));
                    Element modelElement = EditorHelper.maybeInsertElementNS(rootNode, namespace, prefix, "model");
                    if (modelElement == null) return;
                    String signalOrPort = SchemaInfo.getSpiritString((String)"signal", (String)namespace);
                    Element signalsElement = EditorHelper.maybeInsertElementNS(modelElement, namespace, prefix, signalOrPort + "s");
                    if (signalsElement == null) return;
                    this.updateSignalModel(signalsElement);
                    return;
                }
            }
            return;
        }
        finally {
            EditorHelper.endUndoRecording(rootNode, this.targetDoc);
        }
    }

    private void updateSignalModel(Element signalsElement) {
        Element rootNode = this.targetDoc.getDocumentElement();
        String namespace = SpiritDocument.getSchemaURI((Document)this.targetDoc);
        String prefix = rootNode.getPrefix() + ':';
        List busDefSignals = this.busInterface.getBusDefSignals();
        AbstractBusType busTypeObject = this.busInterface.getBusTypeObject();
        if (busDefSignals != null && busTypeObject != null) {
            int busType = busTypeObject.getBusType();
            boolean isMirrored = busTypeObject.isMirrored();
            if (3 == busType) {
                MonitorType monitorType = (MonitorType)busTypeObject;
                busType = monitorType.getInterfaceType().getBusType();
            }
            String componentSignalPrefix = this.busInterface.getComponentSignalPrefix();
            for (SpiritSignal signal : busDefSignals) {
                String modelSignalName = componentSignalPrefix + signal.getName();
                try {
                    XPath xpath = SpiritDocument.createXPath((String)namespace);
                    NodeList signalNodes = (NodeList)xpath.evaluate("./spirit:signal[normalize-space(spirit:name)='" + modelSignalName + "']", signalsElement, XPathConstants.NODESET);
                    Element modelSignalElement = signalNodes.getLength() > 0 ? (Element)signalNodes.item(0) : null;
                    if (modelSignalElement != null) continue;
                    String direction = "in";
                    SpiritSignal.SignalInfo signalInfo = signal.getSignalInfo(busType);
                    if (signalInfo == null) continue;
                    if (signalInfo.direction != null) {
                        direction = signalInfo.direction;
                        if ("illegal".equals(direction)) continue;
                        if (isMirrored) {
                            if ("in".equals(direction)) {
                                direction = "out";
                            } else if ("out".equals(direction)) {
                                direction = "in";
                            }
                        }
                    }
                    String signalOrPort = SchemaInfo.getSpiritString((String)"signal", (String)namespace);
                    modelSignalElement = this.targetDoc.createElementNS(namespace, prefix + signalOrPort);
                    signalsElement.appendChild(modelSignalElement);
                    SchemaInfo.IpxactVersion ipxactVersion = SchemaInfo.getIpxactVersion((String)this.targetDoc.getDocumentElement().getNamespaceURI());
                    Element e = this.targetDoc.createElementNS(namespace, prefix + "name");
                    e.appendChild(this.targetDoc.createTextNode(modelSignalName));
                    modelSignalElement.appendChild(e);
                    switch (ipxactVersion) {
                        case BEFORE_V14: {
                            e = this.targetDoc.createElementNS(namespace, prefix + "direction");
                            e.appendChild(this.targetDoc.createTextNode(direction));
                            modelSignalElement.appendChild(e);
                            if (signalInfo.bitWidth == null) break;
                            e = this.targetDoc.createElementNS(namespace, prefix + "left");
                            e.appendChild(this.targetDoc.createTextNode("1"));
                            modelSignalElement.appendChild(e);
                            e = this.targetDoc.createElementNS(namespace, prefix + "right");
                            e.appendChild(this.targetDoc.createTextNode(signalInfo.bitWidth));
                            modelSignalElement.appendChild(e);
                            break;
                        }
                        case V14: {
                            Element wireSignalElement = this.targetDoc.createElementNS(namespace, prefix + "wire");
                            e = this.targetDoc.createElementNS(namespace, prefix + "direction");
                            e.appendChild(this.targetDoc.createTextNode(direction));
                            wireSignalElement.appendChild(e);
                            if (signalInfo.bitWidth != null) {
                                Element vectorSignalElement = this.targetDoc.createElementNS(namespace, prefix + "vector");
                                e = this.targetDoc.createElementNS(namespace, prefix + "left");
                                e.appendChild(this.targetDoc.createTextNode("1"));
                                vectorSignalElement.appendChild(e);
                                e = this.targetDoc.createElementNS(namespace, prefix + "right");
                                e.appendChild(this.targetDoc.createTextNode(signalInfo.bitWidth));
                                vectorSignalElement.appendChild(e);
                                wireSignalElement.appendChild(vectorSignalElement);
                            }
                            modelSignalElement.appendChild(wireSignalElement);
                        }
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public String getWarningMessage() {
        String warningMessage = Messages.CreateNewBusInterfaceWizard_EnterBasicInfo;
        SchemaInfo.IpxactVersion documentVersionHandling = SchemaInfo.getIpxactVersion((String)this.targetDoc.getDocumentElement().getNamespaceURI());
        Vlnv abstractionVlnv = this.busInterface.getAbstractionType();
        SpiritDocument abstraction = SpiritResourceLibrary.getDefault().get(abstractionVlnv);
        if (abstraction != null) {
            SchemaInfo.IpxactVersion interfaceVersionHandling = abstraction.schemaVersion();
            if (!documentVersionHandling.equals((Object)interfaceVersionHandling)) {
                warningMessage = "WARNING: A " + interfaceVersionHandling.toString() + " abstraction definition is being inserted into a " + documentVersionHandling.toString() + " document." + "\n" + Messages.CreateNewBusInterfaceWizard_WARNING;
            }
        } else {
            Vlnv vlnv = this.busInterface.getBusType();
            SchemaInfo.IpxactVersion interfaceVersionHandling = SchemaInfo.getIpxactVersion((String)SpiritResourceLibrary.getDefault().get(vlnv).getDocumentElement().getNamespaceURI());
            if (!documentVersionHandling.equals((Object)interfaceVersionHandling)) {
                warningMessage = "WARNING: A " + interfaceVersionHandling.toString() + " bus definition is being inserted into a " + documentVersionHandling.toString() + " document." + "\n" + Messages.CreateNewBusInterfaceWizard_WARNING;
            }
        }
        return warningMessage;
    }

    class BasicInfoPage
    extends AbstractWizardPage {
        private Text instanceNameField;
        private Button requiredBtn;
        private Combo busTypeCombo;
        private Button createSignalMapFromBusDefBtn;
        private Text prefixField;
        private String warningMessage;

        public BasicInfoPage() {
            super(Messages.CreateNewBusInterfaceWizard_NewBusInterface);
            this.warningMessage = CreateNewBusInterfaceWizard.this.getWarningMessage();
            this.setTitle(Messages.CreateNewBusInterfaceWizard_BasicInfo);
            this.setDescription(this.warningMessage);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(3, false));
            this.setControl((Control)container);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_BusInterfaceName);
            this.instanceNameField = new Text(container, 2048);
            this.instanceNameField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            Vlnv busDefVlnv = CreateNewBusInterfaceWizard.this.busInterface.getBusType();
            if (busDefVlnv != null) {
                this.instanceNameField.setText(busDefVlnv.toString());
                this.instanceNameField.selectAll();
            }
            this.addMonitor((Control)this.instanceNameField);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_Connection);
            Composite requireGroup = new Composite(container, 0);
            requireGroup.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            requireGroup.setLayout((Layout)new FillLayout(256));
            this.requiredBtn = new Button(requireGroup, 16);
            this.requiredBtn.setText(Messages.CreateNewBusInterfaceWizard_Required);
            this.requiredBtn.setSelection(false);
            this.addMonitor((Control)this.requiredBtn);
            Button explicitBtn = new Button(requireGroup, 16);
            explicitBtn.setText(Messages.CreateNewBusInterfaceWizard_Explicit);
            explicitBtn.setSelection(true);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_Type);
            this.busTypeCombo = new Combo(container, 0);
            this.busTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            for (String name : CreateNewBusInterfaceWizard.this.busSubtypeMap.keySet()) {
                this.busTypeCombo.add(name);
            }
            this.addMonitor((Control)this.busTypeCombo);
            LayoutHelper.makeLabel(container, "");
            this.createSignalMapFromBusDefBtn = new Button(container, 32);
            this.createSignalMapFromBusDefBtn.setText(Messages.CreateNewBusInterfaceWizard_CreateSignalMap);
            this.createSignalMapFromBusDefBtn.setSelection(true);
            this.createSignalMapFromBusDefBtn.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.createSignalMapFromBusDefBtn);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_SignalPrefix);
            this.prefixField = new Text(container, 2048);
            this.prefixField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.prefixField);
            CreateNewBusInterfaceWizard.this.busInterface.setConnectionRequired(this.requiredBtn.getSelection());
            CreateNewBusInterfaceWizard.this.busInterface.setCreateSignalMapEnabled(this.createSignalMapFromBusDefBtn.getSelection());
            this.setPageComplete(false);
        }

        protected void updatePageComplete() {
            String name = this.instanceNameField.getText().trim();
            CreateNewBusInterfaceWizard.this.busInterface.setInstanceName(name);
            CreateNewBusInterfaceWizard.this.busInterface.setComponentSignalPrefix(this.prefixField.getText());
            CreateNewBusInterfaceWizard.this.busInterface.setConnectionRequired(this.requiredBtn.getSelection());
            boolean enabled = this.createSignalMapFromBusDefBtn.getSelection();
            CreateNewBusInterfaceWizard.this.busInterface.setCreateSignalMapEnabled(enabled);
            this.prefixField.setEnabled(enabled);
            String busTypeSelection = this.busTypeCombo.getText().trim();
            CreateNewBusInterfaceWizard.this.busSubTypePage = (AbstractBusTypeWizardPage)((Object)CreateNewBusInterfaceWizard.this.busSubtypeMap.get(busTypeSelection));
            boolean found = CreateNewBusInterfaceWizard.this.busSubtypeMap.containsKey(busTypeSelection);
            this.setPageComplete(name.length() > 0 && found);
        }
    }

    class MasterTypePage
    extends AbstractBusTypeWizardPage {
        private Text nameField;
        private Text baseAddressField;
        private Text bitOffsetField;

        protected MasterTypePage() {
            super("MasterType", (AbstractBusType)new MasterType());
            this.setTitle(Messages.CreateNewBusInterfaceWizard_MasterBusInfo);
            this.setDescription(Messages.CreateNewBusInterfaceWizard_MasterBusInfoDesc);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(3, false));
            this.setControl((Control)container);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_AddressSpaceName);
            this.nameField = new Text(container, 2048);
            this.nameField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.nameField);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_BaseAddress);
            this.baseAddressField = new Text(container, 2048);
            this.baseAddressField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.baseAddressField);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_BitOffset);
            this.bitOffsetField = new Text(container, 2048);
            this.bitOffsetField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.bitOffsetField);
        }

        protected void updatePageComplete() {
            MasterType model = (MasterType)this.getModel();
            model.setAddressSpaceName(this.nameField.getText());
            model.setBaseAddress(this.baseAddressField.getText());
            model.setBitOffset(this.bitOffsetField.getText());
            this.setPageComplete(true);
        }
    }

    class MirroredSlaveTypePage
    extends AbstractBusTypeWizardPage {
        protected MirroredSlaveTypePage() {
            super("MirroredSlaveType", (AbstractBusType)new MirroredSlaveType());
            this.setTitle(Messages.CreateNewBusInterfaceWizard_MirroredSlaveInfo);
            this.setDescription(Messages.CreateNewBusInterfaceWizard_MirroredSlaveInfoDesc);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            container.setLayout((Layout)gridLayout);
            this.setControl((Control)container);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_CompleteManually);
        }

        protected void updatePageComplete() {
            this.setPageComplete(true);
        }
    }

    class MirroredSystemTypePage
    extends AbstractBusTypeWizardPage {
        private Text groupNameField;

        protected MirroredSystemTypePage() {
            super("MirroredSystemType", (AbstractBusType)new MirroredSystemType());
            this.setTitle(Messages.CreateNewBusInterfaceWizard_MirroredSystemInfo);
            this.setDescription(Messages.CreateNewBusInterfaceWizard_MirroredSystemInfoDesc);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            container.setLayout((Layout)gridLayout);
            this.setControl((Control)container);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_GroupName);
            this.groupNameField = new Text(container, 2048);
            this.groupNameField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.groupNameField);
        }

        protected void updatePageComplete() {
            MirroredSystemType model = (MirroredSystemType)this.getModel();
            String groupName = this.groupNameField.getText();
            model.setGroupName(groupName);
            this.setPageComplete(groupName.length() > 0);
        }
    }

    class MonitorTypePage
    extends AbstractBusTypeWizardPage {
        private Combo busTypeCombo;
        private Text groupNameField;
        private HashMap<String, InterfaceType> monitorTarget;

        protected MonitorTypePage() {
            super("MonitorType", (AbstractBusType)new MonitorType());
            this.setTitle(Messages.CreateNewBusInterfaceWizard_MonitorBusInfo);
            this.setDescription(Messages.CreateNewBusInterfaceWizard_MonitorBusInfoDesc);
            this.initMonitorTargetEntries();
        }

        private void initMonitorTargetEntries() {
            this.monitorTarget = new HashMap();
            this.monitorTarget.put("Master", InterfaceType.MASTER);
            this.monitorTarget.put("Slave", InterfaceType.SLAVE);
            this.monitorTarget.put("System", InterfaceType.SYSTEM);
            this.monitorTarget.put("Mirrored Master", InterfaceType.MIRRORED_MASTER);
            this.monitorTarget.put("Mirrored Slave", InterfaceType.MIRRORED_SLAVE);
            this.monitorTarget.put("Mirrored System", InterfaceType.MIRRORED_SYSTEM);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            container.setLayout((Layout)gridLayout);
            this.setControl((Control)container);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_Type);
            this.busTypeCombo = new Combo(container, 0);
            this.busTypeCombo.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            for (String name : this.monitorTarget.keySet()) {
                this.busTypeCombo.add(name);
            }
            this.addMonitor((Control)this.busTypeCombo);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_GroupName);
            this.groupNameField = new Text(container, 2048);
            this.groupNameField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.groupNameField);
            this.setPageComplete(false);
        }

        protected void updatePageComplete() {
            MonitorType model = (MonitorType)this.getModel();
            String groupName = this.groupNameField.getText();
            model.setGroupName(groupName);
            InterfaceType t = this.monitorTarget.get(this.busTypeCombo.getText());
            model.setInterfaceType(t);
            this.setPageComplete(t != null);
        }
    }

    class SlaveTypePage
    extends AbstractBusTypeWizardPage {
        private Text memoryMapRefField;
        private Text masterRefField;
        private Button isOpaqueBtn;
        private Bridge bridge;

        protected SlaveTypePage() {
            super("SlaveType", (AbstractBusType)new SlaveType());
            this.setTitle(Messages.CreateNewBusInterfaceWizard_SlaveTypeInfo);
            this.setDescription(Messages.CreateNewBusInterfaceWizard_SlaveTypeInfoDesc);
            this.bridge = new Bridge();
            SlaveType model = (SlaveType)this.getModel();
            model.addBridge(this.bridge);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            container.setLayout((Layout)new GridLayout(3, false));
            this.setControl((Control)container);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_MemoryMapName, true);
            this.memoryMapRefField = new Text(container, 2048);
            this.memoryMapRefField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.memoryMapRefField);
            Group bridgeGroup = new Group(container, 4);
            bridgeGroup.setLayoutData((Object)new GridData(4, 0, true, false, 3, 1));
            bridgeGroup.setLayout((Layout)new FillLayout(512));
            bridgeGroup.setText(Messages.CreateNewBusInterfaceWizard_Bridge);
            Composite c = new Composite((Composite)bridgeGroup, 0);
            c.setLayout((Layout)new GridLayout(2, false));
            LayoutHelper.makeLabel(c, Messages.CreateNewBusInterfaceWizard_MasterName);
            this.masterRefField = new Text(c, 2048);
            this.masterRefField.setLayoutData((Object)new GridData(4, 0, true, false, 1, 1));
            this.addMonitor((Control)this.masterRefField);
            this.isOpaqueBtn = new Button(c, 32);
            this.isOpaqueBtn.setLayoutData((Object)new GridData(4, 0, false, false, 1, 1));
            this.isOpaqueBtn.setText(Messages.CreateNewBusInterfaceWizard_Opaque);
            this.isOpaqueBtn.setSelection(false);
            this.addMonitor((Control)this.isOpaqueBtn);
            this.setPageComplete(true);
        }

        protected void updatePageComplete() {
            SlaveType model = (SlaveType)this.getModel();
            model.setMemoryMapRef(this.memoryMapRefField.getText());
            this.bridge.setMasterRef(this.masterRefField.getText());
            this.bridge.setOpaque(this.isOpaqueBtn.getSelection());
        }
    }

    class SystemTypePage
    extends AbstractBusTypeWizardPage {
        private Text groupNameField;

        protected SystemTypePage() {
            super("SystemType", (AbstractBusType)new SystemType());
            this.setTitle(Messages.CreateNewBusInterfaceWizard_SystemBusInfo);
            this.setDescription(Messages.CreateNewBusInterfaceWizard_SystemBusInfoDesc);
        }

        public void createControl(Composite parent) {
            Composite container = new Composite(parent, 0);
            GridLayout gridLayout = new GridLayout();
            gridLayout.numColumns = 3;
            container.setLayout((Layout)gridLayout);
            this.setControl((Control)container);
            LayoutHelper.makeLabel(container, Messages.CreateNewBusInterfaceWizard_GroupName);
            this.groupNameField = new Text(container, 2048);
            this.groupNameField.setLayoutData((Object)new GridData(4, 0, true, false, 2, 1));
            this.addMonitor((Control)this.groupNameField);
        }

        protected void updatePageComplete() {
            SystemType model = (SystemType)this.getModel();
            String groupName = this.groupNameField.getText();
            model.setGroupName(groupName);
            this.setPageComplete(groupName.length() > 0);
        }
    }
}

