/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service;

import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executor;
import org.eclipse.cdt.debug.internal.core.sourcelookup.CSourceLookupDirector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.RequestMonitor;
import org.eclipse.dd.dsf.debug.service.ISourceLookup;
import org.eclipse.dd.dsf.service.AbstractDsfService;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.osgi.framework.BundleContext;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CSourceLookup
extends AbstractDsfService
implements ISourceLookup {
    private Map<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector> fDirectors = new HashMap<ISourceLookup.ISourceLookupDMContext, CSourceLookupDirector>();

    public CSourceLookup(DsfSession session) {
        super(session);
    }

    protected BundleContext getBundleContext() {
        return MIPlugin.getBundleContext();
    }

    public void setSourceLookupDirector(ISourceLookup.ISourceLookupDMContext ctx, CSourceLookupDirector director) {
        this.fDirectors.put(ctx, director);
    }

    public void initialize(final RequestMonitor requestMonitor) {
        super.initialize(new RequestMonitor((Executor)this.getExecutor(), requestMonitor){

            protected void handleOK() {
                CSourceLookup.this.doInitialize(requestMonitor);
            }
        });
    }

    private void doInitialize(RequestMonitor requestMonitor) {
        this.register(new String[]{CSourceLookup.class.getName(), ISourceLookup.class.getName()}, new Hashtable());
        requestMonitor.done();
    }

    public void shutdown(RequestMonitor requestMonitor) {
        this.unregister();
        super.shutdown(requestMonitor);
    }

    public void getDebuggerPath(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, Object source, final DataRequestMonitor<String> rm) {
        if (!(source instanceof String)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10003, "Only string source element is supported", null));
            rm.done();
            return;
        }
        final String sourceString = (String)source;
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        new Job("Lookup Debugger Path"){

            protected IStatus run(IProgressMonitor monitor) {
                IPath debuggerPath = director.getCompilationPath(sourceString);
                if (debuggerPath != null) {
                    rm.setData((Object)debuggerPath.toString());
                } else {
                    rm.setData((Object)sourceString);
                }
                rm.done();
                return Status.OK_STATUS;
            }
        }.schedule();
    }

    public void getSource(ISourceLookup.ISourceLookupDMContext sourceLookupCtx, final String debuggerPath, final DataRequestMonitor<Object> rm) {
        if (!this.fDirectors.containsKey(sourceLookupCtx)) {
            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10002, "No source director configured for given context", null));
            rm.done();
            return;
        }
        final CSourceLookupDirector director = this.fDirectors.get(sourceLookupCtx);
        new Job("Lookup Source"){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Object[] sources = director.findSourceElements((Object)debuggerPath);
                    if (sources == null || sources.length == 0) {
                        rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "No sources found", null));
                    } else {
                        rm.setData(sources[0]);
                    }
                }
                catch (CoreException e) {
                    rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10004, "Source lookup failed", (Throwable)e));
                }
                finally {
                    rm.done();
                }
                return Status.OK_STATUS;
            }
        }.schedule();
    }
}

