/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.commands;

import org.eclipse.dd.dsf.datamodel.DMContexts;
import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.mi.service.command.MIControlDMContext;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIOutput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MICommand<V extends MIInfo>
implements ICommand<V> {
    static final String[] empty = new String[0];
    String[] fOptions = empty;
    String[] fParameters = empty;
    String fOperation = new String();
    IDMContext fCtx;

    public MICommand(IDMContext ctx, String operation) {
        this(ctx, operation, empty, empty);
    }

    public MICommand(IDMContext ctx, String operation, String[] options) {
        this(ctx, operation, options, empty);
    }

    public MICommand(IDMContext ctx, String operation, String[] options, String[] params) {
        assert (ctx != null && DMContexts.getAncestorOfType((IDMContext)ctx, MIControlDMContext.class) != null);
        this.fCtx = ctx;
        this.fOperation = operation;
        this.fOptions = options;
        this.fParameters = params;
    }

    public String getCommandControlFilter() {
        MIControlDMContext controlDmc = (MIControlDMContext)DMContexts.getAncestorOfType((IDMContext)this.getContext(), MIControlDMContext.class);
        return controlDmc.getCommandControlFilter();
    }

    public String getOperation() {
        return this.fOperation;
    }

    public String[] getOptions() {
        return this.fOptions;
    }

    public void setOptions(String[] options) {
        this.fOptions = options;
    }

    public String[] getParameters() {
        return this.fParameters;
    }

    public void setParameters(String[] params) {
        this.fParameters = params;
    }

    public String constructCommand() {
        String p;
        StringBuffer command = new StringBuffer(this.getOperation());
        String opt = this.optionsToString();
        if (opt.length() > 0) {
            command.append(' ').append(opt);
        }
        if ((p = this.parametersToString()).length() > 0) {
            command.append(' ').append(p);
        }
        command.append('\n');
        return command.toString();
    }

    public ICommand<? extends ICommandResult> coalesceWith(ICommand<? extends ICommandResult> command) {
        return null;
    }

    public IDMContext getContext() {
        return this.fCtx;
    }

    public MIInfo getResult(MIOutput MIresult) {
        return new MIInfo(MIresult);
    }

    protected String optionsToString() {
        String[] options = this.getOptions();
        StringBuffer sb = new StringBuffer();
        if (options != null && options.length > 0) {
            for (int i = 0; i < options.length; ++i) {
                String option = options[i];
                if (option.indexOf(34) != -1 || option.indexOf(92) != -1) {
                    StringBuffer buf = new StringBuffer();
                    for (int j = 0; j < option.length(); ++j) {
                        char c = option.charAt(j);
                        if (c == '\"' || c == '\\') {
                            buf.append('\\');
                        }
                        buf.append(c);
                    }
                    option = buf.toString();
                }
                if (option.indexOf(9) != -1 || option.indexOf(32) != -1) {
                    sb.append(' ').append('\"').append(option).append('\"');
                    continue;
                }
                sb.append(' ').append(option);
            }
        }
        return sb.toString().trim();
    }

    protected String parametersToString() {
        String[] parameters = this.getParameters();
        String[] options = this.getOptions();
        StringBuffer buffer = new StringBuffer();
        if (parameters != null && parameters.length > 0) {
            if (options != null && options.length > 0) {
                for (int i = 0; i < parameters.length; ++i) {
                    if (!parameters[i].startsWith("-")) continue;
                    buffer.append('-').append('-');
                    break;
                }
            }
            StringBuffer sb = new StringBuffer();
            for (int i = 0; i < parameters.length; ++i) {
                sb.setLength(0);
                String param = parameters[i];
                for (int j = 0; j < param.length(); ++j) {
                    char c = param.charAt(j);
                    if (c == '\"' || c == '\\') {
                        sb.append('\\');
                    }
                    sb.append(c);
                }
                if (this.containsWhitespace(param)) {
                    sb.insert(0, '\"');
                    sb.append('\"');
                }
                buffer.append(' ').append(sb);
            }
        }
        return buffer.toString().trim();
    }

    protected boolean containsWhitespace(String s) {
        for (int i = 0; i < s.length(); ++i) {
            if (!Character.isWhitespace(s.charAt(i))) continue;
            return true;
        }
        return false;
    }

    public boolean equals(Object obj) {
        if (obj instanceof MICommand) {
            MICommand otherCmd = (MICommand)obj;
            return (this.fCtx == null && otherCmd.fCtx == null || this.fCtx != null && this.fCtx.equals(otherCmd.fCtx)) && this.constructCommand().equals(otherCmd.constructCommand());
        }
        return false;
    }

    public int hashCode() {
        return this.constructCommand().hashCode();
    }

    public String toString() {
        return this.constructCommand();
    }
}

