/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command.output;

import java.util.ArrayList;
import org.eclipse.dd.mi.service.command.output.MIAsyncRecord;
import org.eclipse.dd.mi.service.command.output.MIConsoleStreamOutput;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIExecAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIList;
import org.eclipse.dd.mi.service.command.output.MILogStreamOutput;
import org.eclipse.dd.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIStatusAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIStreamRecord;
import org.eclipse.dd.mi.service.command.output.MITargetStreamOutput;
import org.eclipse.dd.mi.service.command.output.MITuple;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIParser {
    public String primaryPrompt;
    public String cliPrompt;
    public String secondaryPrompt;

    public MIParser() {
        this.cliPrompt = this.primaryPrompt = "(gdb)";
        this.secondaryPrompt = ">";
    }

    public RecordType getRecordType(String line) {
        int i = 0;
        if (Character.isDigit(line.charAt(0))) {
            for (i = 1; i < line.length() && Character.isDigit(line.charAt(i)); ++i) {
            }
        }
        if (i < line.length() && line.charAt(i) == '^') {
            return RecordType.ResultRecord;
        }
        if (line.startsWith(this.primaryPrompt, i)) {
            return RecordType.PrimaryPrompt;
        }
        return RecordType.OOBRecord;
    }

    public MIResultRecord parseMIResultRecord(String line) {
        StringBuffer buffer = new StringBuffer(line);
        int id = this.parseToken(buffer);
        buffer.deleteCharAt(0);
        MIResultRecord rr = new MIResultRecord();
        rr.setToken(id);
        if (buffer.toString().startsWith("done")) {
            rr.setResultClass("done");
            buffer.delete(0, "done".length());
        } else if (buffer.toString().startsWith("error")) {
            rr.setResultClass("error");
            buffer.delete(0, "error".length());
        } else if (buffer.toString().startsWith("exit")) {
            rr.setResultClass("exit");
            buffer.delete(0, "exit".length());
        } else if (buffer.toString().startsWith("running")) {
            rr.setResultClass("running");
            buffer.delete(0, "running".length());
        } else if (buffer.toString().startsWith("connected")) {
            rr.setResultClass("connected");
            buffer.delete(0, "connected".length());
        }
        if (buffer.length() > 0 && buffer.charAt(0) == ',') {
            buffer.deleteCharAt(0);
            MIResult[] res = this.processMIResults(new FSB(buffer));
            rr.setMIResults(res);
        }
        return rr;
    }

    public MIOOBRecord parseMIOOBRecord(String line) {
        char c;
        StringBuffer buffer = new StringBuffer(line);
        int id = this.parseToken(buffer);
        MIOOBRecord oob = null;
        char c2 = c = buffer.length() != 0 ? buffer.charAt(0) : (char)'\u0000';
        if (c == '*' || c == '+' || c == '=') {
            buffer.deleteCharAt(0);
            MIAsyncRecord async = null;
            switch (c) {
                case '*': {
                    async = new MIExecAsyncOutput();
                    break;
                }
                case '+': {
                    async = new MIStatusAsyncOutput();
                    break;
                }
                case '=': {
                    async = new MINotifyAsyncOutput();
                }
            }
            async.setToken(id);
            int i = buffer.toString().indexOf(44);
            if (i != -1) {
                String asyncClass = buffer.substring(0, i);
                async.setAsyncClass(asyncClass);
                buffer.delete(0, i + 1);
            } else {
                async.setAsyncClass(buffer.toString().trim());
                buffer.setLength(0);
            }
            MIResult[] res = this.processMIResults(new FSB(buffer));
            async.setMIResults(res);
            oob = async;
        } else if (c == '~' || c == '@' || c == '&') {
            buffer.deleteCharAt(0);
            MIStreamRecord stream = null;
            switch (c) {
                case '~': {
                    stream = new MIConsoleStreamOutput();
                    break;
                }
                case '@': {
                    stream = new MITargetStreamOutput();
                    break;
                }
                case '&': {
                    stream = new MILogStreamOutput();
                }
            }
            if (buffer.length() > 0 && buffer.charAt(0) == '\"') {
                buffer.deleteCharAt(0);
            }
            stream.setCString(this.translateCString(new FSB(buffer)));
            oob = stream;
        } else {
            MITargetStreamOutput stream = new MITargetStreamOutput();
            stream.setCString(line + "\n");
            oob = stream;
        }
        return oob;
    }

    private int parseToken(StringBuffer buffer) {
        int id = -1;
        if (Character.isDigit(buffer.charAt(0))) {
            int i;
            for (i = 1; i < buffer.length() && Character.isDigit(buffer.charAt(i)); ++i) {
            }
            String numbers = buffer.substring(0, i);
            try {
                id = Integer.parseInt(numbers);
            }
            catch (NumberFormatException e) {
                // empty catch block
            }
            buffer.delete(0, i);
        }
        return id;
    }

    private MIResult[] processMIResults(FSB buffer) {
        ArrayList<MIResult> aList = new ArrayList<MIResult>();
        MIResult result = this.processMIResult(buffer);
        if (result != null) {
            aList.add(result);
        }
        while (buffer.length() > 0 && buffer.charAt(0) == ',') {
            buffer.deleteCharAt(0);
            result = this.processMIResult(buffer);
            if (result == null) continue;
            aList.add(result);
        }
        return aList.toArray(new MIResult[aList.size()]);
    }

    private MIResult processMIResult(FSB buffer) {
        int equal;
        MIResult result = new MIResult();
        if (buffer.length() > 0 && Character.isLetter(buffer.charAt(0)) && (equal = buffer.indexOf('=')) != -1) {
            String variable = buffer.substring(0, equal);
            result.setVariable(variable);
            buffer.delete(0, equal + 1);
            MIValue value = this.processMIValue(buffer);
            result.setMIValue(value);
        } else if (buffer.length() > 0 && buffer.charAt(0) == '\"') {
            MIValue value = this.processMIValue(buffer);
            result.setMIValue(value);
        } else {
            result.setVariable(buffer.toString());
            result.setMIValue(new MIConst());
            buffer.setLength(0);
        }
        return result;
    }

    private MIValue processMIValue(FSB buffer) {
        MIValue value = null;
        if (buffer.length() > 0) {
            if (buffer.charAt(0) == '{') {
                buffer.deleteCharAt(0);
                value = this.processMITuple(buffer);
            } else if (buffer.charAt(0) == '[') {
                buffer.deleteCharAt(0);
                value = this.processMIList(buffer);
            } else if (buffer.charAt(0) == '\"') {
                buffer.deleteCharAt(0);
                MIConst cnst = new MIConst();
                cnst.setCString(this.translateCString(buffer));
                value = cnst;
            }
        }
        return value;
    }

    private MIValue processMITuple(FSB buffer) {
        MITuple tuple = new MITuple();
        ArrayList<MIValue> valueList = new ArrayList<MIValue>();
        ArrayList<MIResult> resultList = new ArrayList<MIResult>();
        while (buffer.length() > 0 && buffer.charAt(0) != '}') {
            MIValue value = this.processMIValue(buffer);
            if (value != null) {
                valueList.add(value);
            } else {
                MIResult result = this.processMIResult(buffer);
                if (result != null) {
                    resultList.add(result);
                }
            }
            if (buffer.length() <= 0 || buffer.charAt(0) != ',') continue;
            buffer.deleteCharAt(0);
        }
        if (buffer.length() > 0 && buffer.charAt(0) == '}') {
            buffer.deleteCharAt(0);
        }
        MIValue[] values = valueList.toArray(new MIValue[valueList.size()]);
        MIResult[] res = resultList.toArray(new MIResult[resultList.size()]);
        tuple.setMIValues(values);
        tuple.setMIResults(res);
        return tuple;
    }

    private MIValue processMIList(FSB buffer) {
        MIList list = new MIList();
        ArrayList<MIValue> valueList = new ArrayList<MIValue>();
        ArrayList<MIResult> resultList = new ArrayList<MIResult>();
        while (buffer.length() > 0 && buffer.charAt(0) != ']') {
            MIValue value = this.processMIValue(buffer);
            if (value != null) {
                valueList.add(value);
            } else {
                MIResult result = this.processMIResult(buffer);
                if (result != null) {
                    resultList.add(result);
                }
            }
            if (buffer.length() <= 0 || buffer.charAt(0) != ',') continue;
            buffer.deleteCharAt(0);
        }
        if (buffer.length() > 0 && buffer.charAt(0) == ']') {
            buffer.deleteCharAt(0);
        }
        MIValue[] values = valueList.toArray(new MIValue[valueList.size()]);
        MIResult[] res = resultList.toArray(new MIResult[resultList.size()]);
        list.setMIValues(values);
        list.setMIResults(res);
        return list;
    }

    private String translateCString(FSB buffer) {
        int index;
        boolean escape = false;
        boolean closingQuotes = false;
        StringBuffer sb = new StringBuffer();
        for (index = 0; index < buffer.length() && !closingQuotes; ++index) {
            char c = buffer.charAt(index);
            if (c == '\\') {
                if (escape) {
                    sb.append(c);
                    escape = false;
                    continue;
                }
                escape = true;
                continue;
            }
            if (c == '\"') {
                if (escape) {
                    sb.append(c);
                    escape = false;
                    continue;
                }
                closingQuotes = true;
                continue;
            }
            if (escape) {
                sb.append('\\');
            }
            sb.append(c);
            escape = false;
        }
        buffer.delete(0, index);
        return sb.toString();
    }

    public boolean startsWith(StringBuffer value, String prefix) {
        int plen;
        int vlen = value.length();
        if (vlen < (plen = prefix.length())) {
            return false;
        }
        for (int i = 0; i < plen; ++i) {
            if (value.charAt(i) == prefix.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public class FSB {
        StringBuffer buf;
        int pos;
        boolean shared;

        public FSB(StringBuffer buf) {
            this.buf = buf;
            this.pos = 0;
            this.shared = false;
        }

        public FSB(FSB fbuf) {
            this.pos = fbuf.pos;
            this.buf = fbuf.buf;
            this.shared = true;
        }

        public int length() {
            int res = this.buf.length() - this.pos;
            if (res < 0) {
                return 0;
            }
            return res;
        }

        public char charAt(int index) {
            return this.buf.charAt(index + this.pos);
        }

        private void resolveCopy() {
            if (this.shared) {
                this.buf = new StringBuffer(this.buf.toString());
                this.shared = false;
            }
        }

        public FSB deleteCharAt(int index) {
            if (index == 0) {
                ++this.pos;
            } else {
                this.resolveCopy();
                this.buf = this.buf.deleteCharAt(this.pos + index);
            }
            return this;
        }

        public FSB delete(int start, int end) {
            if (start == 0) {
                this.pos = this.pos + end - start;
            } else {
                this.resolveCopy();
                this.buf.delete(start + this.pos, end + this.pos);
            }
            return this;
        }

        public void setLength(int a) {
            if (a == 0) {
                this.pos = this.buf.length();
            }
        }

        public String substring(int start, int end) {
            return this.buf.substring(start + this.pos, end + this.pos);
        }

        public String toString() {
            return this.buf.substring(this.pos, this.buf.length());
        }

        int indexOf(char c) {
            int len = this.buf.length();
            for (int i = this.pos; i < len; ++i) {
                if (this.buf.charAt(i) != c) continue;
                return i - this.pos;
            }
            return -1;
        }

        boolean startsWith(String s) {
            int len = Math.min(s.length(), this.length());
            if (len < s.length()) {
                return false;
            }
            for (int i = 0; i < len; ++i) {
                if (s.charAt(i) == this.buf.charAt(this.pos + i)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum RecordType {
        ResultRecord,
        OOBRecord,
        PrimaryPrompt;

    }
}

