/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.RejectedExecutionException;
import org.eclipse.cdt.utils.pty.PTY;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.dd.dsf.concurrent.ConfinedToDsfExecutor;
import org.eclipse.dd.dsf.concurrent.DataRequestMonitor;
import org.eclipse.dd.dsf.concurrent.DsfRunnable;
import org.eclipse.dd.dsf.concurrent.ImmediateExecutor;
import org.eclipse.dd.dsf.concurrent.Query;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.ICommandToken;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.service.DsfSession;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.LargePipedInputStream;
import org.eclipse.dd.mi.service.command.commands.CLICommand;
import org.eclipse.dd.mi.service.command.commands.CLIExecAbort;
import org.eclipse.dd.mi.service.command.commands.MIGDBShowExitCode;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIExecAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIGDBShowExitCodeInfo;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MITargetStreamOutput;
import org.eclipse.dd.mi.service.command.output.MIValue;

public class MIInferiorProcess
extends Process
implements IEventListener,
ICommandListener {
    private final OutputStream fOutputStream;
    private final InputStream fInputStream;
    private final PipedOutputStream fInputStreamPiped;
    private final PipedInputStream fErrorStream;
    private final PipedOutputStream fErrorStreamPiped;
    private final DsfSession fSession;
    private final PTY fPty;
    private final AbstractMIControl fCommandControl;
    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private boolean fDisposed = false;
    private int fSuppressTargetOutputCounter = 0;
    Integer fExitCode = null;
    private State fState = State.RUNNING;
    int inferiorPID;

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(AbstractMIControl commandControl, OutputStream gdbOutputStream) {
        this(commandControl, gdbOutputStream, null);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public MIInferiorProcess(AbstractMIControl commandControl, PTY p) {
        this(commandControl, null, p);
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private MIInferiorProcess(AbstractMIControl commandControl, final OutputStream gdbOutputStream, PTY p) {
        this.fCommandControl = commandControl;
        this.fSession = commandControl.getSession();
        commandControl.addEventListener(this);
        commandControl.addCommandListener(this);
        this.fPty = p;
        if (this.fPty != null) {
            this.fOutputStream = this.fPty.getOutputStream();
            this.fInputStream = this.fPty.getInputStream();
            this.fInputStreamPiped = null;
        } else {
            this.fOutputStream = new OutputStream(){

                public void write(int b) throws IOException {
                    if (MIInferiorProcess.this.getState() != State.RUNNING) {
                        throw new IOException("Target is not running");
                    }
                    gdbOutputStream.write(b);
                }
            };
            this.fInputStreamPiped = new PipedOutputStream();
            LargePipedInputStream inputStream = null;
            try {
                inputStream = new LargePipedInputStream(this.fInputStreamPiped);
            }
            catch (IOException e) {
                // empty catch block
            }
            this.fInputStream = inputStream;
        }
        this.fErrorStreamPiped = new PipedOutputStream();
        LargePipedInputStream errorStream = null;
        try {
            errorStream = new LargePipedInputStream(this.fErrorStreamPiped);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.fErrorStream = errorStream;
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.closeIO();
        this.setState(State.TERMINATED);
        this.fDisposed = true;
    }

    protected DsfSession getSession() {
        return this.fSession;
    }

    protected AbstractMIControl getCommandControl() {
        return this.fCommandControl;
    }

    protected boolean isDisposed() {
        return this.fDisposed;
    }

    public OutputStream getOutputStream() {
        return this.fOutputStream;
    }

    public InputStream getInputStream() {
        return this.fInputStream;
    }

    public InputStream getErrorStream() {
        return this.fErrorStream;
    }

    public synchronized void waitForSync() throws InterruptedException {
        while (this.getState() != State.TERMINATED) {
            this.wait(100L);
        }
    }

    public int waitFor() throws InterruptedException {
        this.waitForSync();
        return this.exitValue();
    }

    public int exitValue() {
        block6: {
            if (this.fExitCode != null) {
                return this.fExitCode;
            }
            try {
                Query<Integer> exitCodeQuery = new Query<Integer>(){

                    protected void execute(final DataRequestMonitor<Integer> rm) {
                        if (!DsfSession.isSessionActive((String)MIInferiorProcess.this.fSession.getId())) {
                            this.cancel(false);
                            return;
                        }
                        if (MIInferiorProcess.this.isDisposed()) {
                            rm.setData((Object)0);
                            rm.done();
                        } else if (MIInferiorProcess.this.getState() != State.TERMINATED) {
                            rm.setStatus((IStatus)new Status(4, "org.eclipse.dsdp.debug.gdb.core", 10001, "GDB is still running.", (Throwable)new IllegalThreadStateException()));
                            rm.done();
                        } else {
                            MIInferiorProcess.this.getCommandControl().queueCommand(new MIGDBShowExitCode(MIInferiorProcess.this.getCommandControl().getControlDMContext()), new DataRequestMonitor<MIGDBShowExitCodeInfo>((Executor)MIInferiorProcess.this.fSession.getExecutor(), rm){

                                protected void handleSuccess() {
                                    rm.setData((Object)((MIGDBShowExitCodeInfo)this.getData()).getCode());
                                    rm.done();
                                }
                            });
                        }
                    }
                };
                this.fSession.getExecutor().execute((Runnable)exitCodeQuery);
                this.fExitCode = (Integer)exitCodeQuery.get();
                return this.fExitCode;
            }
            catch (RejectedExecutionException e) {
            }
            catch (InterruptedException e) {
            }
            catch (CancellationException e) {
            }
            catch (ExecutionException e) {
                if (!(e.getCause() instanceof CoreException) || !(((CoreException)e.getCause()).getStatus().getException() instanceof RuntimeException)) break block6;
                throw (RuntimeException)((CoreException)e.getCause()).getStatus().getException();
            }
        }
        return 0;
    }

    public void destroy() {
        try {
            this.fSession.getExecutor().execute((Runnable)new DsfRunnable(){

                public void run() {
                    MIInferiorProcess.this.doDestroy();
                }
            });
        }
        catch (RejectedExecutionException rejectedExecutionException) {
            // empty catch block
        }
        this.closeIO();
    }

    private void closeIO() {
        try {
            this.fOutputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fInputStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fInputStreamPiped.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fErrorStream.close();
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            this.fErrorStreamPiped.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @ConfinedToDsfExecutor(value="fSession#getExecutor")
    private void doDestroy() {
        if (this.isDisposed() || !this.fSession.isActive() || this.getState() == State.TERMINATED) {
            return;
        }
        CLIExecAbort cmd = new CLIExecAbort(this.getCommandControl().getControlDMContext());
        this.getCommandControl().queueCommand(cmd, new DataRequestMonitor<MIInfo>(ImmediateExecutor.getInstance(), null){

            protected void handleCompleted() {
                MIInferiorProcess.this.setState(State.TERMINATED);
            }
        });
    }

    public State getState() {
        return this.fState;
    }

    synchronized void setState(State state) {
        if (this.fState == State.TERMINATED) {
            return;
        }
        this.fState = state;
        if (this.fState == State.TERMINATED) {
            this.closeIO();
        }
        this.notifyAll();
    }

    public OutputStream getPipedOutputStream() {
        return this.fInputStreamPiped;
    }

    public OutputStream getPipedErrorStream() {
        return this.fErrorStreamPiped;
    }

    public PTY getPTY() {
        return this.fPty;
    }

    public void eventReceived(Object output) {
        for (MIOOBRecord oobr : ((MIOutput)output).getMIOOBRecords()) {
            if (oobr instanceof MIExecAsyncOutput) {
                MIExecAsyncOutput async = (MIExecAsyncOutput)oobr;
                String state = async.getAsyncClass();
                if (!"stopped".equals(state)) continue;
                boolean handled = false;
                MIResult[] results = async.getMIResults();
                for (int i = 0; i < results.length; ++i) {
                    MIValue value;
                    String var = results[i].getVariable();
                    if (!var.equals("reason") || !((value = results[i].getMIValue()) instanceof MIConst)) continue;
                    String reason = ((MIConst)value).getString();
                    if ("exited-signalled".equals(reason) || "exited-normally".equals(reason) || "exited".equals(reason)) {
                        this.setState(State.TERMINATED);
                    } else {
                        this.setState(State.STOPPED);
                    }
                    handled = true;
                }
                if (handled) continue;
                this.setState(State.STOPPED);
                continue;
            }
            if (!(oobr instanceof MITargetStreamOutput)) continue;
            if (this.fSuppressTargetOutputCounter > 0) {
                return;
            }
            MITargetStreamOutput tgtOut = (MITargetStreamOutput)oobr;
            if (this.fInputStreamPiped == null || tgtOut.getString() == null) continue;
            try {
                this.fInputStreamPiped.write(tgtOut.getString().getBytes());
                this.fInputStreamPiped.flush();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
        if (token.getCommand() instanceof CLICommand) {
            ++this.fSuppressTargetOutputCounter;
        }
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        MIInfo cmdResult;
        MIOutput output;
        MIResultRecord rr;
        String state;
        if (token.getCommand() instanceof CLICommand) {
            --this.fSuppressTargetOutputCounter;
        }
        if ("running".equals(state = (rr = (output = (cmdResult = (MIInfo)result).getMIOutput()).getMIResultRecord()).getResultClass())) {
            this.setState(State.RUNNING);
        } else if ("exit".equals(state)) {
            this.setState(State.TERMINATED);
        } else if ("error".equals(state)) {
            this.setState(State.STOPPED);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum State {
        RUNNING,
        STOPPED,
        TERMINATED;

    }
}

