/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.mi.service.command;

import java.util.LinkedList;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.command.ICommand;
import org.eclipse.dd.dsf.debug.service.command.ICommandListener;
import org.eclipse.dd.dsf.debug.service.command.ICommandResult;
import org.eclipse.dd.dsf.debug.service.command.ICommandToken;
import org.eclipse.dd.dsf.debug.service.command.IEventListener;
import org.eclipse.dd.dsf.service.DsfServicesTracker;
import org.eclipse.dd.mi.internal.MIPlugin;
import org.eclipse.dd.mi.service.MIRunControl;
import org.eclipse.dd.mi.service.command.AbstractMIControl;
import org.eclipse.dd.mi.service.command.commands.MIExecContinue;
import org.eclipse.dd.mi.service.command.commands.MIExecFinish;
import org.eclipse.dd.mi.service.command.commands.MIExecNext;
import org.eclipse.dd.mi.service.command.commands.MIExecNextInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecReturn;
import org.eclipse.dd.mi.service.command.commands.MIExecStep;
import org.eclipse.dd.mi.service.command.commands.MIExecStepInstruction;
import org.eclipse.dd.mi.service.command.commands.MIExecUntil;
import org.eclipse.dd.mi.service.command.events.MIBreakpointHitEvent;
import org.eclipse.dd.mi.service.command.events.MIEvent;
import org.eclipse.dd.mi.service.command.events.MIFunctionFinishedEvent;
import org.eclipse.dd.mi.service.command.events.MIInferiorExitEvent;
import org.eclipse.dd.mi.service.command.events.MIInferiorSignalExitEvent;
import org.eclipse.dd.mi.service.command.events.MILocationReachedEvent;
import org.eclipse.dd.mi.service.command.events.MIRunningEvent;
import org.eclipse.dd.mi.service.command.events.MISignalEvent;
import org.eclipse.dd.mi.service.command.events.MISteppingRangeEvent;
import org.eclipse.dd.mi.service.command.events.MIStoppedEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointScopeEvent;
import org.eclipse.dd.mi.service.command.events.MIWatchpointTriggerEvent;
import org.eclipse.dd.mi.service.command.output.MIConst;
import org.eclipse.dd.mi.service.command.output.MIExecAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIInfo;
import org.eclipse.dd.mi.service.command.output.MINotifyAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIOOBRecord;
import org.eclipse.dd.mi.service.command.output.MIOutput;
import org.eclipse.dd.mi.service.command.output.MIResult;
import org.eclipse.dd.mi.service.command.output.MIResultRecord;
import org.eclipse.dd.mi.service.command.output.MIStatusAsyncOutput;
import org.eclipse.dd.mi.service.command.output.MIValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MIRunControlEventProcessor
implements IEventListener,
ICommandListener {
    private final AbstractMIControl fCommandControl;
    private final IRunControl.IContainerDMContext fContainerDmc;
    private final DsfServicesTracker fServicesTracker;

    public MIRunControlEventProcessor(AbstractMIControl connection, IRunControl.IContainerDMContext containerDmc) {
        this.fCommandControl = connection;
        this.fContainerDmc = containerDmc;
        this.fServicesTracker = new DsfServicesTracker(MIPlugin.getBundleContext(), this.fCommandControl.getSession().getId());
        connection.addEventListener(this);
        connection.addCommandListener(this);
    }

    public void dispose() {
        this.fCommandControl.removeEventListener(this);
        this.fCommandControl.removeCommandListener(this);
        this.fServicesTracker.dispose();
    }

    public void eventReceived(Object output) {
        for (MIOOBRecord oobr : ((MIOutput)output).getMIOOBRecords()) {
            if (oobr instanceof MIExecAsyncOutput) {
                MIExecAsyncOutput exec = (MIExecAsyncOutput)oobr;
                String state = exec.getAsyncClass();
                if (!"stopped".equals(state)) continue;
                this.fCommandControl.resetCurrentThreadLevel();
                this.fCommandControl.resetCurrentStackLevel();
                LinkedList events = new LinkedList();
                MIResult[] results = exec.getMIResults();
                for (int i = 0; i < results.length; ++i) {
                    String reason;
                    MIEvent<?> e;
                    String string = results[i].getVariable();
                    MIValue val = results[i].getMIValue();
                    if (!string.equals("reason") || !(val instanceof MIConst) || (e = this.createEvent(reason = ((MIConst)val).getString(), exec)) == null) continue;
                    events.add(e);
                }
                if (events.isEmpty()) {
                    MIStoppedEvent e = MIStoppedEvent.parse((MIRunControl)((Object)this.fServicesTracker.getService(MIRunControl.class)), this.fContainerDmc, exec.getToken(), exec.getMIResults());
                    events.add(e);
                }
                for (MIEvent mIEvent : events) {
                    this.fCommandControl.getSession().dispatchEvent((Object)mIEvent, this.fCommandControl.getProperties());
                }
                continue;
            }
            if (!(oobr instanceof MIStatusAsyncOutput) && !(oobr instanceof MINotifyAsyncOutput)) continue;
        }
    }

    protected MIEvent<?> createEvent(String reason, MIExecAsyncOutput exec) {
        MIRunControl runControl = (MIRunControl)((Object)this.fServicesTracker.getService(MIRunControl.class));
        MIEvent event = null;
        if ("breakpoint-hit".equals(reason)) {
            event = MIBreakpointHitEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-trigger".equals(reason) || "read-watchpoint-trigger".equals(reason) || "access-watchpoint-trigger".equals(reason)) {
            event = MIWatchpointTriggerEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("watchpoint-scope".equals(reason)) {
            event = MIWatchpointScopeEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("end-stepping-range".equals(reason)) {
            event = MISteppingRangeEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("signal-received".equals(reason)) {
            event = MISignalEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("location-reached".equals(reason)) {
            event = MILocationReachedEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("function-finished".equals(reason)) {
            event = MIFunctionFinishedEvent.parse(runControl, this.fContainerDmc, exec.getToken(), exec.getMIResults());
        } else if ("exited-normally".equals(reason) || "exited".equals(reason)) {
            event = MIInferiorExitEvent.parse(this.fCommandControl.getControlDMContext(), exec.getToken(), exec.getMIResults());
        } else if ("exited-signalled".equals(reason)) {
            event = MIInferiorSignalExitEvent.parse(this.fCommandControl.getControlDMContext(), exec.getToken(), exec.getMIResults());
        }
        return event;
    }

    public void commandQueued(ICommandToken token) {
    }

    public void commandSent(ICommandToken token) {
    }

    public void commandRemoved(ICommandToken token) {
    }

    public void commandDone(ICommandToken token, ICommandResult result) {
        ICommand cmd = token.getCommand();
        MIInfo cmdResult = (MIInfo)result;
        MIOutput output = cmdResult.getMIOutput();
        MIResultRecord rr = output.getMIResultRecord();
        if (rr != null) {
            int id = rr.getToken();
            String state = rr.getResultClass();
            if ("running".equals(state)) {
                int type = 0;
                type = cmd instanceof MIExecNext ? 1 : (cmd instanceof MIExecNextInstruction ? 2 : (cmd instanceof MIExecStep ? 3 : (cmd instanceof MIExecStepInstruction ? 4 : (cmd instanceof MIExecUntil ? 6 : (cmd instanceof MIExecFinish ? 5 : (cmd instanceof MIExecReturn ? 7 : (cmd instanceof MIExecContinue ? 0 : 0)))))));
                this.fCommandControl.getSession().dispatchEvent((Object)new MIRunningEvent((IRunControl.IExecutionDMContext)this.fContainerDmc, id, type), this.fCommandControl.getProperties());
            } else if ("exit".equals(state) || "connected".equals(state) || "error".equals(state)) {
                // empty if block
            }
        }
    }
}

