/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.debug.ui.memory.search;

import java.lang.reflect.Method;
import java.math.BigInteger;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dd.debug.ui.memory.search.MemoryMatch;
import org.eclipse.dd.debug.ui.memory.search.MemorySearchPlugin;
import org.eclipse.dd.debug.ui.memory.search.MemorySearchResult;
import org.eclipse.dd.debug.ui.memory.search.Messages;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IMemoryBlockExtension;
import org.eclipse.debug.core.model.MemoryByte;
import org.eclipse.debug.internal.ui.views.memory.MemoryView;
import org.eclipse.debug.ui.memory.IMemoryRendering;
import org.eclipse.debug.ui.memory.IMemoryRenderingContainer;
import org.eclipse.debug.ui.memory.IRepositionableMemoryRendering;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search.ui.NewSearchUI;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.SelectionDialog;

public class FindReplaceDialog
extends SelectionDialog {
    private IMemoryBlockExtension fMemoryBlock;
    static final int preFetchSize = 10240;
    private Text fFindText;
    private Text fReplaceText;
    private Combo fStartText;
    private Combo fEndText;
    private Button fFindButton;
    private Button fFindAllButton;
    private Button fReplaceButton;
    private Button fReplaceFindButton;
    private Button fReplaceAllButton;
    private Button fCloseButton;
    private MemoryView fMemoryView;
    private Button fFormatAsciiButton;
    private Button fFormatHexButton;
    private Button fFormatOctalButton;
    private Button fFormatBinaryButton;
    private Button fFormatDecimalButton;
    private Button fFormatByteSequenceButton;
    private Button fCaseInSensitiveCheckbox;
    private Button fWrapCheckbox;
    private Button fForwardButton;
    private Properties fProperties;
    protected static final String SEARCH_FIND = "SEARCH_FIND";
    protected static final String SEARCH_REPLACE = "SEARCH_REPLACE";
    protected static final String SEARCH_START = "SEARCH_START";
    protected static final String SEARCH_END = "SEARCH_END";
    protected static final String SEARCH_LAST_FOUND = "SEARCH_LAST_FOUND";
    protected static final String SEARCH_FORMAT = "SEARCH_FORMAT";
    protected static final String SEARCH_FORMAT_ASCII = "SEARCH_FORMAT_ASCII";
    protected static final String SEARCH_FORMAT_HEX = "SEARCH_FORMAT_HEX";
    protected static final String SEARCH_FORMAT_OCTAL = "SEARCH_FORMAT_OCTAL";
    protected static final String SEARCH_FORMAT_BINARY = "SEARCH_FORMAT_BINARY";
    protected static final String SEARCH_FORMAT_DECIMAL = "SEARCH_FORMAT_DECIMAL";
    protected static final String SEARCH_FORMAT_BYTESEQUENCE = "SEARCH_FORMAT_BYTESEQUENCE";
    protected static final String SEARCH_FORMAT_CASEINSENSTIVE = "SEARCH_FORMAT_CASEINSENSTIVE";
    protected static final String SEARCH_FORMAT_FORWARD = "SEARCH_FORMAT_FORWARD";
    protected static final String SEARCH_FORMAT_WRAP = "SEARCH_FORMAT_WRAP";
    protected static final String SEARCH_ENABLE_FIND_NEXT = "SEARCH_ENABLE_FIND_NEXT";

    public FindReplaceDialog(Shell parent, IMemoryBlockExtension memoryBlock, MemoryView memoryView, Properties properties) {
        super(parent);
        super.setTitle(Messages.getString("FindReplaceDialog.Title"));
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.fMemoryBlock = memoryBlock;
        this.fMemoryView = memoryView;
        this.fProperties = properties;
        this.setBlockOnOpen(false);
    }

    private BigInteger getUserStart() {
        String start = this.fStartText.getText();
        if (start.toUpperCase().startsWith("0X")) {
            start = start.substring(2);
        }
        return new BigInteger(start, 16);
    }

    private BigInteger getUserEnd() {
        String end = this.fEndText.getText();
        if (end.toUpperCase().startsWith("0X")) {
            end = end.substring(2);
        }
        return new BigInteger(end, 16);
    }

    private boolean getIsDirectionForward() {
        return this.fForwardButton.getSelection();
    }

    private SearchPhrase getSearchPhrase() {
        SearchPhrase phrase = null;
        if (this.fFormatAsciiButton.getSelection()) {
            phrase = new AsciiSearchPhrase(this.fFindText.getText(), this.fCaseInSensitiveCheckbox.getSelection());
        } else if (this.fFormatHexButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.fFindText.getText().toUpperCase().startsWith("0X") ? this.fFindText.getText().substring(2) : this.fFindText.getText(), 16), 16);
        } else if (this.fFormatOctalButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.fFindText.getText().startsWith("0") ? this.fFindText.getText().substring(1) : this.fFindText.getText(), 8), 8);
        } else if (this.fFormatBinaryButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.fFindText.getText().toUpperCase().startsWith("0B") ? this.fFindText.getText().substring(2) : this.fFindText.getText(), 2), 2);
        } else if (this.fFormatDecimalButton.getSelection()) {
            phrase = new BigIntegerSearchPhrase(new BigInteger(this.fFindText.getText(), 10), 10);
        } else if (this.fFormatByteSequenceButton.getSelection()) {
            phrase = new ByteSequenceSearchPhrase(this.fFindText.getText());
        }
        return phrase;
    }

    protected byte[] parseByteSequence(String s) {
        Vector<Byte> sequence = new Vector<Byte>();
        StringTokenizer st = new StringTokenizer(s, " ");
        while (st.hasMoreElements()) {
            String element = ((String)st.nextElement()).trim();
            if (element.length() <= 0) continue;
            BigInteger value = element.toUpperCase().startsWith("0X") ? new BigInteger(element.substring(2), 16) : (element.toUpperCase().startsWith("0B") ? new BigInteger(element.substring(2), 2) : (element.toUpperCase().startsWith("0") ? new BigInteger(element.substring(1), 8) : new BigInteger(element, 10)));
            Byte b = new Byte(value.byteValue());
            if (value.compareTo(BigInteger.valueOf(255L)) > 0) {
                return null;
            }
            sequence.addElement(b);
        }
        Byte[] seq = sequence.toArray(new Byte[sequence.size()]);
        byte[] bytes = new byte[seq.length];
        for (int i = 0; i < seq.length; ++i) {
            bytes[i] = seq[i];
        }
        return bytes;
    }

    private byte[] getReplaceData() {
        if (this.fFormatAsciiButton.getSelection()) {
            return this.fReplaceText.getText().getBytes();
        }
        if (this.fFormatHexButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.fReplaceText.getText().toUpperCase().startsWith("0X") ? this.fReplaceText.getText().substring(2) : this.fReplaceText.getText(), 16).toByteArray());
        }
        if (this.fFormatOctalButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.fReplaceText.getText().startsWith("0") ? this.fReplaceText.getText().substring(1) : this.fReplaceText.getText(), 8).toByteArray());
        }
        if (this.fFormatBinaryButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.fReplaceText.getText().toUpperCase().startsWith("0B") ? this.fReplaceText.getText().substring(2) : this.fReplaceText.getText(), 2).toByteArray());
        }
        if (this.fFormatDecimalButton.getSelection()) {
            return this.removeZeroPrefixByte(new BigInteger(this.fReplaceText.getText(), 10).toByteArray());
        }
        if (this.fFormatByteSequenceButton.getSelection()) {
            return this.parseByteSequence(this.fReplaceText.getText());
        }
        return new byte[0];
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.fFindButton = this.createButton(parent, 10, Messages.getString("FindReplaceDialog.ButtonFind"), true);
        this.fFindButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), null, false, false);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.fFindAllButton = this.createButton(parent, 10, Messages.getString("FindReplaceDialog.ButtonFindAll"), true);
        this.fFindAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), null, true, false);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.fReplaceFindButton = this.createButton(parent, 11, Messages.getString("FindReplaceDialog.ButtonReplaceFind"), false);
        this.fReplaceFindButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), FindReplaceDialog.this.getReplaceData(), false, true);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.fReplaceButton = this.createButton(parent, 12, Messages.getString("FindReplaceDialog.ButtonReplace"), false);
        this.fReplaceButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), FindReplaceDialog.this.getReplaceData(), false, false);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.fReplaceAllButton = this.createButton(parent, 13, Messages.getString("FindReplaceDialog.ButtonReplaceAll"), false);
        this.fReplaceAllButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.performFind(FindReplaceDialog.this.getUserStart(), FindReplaceDialog.this.getUserEnd(), FindReplaceDialog.this.getSearchPhrase(), FindReplaceDialog.this.getIsDirectionForward(), FindReplaceDialog.this.getReplaceData(), true, false);
                FindReplaceDialog.this.cancelPressed();
            }
        });
        this.fCloseButton = this.createButton(parent, 1, Messages.getString("FindReplaceDialog.Close"), false);
        ((GridLayout)parent.getLayout()).numColumns = 2;
        this.validate();
    }

    public Object[] getResult() {
        Object[] results = super.getResult();
        if (results != null) {
            return results;
        }
        return new Object[0];
    }

    protected void cancelPressed() {
        this.fProperties.setProperty(SEARCH_FIND, this.fFindText.getText());
        this.fProperties.setProperty(SEARCH_REPLACE, this.fReplaceText.getText());
        this.fProperties.setProperty(SEARCH_START, this.fStartText.getText());
        this.fProperties.setProperty(SEARCH_END, this.fEndText.getText());
        if (this.fFormatAsciiButton.getSelection()) {
            this.fProperties.setProperty(SEARCH_FORMAT, SEARCH_FORMAT_ASCII);
        } else if (this.fFormatBinaryButton.getSelection()) {
            this.fProperties.setProperty(SEARCH_FORMAT, SEARCH_FORMAT_BINARY);
        } else if (this.fFormatByteSequenceButton.getSelection()) {
            this.fProperties.setProperty(SEARCH_FORMAT, SEARCH_FORMAT_BYTESEQUENCE);
        } else if (this.fFormatDecimalButton.getSelection()) {
            this.fProperties.setProperty(SEARCH_FORMAT, SEARCH_FORMAT_DECIMAL);
        } else if (this.fFormatHexButton.getSelection()) {
            this.fProperties.setProperty(SEARCH_FORMAT, SEARCH_FORMAT_HEX);
        } else if (this.fFormatOctalButton.getSelection()) {
            this.fProperties.setProperty(SEARCH_FORMAT, SEARCH_FORMAT_OCTAL);
        }
        this.fProperties.setProperty(SEARCH_FORMAT_FORWARD, "" + this.fForwardButton.getSelection());
        this.fProperties.setProperty(SEARCH_FORMAT_CASEINSENSTIVE, "" + this.fCaseInSensitiveCheckbox.getSelection());
        this.fProperties.setProperty(SEARCH_FORMAT_WRAP, "" + this.fWrapCheckbox.getSelection());
        this.fProperties.setProperty(SEARCH_ENABLE_FIND_NEXT, "false");
        this.setResult(null);
        super.cancelPressed();
    }

    protected void okPressed() {
        this.setSelectionResult(new Object[]{this.fProperties});
        super.okPressed();
    }

    public BigInteger getEndAddress() {
        String text = this.fEndText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger endAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return endAddress;
    }

    public BigInteger getStartAddress() {
        String text = this.fStartText.getText();
        boolean hex = text.startsWith("0x");
        BigInteger startAddress = new BigInteger(hex ? text.substring(2) : text, hex ? 16 : 10);
        return startAddress;
    }

    private void validate() {
        boolean valid = false;
        boolean replaceValid = false;
        try {
            BigInteger endAddress = this.getEndAddress();
            BigInteger startAddress = this.getStartAddress();
            if (startAddress.compareTo(endAddress) == -1) {
                if (this.getSearchPhrase() != null && this.getSearchPhrase().getByteLength() > 0) {
                    valid = true;
                }
                if (this.getReplaceData() != null && this.getReplaceData().length > 0) {
                    replaceValid = true;
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.fFindButton.setEnabled(valid);
        this.fReplaceButton.setEnabled(replaceValid);
        this.fReplaceFindButton.setEnabled(replaceValid);
        this.fReplaceAllButton.setEnabled(replaceValid);
    }

    private String pad(int characterCount, String value) {
        StringBuffer sb = new StringBuffer(value);
        for (int i = 0; i < characterCount - value.length(); ++i) {
            sb.insert(0, "0");
        }
        return sb.toString();
    }

    private String[] removeNullElements(String[] strings) {
        Vector<String> nonNullStrings = new Vector<String>();
        for (String string : strings) {
            if (string == null) continue;
            nonNullStrings.addElement(string);
        }
        return nonNullStrings.toArray(new String[0]);
    }

    private String getMemoryBlockBaseAddress() {
        BigInteger base = null;
        try {
            base = this.fMemoryBlock.getBigBaseAddress();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (base == null) {
            base = BigInteger.ZERO;
        }
        return "0x" + this.pad(this.getAddressSize() * 2, base.toString(16).toUpperCase());
    }

    private String getViewportStart() {
        ISelection selection = this.fMemoryView.getViewPane("org.eclipse.debug.ui.MemoryView.RenderingViewPane.1").getSelectionProvider().getSelection();
        if (selection instanceof StructuredSelection && ((StructuredSelection)selection).getFirstElement() instanceof IRepositionableMemoryRendering) {
            ((IRepositionableMemoryRendering)((StructuredSelection)selection).getFirstElement()).getSelectedAddress();
        }
        return null;
    }

    private String getStart() {
        BigInteger start = null;
        try {
            start = this.fMemoryBlock.getMemoryBlockStartAddress();
        }
        catch (DebugException debugException) {
            // empty catch block
        }
        if (start == null) {
            start = BigInteger.ZERO;
        }
        return "0x" + this.pad(this.getAddressSize() * 2, start.toString(16).toUpperCase());
    }

    private String getEnd() {
        BigInteger end = null;
        try {
            end = this.fMemoryBlock.getMemoryBlockEndAddress();
        }
        catch (DebugException de) {
            // empty catch block
        }
        if (end == null) {
            end = BigInteger.ZERO;
            for (int i = this.getAddressSize(); i > 0; --i) {
                end = end.shiftLeft(8);
                end = end.or(BigInteger.valueOf(255L));
            }
        }
        return "0x" + this.pad(this.getAddressSize() * 2, end.toString(16).toUpperCase());
    }

    private int getAddressSize() {
        int addressSize;
        try {
            addressSize = this.fMemoryBlock.getAddressSize();
        }
        catch (DebugException de) {
            addressSize = 4;
        }
        return addressSize;
    }

    protected Control createDialogArea(Composite parent) {
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)parent, MemorySearchPlugin.getUniqueIdentifier() + ".MemorySearchDialog_context");
        Composite composite = new Composite(parent, 0);
        FormLayout formLayout = new FormLayout();
        formLayout.spacing = 5;
        formLayout.marginHeight = 9;
        formLayout.marginWidth = 9;
        composite.setLayout((Layout)formLayout);
        Label findLabel = new Label(composite, 0);
        Label replaceLabel = new Label(composite, 0);
        this.fReplaceText = new Text(composite, 2048);
        findLabel.setText(Messages.getString("FindReplaceDialog.LabelFind"));
        this.fFindText = new Text(composite, 2048);
        FormData data = new FormData();
        data.left = new FormAttachment((Control)this.fReplaceText, 0, 16384);
        data.width = 260;
        this.fFindText.setLayoutData((Object)data);
        this.fFindText.setText(this.fProperties.getProperty(SEARCH_FIND, ""));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fFindText, 0, 0x1000000);
        findLabel.setLayoutData((Object)data);
        replaceLabel.setText(Messages.getString("FindReplaceDialog.LabelReplaceWith"));
        data = new FormData();
        data.top = new FormAttachment((Control)this.fFindText);
        replaceLabel.setLayoutData((Object)data);
        data = new FormData();
        data.top = new FormAttachment((Control)replaceLabel, 0, 0x1000000);
        data.left = new FormAttachment((Control)replaceLabel);
        data.width = 260;
        this.fReplaceText.setLayoutData((Object)data);
        this.fReplaceText.setText(this.fProperties.getProperty(SEARCH_REPLACE, ""));
        Group directionGroup = new Group(composite, 0);
        Group formatGroup = new Group(composite, 0);
        Group rangeGroup = new Group(composite, 0);
        directionGroup.setText(Messages.getString("FindReplaceDialog.LabelDirection"));
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        directionGroup.setLayout((Layout)layout);
        this.fForwardButton = new Button((Composite)directionGroup, 16);
        this.fForwardButton.setText(Messages.getString("FindReplaceDialog.ButtonForward"));
        Button backwardButton = new Button((Composite)directionGroup, 16);
        backwardButton.setText(Messages.getString("FindReplaceDialog.ButtonBackward"));
        boolean isForward = this.fProperties.getProperty(SEARCH_FORMAT_FORWARD, "true").equalsIgnoreCase("true");
        this.fForwardButton.setSelection(isForward);
        backwardButton.setSelection(!isForward);
        data = new FormData();
        data.top = new FormAttachment((Control)this.fReplaceText);
        data.right = new FormAttachment((Control)formatGroup, 0, 131072);
        data.left = new FormAttachment((Control)formatGroup, 0, 16384);
        data.bottom = new FormAttachment((Control)rangeGroup, 0, 1024);
        directionGroup.setLayoutData((Object)data);
        rangeGroup.setText(Messages.getString("FindReplaceDialog.LabelRange"));
        layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = false;
        rangeGroup.setLayout((Layout)layout);
        Label startLabel = new Label((Composite)rangeGroup, 0);
        startLabel.setText(Messages.getString("FindReplaceDialog.LabelStartAddress"));
        this.fStartText = new Combo((Composite)rangeGroup, 2048);
        GridData gridData = new GridData();
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        this.fStartText.setLayoutData((Object)gridData);
        Label endLabel = new Label((Composite)rangeGroup, 0);
        endLabel.setText(Messages.getString("FindReplaceDialog.LabelEndAddress"));
        this.fEndText = new Combo((Composite)rangeGroup, 2048);
        gridData = new GridData();
        gridData.widthHint = 200;
        gridData.grabExcessHorizontalSpace = true;
        this.fEndText.setLayoutData((Object)gridData);
        data = new FormData();
        data.left = new FormAttachment((Control)directionGroup);
        data.top = new FormAttachment((Control)directionGroup, 0, 128);
        data.right = new FormAttachment((Control)this.fFindText, 0, 131072);
        rangeGroup.setLayoutData((Object)data);
        this.fStartText.setItems(this.removeNullElements(new String[]{this.getViewportStart(), this.getStart(), this.getEnd(), this.getMemoryBlockBaseAddress()}));
        this.fEndText.setItems(this.removeNullElements(new String[]{this.getEnd(), this.getStart(), this.getMemoryBlockBaseAddress(), this.getViewportStart()}));
        if (this.fProperties.getProperty(SEARCH_START) != null) {
            this.fStartText.add(this.fProperties.getProperty(SEARCH_START), 0);
        }
        if (this.fProperties.getProperty(SEARCH_END) != null) {
            this.fEndText.add(this.fProperties.getProperty(SEARCH_END), 0);
        }
        this.fStartText.select(0);
        this.fEndText.select(0);
        formatGroup.setText(Messages.getString("FindReplaceDialog.LabelFormat"));
        layout = new GridLayout();
        layout.numColumns = 1;
        formatGroup.setLayout((Layout)layout);
        this.fFormatAsciiButton = new Button((Composite)formatGroup, 16);
        this.fFormatAsciiButton.setText(Messages.getString("FindReplaceDialog.ButtonASCII"));
        this.fFormatHexButton = new Button((Composite)formatGroup, 16);
        this.fFormatHexButton.setText(Messages.getString("FindReplaceDialog.ButtonHexadecimal"));
        this.fFormatOctalButton = new Button((Composite)formatGroup, 16);
        this.fFormatOctalButton.setText(Messages.getString("FindReplaceDialog.ButtonOctal"));
        this.fFormatBinaryButton = new Button((Composite)formatGroup, 16);
        this.fFormatBinaryButton.setText(Messages.getString("FindReplaceDialog.ButtonBinary"));
        this.fFormatDecimalButton = new Button((Composite)formatGroup, 16);
        this.fFormatDecimalButton.setText(Messages.getString("FindReplaceDialog.ButtonDecimal"));
        this.fFormatByteSequenceButton = new Button((Composite)formatGroup, 16);
        this.fFormatByteSequenceButton.setText(Messages.getString("FindReplaceDialog.ButtonByteSequence"));
        String format = this.fProperties.getProperty(SEARCH_FORMAT, SEARCH_FORMAT_ASCII);
        this.fFormatAsciiButton.setSelection(format.equals(SEARCH_FORMAT_ASCII));
        this.fFormatOctalButton.setSelection(format.equals(SEARCH_FORMAT_OCTAL));
        this.fFormatBinaryButton.setSelection(format.equals(SEARCH_FORMAT_BINARY));
        this.fFormatDecimalButton.setSelection(format.equals(SEARCH_FORMAT_DECIMAL));
        this.fFormatHexButton.setSelection(format.equals(SEARCH_FORMAT_HEX));
        this.fFormatByteSequenceButton.setSelection(format.equals(SEARCH_FORMAT_BYTESEQUENCE));
        data = new FormData();
        data.top = new FormAttachment((Control)rangeGroup);
        formatGroup.setLayoutData((Object)data);
        Group optionsGroup = new Group(composite, 0);
        optionsGroup.setText(Messages.getString("FindReplaceDialog.LabelOptions"));
        data = new FormData();
        data.left = new FormAttachment((Control)formatGroup);
        data.top = new FormAttachment((Control)rangeGroup);
        data.bottom = new FormAttachment((Control)formatGroup, 0, 1024);
        data.right = new FormAttachment((Control)rangeGroup, 0, 131072);
        optionsGroup.setLayoutData((Object)data);
        layout = new GridLayout();
        layout.numColumns = 1;
        optionsGroup.setLayout((Layout)layout);
        this.fWrapCheckbox = new Button((Composite)optionsGroup, 32);
        this.fWrapCheckbox.setText(Messages.getString("FindReplaceDialog.ButtonWrapSearch"));
        this.fWrapCheckbox.setEnabled(false);
        this.fCaseInSensitiveCheckbox = new Button((Composite)optionsGroup, 32);
        this.fCaseInSensitiveCheckbox.setText(Messages.getString("FindReplaceDialog.ButtonCaseInsensitive"));
        this.fFormatAsciiButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.fCaseInSensitiveCheckbox.setEnabled(true);
            }
        });
        SelectionListener nonAsciiListener = new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                FindReplaceDialog.this.fCaseInSensitiveCheckbox.setEnabled(false);
                FindReplaceDialog.this.validate();
            }
        };
        this.fFormatHexButton.addSelectionListener(nonAsciiListener);
        this.fFormatOctalButton.addSelectionListener(nonAsciiListener);
        this.fFormatBinaryButton.addSelectionListener(nonAsciiListener);
        this.fFormatDecimalButton.addSelectionListener(nonAsciiListener);
        this.fFormatByteSequenceButton.addSelectionListener(nonAsciiListener);
        this.fStartText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                boolean valid = true;
                try {
                    FindReplaceDialog.this.getStartAddress();
                }
                catch (Exception ex) {
                    valid = false;
                }
                FindReplaceDialog.this.fStartText.setForeground(valid ? Display.getDefault().getSystemColor(2) : Display.getDefault().getSystemColor(3));
                FindReplaceDialog.this.validate();
            }
        });
        this.fEndText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                try {
                    FindReplaceDialog.this.getEndAddress();
                    FindReplaceDialog.this.fEndText.setForeground(Display.getDefault().getSystemColor(2));
                }
                catch (Exception ex) {
                    FindReplaceDialog.this.fEndText.setForeground(Display.getDefault().getSystemColor(3));
                }
                FindReplaceDialog.this.validate();
            }
        });
        this.fFindText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindReplaceDialog.this.validate();
            }
        });
        this.fReplaceText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FindReplaceDialog.this.validate();
            }
        });
        composite.setTabList(new Control[]{this.fFindText, this.fReplaceText, directionGroup, rangeGroup, formatGroup, optionsGroup});
        this.fFindText.setFocus();
        return composite;
    }

    MemoryByte[] getBytesFromAddress(BigInteger address, int length, FindReplaceMemoryCache cache) throws DebugException {
        if (address.compareTo(cache.memoryCacheStartAddress) < 0 || address.add(BigInteger.valueOf(length)).compareTo(cache.memoryCacheStartAddress.add(BigInteger.valueOf(cache.memoryCacheData.length))) >= 0) {
            BigInteger fetchAddress = address.subtract(BigInteger.valueOf(10240L));
            if (fetchAddress.compareTo(BigInteger.ZERO) < 0) {
                fetchAddress = BigInteger.ZERO;
            }
            MemoryByte[] bytes = this.fMemoryBlock.getBytesFromAddress(fetchAddress, 20480L);
            cache.memoryCacheStartAddress = fetchAddress;
            cache.memoryCacheData = bytes;
        }
        MemoryByte[] bytes = new MemoryByte[length];
        System.arraycopy(cache.memoryCacheData, address.subtract(cache.memoryCacheStartAddress).intValue(), bytes, 0, length);
        return bytes;
    }

    private BigInteger parseHexBigInteger(String s) {
        if (s.toUpperCase().startsWith("0X")) {
            return new BigInteger(s.substring(2), 16);
        }
        return new BigInteger(s, 16);
    }

    protected void performFindNext() {
        try {
            BigInteger start = this.parseHexBigInteger(this.fProperties.getProperty(SEARCH_LAST_FOUND));
            BigInteger end = this.parseHexBigInteger(this.fProperties.getProperty(SEARCH_END));
            boolean searchForward = this.fProperties.getProperty(SEARCH_FORMAT_FORWARD, "false").equals("true");
            boolean caseInSensitive = this.fProperties.getProperty(SEARCH_FORMAT_CASEINSENSTIVE, "false").equals("true");
            start = searchForward ? start.add(BigInteger.ONE) : start.subtract(BigInteger.ONE);
            SearchPhrase phrase = null;
            String findText = this.fProperties.getProperty(SEARCH_FIND);
            if (this.fProperties.getProperty(SEARCH_FORMAT).equals(SEARCH_FORMAT_ASCII)) {
                phrase = new AsciiSearchPhrase(findText, caseInSensitive);
            } else if (this.fProperties.getProperty(SEARCH_FORMAT).equals(SEARCH_FORMAT_HEX)) {
                phrase = new BigIntegerSearchPhrase(new BigInteger(findText.toUpperCase().startsWith("0X") ? findText.substring(2) : findText, 16), 16);
            } else if (this.fProperties.getProperty(SEARCH_FORMAT).equals(SEARCH_FORMAT_OCTAL)) {
                phrase = new BigIntegerSearchPhrase(new BigInteger(findText.startsWith("0") ? findText.substring(1) : findText, 8), 8);
            } else if (this.fProperties.getProperty(SEARCH_FORMAT).equals(SEARCH_FORMAT_BINARY)) {
                phrase = new BigIntegerSearchPhrase(new BigInteger(findText.toUpperCase().startsWith("0B") ? findText.substring(2) : findText, 2), 2);
            } else if (this.fProperties.getProperty(SEARCH_FORMAT).equals(SEARCH_FORMAT_DECIMAL)) {
                phrase = new BigIntegerSearchPhrase(new BigInteger(findText, 10), 10);
            } else if (this.fProperties.getProperty(SEARCH_FORMAT).equals(SEARCH_FORMAT_BYTESEQUENCE)) {
                phrase = new ByteSequenceSearchPhrase(findText);
            }
            this.performFind(start, end, phrase, searchForward, null, false, false);
        }
        catch (Exception e) {
            MemorySearchPlugin.logError(Messages.getString("FindReplaceDialog.MemorySearchFailure"), e);
        }
    }

    private void performFind(final BigInteger start, final BigInteger end, final SearchPhrase searchPhrase, final boolean searchForward, final byte[] replaceData, final boolean all, final boolean replaceThenFind) {
        final IMemorySearchQuery query = new IMemorySearchQuery(){
            private ISearchResult fSearchResult = null;

            public boolean canRerun() {
                return false;
            }

            public boolean canRunInBackground() {
                return true;
            }

            public String getLabel() {
                return Messages.getString("FindReplaceDialog.SearchingMemoryFor") + searchPhrase;
            }

            public ISearchResult getSearchResult() {
                if (this.fSearchResult == null) {
                    this.fSearchResult = new MemorySearchResult(this, Messages.getString("FindReplaceDialog.SearchingMemoryFor") + searchPhrase);
                }
                return this.fSearchResult;
            }

            public IStatus run(IProgressMonitor monitor) throws OperationCanceledException {
                final BigInteger searchPhraseLength = BigInteger.valueOf(searchPhrase.getByteLength());
                BigInteger range = searchForward ? end.subtract(start) : start.subtract(end);
                BigInteger currentPosition = start;
                boolean isReplace = replaceData != null;
                BigInteger jobs = range.subtract(searchPhraseLength);
                BigInteger factor = BigInteger.ONE;
                if (jobs.compareTo(BigInteger.valueOf(0x7FFFFFFL)) > 0) {
                    factor = jobs.divide(BigInteger.valueOf(0x7FFFFFFL));
                    jobs = jobs.divide(factor);
                }
                BigInteger jobCount = BigInteger.ZERO;
                BigInteger replaceCount = BigInteger.ZERO;
                FindReplaceMemoryCache cache = new FindReplaceMemoryCache();
                monitor.beginTask(Messages.getString("FindReplaceDialog.SearchingMemoryFor") + searchPhrase, jobs.intValue());
                boolean matched = false;
                while ((searchForward && currentPosition.compareTo(end.subtract(searchPhraseLength)) < 0 || !searchForward && currentPosition.compareTo(end) > 0) && !monitor.isCanceled()) {
                    try {
                        MemoryByte[] bytes = FindReplaceDialog.this.getBytesFromAddress(currentPosition, searchPhraseLength.intValue(), cache);
                        matched = searchPhrase.isMatch(bytes);
                        if (matched) {
                            if (all && !isReplace) {
                                ((MemorySearchResult)this.getSearchResult()).addMatch(new MemoryMatch(currentPosition, searchPhraseLength));
                            }
                            if (isReplace) {
                                try {
                                    FindReplaceDialog.this.fMemoryBlock.setValue(currentPosition.subtract(FindReplaceDialog.this.fMemoryBlock.getBigBaseAddress()), replaceData);
                                }
                                catch (DebugException de) {
                                    MemorySearchPlugin.logError(Messages.getString("FindReplaceDialog.MemoryReadFailed"), (Exception)((Object)de));
                                }
                                replaceCount = replaceCount.add(BigInteger.ONE);
                            }
                            if (isReplace && replaceThenFind && replaceCount.compareTo(BigInteger.ONE) == 0) {
                                isReplace = false;
                                matched = false;
                            }
                            if (matched && !all) {
                                final BigInteger finalCurrentPosition = currentPosition;
                                Display.getDefault().asyncExec(new Runnable(){

                                    public void run() {
                                        IMemoryRenderingContainer[] containers = this.getMemoryView().getMemoryRenderingContainers();
                                        for (int i = 0; i < containers.length; ++i) {
                                            IMemoryRendering rendering = containers[i].getActiveRendering();
                                            if (rendering instanceof IRepositionableMemoryRendering) {
                                                try {
                                                    ((IRepositionableMemoryRendering)rendering).goToAddress(finalCurrentPosition);
                                                }
                                                catch (DebugException e) {
                                                    MemorySearchPlugin.logError(Messages.getString("FindReplaceDialog.RepositioningMemoryViewFailed"), (Exception)((Object)e));
                                                }
                                            }
                                            if (rendering == null) continue;
                                            try {
                                                Method m = rendering.getClass().getMethod("setSelection", BigInteger.class, BigInteger.class);
                                                if (m == null) continue;
                                                m.invoke((Object)rendering, finalCurrentPosition, finalCurrentPosition.add(searchPhraseLength));
                                                continue;
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                });
                                FindReplaceDialog.this.fProperties.setProperty(FindReplaceDialog.SEARCH_ENABLE_FIND_NEXT, "true");
                                FindReplaceDialog.this.fProperties.setProperty(FindReplaceDialog.SEARCH_LAST_FOUND, "0x" + finalCurrentPosition.toString(16));
                                return Status.OK_STATUS;
                            }
                        }
                        matched = false;
                        currentPosition = searchForward ? currentPosition.add(BigInteger.ONE) : currentPosition.subtract(BigInteger.ONE);
                    }
                    catch (DebugException e) {
                        MemorySearchPlugin.logError(Messages.getString("FindReplaceDialog.MemorySearchFailure"), (Exception)((Object)e));
                        return Status.CANCEL_STATUS;
                    }
                    if ((jobCount = jobCount.add(BigInteger.ONE)).compareTo(factor) != 0) continue;
                    jobCount = BigInteger.ZERO;
                    monitor.worked(1);
                }
                if (monitor.isCanceled()) {
                    return Status.CANCEL_STATUS;
                }
                return Status.OK_STATUS;
            }

            public MemoryView getMemoryView() {
                return FindReplaceDialog.this.fMemoryView;
            }
        };
        if (all && replaceData == null) {
            Display.getDefault().asyncExec(new Runnable(){

                public void run() {
                    NewSearchUI.activateSearchResultView();
                    NewSearchUI.runQueryInBackground((ISearchQuery)query);
                }
            });
        } else {
            Job job = new Job("Searching memory for " + searchPhrase){

                public IStatus run(IProgressMonitor monitor) {
                    return query.run(monitor);
                }
            };
            job.schedule();
        }
    }

    private byte[] removeZeroPrefixByte(byte[] bytes) {
        if (bytes[0] != 0 || bytes.length == 1) {
            return bytes;
        }
        byte[] processedBytes = new byte[bytes.length - 1];
        System.arraycopy(bytes, 1, processedBytes, 0, processedBytes.length);
        return processedBytes;
    }

    class AsciiSearchPhrase
    implements SearchPhrase {
        private String fPhrase;
        private boolean fIsCaseInsensitive;

        public AsciiSearchPhrase(String phrase, boolean isCaseInsensitive) {
            this.fPhrase = phrase;
            this.fIsCaseInsensitive = isCaseInsensitive;
        }

        public int getByteLength() {
            return this.fPhrase.length();
        }

        public String toString() {
            return this.fPhrase;
        }

        public boolean isMatch(MemoryByte[] bytes) {
            byte[] targetBytes = new byte[bytes.length];
            for (int i = 0; i < bytes.length; ++i) {
                targetBytes[i] = bytes[i].getValue();
            }
            String searchString = this.fPhrase;
            String targetString = new String(targetBytes);
            if (this.fIsCaseInsensitive) {
                searchString = searchString.toUpperCase();
                targetString = targetString.toUpperCase();
            }
            return searchString.equals(targetString);
        }
    }

    class BigIntegerSearchPhrase
    implements SearchPhrase {
        private BigInteger fPhrase;
        private int fRadix;

        public BigIntegerSearchPhrase(BigInteger phrase, int radix) {
            this.fPhrase = phrase;
            this.fRadix = radix;
        }

        public int getByteLength() {
            return FindReplaceDialog.this.removeZeroPrefixByte(this.fPhrase.toByteArray()).length;
        }

        public String toString() {
            return this.fPhrase.toString(this.fRadix);
        }

        public boolean isMatch(MemoryByte[] bytes) {
            byte[] targetBytes = new byte[bytes.length + 1];
            targetBytes[0] = 0;
            for (int i = 0; i < bytes.length; ++i) {
                targetBytes[i + 1] = bytes[i].getValue();
            }
            BigInteger targetBigInteger = new BigInteger(targetBytes);
            return this.fPhrase.equals(targetBigInteger);
        }
    }

    class ByteSequenceSearchPhrase
    implements SearchPhrase {
        private byte[] fBytes = null;

        public ByteSequenceSearchPhrase(String phrase) {
            this.fBytes = FindReplaceDialog.this.parseByteSequence(phrase);
        }

        public int getByteLength() {
            if (this.fBytes != null) {
                return this.fBytes.length;
            }
            return 0;
        }

        public String toString() {
            if (this.fBytes == null) {
                return "";
            }
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < this.fBytes.length; ++i) {
                buf.append(BigInteger.valueOf(this.fBytes[i]).toString(16) + " ");
            }
            return buf.toString();
        }

        public boolean isMatch(MemoryByte[] bytes) {
            if (this.fBytes == null) {
                return false;
            }
            for (int i = 0; i < bytes.length; ++i) {
                if (bytes[i].getValue() == this.fBytes[i]) continue;
                return false;
            }
            return true;
        }
    }

    class FindReplaceMemoryCache {
        BigInteger memoryCacheStartAddress = BigInteger.ZERO;
        MemoryByte[] memoryCacheData = new MemoryByte[0];

        FindReplaceMemoryCache() {
        }
    }

    static interface IMemorySearchQuery
    extends ISearchQuery {
        public MemoryView getMemoryView();
    }

    static interface SearchPhrase {
        public boolean isMatch(MemoryByte[] var1);

        public int getByteLength();

        public String toString();
    }
}

