/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch;

import org.eclipse.dd.dsf.datamodel.IDMContext;
import org.eclipse.dd.dsf.debug.internal.provisional.ui.viewmodel.launch.FullStackRefreshEvent;
import org.eclipse.dd.dsf.debug.service.IRunControl;
import org.eclipse.dd.dsf.debug.service.IStack;
import org.eclipse.dd.dsf.ui.viewmodel.datamodel.IDMVMContext;
import org.eclipse.dd.dsf.ui.viewmodel.update.IElementUpdateTester;
import org.eclipse.dd.dsf.ui.viewmodel.update.IVMUpdatePolicy;
import org.eclipse.dd.dsf.ui.viewmodel.update.UpdatePolicyDecorator;
import org.eclipse.jface.viewers.TreePath;

public class DelayedStackRefreshUpdatePolicy
extends UpdatePolicyDecorator {
    public DelayedStackRefreshUpdatePolicy(IVMUpdatePolicy base) {
        super(base);
    }

    public IElementUpdateTester getElementUpdateTester(Object event) {
        if (event instanceof IRunControl.ISuspendedDMEvent) {
            return new DelayedStackRefreshUpdateTester(this.getBaseUpdatePolicy().getElementUpdateTester(event), true);
        }
        if (event instanceof FullStackRefreshEvent) {
            return new DelayedStackRefreshUpdateTester(this.getBaseUpdatePolicy().getElementUpdateTester(event), false);
        }
        if (event instanceof IRunControl.IExitedDMEvent && ((IRunControl.IExitedDMEvent)event).getDMContext() instanceof IRunControl.IContainerDMContext) {
            return new ThreadsUpdateTester(super.getElementUpdateTester(event), true);
        }
        return new ThreadsUpdateTester(super.getElementUpdateTester(event), false);
    }

    private static final class DelayedStackRefreshUpdateTester
    implements IElementUpdateTester {
        private final IElementUpdateTester fBaseTester;
        private final boolean fLazyStackFrameMode;

        DelayedStackRefreshUpdateTester(IElementUpdateTester baseTester, boolean lazyStackFrameMode) {
            this.fBaseTester = baseTester;
            this.fLazyStackFrameMode = lazyStackFrameMode;
        }

        public int getUpdateFlags(Object viewerInput, TreePath path) {
            Object element;
            Object object = element = path.getSegmentCount() != 0 ? path.getLastSegment() : viewerInput;
            if (element instanceof IDMVMContext) {
                IDMContext dmc = ((IDMVMContext)element).getDMContext();
                if (this.fLazyStackFrameMode) {
                    if (dmc instanceof IStack.IFrameDMContext) {
                        if (((IStack.IFrameDMContext)dmc).getLevel() == 0) {
                            return 1;
                        }
                    } else if (dmc instanceof IRunControl.IExecutionDMContext) {
                        return this.fBaseTester.getUpdateFlags(viewerInput, path);
                    }
                    return 4;
                }
                if (dmc instanceof IRunControl.IContainerDMContext) {
                    return this.fBaseTester.getUpdateFlags(viewerInput, path);
                }
            }
            return 1;
        }

        public boolean includes(IElementUpdateTester tester) {
            if (tester instanceof DelayedStackRefreshUpdateTester) {
                DelayedStackRefreshUpdateTester sfTester = (DelayedStackRefreshUpdateTester)tester;
                if (this.fLazyStackFrameMode) {
                    if (sfTester.fLazyStackFrameMode) {
                        return this.fBaseTester.includes(sfTester.fBaseTester);
                    }
                } else {
                    if (!sfTester.fLazyStackFrameMode) {
                        return this.fBaseTester.includes(sfTester.fBaseTester);
                    }
                    return true;
                }
            }
            return false;
        }

        public String toString() {
            return "Delayed stack refresh (lazy = " + this.fLazyStackFrameMode + ", base = " + this.fBaseTester + ") update tester";
        }
    }

    private static final class ThreadsUpdateTester
    implements IElementUpdateTester {
        private final IElementUpdateTester fBaseTester;
        private final boolean fRefreshAll;

        ThreadsUpdateTester(IElementUpdateTester baseTester, boolean refreshAll) {
            this.fBaseTester = baseTester;
            this.fRefreshAll = refreshAll;
        }

        public int getUpdateFlags(Object viewerInput, TreePath path) {
            IDMContext dmc;
            Object element;
            Object object = element = path.getSegmentCount() != 0 ? path.getLastSegment() : viewerInput;
            if (!this.fRefreshAll && element instanceof IDMVMContext && (dmc = ((IDMVMContext)element).getDMContext()) instanceof IRunControl.IContainerDMContext) {
                return this.fBaseTester.getUpdateFlags(viewerInput, path);
            }
            return 1;
        }

        public boolean includes(IElementUpdateTester tester) {
            if (tester instanceof ThreadsUpdateTester) {
                ThreadsUpdateTester threadsTester = (ThreadsUpdateTester)tester;
                if (this.fRefreshAll) {
                    if (threadsTester.fRefreshAll) {
                        return this.fBaseTester.includes(threadsTester.fBaseTester);
                    }
                    return true;
                }
                if (!threadsTester.fRefreshAll) {
                    return this.fBaseTester.includes(threadsTester.fBaseTester);
                }
            }
            return false;
        }

        public String toString() {
            return "Threads update tester (base = " + this.fBaseTester + ") update tester";
        }
    }
}

