/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.operation.ModalContext;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.resources.SystemIFileProperties;
import org.eclipse.rse.internal.importexport.RemoteImportExportPlugin;
import org.eclipse.rse.internal.importexport.RemoteImportExportUtil;
import org.eclipse.rse.internal.importexport.SystemImportExportResources;
import org.eclipse.rse.internal.importexport.files.IRemoteFileExportDescriptionWriter;
import org.eclipse.rse.internal.importexport.files.RemoteExporter;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportData;
import org.eclipse.rse.internal.importexport.files.UniFilePlus;
import org.eclipse.rse.internal.importexport.files.Utilities;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.ui.dialogs.IOverwriteQuery;

class RemoteFileExportOperation
implements IRunnableWithProgress {
    private IHost conn;
    private IPath path;
    private IProgressMonitor monitor;
    private RemoteExporter exporter;
    private List resourcesToExport;
    private IOverwriteQuery overwriteCallback;
    private IResource resource;
    private List errorTable = new ArrayList(1);
    private RemoteFileExportData exportData;
    private boolean saveSettings;
    private String descriptionFilePath;
    private static final int OVERWRITE_NOT_SET = 0;
    private static final int OVERWRITE_NONE = 1;
    private static final int OVERWRITE_ALL = 2;
    private int overwriteState = 0;
    private boolean createLeadupStructure = true;
    private boolean createContainerDirectories = true;

    private RemoteFileExportOperation(IHost conn, IResource resource, List resources, String destinationPath, IOverwriteQuery overwriteImplementor) {
        this.conn = conn;
        this.resource = resource;
        this.resourcesToExport = resources;
        this.path = new Path(destinationPath);
        this.overwriteCallback = overwriteImplementor;
        this.exporter = new RemoteExporter(conn);
    }

    public RemoteFileExportOperation(RemoteFileExportData data, IOverwriteQuery overwriteImplementor) {
        this(Utilities.parseForSystemConnection(data.getDestination()), null, data.getElements(), Utilities.parseForPath(data.getDestination()), overwriteImplementor);
        this.exportData = data;
        this.saveSettings = data.isSaveSettings();
        this.descriptionFilePath = data.getDescriptionFilePath();
        this.setCreateLeadupStructure(data.isCreateDirectoryStructure());
        this.setOverwriteFiles(data.isOverWriteExistingFiles());
    }

    protected void addError(String message, Throwable e) {
        this.errorTable.add(new Status(4, "org.eclipse.ui", 0, message, e));
    }

    protected int countChildrenOf(IResource resource) throws CoreException {
        if (resource.getType() == 1) {
            return 1;
        }
        int count = 0;
        if (resource.isAccessible()) {
            IResource[] children = ((IContainer)resource).members();
            int i = 0;
            while (i < children.length) {
                count += this.countChildrenOf(children[i]);
                ++i;
            }
        }
        return count;
    }

    protected int countSelectedResources() throws CoreException {
        int result = 0;
        Iterator resources = this.resourcesToExport.iterator();
        while (resources.hasNext()) {
            result += this.countChildrenOf((IResource)resources.next());
        }
        return result;
    }

    protected void createLeadupDirectoriesFor(IResource resource) {
        IPath resourcePath = resource.getFullPath().removeLastSegments(1);
        int i = 0;
        while (i < resourcePath.segmentCount()) {
            this.path = this.path.append(resourcePath.segment(i));
            this.exporter.createFolder(this.path);
            ++i;
        }
    }

    protected void exportAllResources() throws InterruptedException {
        if (this.resource.getType() == 1) {
            this.exportFile((IFile)this.resource, this.path);
        } else {
            try {
                this.exportChildren(((IContainer)this.resource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e);
            }
        }
    }

    protected void exportChildren(IResource[] children, IPath currentPath) throws InterruptedException {
        int i = 0;
        while (i < children.length) {
            IResource child = children[i];
            if (child.isAccessible()) {
                if (child.getType() == 1) {
                    this.exportFile((IFile)child, currentPath);
                } else {
                    IPath destination = currentPath.append(child.getName());
                    try {
                        this.exporter.createFolder(destination);
                    }
                    catch (Exception e) {
                        String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8057", (Object[])new Object[]{destination, e.getLocalizedMessage() == null ? e.toString() : e.getMessage(), e}).toString();
                        this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, (Throwable)e));
                    }
                    try {
                        this.exportChildren(((IContainer)child).members(), destination);
                    }
                    catch (CoreException e) {
                        this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, e.getMessage(), (Throwable)e));
                    }
                }
            }
            ++i;
        }
    }

    protected void exportFile(IFile file, IPath location) throws InterruptedException {
        IPath fullPath = location.append(file.getName());
        String destination = fullPath.toString();
        boolean exportRequired = false;
        this.monitor.subTask(file.getFullPath().toString());
        String properPathString = fullPath.toOSString();
        File targetFile = null;
        if (this.conn == null) {
            targetFile = new File(properPathString);
        } else {
            try {
                targetFile = new UniFilePlus(Utilities.getIRemoteFile(this.conn, fullPath.toString()));
            }
            catch (NullPointerException e) {
                String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8057", (Object[])new Object[]{fullPath, RSEUIPlugin.getPluginMessage((String)"RSEF5101").getLevelOneText(), e}).toString();
                this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, (Throwable)e));
                throw e;
            }
        }
        if (targetFile.exists()) {
            exportRequired = this.isExportRequired(file, destination);
            if (!exportRequired) {
                return;
            }
            if (!targetFile.canWrite()) {
                String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8059", (Object)targetFile.getAbsolutePath()).toString();
                this.errorTable.add(new Status(4, "org.eclipse.ui", 0, msg, null));
                this.monitor.worked(1);
                return;
            }
            if (this.overwriteState == 1) {
                return;
            }
            if (this.overwriteState != 2) {
                String overwriteAnswer = this.overwriteCallback.queryOverwrite(properPathString);
                if (overwriteAnswer.equals("CANCEL")) {
                    throw new InterruptedException();
                }
                if (overwriteAnswer.equals("NO")) {
                    this.monitor.worked(1);
                    return;
                }
                if (overwriteAnswer.equals("NOALL")) {
                    this.monitor.worked(1);
                    this.overwriteState = 1;
                    return;
                }
                if (overwriteAnswer.equals("ALL")) {
                    this.overwriteState = 2;
                }
            }
        } else if (!targetFile.exists()) {
            exportRequired = true;
        }
        try {
            this.exporter.write((IResource)file, fullPath);
            SystemIFileProperties props = new SystemIFileProperties((IResource)file);
            long modTime = file.getModificationStamp();
            props.setModificationStampAtExport(this.conn.getHostName(), destination, modTime);
        }
        catch (IOException e) {
            String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8057", (Object[])new Object[]{fullPath, e.getLocalizedMessage(), e}).toString();
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, msg, (Throwable)e));
        }
        catch (CoreException e) {
            String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8057", (Object[])new Object[]{fullPath, e.getLocalizedMessage(), e}).toString();
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, msg, (Throwable)e));
        }
        catch (RemoteFileIOException e) {
            String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8057", (Object[])new Object[]{fullPath, e.getLocalizedMessage(), e}).toString();
            this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, (Throwable)e));
        }
        catch (RemoteFileSecurityException e) {
            String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8057", (Object[])new Object[]{fullPath, e.getLocalizedMessage(), e}).toString();
            this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getBundle().getSymbolicName(), 0, msg, (Throwable)e));
        }
        catch (Exception e) {
            String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8057", (Object[])new Object[]{fullPath, e.getLocalizedMessage(), e}).toString();
            this.errorTable.add(new Status(4, "org.eclipse.ui", 0, msg, (Throwable)e));
        }
        this.monitor.worked(1);
        ModalContext.checkCanceled((IProgressMonitor)this.monitor);
    }

    protected boolean isExportRequired(IFile file, String destinationPath) {
        if (this.conn != null) {
            long currentModTime;
            SystemIFileProperties props = new SystemIFileProperties((IResource)file);
            String hostName = this.conn.getHostName();
            boolean hasModTime = props.hasModificationStampAtExport(hostName, destinationPath);
            if (!hasModTime) {
                return true;
            }
            long modTime = props.getModificationStampAtExport(hostName, destinationPath);
            return modTime != (currentModTime = file.getModificationStamp());
        }
        return true;
    }

    protected void exportSpecifiedResources() throws InterruptedException {
        Iterator resources = this.resourcesToExport.iterator();
        IPath initPath = (IPath)this.path.clone();
        while (resources.hasNext()) {
            IResource currentResource = (IResource)resources.next();
            if (!currentResource.isAccessible()) continue;
            this.path = initPath;
            if (this.resource == null) {
                if (this.createLeadupStructure) {
                    this.createLeadupDirectoriesFor(currentResource);
                }
            } else {
                IPath containersToCreate = currentResource.getFullPath().removeFirstSegments(this.resource.getFullPath().segmentCount()).removeLastSegments(1);
                int i = 0;
                while (i < containersToCreate.segmentCount()) {
                    this.path = this.path.append(containersToCreate.segment(i));
                    this.exporter.createFolder(this.path);
                    ++i;
                }
            }
            if (currentResource.getType() == 1) {
                this.exportFile((IFile)currentResource, this.path);
                continue;
            }
            if (this.createContainerDirectories) {
                this.path = this.path.append(currentResource.getName());
                this.exporter.createFolder(this.path);
            }
            try {
                this.exportChildren(((IContainer)currentResource).members(), this.path);
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
        }
    }

    public IStatus getStatus() {
        IStatus[] errors = new IStatus[this.errorTable.size()];
        this.errorTable.toArray(errors);
        String msg = RSEUIPlugin.getPluginMessage((String)"RSEF8058").getLevelOneText();
        return new MultiStatus("org.eclipse.ui", 0, errors, msg, null);
    }

    protected boolean isDescendent(List resources, IResource child) {
        if (child.getType() == 4) {
            return false;
        }
        IContainer parent = child.getParent();
        if (resources.contains(parent)) {
            return true;
        }
        return this.isDescendent(resources, (IResource)parent);
    }

    public void run(IProgressMonitor monitor) throws InterruptedException {
        this.monitor = monitor;
        if (this.resource != null) {
            if (this.createLeadupStructure) {
                this.createLeadupDirectoriesFor(this.resource);
            }
            if (this.createContainerDirectories && this.resource.getType() != 1) {
                this.path = this.path.append(this.resource.getName());
                this.exporter.createFolder(this.path);
            }
        }
        try {
            int totalWork = -1;
            try {
                totalWork = this.resourcesToExport == null ? this.countChildrenOf(this.resource) : this.countSelectedResources();
            }
            catch (CoreException e) {
                this.errorTable.add(e.getStatus());
            }
            String taskMsg = SystemImportExportResources.RESID_FILEEXPORT_EXPORTING;
            monitor.beginTask(taskMsg, totalWork);
            if (this.resourcesToExport == null) {
                this.exportAllResources();
            } else {
                this.exportSpecifiedResources();
            }
            if (this.saveSettings) {
                try {
                    this.saveDescription();
                }
                catch (CoreException e) {
                    SystemBasePlugin.logError((String)("Error occured trying to save description " + this.descriptionFilePath), (Throwable)e);
                    this.errorTable.add(e.getStatus());
                }
                catch (IOException e) {
                    SystemBasePlugin.logError((String)("Error occured trying to save description " + this.descriptionFilePath), (Throwable)e);
                    this.errorTable.add(new Status(4, RemoteImportExportPlugin.getDefault().getSymbolicName(), 0, e.getLocalizedMessage(), (Throwable)e));
                }
            }
        }
        finally {
            monitor.done();
        }
    }

    protected void saveDescription() throws CoreException, IOException {
        ByteArrayOutputStream objectStreamOutput = new ByteArrayOutputStream();
        IRemoteFileExportDescriptionWriter writer = this.exportData.createExportDescriptionWriter(objectStreamOutput);
        ByteArrayInputStream fileInput = null;
        try {
            writer.write(this.exportData);
            fileInput = new ByteArrayInputStream(objectStreamOutput.toByteArray());
            IFile descriptionFile = this.exportData.getDescriptionFile();
            if (descriptionFile.isAccessible()) {
                descriptionFile.setContents((InputStream)fileInput, true, true, null);
            } else {
                IResource variant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(descriptionFile.getFullPath());
                if (variant == null) {
                    IContainer parent = descriptionFile.getParent();
                    if (parent != null) {
                        IResource parentVariant = RemoteImportExportUtil.getInstance().findExistingResourceVariant(parent.getFullPath());
                        if (parentVariant == null) {
                            descriptionFile.create((InputStream)fileInput, true, null);
                        } else {
                            IPath newPath = parentVariant.getFullPath().append(descriptionFile.getName());
                            IFile newDescriptionFile = SystemBasePlugin.getWorkspace().getRoot().getFile(newPath);
                            newDescriptionFile.create((InputStream)fileInput, true, null);
                        }
                    }
                } else if (variant instanceof IFile) {
                    ((IFile)variant).setContents((InputStream)fileInput, true, true, null);
                }
            }
        }
        finally {
            if (fileInput != null) {
                fileInput.close();
            }
            if (writer != null) {
                writer.close();
            }
        }
    }

    public void setCreateContainerDirectories(boolean value) {
        this.createContainerDirectories = value;
    }

    public void setCreateLeadupStructure(boolean value) {
        this.createLeadupStructure = value;
    }

    public void setOverwriteFiles(boolean value) {
        if (value) {
            this.overwriteState = 2;
        }
    }
}

