/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.local.files;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.internal.services.local.ILocalService;
import org.eclipse.rse.internal.services.local.LocalServiceResources;
import org.eclipse.rse.internal.services.local.files.LocalHostFile;
import org.eclipse.rse.internal.services.local.files.LocalVirtualHostFile;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.IMatcher;
import org.eclipse.rse.services.clientserver.ISystemFileTypes;
import org.eclipse.rse.services.clientserver.ISystemOperationMonitor;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.SystemEncodingUtil;
import org.eclipse.rse.services.clientserver.SystemOperationMonitor;
import org.eclipse.rse.services.clientserver.archiveutils.AbsoluteVirtualPath;
import org.eclipse.rse.services.clientserver.archiveutils.ArchiveHandlerManager;
import org.eclipse.rse.services.clientserver.archiveutils.ISystemArchiveHandler;
import org.eclipse.rse.services.clientserver.archiveutils.VirtualChild;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemElementNotFoundException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationCancelledException;
import org.eclipse.rse.services.clientserver.messages.SystemOperationFailedException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.HostFilePermissions;
import org.eclipse.rse.services.files.IFilePermissionsService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.IHostFilePermissions;
import org.eclipse.rse.services.files.IHostFilePermissionsContainer;
import org.eclipse.rse.services.files.RemoteFileException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;

public class LocalFileService
extends AbstractFileService
implements ILocalService,
IFilePermissionsService {
    private static final String[] ALLDRIVES = new String[]{"C:\\", "D:\\", "E:\\", "F:\\", "G:\\", "H:\\", "I:\\", "J:\\", "K:\\", "L:\\", "M:\\", "N:\\", "O:\\", "P:\\", "Q:\\", "R:\\", "S:\\", "T:\\", "U:\\", "V:\\", "W:\\", "X:\\", "Y:\\", "Z:\\"};
    private boolean _checkedOS = false;
    private boolean _isWindows = false;
    private boolean _isWin95 = false;
    private boolean _isWinNT = false;
    private String _osCmdShell = null;
    protected ISystemFileTypes _fileTypeRegistry;

    public LocalFileService(ISystemFileTypes fileTypeRegistry) {
        this._fileTypeRegistry = fileTypeRegistry;
    }

    public String getName() {
        return LocalServiceResources.Local_File_Service_Name;
    }

    public String getDescription() {
        return LocalServiceResources.Local_File_Service_Description;
    }

    public boolean isWindows() {
        if (!this._checkedOS) {
            String osName = System.getProperty("os.name").toLowerCase();
            this._isWindows = osName.startsWith("win");
            this._isWin95 = this._isWindows && (osName.indexOf("95") >= 0 || osName.indexOf("98") >= 0 || osName.indexOf("me") >= 0);
            boolean bl = this._isWinNT = this._isWindows && (osName.indexOf("nt") >= 0 || osName.indexOf("2000") >= 0 || osName.indexOf("xp") >= 0);
            if (this._isWinNT) {
                this._osCmdShell = "cmd /C ";
            } else if (this._isWin95) {
                this._osCmdShell = "start /B ";
            }
            this._checkedOS = true;
        }
        return this._isWindows;
    }

    /*
     * Unable to fully structure code
     */
    public void upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        block36: {
            isCancelled = false;
            bufInputStream = null;
            outputStream = null;
            bufOutputStream = null;
            outputWriter = null;
            bufWriter = null;
            destinationFile = new File(remoteParent, remoteFile);
            if (!ArchiveHandlerManager.isVirtual((String)destinationFile.getAbsolutePath())) break block36;
            child = ArchiveHandlerManager.getInstance().getVirtualObject(destinationFile.getAbsolutePath());
            handler = child.getHandler();
            if (handler == null) {
                this.throwCorruptArchiveException(this.getClass() + ".upload()");
                break block36;
            }
            handler.add(stream, child.path, remoteFile, SystemEncodingUtil.ENCODING_UTF_8, hostEncoding, isBinary == false, null);
lbl16:
            // 2 sources

            while (true) {
                try {
                    if (bufWriter != null) {
                        bufWriter.close();
                    }
                    if (bufInputStream != null) {
                        bufInputStream.close();
                    }
                    if (bufOutputStream != null) {
                        bufOutputStream.close();
                    }
                    if (isCancelled) {
                        throw new SystemOperationCancelledException();
                    }
                }
                catch (IOException v0) {}
                return;
            }
        }
        try {
            try {
                if (ArchiveHandlerManager.getInstance().isArchive(destinationFile)) {
                    handler = ArchiveHandlerManager.getInstance().getRegisteredHandler(destinationFile);
                    if (handler == null) {
                        this.throwCorruptArchiveException(this.getClass() + ".copyToArchive()");
                    } else {
                        handler.add(stream, "", remoteFile, SystemEncodingUtil.ENCODING_UTF_8, hostEncoding, isBinary == false, null);
                        ** continue;
                    }
                }
                if (!(destinationParent = destinationFile.getParentFile()).exists()) {
                    destinationParent.mkdirs();
                }
                bufInputStream = new BufferedInputStream(stream);
                outputStream = new FileOutputStream(destinationFile);
                v1 = isEncodingConversionRequired = isBinary == false;
                if (isEncodingConversionRequired) {
                    outputWriter = new OutputStreamWriter((OutputStream)outputStream, hostEncoding);
                    bufWriter = new BufferedWriter(outputWriter);
                } else {
                    bufOutputStream = new BufferedOutputStream(outputStream);
                }
                buffer = new byte[512000];
                readCount = 0;
                while ((readCount = bufInputStream.read(buffer)) > 0 && !isCancelled) {
                    if (isEncodingConversionRequired && bufWriter != null) {
                        s = new String(buffer, 0, readCount, hostEncoding);
                        bufWriter.write(s);
                    } else if (bufOutputStream != null) {
                        bufOutputStream.write(buffer, 0, readCount);
                    }
                    if (monitor == null) continue;
                    monitor.worked(readCount);
                    isCancelled = monitor.isCanceled();
                }
            }
            catch (SystemMessageException e) {
                throw e;
            }
            catch (Exception e) {
                throw new RemoteFileIOException("org.eclipse.rse.services.local", e);
            }
        }
        catch (Throwable var19_22) {
            try {
                if (bufWriter != null) {
                    bufWriter.close();
                }
                if (bufInputStream != null) {
                    bufInputStream.close();
                }
                if (bufOutputStream != null) {
                    bufOutputStream.close();
                }
                if (isCancelled) {
                    throw new SystemOperationCancelledException();
                }
            }
            catch (IOException v2) {}
            throw var19_22;
        }
        try {
            if (bufWriter != null) {
                bufWriter.close();
            }
            if (bufInputStream != null) {
                bufInputStream.close();
            }
            if (bufOutputStream != null) {
                bufOutputStream.close();
            }
            if (isCancelled) {
                throw new SystemOperationCancelledException();
            }
        }
        catch (IOException v3) {}
    }

    public void download(String remoteParent, String remoteFile, File destinationFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        File file = new File(remoteParent, remoteFile);
        FileInputStream inputStream = null;
        BufferedInputStream bufInputStream = null;
        FileOutputStream outputStream = null;
        FilterOutputStream bufOutputStream = null;
        OutputStreamWriter outputWriter = null;
        BufferedWriter bufWriter = null;
        boolean isCancelled = false;
        boolean sourceIsVirtual = ArchiveHandlerManager.isVirtual((String)file.getAbsolutePath());
        boolean targetIsVirtual = ArchiveHandlerManager.isVirtual((String)destinationFile.getParent());
        boolean targetIsArchive = ArchiveHandlerManager.getInstance().isArchive(destinationFile.getParentFile());
        if (sourceIsVirtual) {
            this.copyFromArchive(file, destinationFile.getParentFile(), destinationFile.getName(), monitor, hostEncoding, SystemEncodingUtil.ENCODING_UTF_8, !isBinary);
            return;
        }
        if (targetIsVirtual || targetIsArchive) {
            this.copyToArchive(file, destinationFile.getParentFile(), destinationFile.getName(), monitor, hostEncoding, SystemEncodingUtil.ENCODING_UTF_8, !isBinary);
            return;
        }
        try {
            try {
                boolean wasReadonly;
                if (!destinationFile.exists()) {
                    File parentDir = destinationFile.getParentFile();
                    parentDir.mkdirs();
                }
                boolean isEncodingConversionRequired = !isBinary;
                inputStream = new FileInputStream(file);
                bufInputStream = new BufferedInputStream(inputStream);
                boolean bl = wasReadonly = destinationFile.exists() && !destinationFile.canWrite();
                if (wasReadonly) {
                    this.setReadOnly(destinationFile.getParent(), destinationFile.getName(), false, monitor);
                }
                outputStream = new FileOutputStream(destinationFile);
                if (isEncodingConversionRequired) {
                    outputWriter = new OutputStreamWriter((OutputStream)outputStream, hostEncoding);
                    bufWriter = new BufferedWriter(outputWriter);
                } else {
                    bufOutputStream = new BufferedOutputStream(outputStream);
                }
                byte[] buffer = new byte[512000];
                long totalSize = file.length();
                int totalRead = 0;
                while ((long)totalRead < totalSize && !isCancelled) {
                    int available = bufInputStream.available();
                    available = available < 512000 ? available : 512000;
                    int bytesRead = bufInputStream.read(buffer, 0, available);
                    if (bytesRead != -1) {
                        if (isEncodingConversionRequired && bufWriter != null) {
                            String s = new String(buffer, 0, bytesRead, hostEncoding);
                            bufWriter.write(s);
                        } else if (bufOutputStream != null) {
                            ((BufferedOutputStream)bufOutputStream).write(buffer, 0, bytesRead);
                        }
                        totalRead += bytesRead;
                        if (monitor == null) continue;
                        monitor.worked(bytesRead);
                        isCancelled = monitor.isCanceled();
                        continue;
                    }
                    break;
                }
            }
            catch (Exception e) {
                throw new RemoteFileIOException("org.eclipse.rse.services.local", e);
            }
        }
        catch (Throwable throwable) {
            try {
                if (bufWriter != null) {
                    bufWriter.close();
                }
                if (bufInputStream != null) {
                    bufInputStream.close();
                }
                if (bufOutputStream != null) {
                    bufOutputStream.close();
                }
                if (isCancelled) {
                    throw new SystemOperationCancelledException();
                }
                if (file.exists()) {
                    boolean sizeCheck;
                    destinationFile.setLastModified(file.lastModified());
                    String systemEncoding = SystemEncodingUtil.getInstance().getEnvironmentEncoding();
                    boolean bl = sizeCheck = !isBinary && systemEncoding.equals(hostEncoding);
                    if (sizeCheck && destinationFile.length() != file.length()) {
                        throw new SystemOperationCancelledException();
                    }
                }
            }
            catch (IOException e) {
                throw new RemoteFileIOException((Exception)e);
            }
            throw throwable;
        }
        try {
            if (bufWriter != null) {
                bufWriter.close();
            }
            if (bufInputStream != null) {
                bufInputStream.close();
            }
            if (bufOutputStream != null) {
                bufOutputStream.close();
            }
            if (isCancelled) {
                throw new SystemOperationCancelledException();
            }
            if (file.exists()) {
                boolean sizeCheck;
                destinationFile.setLastModified(file.lastModified());
                String systemEncoding = SystemEncodingUtil.getInstance().getEnvironmentEncoding();
                boolean bl = sizeCheck = !isBinary && systemEncoding.equals(hostEncoding);
                if (sizeCheck && destinationFile.length() != file.length()) {
                    throw new SystemOperationCancelledException();
                }
            }
        }
        catch (IOException e) {
            throw new RemoteFileIOException((Exception)e);
        }
    }

    private boolean copyToArchive(File file, File destination, String newName, IProgressMonitor monitor, String sourceEncoding, String targetEncoding, boolean isText) throws SystemMessageException {
        ISystemArchiveHandler handler = null;
        String path = "";
        if (ArchiveHandlerManager.isVirtual((String)destination.getAbsolutePath())) {
            VirtualChild virtualChild = ArchiveHandlerManager.getInstance().getVirtualObject(destination.getAbsolutePath());
            handler = virtualChild.getHandler();
            path = virtualChild.fullName;
            if (!virtualChild.isDirectory) {
                path = virtualChild.path;
            }
        } else if (ArchiveHandlerManager.getInstance().isArchive(destination)) {
            handler = ArchiveHandlerManager.getInstance().getRegisteredHandler(destination);
        }
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".copyToArchive()");
        }
        SystemOperationMonitor archiveOperationMonitor = null;
        if (monitor != null) {
            archiveOperationMonitor = new SystemOperationMonitor();
            CheckArchiveOperationStatusThread checkArchiveOperationStatusThread = new CheckArchiveOperationStatusThread((ISystemOperationMonitor)archiveOperationMonitor, monitor);
            checkArchiveOperationStatusThread.start();
        }
        try {
            if (file.isDirectory()) {
                handler.add(file, path, newName, sourceEncoding, targetEncoding, this._fileTypeRegistry, (ISystemOperationMonitor)archiveOperationMonitor);
            } else {
                handler.add(file, path, newName, sourceEncoding, targetEncoding, isText, (ISystemOperationMonitor)archiveOperationMonitor);
            }
        }
        catch (SystemMessageException e) {
            if (monitor != null && monitor.isCanceled()) {
                throw this.getCancelledException();
            }
            String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_FILE_NOT_SAVED, (Object)destination.getName(), (Object)"localhost");
            SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF5006", 4, msgTxt, (Throwable)e);
            throw new SystemMessageException((SystemMessage)msg);
        }
        return true;
    }

    /*
     * Unable to fully structure code
     */
    public void upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        block49: {
            isCancelled = false;
            inputStream = null;
            bufInputStream = null;
            outputStream = null;
            bufOutputStream = null;
            outputWriter = null;
            bufWriter = null;
            destinationFile = null;
            target = new File(remoteParent, remoteFile);
            sourceIsVirtual = ArchiveHandlerManager.isVirtual((String)localFile.getAbsolutePath());
            targetIsVirtual = ArchiveHandlerManager.isVirtual((String)target.getAbsolutePath());
            if (sourceIsVirtual) {
                this.copyFromArchive(localFile, target, remoteFile, monitor, srcEncoding, hostEncoding, isBinary == false);
                return;
            }
            if (targetIsVirtual) {
                this.copyToArchive(localFile, target, remoteFile, monitor, srcEncoding, hostEncoding, isBinary == false);
                return;
            }
            try {
                destinationFile = new File(remoteParent, remoteFile);
                totalSize = (int)localFile.length();
                destinationParent = destinationFile.getParentFile();
                if (!destinationParent.exists()) {
                    destinationParent.mkdirs();
                }
                inputStream = new FileInputStream(localFile);
                bufInputStream = new BufferedInputStream(inputStream);
                outputStream = new FileOutputStream(destinationFile);
                v0 = isEncodingConversionRequired = isBinary == false && srcEncoding.equals(hostEncoding) == false;
                if (isEncodingConversionRequired) {
                    outputWriter = new OutputStreamWriter((OutputStream)outputStream, hostEncoding);
                    bufWriter = new BufferedWriter(outputWriter);
                } else {
                    bufOutputStream = new BufferedOutputStream(outputStream);
                }
                buffer = new byte[512000];
                totalRead = 0;
                while (totalRead < totalSize && !isCancelled) {
                    available = bufInputStream.available();
                    available = available < 512000 ? available : 512000;
                    bytesRead = bufInputStream.read(buffer, 0, available);
                    if (bytesRead != -1) {
                        if (isEncodingConversionRequired && bufWriter != null) {
                            s = new String(buffer, 0, bytesRead, srcEncoding);
                            bufWriter.write(s);
                        } else if (bufOutputStream != null) {
                            bufOutputStream.write(buffer, 0, bytesRead);
                        }
                        totalRead += bytesRead;
                        if (monitor == null) continue;
                        monitor.worked(bytesRead);
                        isCancelled = monitor.isCanceled();
                        continue;
                    }
                    break;
                }
            }
            catch (FileNotFoundException v1) {
                try {
                    if (bufWriter != null) {
                        bufWriter.close();
                    }
                    if (bufInputStream != null) {
                        bufInputStream.close();
                    }
                    if (bufOutputStream != null) {
                        bufOutputStream.close();
                    }
                    if (isCancelled) {
                        throw new SystemOperationCancelledException();
                    }
                    break block49;
                }
                catch (IOException v2) {}
                break block49;
            }
            catch (UnsupportedEncodingException v3) {
                ** try [egrp 3[TRYBLOCK] [7 : 455->456)] { 
lbl72:
                // 1 sources

                try {
                    if (bufWriter != null) {
                        bufWriter.close();
                    }
                    if (bufInputStream != null) {
                        bufInputStream.close();
                    }
                    if (bufOutputStream != null) {
                        bufOutputStream.close();
                    }
                    if (isCancelled) {
                        throw new SystemOperationCancelledException();
                    }
                    break block49;
                }
                catch (IOException v4) {}
                break block49;
            }
            catch (IOException v5) {
                ** try [egrp 5[TRYBLOCK] [8 : 503->504)] { 
lbl-1000:
                // 3 sources

                {
                    catch (Throwable var27_27) {
                        try {
                            if (bufWriter != null) {
                                bufWriter.close();
                            }
                            if (bufInputStream != null) {
                                bufInputStream.close();
                            }
                            if (bufOutputStream != null) {
                                bufOutputStream.close();
                            }
                            if (isCancelled) {
                                throw new SystemOperationCancelledException();
                            }
                        }
                        catch (IOException v6) {}
                        throw var27_27;
                    }
                }
lbl99:
                // 1 sources

                try {
                    if (bufWriter != null) {
                        bufWriter.close();
                    }
                    if (bufInputStream != null) {
                        bufInputStream.close();
                    }
                    if (bufOutputStream != null) {
                        bufOutputStream.close();
                    }
                    if (isCancelled) {
                        throw new SystemOperationCancelledException();
                    }
                    break block49;
                }
                catch (IOException v7) {}
                break block49;
            }
            try {
                if (bufWriter != null) {
                    bufWriter.close();
                }
                if (bufInputStream != null) {
                    bufInputStream.close();
                }
                if (bufOutputStream != null) {
                    bufOutputStream.close();
                }
                if (isCancelled) {
                    throw new SystemOperationCancelledException();
                }
            }
            catch (IOException v8) {}
        }
    }

    protected IHostFile[] internalFetch(String remoteParent, String fileFilter, int type, IProgressMonitor monitor) throws SystemMessageException {
        LocalFileNameFilter fFilter = new LocalFileNameFilter(fileFilter, type);
        File localParent = new File(remoteParent);
        boolean isArchive = false;
        boolean isVirtual = false;
        if (localParent.exists()) {
            if (localParent.isFile()) {
                isArchive = ArchiveHandlerManager.getInstance().isArchive(localParent);
            }
            if (this.isWindows()) {
                try {
                    localParent = localParent.getCanonicalFile();
                }
                catch (IOException iOException) {
                    System.out.println("Can not get canonical path: " + localParent.getAbsolutePath());
                }
            }
        } else {
            if (remoteParent.endsWith("#virtual#/")) {
                remoteParent = remoteParent.substring(0, remoteParent.length() - "#virtual#/".length());
            }
            isVirtual = ArchiveHandlerManager.isVirtual((String)remoteParent);
        }
        if (isVirtual || isArchive) {
            VirtualChild[] contents = null;
            File theFile = this.getContainingArchive(localParent);
            if (isArchive) {
                contents = ArchiveHandlerManager.getInstance().getContents(localParent, "");
            } else if (isVirtual) {
                AbsoluteVirtualPath avp = new AbsoluteVirtualPath(remoteParent);
                contents = ArchiveHandlerManager.getInstance().getContents(theFile, avp.getVirtualPart());
            }
            if (contents == null) {
                return null;
            }
            IHostFile[] results = new LocalVirtualHostFile[contents.length];
            int i = 0;
            while (i < contents.length) {
                results[i] = new LocalVirtualHostFile(contents[i]);
                ++i;
            }
            return results;
        }
        if (monitor != null && monitor.isCanceled()) {
            throw new SystemOperationCancelledException();
        }
        if (localParent.exists()) {
            File[] files = localParent.listFiles(fFilter);
            return this.convertToHostFiles(files, type);
        }
        return new IHostFile[0];
    }

    protected IHostFile[] convertToHostFiles(File[] files, int type) {
        ArrayList<LocalHostFile> results = new ArrayList<LocalHostFile>();
        if (files != null) {
            int i = 0;
            while (i < files.length) {
                File file = files[i];
                if (file.isDirectory()) {
                    if (type == 0 || type == 2) {
                        results.add(new LocalHostFile(file));
                    }
                } else if (file.isFile()) {
                    if (type == 0 || type == 1) {
                        results.add(new LocalHostFile(file));
                    } else if (type == 2 && ArchiveHandlerManager.getInstance().isArchive(file)) {
                        results.add(new LocalHostFile(file));
                    }
                } else if (file.exists()) {
                    results.add(new LocalHostFile(file));
                }
                ++i;
            }
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    public IHostFile getUserHome() {
        File userHomeFile;
        String userHome = System.getProperty("user.home");
        return new LocalHostFile(userHomeFile, (userHomeFile = new File(userHome)).getParent() == null);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        ArrayList<File> v = new ArrayList<File>();
        if (this.isWindows()) {
            int idx = 0;
            while (idx < ALLDRIVES.length) {
                File drive = new File(ALLDRIVES[idx]);
                if (drive.exists()) {
                    try {
                        v.add(drive.getAbsoluteFile());
                    }
                    catch (Exception exception) {}
                }
                ++idx;
            }
        } else {
            v.add(new File("/"));
        }
        IHostFile[] fileObjs = new LocalHostFile[v.size()];
        int idx = 0;
        while (idx < v.size()) {
            fileObjs[idx] = new LocalHostFile((File)v.get(idx), true);
            ++idx;
        }
        return fileObjs;
    }

    public IHostFile getFile(String remoteParent, String name, IProgressMonitor monitor) throws SystemMessageException {
        boolean isRoot;
        if (name.endsWith("#virtual#/")) {
            name = name.substring(0, name.length() - "#virtual#/".length());
        }
        boolean isVirtualParent = false;
        boolean isArchiveParent = false;
        boolean bl = isRoot = remoteParent == null || remoteParent.length() == 0;
        if (!isRoot) {
            File remoteParentFile = new File(remoteParent);
            if (!remoteParentFile.exists()) {
                isVirtualParent = ArchiveHandlerManager.isVirtual((String)remoteParent);
            } else if (remoteParentFile.isFile()) {
                isArchiveParent = ArchiveHandlerManager.getInstance().isArchive(remoteParentFile);
            }
        }
        if (!isVirtualParent && !isArchiveParent) {
            File file = isRoot ? new File(name) : new File(remoteParent, name);
            return new LocalHostFile(file, isRoot);
        }
        String fullpath = remoteParent;
        fullpath = isArchiveParent ? String.valueOf(fullpath) + "#virtual#/" : String.valueOf(fullpath) + "/";
        VirtualChild vc = ArchiveHandlerManager.getInstance().getVirtualObject(String.valueOf(fullpath) + name);
        LocalVirtualHostFile results = new LocalVirtualHostFile(vc);
        return results;
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        File parentFile = new File(remoteParent);
        File fileToCreate = new File(parentFile, fileName);
        if (!fileToCreate.exists()) {
            if (ArchiveHandlerManager.isVirtual((String)fileToCreate.getAbsolutePath())) {
                return this.createFileInArchive(fileToCreate, monitor);
            }
            if (!parentFile.exists()) {
                parentFile.mkdirs();
            } else {
                try {
                    fileToCreate.createNewFile();
                }
                catch (IOException e) {
                    throw new RemoteFileSecurityException((Exception)e);
                }
                if (ArchiveHandlerManager.getInstance().isArchive(fileToCreate)) {
                    try {
                        ArchiveHandlerManager.getInstance().createEmptyArchive(fileToCreate);
                    }
                    catch (SystemMessageException e) {
                        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEG1122", 4, LocalServiceResources.FILEMSG_ARCHIVE_CORRUPTED, (Throwable)e);
                        throw new SystemMessageException((SystemMessage)msg);
                    }
                }
            }
        } else {
            throw new RemoteFileIOException((Exception)new IOException());
        }
        return new LocalHostFile(fileToCreate);
    }

    protected LocalVirtualHostFile createFileInArchive(File newFile, IProgressMonitor monitor) throws SystemMessageException {
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(newFile.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".createFileInArchive()");
        } else {
            SystemOperationMonitor archiveOperationMonitor = null;
            if (monitor != null) {
                archiveOperationMonitor = new SystemOperationMonitor();
                CheckArchiveOperationStatusThread checkArchiveOperationStatusThread = new CheckArchiveOperationStatusThread((ISystemOperationMonitor)archiveOperationMonitor, monitor);
                checkArchiveOperationStatusThread.start();
            }
            try {
                handler.createFile(child.fullName, (ISystemOperationMonitor)archiveOperationMonitor);
            }
            catch (SystemMessageException e) {
                if (monitor != null && monitor.isCanceled()) {
                    throw this.getCancelledException();
                }
                String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_CREATE_VIRTUAL_FAILED, (Object)newFile);
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1124", 4, msgTxt, (Throwable)e);
                throw new SystemMessageException((SystemMessage)msg);
            }
        }
        return new LocalVirtualHostFile(child);
    }

    private void throwCorruptArchiveException(String classAndMethod) throws SystemMessageException {
        SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEG1122", 4, LocalServiceResources.FILEMSG_ARCHIVE_CORRUPTED, LocalServiceResources.FILEMSG_ARCHIVE_CORRUPTED_DETAILS);
        throw new SystemMessageException((SystemMessage)msg);
    }

    protected File getContainingArchive(File file) {
        String absPath = file.getAbsolutePath();
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
        return new File(avp.getContainingArchiveString());
    }

    protected String getVirtualPart(String absPath) {
        AbsoluteVirtualPath avp = new AbsoluteVirtualPath(absPath);
        return avp.getVirtualPart();
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        File folderToCreate = new File(remoteParent, folderName);
        if (!folderToCreate.exists()) {
            if (ArchiveHandlerManager.isVirtual((String)folderToCreate.getAbsolutePath())) {
                return this.createFolderInArchive(folderToCreate, monitor);
            }
            if (!folderToCreate.mkdirs()) {
                throw new RemoteFileSecurityException((Exception)new IOException());
            }
        } else {
            throw new RemoteFileIOException((Exception)new IOException());
        }
        return new LocalHostFile(folderToCreate);
    }

    protected LocalVirtualHostFile createFolderInArchive(File newFolder, IProgressMonitor monitor) throws SystemMessageException {
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(newFolder.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".createFolderInArchive()");
        } else {
            SystemOperationMonitor archiveOperationMonitor = null;
            if (monitor != null) {
                archiveOperationMonitor = new SystemOperationMonitor();
                CheckArchiveOperationStatusThread checkArchiveOperationStatusThread = new CheckArchiveOperationStatusThread((ISystemOperationMonitor)archiveOperationMonitor, monitor);
                checkArchiveOperationStatusThread.start();
            }
            try {
                handler.createFolder(child.fullName, (ISystemOperationMonitor)archiveOperationMonitor);
            }
            catch (SystemMessageException e) {
                if (monitor != null && monitor.isCanceled()) {
                    throw this.getCancelledException();
                }
                String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_CREATE_VIRTUAL_FAILED, (Object)newFolder);
                SimpleSystemMessage msg = new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1124", 4, msgTxt, (Throwable)e);
                throw new SystemMessageException((SystemMessage)msg);
            }
        }
        return new LocalVirtualHostFile(child);
    }

    public void delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        if (fileName.endsWith("#virtual#/")) {
            fileName = fileName.substring(0, fileName.length() - "#virtual#/".length());
        }
        File remoteParentFile = new File(remoteParent);
        if (ArchiveHandlerManager.getInstance().isArchive(remoteParentFile)) {
            remoteParent = String.valueOf(remoteParent) + "#virtual#/";
        }
        boolean result = true;
        File fileToDelete = new File(remoteParent, fileName);
        if (ArchiveHandlerManager.isVirtual((String)fileToDelete.getAbsolutePath())) {
            result = this.deleteFromArchive(fileToDelete, monitor);
        } else if (ArchiveHandlerManager.getInstance().isArchive(fileToDelete)) {
            result = this.deleteArchive(fileToDelete);
        }
        if (fileToDelete.isDirectory()) {
            result = this.deleteContents(fileToDelete, monitor);
        } else if (fileToDelete.exists()) {
            result = fileToDelete.delete();
        }
        if (!result) {
            if (fileToDelete.exists()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services.local", "Failed to delete: " + fileToDelete.getAbsolutePath());
            }
            throw new SystemElementNotFoundException(fileToDelete.getAbsolutePath(), "delete");
        }
    }

    public void deleteBatch(String[] remoteParents, String[] fileNames, IProgressMonitor monitor) throws SystemMessageException {
        String deletingMessage = NLS.bind((String)LocalServiceResources.FILEMSG_DELETING, (Object)"");
        monitor.beginTask(deletingMessage, remoteParents.length);
        int i = 0;
        while (i < remoteParents.length) {
            deletingMessage = NLS.bind((String)LocalServiceResources.FILEMSG_DELETING, (Object)fileNames[i]);
            monitor.subTask(deletingMessage);
            this.delete(remoteParents[i], fileNames[i], monitor);
            monitor.worked(1);
            ++i;
        }
    }

    private boolean deleteContents(File folder, IProgressMonitor monitor) {
        boolean result = true;
        File[] files = folder.listFiles();
        int i = 0;
        while (i < files.length && result) {
            File file = files[i];
            result = file.isDirectory() ? this.deleteContents(file, monitor) : file.delete();
            ++i;
        }
        if (result) {
            result = folder.delete();
        }
        return result;
    }

    protected boolean deleteFromArchive(File destination, IProgressMonitor monitor) throws SystemMessageException {
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(destination.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".deleteFromArchive()");
        }
        SystemOperationMonitor archiveOperationMonitor = null;
        if (monitor != null) {
            archiveOperationMonitor = new SystemOperationMonitor();
            CheckArchiveOperationStatusThread checkArchiveOperationStatusThread = new CheckArchiveOperationStatusThread((ISystemOperationMonitor)archiveOperationMonitor, monitor);
            checkArchiveOperationStatusThread.start();
        }
        try {
            return handler.delete(child.fullName, (ISystemOperationMonitor)archiveOperationMonitor);
        }
        catch (SystemMessageException e) {
            if (monitor != null && monitor.isCanceled()) {
                throw this.getCancelledException();
            }
            String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_DELETE_VIRTUAL_FAILED, (Object)destination);
            throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1125", 4, msgTxt, (Throwable)e));
        }
    }

    protected boolean deleteArchive(File file) {
        ArchiveHandlerManager.getInstance().disposeOfRegisteredHandlerFor(file);
        return file.delete();
    }

    public void rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        File fileToRename = new File(remoteParent, oldName);
        if (ArchiveHandlerManager.isVirtual((String)fileToRename.getAbsolutePath())) {
            this.renameVirtualFile(fileToRename, newName, monitor);
            return;
        }
        File newFile = new File(remoteParent, newName);
        boolean result = fileToRename.renameTo(newFile);
        if (!result) {
            String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_RENAME_FILE_FAILED, (Object)newFile);
            String msgDetails = LocalServiceResources.FILEMSG_RENAME_FILE_FAILED_DETAILS;
            throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1301", 4, msgTxt, msgDetails));
        }
    }

    public void rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) throws SystemMessageException {
        this.rename(remoteParent, oldName, newName, monitor);
        File newFile = new File(remoteParent, newName);
        oldFile.renameTo(newFile.getAbsolutePath());
    }

    protected boolean renameVirtualFile(File destination, String newName, IProgressMonitor monitor) throws SystemMessageException {
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(destination.getAbsolutePath());
        ISystemArchiveHandler handler = child.getHandler();
        if (handler == null) {
            this.throwCorruptArchiveException(this.getClass() + ".renameVirtualFile()");
        } else {
            SystemOperationMonitor archiveOperationMonitor = null;
            if (monitor != null) {
                archiveOperationMonitor = new SystemOperationMonitor();
                CheckArchiveOperationStatusThread checkArchiveOperationStatusThread = new CheckArchiveOperationStatusThread((ISystemOperationMonitor)archiveOperationMonitor, monitor);
                checkArchiveOperationStatusThread.start();
            }
            try {
                handler.rename(child.fullName, newName, (ISystemOperationMonitor)archiveOperationMonitor);
            }
            catch (SystemMessageException e) {
                if (monitor != null && monitor.isCanceled()) {
                    throw this.getCancelledException();
                }
                String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_RENAME_FILE_FAILED, (Object)child.fullName);
                throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1301", 4, msgTxt, (Throwable)e));
            }
        }
        return false;
    }

    public void move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        File sourceFolderOrFile = new File(srcParent, srcName);
        File targetFolder = new File(tgtParent, tgtName);
        boolean movedOk = false;
        boolean sourceIsVirtual = ArchiveHandlerManager.isVirtual((String)sourceFolderOrFile.getAbsolutePath());
        boolean targetIsVirtual = ArchiveHandlerManager.isVirtual((String)targetFolder.getAbsolutePath());
        boolean targetIsArchive = ArchiveHandlerManager.getInstance().isArchive(targetFolder);
        if (!(sourceIsVirtual || targetIsVirtual || targetIsArchive)) {
            File fileToMove = new File(srcParent, srcName);
            File newFile = new File(tgtParent, tgtName);
            movedOk = fileToMove.renameTo(newFile);
        }
        if (!movedOk) {
            this.copy(srcParent, srcName, tgtParent, tgtName, monitor);
            try {
                this.delete(srcParent, srcName, monitor);
            }
            catch (SystemMessageException exc) {
                if (monitor.isCanceled()) {
                    this.delete(tgtParent, tgtName, null);
                }
                throw exc;
            }
        }
    }

    public void copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        File srcFile = new File(srcParent, srcName);
        File tgtFile = new File(tgtParent, tgtName);
        String command = null;
        boolean folderCopy = srcFile.isDirectory();
        String src = srcFile.getAbsolutePath();
        String target = tgtFile.getAbsolutePath();
        boolean sourceIsVirtual = ArchiveHandlerManager.isVirtual((String)src);
        boolean targetIsVirtual = ArchiveHandlerManager.isVirtual((String)target);
        boolean targetIsArchive = ArchiveHandlerManager.getInstance().isArchive(new File(tgtParent));
        if (sourceIsVirtual) {
            this.copyFromArchive(srcFile, new File(tgtParent), tgtName, monitor, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false);
            return;
        }
        if (targetIsVirtual || targetIsArchive) {
            this.copyToArchive(srcFile, new File(tgtParent), tgtName, monitor, SystemEncodingUtil.ENCODING_UTF_8, SystemEncodingUtil.ENCODING_UTF_8, false);
            return;
        }
        src = this.enQuote(src);
        target = this.enQuote(target);
        if (this.isWindows()) {
            if (folderCopy) {
                command = "xcopy " + src + " " + target + " /S /E /K /Q /H /I /Y";
            } else {
                if (!tgtFile.exists()) {
                    try {
                        tgtFile.createNewFile();
                    }
                    catch (Exception e) {
                        throw new RemoteFileException(e.getMessage(), e);
                    }
                }
                command = String.valueOf(this._osCmdShell) + "xcopy " + src + " " + target + " /Y /K /Q /H";
            }
        } else {
            command = folderCopy ? "cp  -Rp " + src + " " + target : "cp -p " + src + " " + target;
        }
        try {
            Process p = null;
            Runtime runtime = Runtime.getRuntime();
            if (this.isWindows()) {
                String theShell = "cmd /C ";
                p = runtime.exec(String.valueOf(theShell) + command);
            } else {
                String theShell = "sh";
                String[] args = new String[]{theShell, "-c", command};
                p = runtime.exec(args);
            }
            p.waitFor();
        }
        catch (Exception e) {
            throw new RemoteFileException(e.getMessage(), e);
        }
    }

    protected String enQuote(String s) {
        if (this.isWindows()) {
            return String.valueOf('\"') + s + '\"';
        }
        return PathUtility.enQuoteUnix((String)s);
    }

    public boolean copyFromArchive(File sourceFolderOrFile, File targetFolder, String newName, IProgressMonitor monitor, String sourceEncoding, String targetEncoding, boolean isText) throws SystemMessageException {
        if (sourceEncoding == null) {
            sourceEncoding = SystemEncodingUtil.ENCODING_UTF_8;
        }
        if (sourceEncoding == null) {
            isText = this._fileTypeRegistry.isText(sourceFolderOrFile);
        }
        if (!ArchiveHandlerManager.isVirtual((String)sourceFolderOrFile.getAbsolutePath())) {
            return false;
        }
        String command = null;
        boolean folderCopy = sourceFolderOrFile.isDirectory();
        String src = sourceFolderOrFile.getAbsolutePath();
        VirtualChild child = ArchiveHandlerManager.getInstance().getVirtualObject(sourceFolderOrFile.getAbsolutePath());
        SystemOperationMonitor archiveOperationMonitor = null;
        Thread checkArchiveOperationStatusThread = null;
        if (monitor != null) {
            archiveOperationMonitor = new SystemOperationMonitor();
            checkArchiveOperationStatusThread = new CheckArchiveOperationStatusThread((ISystemOperationMonitor)archiveOperationMonitor, monitor);
        }
        if (!ArchiveHandlerManager.isVirtual((String)targetFolder.getAbsolutePath()) && !ArchiveHandlerManager.getInstance().isArchive(targetFolder)) {
            if (monitor != null) {
                checkArchiveOperationStatusThread.start();
            }
            File destinationFile = new File(targetFolder, child.name);
            try {
                child.getExtractedFile(destinationFile, sourceEncoding, isText, (ISystemOperationMonitor)archiveOperationMonitor);
            }
            catch (SystemMessageException e) {
                if (destinationFile.isDirectory()) {
                    this.deleteContents(destinationFile, monitor);
                } else {
                    destinationFile.delete();
                }
                if (monitor != null && monitor.isCanceled()) {
                    throw this.getCancelledException();
                }
                String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_RENAME_FILE_FAILED, (Object)child.fullName);
                throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1301", 4, msgTxt, (Throwable)e));
            }
            return true;
        }
        if (monitor != null) {
            checkArchiveOperationStatusThread.start();
        }
        src = child.getExtractedFile(sourceEncoding, isText, (ISystemOperationMonitor)archiveOperationMonitor).getAbsolutePath();
        if (monitor != null && monitor.isCanceled()) {
            throw this.getCancelledException();
        }
        if (child.isDirectory) {
            File tempSource = null;
            try {
                tempSource = File.createTempFile(child.name, "virtual");
                tempSource.deleteOnExit();
            }
            catch (IOException iOException) {
                String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_COPY_FILE_FAILED, (Object)sourceFolderOrFile);
                String msgDetails = LocalServiceResources.FILEMSG_COPY_FILE_FAILED_DETAILS;
                throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1306", 4, msgTxt, msgDetails));
            }
            tempSource.delete();
            if (!tempSource.mkdir()) {
                String msgTxt = NLS.bind((String)LocalServiceResources.FILEMSG_COPY_FILE_FAILED, (Object)sourceFolderOrFile);
                String msgDetails = LocalServiceResources.FILEMSG_COPY_FILE_FAILED_DETAILS;
                throw new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEF1306", 4, msgTxt, msgDetails));
            }
            ISystemArchiveHandler handler = child.getHandler();
            if (handler == null) {
                this.throwCorruptArchiveException(this.getClass() + ".copy()");
            } else {
                handler.extractVirtualDirectory(child.fullName, tempSource, sourceEncoding, isText, (ISystemOperationMonitor)archiveOperationMonitor);
            }
            src = String.valueOf(tempSource.getAbsolutePath()) + File.separatorChar + child.name;
        }
        if (ArchiveHandlerManager.isVirtual((String)targetFolder.getAbsolutePath()) || ArchiveHandlerManager.getInstance().isArchive(targetFolder)) {
            File source = new File(src);
            boolean returnValue = this.copyToArchive(source, targetFolder, newName, monitor, SystemEncodingUtil.ENCODING_UTF_8, targetEncoding, isText);
            if (!returnValue && monitor != null && monitor.isCanceled()) {
                throw this.getCancelledException();
            }
            return returnValue;
        }
        String target = String.valueOf(targetFolder.getAbsolutePath()) + File.separator + newName;
        if (src.indexOf(32) >= 0) {
            src = "\"" + src + "\"";
        }
        if (target.indexOf(32) >= 0) {
            target = "\"" + target + "\"";
        }
        command = System.getProperty("os.name").toLowerCase().startsWith("win") ? (folderCopy ? "xcopy " + src + " " + target + " /S /E /K /Q /H /I /Y" : String.valueOf(this._osCmdShell) + "copy " + src + " " + target) : (folderCopy ? "cp  -r " + src + " " + target : "cp " + src + " " + target);
        int rc = -1;
        try {
            Process p = Runtime.getRuntime().exec(command);
            rc = p.exitValue();
        }
        catch (Exception exception) {}
        return rc == 0;
    }

    public boolean isCaseSensitive() {
        return !this.isWindows();
    }

    public void copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        String deletingMessage = NLS.bind((String)LocalServiceResources.FILEMSG_COPYING, (Object)"");
        monitor.beginTask(deletingMessage, srcParents.length);
        int i = 0;
        while (i < srcParents.length) {
            deletingMessage = NLS.bind((String)LocalServiceResources.FILEMSG_COPYING, (Object)srcNames[i]);
            monitor.subTask(deletingMessage);
            this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            monitor.worked(1);
            ++i;
        }
    }

    public void setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        File file = new File(parent, name);
        if (!file.setLastModified(timestamp)) {
            if (!file.exists()) {
                throw new SystemElementNotFoundException("org.eclipse.rse.services.local", file.getAbsolutePath(), "setLastModified");
            }
            throw new SystemOperationFailedException("org.eclipse.rse.services.local", "setLastModified: " + file.getAbsolutePath());
        }
    }

    public void setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        File file = new File(parent, name);
        if (!file.exists()) {
            throw new SystemElementNotFoundException("org.eclipse.rse.services.local", file.getAbsolutePath(), "setReadOnly");
        }
        if (readOnly != file.canWrite()) {
            return;
        }
        if (readOnly) {
            if (!file.setReadOnly()) {
                throw new SystemOperationFailedException("org.eclipse.rse.services.local", "Failed to setReadOnly: " + file.getAbsolutePath());
            }
            return;
        }
        Exception remoteException = null;
        String remoteError = "";
        if (!this._isWindows) {
            String[] cmd = new String[]{"chmod", "u+w", file.getAbsolutePath()};
            int exitValue = -1;
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                exitValue = p.waitFor();
                if (p.getErrorStream().available() > 0) {
                    remoteError = ": " + new BufferedReader(new InputStreamReader(p.getErrorStream())).readLine();
                } else if (p.getInputStream().available() > 0) {
                    remoteError = ": " + new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
                }
            }
            catch (Exception e) {
                remoteException = e;
            }
            if (exitValue != 0) {
                throw new SystemOperationFailedException("org.eclipse.rse.services.local", "Failed to setWritable: " + remoteError, remoteException);
            }
        } else {
            String[] cmd = new String[]{"attrib", "-R", file.getAbsolutePath()};
            int exitValue = -1;
            try {
                Process p = Runtime.getRuntime().exec(cmd);
                exitValue = p.waitFor();
                if (p.getErrorStream().available() > 0) {
                    remoteError = ": " + new BufferedReader(new InputStreamReader(p.getErrorStream())).readLine();
                } else if (p.getInputStream().available() > 0) {
                    remoteError = ": " + new BufferedReader(new InputStreamReader(p.getInputStream())).readLine();
                }
            }
            catch (Exception e) {
                remoteException = e;
            }
            if (exitValue != 0) {
                throw new SystemOperationFailedException("org.eclipse.rse.services.local", "Failed to setWritable: " + remoteError, remoteException);
            }
        }
        if (!file.canWrite()) {
            remoteError = remoteError.length() == 0 ? "Failed to setWritable: " + file.getAbsolutePath() : remoteError.substring(2);
            throw new SystemOperationFailedException("org.eclipse.rse.services.local", remoteError);
        }
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        File file = new File(remoteParent, remoteFile);
        FileInputStream stream = null;
        try {
            stream = new FileInputStream(file);
        }
        catch (FileNotFoundException e) {
            if (!file.exists()) {
                throw new SystemElementNotFoundException("org.eclipse.rse.services.local", file.getAbsolutePath(), "getInputStream");
            }
            throw new RemoteFileIOException((Exception)e);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return stream;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        int options = isBinary ? 0 : 2;
        return this.getOutputStream(remoteParent, remoteFile, options, monitor);
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, int options, IProgressMonitor monitor) throws SystemMessageException {
        File file = new File(remoteParent, remoteFile);
        FileOutputStream stream = null;
        try {
            stream = (options & 1) == 0 ? new FileOutputStream(file) : new FileOutputStream(file, true);
        }
        catch (FileNotFoundException e) {
            if (!file.exists()) {
                throw new SystemElementNotFoundException("org.eclipse.rse.services.local", file.getAbsolutePath(), "getOutputStream");
            }
            throw new RemoteFileIOException((Exception)e);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return stream;
    }

    public int getCapabilities(IHostFile file) {
        int capabilities = 0;
        if (this._isWindows) {
            return capabilities;
        }
        if (file instanceof LocalVirtualHostFile) {
            return capabilities;
        }
        return 63;
    }

    public IHostFilePermissions getFilePermissions(IHostFile rfile, IProgressMonitor monitor) throws SystemMessageException {
        if (!this._isWindows) {
            File file = new File(rfile.getParentPath(), rfile.getName());
            String ldStr = this.simpleShellCommand("ls -ld", file);
            StringTokenizer tokenizer = new StringTokenizer(ldStr, " \t");
            String permString = tokenizer.nextToken().substring(1);
            tokenizer.nextToken();
            String user = tokenizer.nextToken();
            String group = tokenizer.nextToken();
            HostFilePermissions permissions = new HostFilePermissions(permString, user, group);
            if (rfile instanceof IHostFilePermissionsContainer) {
                ((IHostFilePermissionsContainer)rfile).setPermissions((IHostFilePermissions)permissions);
            }
            return permissions;
        }
        return null;
    }

    public void setFilePermissions(IHostFile rfile, IHostFilePermissions newPermissions, IProgressMonitor monitor) throws SystemMessageException {
        if (!this._isWindows) {
            File file = new File(rfile.getParentPath(), rfile.getName());
            int bits = newPermissions.getPermissionBits();
            String permissionsInOctal = Integer.toOctalString(bits);
            String user = newPermissions.getUserOwner();
            String group = newPermissions.getGroupOwner();
            this.simpleShellCommand("chmod " + permissionsInOctal, file);
            this.simpleShellCommand("chown " + user, file);
            this.simpleShellCommand("chown :" + group, file);
        }
    }

    private String simpleShellCommand(String cmd, File file) {
        String result = null;
        String[] args = new String[]{"sh", "-c", String.valueOf(cmd) + " " + PathUtility.enQuoteUnix((String)file.getAbsolutePath())};
        BufferedReader childReader = null;
        try {
            Process childProcess = Runtime.getRuntime().exec(args);
            childReader = new BufferedReader(new InputStreamReader(childProcess.getInputStream()));
            result = childReader.readLine().trim();
            childReader.close();
        }
        catch (Exception exception) {
            try {
                childReader.close();
            }
            catch (IOException iOException) {}
        }
        return result;
    }

    private SystemMessageException getCancelledException() {
        return new SystemMessageException((SystemMessage)new SimpleSystemMessage("org.eclipse.rse.services.local", "RSEG1067", 8, CommonMessages.MSG_OPERATION_CANCELLED));
    }

    private class CheckArchiveOperationStatusThread
    extends Thread {
        private ISystemOperationMonitor archiveOperationMonitor = null;
        private IProgressMonitor monitor = null;

        public CheckArchiveOperationStatusThread(ISystemOperationMonitor archiveOperationMonitor, IProgressMonitor monitor) {
            this.archiveOperationMonitor = archiveOperationMonitor;
            this.monitor = monitor;
        }

        public void run() {
            while (!this.monitor.isCanceled() && !this.archiveOperationMonitor.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {}
            }
            if (this.monitor.isCanceled() && !this.archiveOperationMonitor.isDone()) {
                this.archiveOperationMonitor.setCancelled(true);
            }
        }
    }

    public class LocalFileNameFilter
    implements FilenameFilter {
        private IMatcher _matcher;
        private int type;

        public LocalFileNameFilter(String filter, int type) {
            if (filter == null) {
                filter = "*";
            }
            if (filter.endsWith(",")) {
                String[] types = filter.split(",");
                this._matcher = new FileTypeMatcher(types);
            } else {
                this._matcher = new NamePatternMatcher(filter);
            }
            this.type = type;
        }

        public boolean accept(File dir, String name) {
            boolean result = false;
            File entry = new File(dir, name);
            if (entry.exists()) {
                if (entry.isFile()) {
                    result = this._matcher.matches(name);
                } else if (entry.isDirectory() && (this.type == 0 || this.type == 2)) {
                    result = true;
                }
            }
            return result;
        }

        public boolean isGeneric() {
            boolean result = true;
            if (this._matcher instanceof NamePatternMatcher) {
                NamePatternMatcher new_name = (NamePatternMatcher)this._matcher;
                result = new_name.isGeneric();
            }
            return result;
        }
    }
}

