/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.tests;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.rse.tests.core.IRSETestLogCollectorDelegate;
import org.eclipse.rse.tests.internal.RSEDefaultTestLogCollectorDelegate;
import org.eclipse.rse.tests.internal.testsubsystem.TestSubSystemAdapterFactory;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.osgi.framework.BundleContext;

public class RSETestsPlugin
extends SystemBasePlugin {
    private static RSETestsPlugin plugin;
    private ResourceBundle resourceBundle;
    private final List logCollectorDelegates = new ArrayList();
    private final IRSETestLogCollectorDelegate defaultLogCollectorDelegate = new RSEDefaultTestLogCollectorDelegate();
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.tests.RSETestsPlugin");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public RSETestsPlugin() {
        plugin = this;
    }

    public static RSETestsPlugin getDefault() {
        return plugin;
    }

    public ResourceBundle getResourceBundle() {
        if (this.resourceBundle != null) {
            return this.resourceBundle;
        }
        this.resourceBundle = ResourceBundle.getBundle("org.eclipse.rse.tests.RSETestsResources");
        return this.resourceBundle;
    }

    public static String getResourceString(String key) {
        if (!$assertionsDisabled && key == null) {
            throw new AssertionError();
        }
        ResourceBundle bundle = RSETestsPlugin.getDefault().getResourceBundle();
        if (bundle != null) {
            try {
                return bundle.getString(key);
            }
            catch (MissingResourceException missingResourceException) {}
        }
        return String.valueOf('!') + key + '!';
    }

    public static String getResourceString(String key, Object argument) {
        if (!$assertionsDisabled && argument == null) {
            throw new AssertionError();
        }
        return RSETestsPlugin.getResourceString(key, new Object[]{argument});
    }

    public static String getResourceString(String key, Object[] arguments) {
        if (!$assertionsDisabled && arguments == null) {
            throw new AssertionError();
        }
        String resourceString = RSETestsPlugin.getResourceString(key);
        if (!resourceString.startsWith("!")) {
            return MessageFormat.format(resourceString, arguments);
        }
        return resourceString;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.addDelegate(this.defaultLogCollectorDelegate);
        IAdapterManager manager = Platform.getAdapterManager();
        TestSubSystemAdapterFactory subSystemAdapterFactory = new TestSubSystemAdapterFactory();
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystem");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)subSystemAdapterFactory, (Class)clazz);
        Class<?> clazz2 = class$2;
        if (clazz2 == null) {
            try {
                clazz2 = class$2 = Class.forName("org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemNode");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)subSystemAdapterFactory, (Class)clazz2);
        Class<?> clazz3 = class$3;
        if (clazz3 == null) {
            try {
                clazz3 = class$3 = Class.forName("org.eclipse.rse.tests.testsubsystem.interfaces.ITestSubSystemConfiguration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)subSystemAdapterFactory, (Class)clazz3);
    }

    public void stop(BundleContext context) throws Exception {
        this.removeDelegate(this.defaultLogCollectorDelegate);
        super.stop(context);
    }

    public static boolean isTestCaseEnabled(String testId) {
        if (!$assertionsDisabled && testId == null) {
            throw new AssertionError();
        }
        String value = System.getProperty(testId);
        if (value != null) {
            return Boolean.getBoolean(value);
        }
        value = RSETestsPlugin.getResourceString(testId);
        if (value != null && !value.startsWith("!")) {
            return Boolean.valueOf(value);
        }
        return true;
    }

    public synchronized void addDelegate(IRSETestLogCollectorDelegate delegate) {
        if (!$assertionsDisabled && delegate == null) {
            throw new AssertionError();
        }
        if (delegate != null && !this.logCollectorDelegates.contains(delegate)) {
            this.logCollectorDelegates.add(delegate);
        }
    }

    public synchronized void removeDelegate(IRSETestLogCollectorDelegate delegate) {
        if (!$assertionsDisabled && delegate == null) {
            throw new AssertionError();
        }
        if (delegate != null) {
            this.logCollectorDelegates.remove(delegate);
        }
    }

    public synchronized IRSETestLogCollectorDelegate[] getTestLogCollectorDelegates() {
        return this.logCollectorDelegates.toArray(new IRSETestLogCollectorDelegate[this.logCollectorDelegates.size()]);
    }

    protected void initializeImageRegistry() {
        String path = RSETestsPlugin.getIconPath();
        this.putImageInRegistry("ICON_ID_BRANCH", String.valueOf(path) + "branch.gif");
        this.putImageInRegistry("ICON_ID_LEAF", String.valueOf(path) + "leaf.gif");
    }
}

