/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.clientserver.messages;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Hashtable;
import java.util.LinkedList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.rse.services.clientserver.messages.IndicatorException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SystemMessageFile
implements ErrorHandler {
    private static final LinkedList msgfList = new LinkedList();
    private MessageFileInfo msgFile;
    private String defaultMsgFileLocation;
    private InputStream dtdInputStream;
    private Hashtable messages = new Hashtable();
    private static final String XML_TAG_COMPONENT = "Component";
    private static final String XML_TAG_SUBCOMPONENT = "Subcomponent";
    private static final String XML_TAG_MESSAGeList = "MessageList";
    private static final String XML_TAG_MESSAGE = "Message";
    private static final String XML_TAG_LEVELONE = "LevelOne";
    private static final String XML_TAG_LEVELTWO = "LevelTwo";
    private static final String XML_ATTR_ABBR = "Abbr";
    private static final String XML_ATTR_ID = "ID";
    private static final String XML_ATTR_INDICATOR = "Indicator";
    private static final String XML_ATTR_NAME = "Name";

    public SystemMessageFile(String messageFileName, InputStream messageFile, InputStream dtdStream) {
        this.msgFile = this.getFromCache(messageFileName);
        this.dtdInputStream = dtdStream;
        if (this.msgFile == null) {
            Document doc = this.loadAndParseXMLFile(messageFile);
            this.msgFile = new MessageFileInfo(messageFileName.toUpperCase(), messageFileName, doc);
            msgfList.add(this.msgFile);
        }
    }

    protected MessageFileInfo getFromCache(String messageFileName) {
        int i = 0;
        while (i < msgfList.size()) {
            MessageFileInfo msgf = (MessageFileInfo)msgfList.get(i);
            if (msgf.getMessageFullFileName().equals(messageFileName.toUpperCase())) {
                return msgf;
            }
            ++i;
        }
        return null;
    }

    public SystemMessage getMessage(String msgId) {
        boolean echoErrorsToStandardOut = true;
        if (this.msgFile.getXMLDocument() == null) {
            this.issueErrorMessage("No XML document for message file", echoErrorsToStandardOut);
            return null;
        }
        SystemMessage msg = (SystemMessage)this.messages.get(String.valueOf(this.msgFile.getMessageShortFileName()) + ":" + msgId);
        if (msg != null) {
            return msg;
        }
        NodeList componentElementList = this.msgFile.getXMLDocument().getElementsByTagName(XML_TAG_COMPONENT);
        if (componentElementList == null || componentElementList.getLength() == 0) {
            this.issueErrorMessage("Unable to find any Component elements", echoErrorsToStandardOut);
            return null;
        }
        Element componentElement = (Element)componentElementList.item(0);
        String componentAbbr = componentElement.getAttribute(XML_ATTR_ABBR);
        NodeList subComponentList = this.msgFile.getXMLDocument().getElementsByTagName(XML_TAG_SUBCOMPONENT);
        if (subComponentList == null || subComponentList.getLength() == 0) {
            this.issueErrorMessage("Unable to find any Subcomponent elements", echoErrorsToStandardOut);
            return null;
        }
        msgId = msgId.toUpperCase();
        int subComponentIdx = 0;
        while (subComponentIdx < subComponentList.getLength()) {
            Element subComponentElement = (Element)subComponentList.item(subComponentIdx);
            String subComponentAbbr = subComponentElement.getAttribute(XML_ATTR_ABBR);
            String msgPrefix = (String.valueOf(componentAbbr) + subComponentAbbr).toUpperCase();
            char msgIndicator = ' ';
            String msgL1 = "";
            String msgL2 = "";
            if (msgId.startsWith(msgPrefix) && Character.isDigit(msgId.charAt(msgPrefix.length()))) {
                String msgNumber = msgId.substring(msgPrefix.length());
                Element messageListNode = null;
                NodeList msgListNodes = subComponentElement.getElementsByTagName(XML_TAG_MESSAGeList);
                if (msgListNodes == null || msgListNodes.getLength() <= 0) {
                    this.issueWarningMessage("unable to find MessageList nodes for subComponent " + subComponentElement.getAttribute(XML_ATTR_NAME), echoErrorsToStandardOut);
                } else {
                    messageListNode = (Element)msgListNodes.item(0);
                    NodeList msgNodes = messageListNode.getElementsByTagName(XML_TAG_MESSAGE);
                    if (msgNodes != null && msgNodes.getLength() != 0) {
                        boolean match = false;
                        int msgIdx = 0;
                        while (!match && msgIdx < msgNodes.getLength()) {
                            Element node = (Element)msgNodes.item(msgIdx);
                            if (node.getAttribute(XML_ATTR_ID).equals(msgNumber)) {
                                match = true;
                                msgIndicator = node.getAttribute(XML_ATTR_INDICATOR).toUpperCase().charAt(0);
                                Node msgNode = node.getFirstChild();
                                while (msgNode != null) {
                                    if (msgNode.getNodeName().equals(XML_TAG_LEVELONE)) {
                                        msgL1 = this.getNodeText(msgNode);
                                    } else if (msgNode.getNodeName().equals(XML_TAG_LEVELTWO)) {
                                        msgL2 = this.getNodeText(msgNode);
                                    }
                                    msgNode = msgNode.getNextSibling();
                                }
                                break;
                            }
                            ++msgIdx;
                        }
                        if (!match) {
                            return null;
                        }
                        try {
                            msg = this.loadSystemMessage(componentAbbr, subComponentAbbr, msgNumber, msgIndicator, msgL1, msgL2);
                            this.messages.put(String.valueOf(this.msgFile.getMessageShortFileName()) + ":" + msgId, msg);
                            return msg;
                        }
                        catch (IndicatorException indicatorException) {
                            break;
                        }
                    }
                    this.issueWarningMessage("unable to find Message nodes for subComponent " + subComponentElement.getAttribute(XML_ATTR_NAME), echoErrorsToStandardOut);
                }
            }
            ++subComponentIdx;
        }
        return null;
    }

    protected SystemMessage loadSystemMessage(String componentAbbr, String subComponentAbbr, String msgNumber, char msgIndicator, String msgL1, String msgL2) throws IndicatorException {
        return new SystemMessage(componentAbbr, subComponentAbbr, msgNumber, msgIndicator, msgL1, msgL2);
    }

    private String getNodeText(Node msgNode) {
        String nodeText = "";
        Node textNode = msgNode.getFirstChild();
        while (textNode != null) {
            if (textNode.getNodeType() == 3 && textNode.getNodeValue().trim().length() > 0) {
                nodeText = String.valueOf(nodeText) + textNode.getNodeValue();
            }
            textNode = textNode.getNextSibling();
        }
        return nodeText.trim();
    }

    public boolean scanForDuplicates() {
        boolean echoErrorsToStandardOut = true;
        if (this.msgFile.getXMLDocument() == null) {
            return this.issueErrorMessage("No XML document for message file", echoErrorsToStandardOut);
        }
        NodeList componentElementList = this.msgFile.getXMLDocument().getElementsByTagName(XML_TAG_COMPONENT);
        if (componentElementList == null || componentElementList.getLength() == 0) {
            return this.issueErrorMessage("Unable to find any Component elements", echoErrorsToStandardOut);
        }
        Element componentElement = (Element)componentElementList.item(0);
        String componentAbbr = componentElement.getAttribute(XML_ATTR_ABBR);
        NodeList subComponentList = this.msgFile.getXMLDocument().getElementsByTagName(XML_TAG_SUBCOMPONENT);
        if (subComponentList == null || subComponentList.getLength() == 0) {
            return this.issueErrorMessage("Unable to find any Subcomponent elements", echoErrorsToStandardOut);
        }
        boolean anyDupes = false;
        int subComponentIdx = 0;
        while (subComponentIdx < subComponentList.getLength()) {
            Element subComponentElement = (Element)subComponentList.item(subComponentIdx);
            String subComponentAbbr = subComponentElement.getAttribute(XML_ATTR_ABBR);
            String msgPrefix = (String.valueOf(componentAbbr) + subComponentAbbr).toUpperCase();
            Vector<String> msgsById = new Vector<String>();
            Element messageListNode = null;
            NodeList msgListNodes = subComponentElement.getElementsByTagName(XML_TAG_MESSAGeList);
            if (msgListNodes == null || msgListNodes.getLength() <= 0) {
                this.issueWarningMessage("unable to find MessageList nodes for subComponent " + subComponentElement.getAttribute(XML_ATTR_NAME), echoErrorsToStandardOut);
            } else {
                messageListNode = (Element)msgListNodes.item(0);
                NodeList msgNodes = messageListNode.getElementsByTagName(XML_TAG_MESSAGE);
                if (msgNodes == null || msgNodes.getLength() == 0) {
                    this.issueWarningMessage("unable to find Message nodes for subComponent " + subComponentElement.getAttribute(XML_ATTR_NAME), echoErrorsToStandardOut);
                } else {
                    int msgIdx = 0;
                    while (msgIdx < msgNodes.getLength()) {
                        Element node = (Element)msgNodes.item(msgIdx);
                        String msgId = String.valueOf(msgPrefix) + node.getAttribute(XML_ATTR_ID);
                        if (msgsById.contains(msgId)) {
                            anyDupes = true;
                            this.issueWarningMessage("Warning: duplicate message " + msgId + " found", echoErrorsToStandardOut);
                        } else {
                            msgsById.addElement(msgId);
                        }
                        ++msgIdx;
                    }
                }
            }
            ++subComponentIdx;
        }
        return anyDupes;
    }

    public boolean printHTML(String fullFileName) {
        String msgPrefix;
        String subComponentAbbr;
        Element subComponentElement;
        boolean echoErrorsToStandardOut = true;
        if (this.msgFile.getXMLDocument() == null) {
            return this.issueErrorMessage("No XML document for message file", echoErrorsToStandardOut);
        }
        NodeList componentElementList = this.msgFile.getXMLDocument().getElementsByTagName(XML_TAG_COMPONENT);
        if (componentElementList == null || componentElementList.getLength() == 0) {
            return this.issueErrorMessage("Unable to find any Component elements", echoErrorsToStandardOut);
        }
        Element componentElement = (Element)componentElementList.item(0);
        String componentAbbr = componentElement.getAttribute(XML_ATTR_ABBR);
        NodeList subComponentList = this.msgFile.getXMLDocument().getElementsByTagName(XML_TAG_SUBCOMPONENT);
        if (subComponentList == null || subComponentList.getLength() == 0) {
            return this.issueErrorMessage("Unable to find any Subcomponent elements", echoErrorsToStandardOut);
        }
        File outFile = new File(fullFileName);
        PrintWriter outFileStream = null;
        try {
            outFileStream = new PrintWriter(new FileOutputStream(outFile));
            outFileStream.println("<HTML> <HEAD> <TITLE> Message File " + this.msgFile.getMessageShortFileName() + " </TITLE>");
            outFileStream.println("<style type=\"text/css\">");
            outFileStream.println("h2 { background-color: #CCCCFF }");
            outFileStream.println("</style>");
            outFileStream.println("</HEAD> <BODY>");
            outFileStream.println("<H1>" + componentElement.getAttribute(XML_ATTR_NAME) + " Messages</H1>");
            outFileStream.println("<br>");
            outFileStream.println("<TABLE BORDER=\"1\" CELLPADDING=\"3\" CELLSPACING=\"0\" WIDTH=\"100%\">");
            outFileStream.println("<TR BGCOLOR=\"#CCCCFF\">");
            outFileStream.println("<TD COLSPAN=2><FONT SIZE=\"+2\">");
            outFileStream.println("<B>Sub-Component Summary</B></FONT></TD>");
            outFileStream.println("</TR>");
        }
        catch (IOException exc) {
            return this.issueErrorMessage("Unable to open given html file in printHTML: " + exc.getMessage(), echoErrorsToStandardOut);
        }
        int subComponentIdx = 0;
        while (subComponentIdx < subComponentList.getLength()) {
            subComponentElement = (Element)subComponentList.item(subComponentIdx);
            subComponentAbbr = subComponentElement.getAttribute(XML_ATTR_ABBR);
            msgPrefix = (String.valueOf(componentAbbr) + subComponentAbbr).toUpperCase();
            String scName = subComponentElement.getAttribute(XML_ATTR_NAME);
            outFileStream.println("<TR BGCOLOR=\"white\">");
            outFileStream.println("<TD ALIGN=\"right\" VALIGN=\"top\" WIDTH=\"1%\">");
            outFileStream.println("<A href=#" + scName + ">" + scName + "</A></TD>");
            outFileStream.println("<TD><b>Message prefix</b>=" + msgPrefix + "</TD></TR>");
            ++subComponentIdx;
        }
        outFileStream.println("</TABLE>");
        subComponentIdx = 0;
        while (subComponentIdx < subComponentList.getLength()) {
            subComponentElement = (Element)subComponentList.item(subComponentIdx);
            subComponentAbbr = subComponentElement.getAttribute(XML_ATTR_ABBR);
            msgPrefix = (String.valueOf(componentAbbr) + subComponentAbbr).toUpperCase();
            Element messageListNode = null;
            NodeList msgListNodes = subComponentElement.getElementsByTagName(XML_TAG_MESSAGeList);
            if (msgListNodes == null || msgListNodes.getLength() <= 0) {
                this.issueWarningMessage("unable to find MessageList nodes for subComponent " + subComponentElement.getAttribute(XML_ATTR_NAME), echoErrorsToStandardOut);
            } else {
                messageListNode = (Element)msgListNodes.item(0);
                NodeList msgNodes = messageListNode.getElementsByTagName(XML_TAG_MESSAGE);
                if (msgNodes == null || msgNodes.getLength() == 0) {
                    this.issueWarningMessage("unable to find Message nodes for subComponent " + subComponentElement.getAttribute(XML_ATTR_NAME), echoErrorsToStandardOut);
                } else {
                    if (subComponentIdx > 0) {
                        outFileStream.println("<hr>");
                    }
                    String scName = subComponentElement.getAttribute(XML_ATTR_NAME);
                    outFileStream.println("<A NAME=\"" + scName + "\"><!-- --></A><H2>" + scName + " Messages</H2>");
                    int msgIdx = 0;
                    while (msgIdx < msgNodes.getLength()) {
                        Element node = (Element)msgNodes.item(msgIdx);
                        String msgId = String.valueOf(msgPrefix) + node.getAttribute(XML_ATTR_ID);
                        char msgIndicator = node.getAttribute(XML_ATTR_INDICATOR).toUpperCase().charAt(0);
                        String msgSeverity = "Unknown";
                        if (msgIndicator == 'E') {
                            msgSeverity = "Error";
                        } else if (msgIndicator == 'W') {
                            msgSeverity = "Warning";
                        } else if (msgIndicator == 'Q') {
                            msgSeverity = "Question";
                        } else if (msgIndicator == 'I') {
                            msgSeverity = "Information";
                        } else if (msgIndicator == 'C') {
                            msgSeverity = "Completion";
                        } else if (msgIndicator == 'U') {
                            msgSeverity = "Unexpected";
                        }
                        String msgL1 = "";
                        String msgL2 = "";
                        Node msgNode = node.getFirstChild();
                        while (msgNode != null) {
                            if (msgNode.getNodeName().equals(XML_TAG_LEVELONE)) {
                                msgL1 = this.getNodeText(msgNode);
                            } else if (msgNode.getNodeName().equals(XML_TAG_LEVELTWO)) {
                                msgL2 = this.getNodeText(msgNode);
                            }
                            msgNode = msgNode.getNextSibling();
                        }
                        outFileStream.println("<H3>" + msgId + "</H3>");
                        outFileStream.println("<b>Severity: </b>" + msgSeverity + "<br>");
                        outFileStream.println("<b>LevelOne: </b>" + msgL1 + "<br>");
                        outFileStream.println("<b>LevelTwo: </b>" + msgL2 + "<br>");
                        ++msgIdx;
                    }
                    outFileStream.println("<br>");
                }
            }
            ++subComponentIdx;
        }
        outFileStream.println("</BODY></HTML>");
        outFileStream.close();
        return true;
    }

    private boolean issueErrorMessage(String errormsg, boolean echoStandardOut) {
        if (echoStandardOut) {
            System.out.println("MessageFile error for msg file " + this.msgFile.getMessageShortFileName() + ": " + errormsg);
        }
        return false;
    }

    private boolean issueWarningMessage(String errormsg, boolean echoStandardOut) {
        if (echoStandardOut) {
            System.out.println("MessageFile warning for msg file " + this.msgFile.getMessageShortFileName() + ": " + errormsg);
        }
        return false;
    }

    private DocumentBuilder createXmlParser() {
        DocumentBuilder parser;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setValidating(true);
        try {
            parser = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            return null;
        }
        parser.setEntityResolver(new EntityResolver(){

            public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
                if (SystemMessageFile.this.dtdInputStream != null) {
                    return new InputSource(SystemMessageFile.this.dtdInputStream);
                }
                try {
                    URI url = new URI(systemId);
                    File dtdFile = new File(url.getPath());
                    if (!dtdFile.exists()) {
                        systemId = String.valueOf(SystemMessageFile.this.defaultMsgFileLocation) + File.separatorChar + dtdFile.getName();
                    }
                }
                catch (URISyntaxException uRISyntaxException) {}
                return new InputSource(systemId);
            }
        });
        parser.setErrorHandler(this);
        return parser;
    }

    private Document loadAndParseXMLFile(InputStream messageFile) {
        DocumentBuilder parser = this.createXmlParser();
        try {
            InputSource in = new InputSource(messageFile);
            in.setSystemId("foo");
            Document document = parser.parse(in);
            return document;
        }
        catch (SAXException e) {
            e.printStackTrace();
            return null;
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    public void warning(SAXParseException ex) {
    }

    public void error(SAXParseException ex) {
    }

    public void fatalError(SAXParseException ex) throws SAXException {
        throw ex;
    }

    private class MessageFileInfo {
        private String filename = null;
        private String shortName = null;
        private Document xmlDocument = null;

        public MessageFileInfo(String ucFileName, String lcFileName, Document doc) {
            this.filename = ucFileName;
            int idx = lcFileName.lastIndexOf(92);
            if (idx == -1) {
                idx = lcFileName.lastIndexOf(47);
            }
            this.shortName = idx >= 0 ? lcFileName.substring(idx + 1) : lcFileName;
            this.xmlDocument = doc;
        }

        public String getMessageFullFileName() {
            return this.filename;
        }

        public String getMessageShortFileName() {
            return this.shortName;
        }

        public Document getXMLDocument() {
            return this.xmlDocument;
        }
    }
}

