/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.services.files;

import org.eclipse.rse.services.files.IHostFilePermissions;

public class HostFilePermissions
implements IHostFilePermissions,
Cloneable {
    private int _permissions = 0;
    private String _user;
    private String _group;

    public HostFilePermissions() {
    }

    public HostFilePermissions(String alphaPermissions, String user, String group) {
        String accessString = this.alphaPermissionsToOctal(alphaPermissions);
        this._permissions = Integer.parseInt(accessString, 8);
        this._user = user;
        this._group = group;
    }

    public HostFilePermissions(int initialPermissions, String user, String group) {
        this._permissions = initialPermissions;
        this._user = user;
        this._group = group;
    }

    private String alphaPermissionsToOctal(String alphaPermissions) {
        if (alphaPermissions.length() == 10) {
            alphaPermissions = alphaPermissions.substring(1);
        }
        StringBuffer buf = new StringBuffer();
        char[] chars = alphaPermissions.toCharArray();
        int offset = -1;
        int i = 0;
        while (i < 3) {
            int value = 0;
            if (chars[++offset] == 'r') {
                value = 4;
            }
            if (chars[++offset] == 'w') {
                value += 2;
            }
            if (chars[++offset] == 'x') {
                ++value;
            }
            buf.append(value);
            ++i;
        }
        return buf.toString();
    }

    public void setPermission(int permission, boolean value) {
        if (value) {
            this.set(permission);
        } else {
            this.clear(permission);
        }
    }

    public boolean getPermission(int permission) {
        return this.isSet(permission);
    }

    public int getPermissionBits() {
        return this._permissions;
    }

    public void setPermissionBits(int bits) {
        this._permissions = bits;
    }

    public String toString() {
        return "" + this._permissions;
    }

    private boolean isSet(long mask) {
        return ((long)this._permissions & mask) != 0L;
    }

    private void set(int mask) {
        this._permissions |= mask;
    }

    private void clear(int mask) {
        this._permissions &= ~mask;
    }

    public String toAlphaString() {
        StringBuffer buf = new StringBuffer();
        buf.append(this.getPermission(256) ? (char)'r' : '-');
        buf.append(this.getPermission(128) ? (char)'w' : '-');
        buf.append(this.getPermission(64) ? (char)'x' : '-');
        buf.append(this.getPermission(32) ? (char)'r' : '-');
        buf.append(this.getPermission(16) ? (char)'w' : '-');
        buf.append(this.getPermission(8) ? (char)'x' : '-');
        buf.append(this.getPermission(4) ? (char)'r' : '-');
        buf.append(this.getPermission(2) ? (char)'w' : '-');
        buf.append(this.getPermission(1) ? (char)'x' : '-');
        return buf.toString();
    }

    public String getGroupOwner() {
        return this._group;
    }

    public String getUserOwner() {
        return this._user;
    }

    public void setGroupOwner(String group) {
        this._group = group;
    }

    public void setUserOwner(String user) {
        this._user = user;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }
}

