/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.core;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Vector;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.comm.SystemKeystoreProviderManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.ISubSystemConfigurationProxy;
import org.eclipse.rse.internal.core.RSECoreRegistry;
import org.eclipse.rse.internal.core.subsystems.SubSystemConfigurationProxy;
import org.eclipse.rse.internal.core.subsystems.SubSystemConfigurationProxyComparator;
import org.eclipse.rse.internal.persistence.RSEPersistenceManager;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.logging.LoggerFactory;
import org.eclipse.rse.persistence.IRSEPersistenceManager;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class RSECorePlugin
extends Plugin {
    public static final int CURRENT_RELEASE = 200;
    public static final String CURRENT_RELEASE_NAME = "2.0.0";
    private static RSECorePlugin plugin = null;
    private Logger logger = null;
    private ISystemRegistry _registry = null;
    private IRSEPersistenceManager _persistenceManager = null;
    private ISubSystemConfigurationProxy[] _subsystemConfigurations = null;

    public static RSECorePlugin getDefault() {
        return plugin;
    }

    public static IRSEPersistenceManager getThePersistenceManager() {
        return RSECorePlugin.getDefault().getPersistenceManager();
    }

    public static IRSECoreRegistry getTheCoreRegistry() {
        return RSECorePlugin.getDefault().getCoreRegistry();
    }

    public static ISystemRegistry getTheSystemRegistry() {
        return RSECorePlugin.getDefault().getSystemRegistry();
    }

    public static String getLocalMachineName() {
        String machineName = null;
        try {
            machineName = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            RSECorePlugin.getDefault().log(e);
        }
        return machineName;
    }

    public static String getLocalMachineIPAddress() {
        String machineAddress = null;
        try {
            machineAddress = InetAddress.getLocalHost().getHostAddress();
        }
        catch (UnknownHostException e) {
            RSECorePlugin.getDefault().log(e);
        }
        return machineAddress;
    }

    public static String getQualifiedHostName(String hostName) {
        try {
            InetAddress address = InetAddress.getByName(hostName);
            return address.getCanonicalHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return hostName;
        }
    }

    public RSECorePlugin() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.registerKeystoreProviders();
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        LoggerFactory.freeLogger(this);
        this.logger = null;
        plugin = null;
    }

    public IRSEPersistenceManager getPersistenceManager() {
        if (this._persistenceManager == null) {
            this._persistenceManager = new RSEPersistenceManager(this._registry);
        }
        return this._persistenceManager;
    }

    public void setSystemRegistry(ISystemRegistry registry) {
        this._registry = registry;
    }

    public ISystemRegistry getSystemRegistry() {
        return this._registry;
    }

    public IRSECoreRegistry getCoreRegistry() {
        return RSECoreRegistry.getInstance();
    }

    public Logger getLogger() {
        if (this.logger == null) {
            this.logger = LoggerFactory.getLogger(this);
        }
        return this.logger;
    }

    private void log(Throwable t) {
        this.getLogger().logError("Unexpected Exception", t);
    }

    private void registerKeystoreProviders() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] systemTypeExtensions = registry.getConfigurationElementsFor("org.eclipse.rse.core", "keystoreProviders");
        int i = 0;
        while (i < systemTypeExtensions.length) {
            String nameSpace = systemTypeExtensions[i].getDeclaringExtension().getNamespaceIdentifier();
            String keystoreProviderType = systemTypeExtensions[i].getAttribute("class");
            Bundle bundle = Platform.getBundle((String)nameSpace);
            if (bundle.getState() != 1) {
                SystemKeystoreProviderManager.getInstance().registerKeystoreProvider(bundle, keystoreProviderType);
            }
            ++i;
        }
    }

    private IConfigurationElement[] getSubSystemConfigurationPlugins() {
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IConfigurationElement[] subsystemConfigurationExtensions = registry.getConfigurationElementsFor("org.eclipse.rse.core", "subsystemConfigurations");
        return subsystemConfigurationExtensions;
    }

    public ISubSystemConfigurationProxy[] getSubSystemConfigurationProxies() {
        if (this._subsystemConfigurations != null) {
            return this._subsystemConfigurations;
        }
        IConfigurationElement[] factoryPlugins = this.getSubSystemConfigurationPlugins();
        if (factoryPlugins != null) {
            Vector<SubSystemConfigurationProxy> v = new Vector<SubSystemConfigurationProxy>();
            int idx = 0;
            while (idx < factoryPlugins.length) {
                SubSystemConfigurationProxy ssf = new SubSystemConfigurationProxy(factoryPlugins[idx]);
                v.addElement(ssf);
                ++idx;
            }
            if (v.size() != 0) {
                this._subsystemConfigurations = new ISubSystemConfigurationProxy[v.size()];
                idx = 0;
                while (idx < v.size()) {
                    this._subsystemConfigurations[idx] = (ISubSystemConfigurationProxy)v.elementAt(idx);
                    ++idx;
                }
            }
            Arrays.sort(this._subsystemConfigurations, new SubSystemConfigurationProxyComparator());
        }
        return this._subsystemConfigurations;
    }
}

