/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence.dom;

import java.util.Vector;
import org.eclipse.rse.core.IRSECoreRegistry;
import org.eclipse.rse.core.IRSESystemType;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.filters.ISystemFilter;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterStartHere;
import org.eclipse.rse.core.filters.ISystemFilterString;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.core.model.IPropertyType;
import org.eclipse.rse.core.model.IRSEModelObject;
import org.eclipse.rse.core.model.ISystemProfile;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.model.PropertyType;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.IServiceSubSystem;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.core.subsystems.SubSystemFilterNamingPolicy;
import org.eclipse.rse.internal.core.model.SystemProfile;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;
import org.eclipse.rse.persistence.dom.RSEDOMNodeAttribute;

public class RSEDOMImporter {
    private static RSEDOMImporter _instance = new RSEDOMImporter();
    private ISystemRegistry _registry;

    public static RSEDOMImporter getInstance() {
        return _instance;
    }

    public void setSystemRegistry(ISystemRegistry registry) {
        this._registry = registry;
    }

    public ISystemProfile restoreProfile(RSEDOM dom) {
        String profileName = dom.getName();
        boolean defaultPrivate = this.getBooleanValue(dom.getAttribute("defaultPrivate").getValue());
        boolean isActive = this.getBooleanValue(dom.getAttribute("isActive").getValue());
        SystemProfile profile = new SystemProfile(profileName, isActive);
        if (profile != null) {
            profile.setDefaultPrivate(defaultPrivate);
            SystemProfileManager.getDefault().addSystemProfile(profile);
            RSEDOMNode[] children = dom.getChildren();
            int i = 0;
            while (i < children.length) {
                RSEDOMNode child = children[i];
                String type = child.getType();
                if (type.equals("Host")) {
                    this.restoreHost(profile, child);
                } else if (type.equals("FilterPool")) {
                    this.restoreFilterPool(profile, child);
                } else if (type.equals("PropertySet")) {
                    this.restorePropertySet(profile, child);
                }
                ++i;
            }
        }
        return profile;
    }

    public IHost restoreHost(ISystemProfile profile, RSEDOMNode hostNode) {
        IHost host = null;
        String connectionName = hostNode.getName();
        String systemTypeName = this.getAttributeValue(hostNode, "type");
        String systemTypeId = this.getAttributeValue(hostNode, "systemType");
        String hostName = this.getAttributeValue(hostNode, "hostname");
        String description = this.getAttributeValue(hostNode, "description");
        boolean isOffline = this.getBooleanValue(this.getAttributeValue(hostNode, "offline"));
        boolean isPromptable = this.getBooleanValue(this.getAttributeValue(hostNode, "promptable"));
        try {
            IRSECoreRegistry registry = RSECorePlugin.getTheCoreRegistry();
            IRSESystemType systemType = null;
            if (systemTypeId != null) {
                systemType = registry.getSystemTypeById(systemTypeId);
            } else if (systemTypeName != null) {
                systemType = registry.getSystemType(systemTypeName);
            }
            host = profile.createHost(systemType, connectionName, hostName, description);
            host.setOffline(isOffline);
            host.setPromptable(isPromptable);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RSEDOMNode[] children = hostNode.getChildren();
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            String type = child.getType();
            if (type.equals("ConnectorService")) {
                this.restoreConnectorService(host, child);
            } else if (type.equals("PropertySet")) {
                this.restorePropertySet(host, child);
            }
            ++i;
        }
        return host;
    }

    public IConnectorService restoreConnectorService(IHost host, RSEDOMNode connectorServiceNode) {
        IConnectorService service = null;
        boolean useSSL = this.getBooleanValue(connectorServiceNode.getAttribute("useSSL").getValue());
        RSEDOMNodeAttribute att = connectorServiceNode.getAttribute("port");
        int port = 0;
        if (att != null) {
            port = this.getIntegerValue(att.getValue());
        }
        RSEDOMNode[] ssChildren = connectorServiceNode.getChildren("SubSystem");
        int s = 0;
        while (s < ssChildren.length) {
            ISubSystemConfiguration subsystemConfiguration;
            RSEDOMNode ssChild = ssChildren[s];
            ISubSystem subSystem = this.restoreSubSystem(host, ssChild);
            if (subSystem != null && service == null && (service = (subsystemConfiguration = subSystem.getSubSystemConfiguration()).getConnectorService(host)) != null) {
                IServerLauncherProperties sl;
                if (subsystemConfiguration.supportsServerLaunchProperties(host) && (sl = subsystemConfiguration.createServerLauncher(service)) != null) {
                    RSEDOMNode serverLauncherPropertiesNode = null;
                    RSEDOMNode[] slChildren = connectorServiceNode.getChildren("ServerLauncher");
                    if (slChildren != null && slChildren.length > 0) {
                        serverLauncherPropertiesNode = slChildren[0];
                        this.restoreServerLauncher(service, serverLauncherPropertiesNode, sl);
                    }
                }
                service.setPort(port);
                service.setIsUsingSSL(useSSL);
            }
            if (service != null && subSystem != null) {
                subSystem.setConnectorService(service);
            }
            ++s;
        }
        RSEDOMNode[] psChildren = connectorServiceNode.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(service, psChild);
            ++p;
        }
        return service;
    }

    public IServerLauncherProperties restoreServerLauncher(IConnectorService service, RSEDOMNode serverLauncherNode, IServerLauncherProperties sl) {
        RSEDOMNode[] psChildren = serverLauncherNode.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(sl, psChild);
            ++p;
        }
        sl.restoreFromProperties();
        service.setRemoteServerLauncherProperties(sl);
        return sl;
    }

    public ISubSystem restoreSubSystem(IHost host, RSEDOMNode subSystemNode) {
        String name = subSystemNode.getName();
        String type = subSystemNode.getAttribute("type").getValue();
        boolean isHidden = this.getBooleanValue(subSystemNode.getAttribute("hidden").getValue());
        ISubSystem subSystem = null;
        ISubSystemConfiguration factory = this.getSubSystemConfiguration(type);
        if (factory != null) {
            ISubSystem[] existingSubSystems;
            if (factory instanceof IServiceSubSystemConfiguration) {
                IServiceSubSystemConfiguration serviceFactory = (IServiceSubSystemConfiguration)factory;
                existingSubSystems = this._registry.getServiceSubSystems(host, serviceFactory.getServiceType());
                if (existingSubSystems != null && existingSubSystems.length > 0) {
                    subSystem = existingSubSystems[0];
                    ((IServiceSubSystem)subSystem).switchServiceFactory(serviceFactory);
                }
            } else {
                ISubSystemConfiguration config = this._registry.getSubSystemConfiguration(type);
                if (config != null && (existingSubSystems = config.getSubSystems(host, true)) != null && existingSubSystems.length > 0) {
                    subSystem = existingSubSystems[0];
                }
            }
            if (subSystem == null) {
                ISubSystem[] createdSystems = this._registry.createSubSystems(host, new ISubSystemConfiguration[]{factory});
                subSystem = createdSystems[0];
            }
            subSystem.setHidden(isHidden);
            subSystem.setHost(host);
            subSystem.setSubSystemConfiguration(factory);
            subSystem.setName(factory.getName());
            subSystem.setConfigurationId(factory.getId());
            if (factory.supportsFilters()) {
                ISystemFilterStartHere startHere = this._registry.getSystemFilterStartHere();
                ISystemFilterPoolReferenceManager fprMgr = startHere.createSystemFilterPoolReferenceManager(subSystem, factory, name, new SubSystemFilterNamingPolicy());
                subSystem.setFilterPoolReferenceManager(fprMgr);
                ISystemFilterPoolManager defaultFilterPoolManager = factory.getFilterPoolManager(host.getSystemProfile());
                fprMgr.setDefaultSystemFilterPoolManager(defaultFilterPoolManager);
            }
            RSEDOMNode[] filterPoolReferenceChildren = subSystemNode.getChildren("FilterPoolReference");
            int i = 0;
            while (i < filterPoolReferenceChildren.length) {
                RSEDOMNode fprChild = filterPoolReferenceChildren[i];
                this.restoreFilterPoolReference(subSystem, fprChild);
                ++i;
            }
            RSEDOMNode[] psChildren = subSystemNode.getChildren("PropertySet");
            int p = 0;
            while (p < psChildren.length) {
                RSEDOMNode psChild = psChildren[p];
                this.restorePropertySet(subSystem, psChild);
                ++p;
            }
            subSystem.wasRestored();
        }
        return subSystem;
    }

    public ISystemFilter restoreFilter(ISystemFilterPool filterPool, RSEDOMNode node) {
        String name = node.getName();
        boolean supportsNestedFilters = this.getBooleanValue(node.getAttribute("supportsNestedFilters").getValue());
        int relativeOrder = this.getIntegerValue(node.getAttribute("relativeOrder").getValue());
        boolean isDefault = this.getBooleanValue(node.getAttribute("default").getValue());
        boolean isSetStringsCaseSensitive = this.getBooleanValue(node.getAttribute("stringsCaseSensitive").getValue());
        boolean isPromptable = this.getBooleanValue(node.getAttribute("promptable").getValue());
        boolean isSetSupportsDuplicateFilterStrings = this.getBooleanValue(node.getAttribute("supportsDuplicateFilterStrings").getValue());
        boolean isNonDeletable = this.getBooleanValue(node.getAttribute("nonDeletable").getValue());
        boolean isNonRenamable = this.getBooleanValue(node.getAttribute("nonRenamable").getValue());
        boolean isNonChangable = this.getBooleanValue(node.getAttribute("nonChangable").getValue());
        boolean isStringsNonChangable = this.getBooleanValue(node.getAttribute("stringsNonChangable").getValue());
        int release = this.getIntegerValue(node.getAttribute("release").getValue());
        boolean isSetSingleFilterStringOnly = this.getBooleanValue(node.getAttribute("singleFilterStringOnly").getValue());
        Vector<String> filterStrings = new Vector<String>();
        RSEDOMNode[] filterStringNodes = node.getChildren("FilterString");
        int i = 0;
        while (i < filterStringNodes.length) {
            RSEDOMNode filterStringNode = filterStringNodes[i];
            filterStrings.add(filterStringNode.getName());
            ++i;
        }
        ISystemFilter filter = filterPool.createSystemFilter(name, filterStrings);
        filter.setSupportsNestedFilters(supportsNestedFilters);
        filter.setRelativeOrder(relativeOrder);
        filter.setDefault(isDefault);
        filter.setStringsCaseSensitive(isSetStringsCaseSensitive);
        filter.setPromptable(isPromptable);
        filter.setSupportsDuplicateFilterStrings(isSetSupportsDuplicateFilterStrings);
        filter.setNonDeletable(isNonDeletable);
        filter.setNonChangable(isNonChangable);
        filter.setNonRenamable(isNonRenamable);
        filter.setStringsNonChangable(isStringsNonChangable);
        filter.setRelease(release);
        filter.setSingleFilterStringOnly(isSetSingleFilterStringOnly);
        RSEDOMNode[] psChildren = node.getChildren("PropertySet");
        int p = 0;
        while (p < psChildren.length) {
            RSEDOMNode psChild = psChildren[p];
            this.restorePropertySet(filter, psChild);
            ++p;
        }
        return filter;
    }

    public ISystemFilterPool restoreFilterPool(ISystemProfile profile, RSEDOMNode node) {
        ISystemFilterPool filterPool = null;
        String name = node.getName();
        String type = node.getAttribute("type").getValue();
        String id = node.getAttribute("id").getValue();
        boolean supportsNestedFilters = this.getBooleanValue(node.getAttribute("supportsNestedFilters").getValue());
        boolean isDeletable = this.getBooleanValue(node.getAttribute("deletable").getValue());
        boolean isDefault = this.getBooleanValue(node.getAttribute("default").getValue());
        boolean isSetStringsCaseSensitive = this.getBooleanValue(node.getAttribute("stringsCaseSensitive").getValue());
        boolean isSetSupportsDuplicateFilterStrings = this.getBooleanValue(node.getAttribute("supportsDuplicateFilterStrings").getValue());
        int release = this.getIntegerValue(node.getAttribute("release").getValue());
        boolean isSetSingleFilterStringOnly = this.getBooleanValue(node.getAttribute("singleFilterStringOnly").getValue());
        String owningParentName = node.getAttribute("owningParentName").getValue();
        boolean isNonRenamable = this.getBooleanValue(node.getAttribute("nonRenamable").getValue());
        try {
            ISubSystemConfiguration factory = this.getSubSystemConfiguration(id);
            if (factory != null) {
                ISystemFilterPoolManager mgr = factory.getFilterPoolManager(profile);
                filterPool = isDefault ? mgr.getFirstDefaultSystemFilterPool() : mgr.getSystemFilterPool(name);
                if (filterPool == null) {
                    filterPool = mgr.createSystemFilterPool(name, isDeletable);
                }
                filterPool.setType(type);
                filterPool.setDefault(isDefault);
                filterPool.setSupportsNestedFilters(supportsNestedFilters);
                filterPool.setStringsCaseSensitive(isSetStringsCaseSensitive);
                filterPool.setSupportsDuplicateFilterStrings(isSetSupportsDuplicateFilterStrings);
                filterPool.setRelease(release);
                filterPool.setSingleFilterStringOnly(isSetSingleFilterStringOnly);
                filterPool.setOwningParentName(owningParentName);
                filterPool.setNonRenamable(isNonRenamable);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        RSEDOMNode[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            String ctype = child.getType();
            if (ctype.equals("Filter")) {
                if (filterPool != null) {
                    this.restoreFilter(filterPool, child);
                }
            } else if (ctype.equals("PropertySet")) {
                this.restorePropertySet(filterPool, child);
            }
            ++i;
        }
        return filterPool;
    }

    public ISystemFilterPoolReference restoreFilterPoolReference(ISubSystem subsystem, RSEDOMNode node) {
        ISystemFilterPoolReference filterPoolReference = null;
        String filterPoolName = node.getName();
        String[] part = filterPoolName.split("___", 2);
        if (part.length == 1) {
            ISystemProfile profile = subsystem.getSystemProfile();
            String profileName = profile.getName();
            filterPoolName = String.valueOf(profileName) + "___" + filterPoolName;
        }
        ISystemFilterPoolReferenceManager referenceManager = subsystem.getFilterPoolReferenceManager();
        filterPoolReference = referenceManager.addReferenceToSystemFilterPool(filterPoolName);
        return filterPoolReference;
    }

    public ISystemFilterString restoreFilterString(ISystemFilter filter, RSEDOMNode node) {
        return null;
    }

    public IPropertySet restorePropertySet(IRSEModelObject modelObject, RSEDOMNode propertySetNode) {
        String name = propertySetNode.getName();
        IPropertySet set = modelObject.createPropertySet(name);
        RSEDOMNodeAttribute[] attributes = propertySetNode.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            RSEDOMNodeAttribute attribute = attributes[i];
            if (attribute.getKey().equals("description")) {
                set.setDescription(attribute.getValue());
            } else {
                String typeStr = attribute.getType();
                IPropertyType type = PropertyType.fromString(typeStr);
                set.addProperty(attribute.getKey(), attribute.getValue(), type);
            }
            ++i;
        }
        RSEDOMNode[] children = propertySetNode.getChildren();
        int i2 = 0;
        while (i2 < children.length) {
            RSEDOMNode child = children[i2];
            String propertyName = child.getName();
            String propertyValue = child.getAttribute("value").getValue();
            String propertyTypeName = child.getAttribute("type").getValue();
            IPropertyType propertyType = PropertyType.fromString(propertyTypeName);
            if (propertyName.equals("description")) {
                set.setDescription(propertyValue);
            } else {
                set.addProperty(propertyName, propertyValue, propertyType);
            }
            ++i2;
        }
        return set;
    }

    private boolean getBooleanValue(String booleanStr) {
        return booleanStr != null && booleanStr.equalsIgnoreCase("true");
    }

    private int getIntegerValue(String integerString) {
        int result = 0;
        if (integerString != null) {
            try {
                result = Integer.parseInt(integerString);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return result;
    }

    private ISubSystemConfiguration getSubSystemConfiguration(String subsystemName) {
        return this._registry.getSubSystemConfiguration(subsystemName);
    }

    private String getAttributeValue(RSEDOMNode node, String attributeName) {
        String result = null;
        RSEDOMNodeAttribute attribute = node.getAttribute(attributeName);
        if (attribute != null) {
            result = attribute.getValue();
        }
        return result;
    }
}

