/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.core.RSECoreMessages;
import org.eclipse.rse.internal.persistence.PFConstants;
import org.eclipse.rse.internal.persistence.PFMetadataAnchor;
import org.eclipse.rse.internal.persistence.PFPersistenceAnchor;
import org.eclipse.rse.internal.persistence.PFPersistenceLocation;
import org.eclipse.rse.internal.persistence.PFWorkspaceAnchor;
import org.eclipse.rse.logging.Logger;
import org.eclipse.rse.persistence.IRSEPersistenceProvider;
import org.eclipse.rse.persistence.dom.RSEDOM;
import org.eclipse.rse.persistence.dom.RSEDOMNode;
import org.eclipse.rse.persistence.dom.RSEDOMNodeAttribute;

public class PropertyFileProvider
implements IRSEPersistenceProvider {
    private static final String NULL_VALUE_STRING = "null";
    private static final String VALID = "abcdefghijklmnopqrstuvwxyz0123456789-._";
    private static final String UPPER = "ABCDEFGHIJKLMNOPQRTSUVWXYZ";
    private static final String P_LOCATION = "location";
    private static final String PV_LOCATION_WORKSPACE = "workspace";
    private static final String PV_LOCATION_METADATA = "metadata";
    private Pattern period = Pattern.compile("\\.");
    private Pattern suffixPattern = Pattern.compile("_(\\d+)$");
    private Pattern unicodePattern = Pattern.compile("#(\\p{XDigit}+)#");
    private Map typeQualifiers = this.getTypeQualifiers();
    private Map saveJobs = new HashMap();
    private PFPersistenceAnchor anchor = null;
    private Properties properties = null;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.rse.internal.persistence.PropertyFileProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        $assertionsDisabled = !clazz.desiredAssertionStatus();
    }

    public String[] getSavedProfileNames() {
        String[] locationNames = this.getAnchor().getProfileLocationNames();
        ArrayList<String> names = new ArrayList<String>(locationNames.length);
        int i = 0;
        while (i < locationNames.length) {
            String locationName = locationNames[i];
            String profileName = this.getNodeName(locationName);
            if (this.isValidName(profileName)) {
                names.add(profileName);
            }
            ++i;
        }
        String[] result = new String[names.size()];
        names.toArray(result);
        return result;
    }

    public IStatus deleteProfile(String profileName, IProgressMonitor monitor) {
        String profileLocationName = this.getLocationName("PRF", profileName);
        IStatus result = this.getAnchor().deleteProfileLocation(profileLocationName, monitor);
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveRSEDOM(RSEDOM dom, IProgressMonitor monitor) {
        boolean result = false;
        RSEDOM rSEDOM = dom;
        synchronized (rSEDOM) {
            String profileLocationName = this.getLocationName(dom);
            PFPersistenceLocation profileLocation = this.getAnchor().getProfileLocation(profileLocationName);
            try {
                int n = this.countNodes(dom);
                monitor.beginTask(RSECoreMessages.PropertyFileProvider_SavingTaskName, n);
                this.saveNode(dom, profileLocation, monitor);
                monitor.done();
                dom.markUpdated();
                result = true;
            }
            catch (Exception e) {
                this.logException(e);
            }
        }
        return result;
    }

    public RSEDOM loadRSEDOM(String profileName, IProgressMonitor monitor) {
        RSEDOM dom = null;
        String profileLocationName = this.getLocationName("PRF", profileName);
        PFPersistenceLocation location = this.getAnchor().getProfileLocation(profileLocationName);
        if (location.exists()) {
            int n = this.countLocations(location);
            monitor.beginTask(RSECoreMessages.PropertyFileProvider_LoadingTaskName, n);
            dom = (RSEDOM)this.loadNode(null, location, monitor);
            monitor.done();
        } else {
            String message = String.valueOf(location.getLocator().toString()) + " does not exist.";
            this.getLogger().logError(message, null);
        }
        return dom;
    }

    public Job getSaveJob(RSEDOM dom) {
        Job saveJob = (Job)this.saveJobs.get(dom);
        if (saveJob == null) {
            saveJob = this.anchor.makeSaveJob(dom, this);
            this.saveJobs.put(dom, saveJob);
        }
        return saveJob;
    }

    public void setProperties(Properties properties) {
        Properties defaults = new Properties();
        defaults.setProperty(P_LOCATION, PV_LOCATION_WORKSPACE);
        this.properties = new Properties(defaults);
        Set<Object> keys = properties.keySet();
        Iterator<Object> z = keys.iterator();
        while (z.hasNext()) {
            String key = (String)z.next();
            String value = properties.getProperty(key);
            if (value == null) continue;
            this.properties.put(key, value);
        }
    }

    private boolean isValidName(String profileName) {
        return profileName.trim().length() > 0;
    }

    private PFPersistenceAnchor getAnchor() {
        if (this.anchor == null) {
            String location = this.properties.getProperty(P_LOCATION);
            this.anchor = location.equals(PV_LOCATION_WORKSPACE) ? new PFWorkspaceAnchor() : (location.equals(PV_LOCATION_METADATA) ? new PFMetadataAnchor() : new PFMetadataAnchor());
        }
        return this.anchor;
    }

    private void saveNode(RSEDOMNode node, PFPersistenceLocation location, IProgressMonitor monitor) {
        if (monitor.isCanceled()) {
            return;
        }
        location.ensure();
        Properties properties = this.getProperties(node, false, monitor);
        RSEDOMNode[] childNodes = node.getChildren();
        HashSet<String> childNames = new HashSet<String>();
        int i = 0;
        while (i < childNodes.length) {
            RSEDOMNode childNode = childNodes[i];
            String index = this.getIndexString(i);
            if (!this.isNodeEmbedded(childNode)) {
                String key = this.combine(PFConstants.MT_REFERENCE[0], index);
                String childName = this.getLocationName(childNode);
                PFPersistenceLocation childLocation = location.getChild(childName);
                this.saveNode(childNode, childLocation, monitor);
                properties.put(key, childName);
                childNames.add(childName);
            }
            ++i;
        }
        location.keepChildren(childNames);
        this.writeProperties(properties, "RSE DOM Node", location);
    }

    private String getNodeName(String locationName) {
        String[] parts = this.split(locationName, 2);
        String frozenName = parts[1];
        String result = this.thaw(frozenName);
        return result;
    }

    private String getLocationName(RSEDOMNode node) {
        String type = node.getType();
        type = (String)this.typeQualifiers.get(type);
        String name = node.getName();
        String result = this.getLocationName(type, name);
        return result;
    }

    private String getLocationName(String typeName, String nodeName) {
        String name = this.freeze(nodeName);
        String result = this.combine(typeName, name);
        return result;
    }

    private String freeze(String name) {
        int p = name.indexOf(58);
        if (p >= 0) {
            name = name.substring(p + 1);
        }
        StringBuffer buf = new StringBuffer(name.length());
        char[] chars = name.toCharArray();
        long suffix = 0L;
        int i = 0;
        while (i < chars.length) {
            char c = chars[i];
            suffix *= 2L;
            if (VALID.indexOf(c) >= 0) {
                buf.append(c);
            } else if (UPPER.indexOf(c) >= 0) {
                buf.append(Character.toLowerCase(c));
                ++suffix;
            } else if (c == ' ') {
                buf.append('_');
                ++suffix;
            } else {
                buf.append('#');
                buf.append(Integer.toHexString(c));
                buf.append('#');
            }
            ++i;
        }
        name = String.valueOf(buf.toString()) + "_" + Long.toString(suffix);
        return name;
    }

    private String thaw(String name) {
        String result = name;
        Matcher m = this.suffixPattern.matcher(name);
        if (m.find()) {
            String root = name.substring(0, m.start());
            String suffix = m.group(1);
            long caseCode = Long.parseLong(suffix);
            root = this.thawUnicode(root);
            result = root = this.thawCase(root, caseCode);
        }
        return result;
    }

    private String thawUnicode(String name) {
        Matcher m = this.unicodePattern.matcher(name);
        StringBuffer b = new StringBuffer();
        int p0 = 0;
        while (m.find()) {
            int p1 = m.start();
            String chunk0 = name.substring(p0, p1);
            String digits = m.group(1);
            int codePoint = Integer.valueOf(digits, 16);
            char ch = (char)codePoint;
            String chunk1 = Character.toString(ch);
            b.append(chunk0);
            b.append(chunk1);
            p0 = m.end();
        }
        b.append(name.substring(p0));
        String result = b.toString();
        return result;
    }

    private String thawCase(String name, long caseCode) {
        StringBuffer b = new StringBuffer();
        char[] chars = name.toCharArray();
        int i = chars.length - 1;
        while (i >= 0) {
            boolean shift;
            int ch = chars[i];
            boolean bl = shift = (caseCode & 1L) == 1L;
            if (shift) {
                ch = ch == 95 ? 32 : (int)Character.toUpperCase((char)ch);
            }
            b.append((char)ch);
            caseCode >>= 1;
            --i;
        }
        String result = b.reverse().toString();
        return result;
    }

    private Map getTypeQualifiers() {
        HashMap<String, String> typeQualifiers = new HashMap<String, String>();
        typeQualifiers.put("ConnectorService", "CS");
        typeQualifiers.put("Filter", "F");
        typeQualifiers.put("FilterPool", "FP");
        typeQualifiers.put("FilterPoolReference", "FPR");
        typeQualifiers.put("FilterString", "FS");
        typeQualifiers.put("Host", "H");
        typeQualifiers.put("Profile", "PRF");
        typeQualifiers.put("Property", "P");
        typeQualifiers.put("PropertySet", "PS");
        typeQualifiers.put("ServerLauncher", "SL");
        typeQualifiers.put("SubSystem", "SS");
        return typeQualifiers;
    }

    private void writeProperties(Properties properties, String header, PFPersistenceLocation location) {
        ByteArrayOutputStream outStream = new ByteArrayOutputStream(500);
        PrintWriter out = new PrintWriter(outStream);
        out.println("# " + header);
        TreeMap<Object, Object> map = new TreeMap<Object, Object>(properties);
        Set keys = map.keySet();
        Iterator z = keys.iterator();
        while (z.hasNext()) {
            String key = (String)z.next();
            String value = (String)map.get(key);
            String keyvalue = String.valueOf(key) + "=" + this.escapeValue(value);
            out.println(keyvalue);
        }
        out.close();
        ByteArrayInputStream inStream = new ByteArrayInputStream(outStream.toByteArray());
        location.setContents(inStream);
    }

    private boolean isNodeEmbedded(RSEDOMNode node) {
        HashSet<String> embeddedTypes = new HashSet<String>();
        embeddedTypes.add("Filter");
        embeddedTypes.add("ConnectorService");
        boolean result = embeddedTypes.contains(node.getType());
        return result;
    }

    private String getIndexString(int i) {
        if (!($assertionsDisabled || i >= 0 && i <= 99999)) {
            throw new AssertionError();
        }
        String index = "00000" + Integer.toString(i);
        index = index.substring(index.length() - 5);
        return index;
    }

    private String fixValue(String value) {
        if (value == null) {
            return NULL_VALUE_STRING;
        }
        return value;
    }

    private String escapeValue(String value) {
        StringBuffer buffer = new StringBuffer(value.length() + 20);
        char[] characters = value.toCharArray();
        int i = 0;
        while (i < characters.length) {
            char c = characters[i];
            if (c == '\\') {
                buffer.append("\\\\");
            } else if (c == '\t') {
                buffer.append("\\t");
            } else if (c == '\f') {
                buffer.append("\\f");
            } else if (c == '\n') {
                buffer.append("\\n");
            } else if (c == '\r') {
                buffer.append("\\r");
            } else if (c < ' ' || c > '~') {
                String cString = "0000" + Integer.toHexString(c);
                cString = cString.substring(cString.length() - 4);
                cString = "\\u" + cString;
                buffer.append(cString);
            } else if ("=!#:".indexOf(c) >= 0) {
                buffer.append('\\');
                buffer.append(c);
            } else {
                buffer.append(c);
            }
            ++i;
        }
        return buffer.toString();
    }

    private Properties getProperties(RSEDOMNode node, boolean force, IProgressMonitor monitor) {
        Properties properties = new Properties();
        properties.put(PFConstants.MT_NODE_NAME[0], node.getName());
        properties.put(PFConstants.MT_NODE_TYPE[0], node.getType());
        properties.putAll((Map<?, ?>)this.getAttributes(node));
        RSEDOMNode[] children = node.getChildren();
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            String index = this.getIndexString(i);
            if (force || this.isNodeEmbedded(child)) {
                String prefix = this.combine(PFConstants.MT_CHILD[0], index);
                Properties childProperties = this.getProperties(child, true, monitor);
                Enumeration<Object> e = childProperties.keys();
                while (e.hasMoreElements()) {
                    String key = (String)e.nextElement();
                    String value = childProperties.getProperty(key);
                    String newKey = this.combine(prefix, key);
                    properties.put(newKey, value);
                }
            }
            ++i;
        }
        monitor.worked(1);
        return properties;
    }

    private Properties getAttributes(RSEDOMNode node) {
        Properties properties = new Properties();
        RSEDOMNodeAttribute[] attributes = node.getAttributes();
        int i = 0;
        while (i < attributes.length) {
            RSEDOMNodeAttribute attribute = attributes[i];
            String attributeName = attribute.getKey();
            String propertyKey = this.combine(PFConstants.MT_ATTRIBUTE[0], attributeName);
            properties.put(propertyKey, this.fixValue(attribute.getValue()));
            String attributeType = attribute.getType();
            if (attributeType != null) {
                propertyKey = this.combine(PFConstants.MT_ATTRIBUTE_TYPE[0], attributeName);
                properties.put(propertyKey, attributeType);
            }
            ++i;
        }
        return properties;
    }

    private int countNodes(RSEDOMNode node) {
        RSEDOMNode[] children = node.getChildren();
        int result = 1;
        int i = 0;
        while (i < children.length) {
            RSEDOMNode child = children[i];
            result += this.countNodes(child);
            ++i;
        }
        return result;
    }

    private int countLocations(PFPersistenceLocation location) {
        int result = 0;
        if (location.hasContents()) {
            ++result;
        }
        PFPersistenceLocation[] children = location.getChildren();
        int i = 0;
        while (i < children.length) {
            PFPersistenceLocation child = children[i];
            result += this.countLocations(child);
            ++i;
        }
        return result;
    }

    private RSEDOMNode loadNode(RSEDOMNode parent, PFPersistenceLocation nodeLocation, IProgressMonitor monitor) {
        RSEDOMNode node = null;
        if (!monitor.isCanceled()) {
            Properties properties = this.loadProperties(nodeLocation);
            if (properties != null) {
                node = this.makeNode(parent, nodeLocation, properties, monitor);
            }
            monitor.worked(1);
        }
        return node;
    }

    private Properties loadProperties(PFPersistenceLocation location) {
        Properties properties = null;
        if (location.hasContents()) {
            properties = new Properties();
            InputStream inStream = location.getContents();
            try {
                properties.load(inStream);
                inStream.close();
            }
            catch (IOException e) {
                this.logException(e);
            }
        }
        return properties;
    }

    private RSEDOMNode makeNode(RSEDOMNode parent, PFPersistenceLocation location, Properties properties, IProgressMonitor monitor) {
        String nodeType = this.getProperty(properties, PFConstants.MT_NODE_TYPE);
        String nodeName = this.getProperty(properties, PFConstants.MT_NODE_NAME);
        RSEDOMNode node = parent == null ? new RSEDOM(nodeName) : new RSEDOMNode(parent, nodeType, nodeName);
        node.setRestoring(true);
        Set<Object> keys = properties.keySet();
        HashMap<String, String> attributes = new HashMap<String, String>();
        HashMap<String, String> attributeTypes = new HashMap<String, String>();
        HashMap childPropertiesMap = new HashMap();
        TreeSet<String> childNames = new TreeSet<String>();
        TreeSet<String> referenceKeys = new TreeSet<String>();
        Iterator<Object> z = keys.iterator();
        while (z.hasNext()) {
            String value;
            String key = (String)z.next();
            String[] words = this.split(key, 2);
            String metatype = words[0];
            if (this.find(metatype, PFConstants.MT_ATTRIBUTE)) {
                value = properties.getProperty(key);
                attributes.put(words[1], value);
                continue;
            }
            if (this.find(metatype, PFConstants.MT_ATTRIBUTE_TYPE)) {
                String type = properties.getProperty(key);
                attributeTypes.put(words[1], type);
                continue;
            }
            if (this.find(metatype, PFConstants.MT_REFERENCE)) {
                referenceKeys.add(key);
                continue;
            }
            if (!this.find(metatype, PFConstants.MT_CHILD)) continue;
            value = properties.getProperty(key);
            words = this.split(words[1], 2);
            String childName = words[0];
            childNames.add(childName);
            String newKey = words[1];
            Properties p = this.getProperties(childPropertiesMap, childName);
            p.put(newKey, value);
        }
        Set attributeNames = attributes.keySet();
        Iterator<Object> z2 = attributeNames.iterator();
        while (z2.hasNext()) {
            String attributeName = (String)z2.next();
            String attributeValue = (String)attributes.get(attributeName);
            if (attributeValue.equals(NULL_VALUE_STRING)) {
                attributeValue = null;
            }
            String attributeType = (String)attributeTypes.get(attributeName);
            node.addAttribute(attributeName, attributeValue, attributeType);
        }
        z2 = childNames.iterator();
        while (z2.hasNext()) {
            String childName = (String)z2.next();
            Properties p = this.getProperties(childPropertiesMap, childName);
            this.makeNode(node, location, p, monitor);
        }
        z2 = referenceKeys.iterator();
        while (z2.hasNext()) {
            String key = (String)z2.next();
            String childLocationName = properties.getProperty(key);
            PFPersistenceLocation childLocation = location.getChild(childLocationName);
            this.loadNode(node, childLocation, monitor);
        }
        node.setRestoring(false);
        return node;
    }

    private String getProperty(Properties properties, String[] keys) {
        String result = null;
        int i = 0;
        while (i < keys.length && result == null) {
            String key = keys[i];
            result = properties.getProperty(key);
            ++i;
        }
        return result;
    }

    private boolean find(String needle, String[] haystack) {
        int i = 0;
        while (i < haystack.length) {
            String value = haystack[i];
            if (value.equals(needle)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Properties getProperties(Map propertiesMap, String selector) {
        Properties p = (Properties)propertiesMap.get(selector);
        if (p == null) {
            p = new Properties();
            propertiesMap.put(selector, p);
        }
        return p;
    }

    private String combine(String typeName, String nodeName) {
        return this.combine(new String[]{typeName, nodeName});
    }

    private String combine(String[] names) {
        StringBuffer buf = new StringBuffer(100);
        int i = 0;
        while (i < names.length) {
            String name = names[i];
            if (i > 0) {
                buf.append('.');
            }
            buf.append(name);
            ++i;
        }
        return buf.toString();
    }

    private String[] split(String longName, int limit) {
        return this.period.split(longName, limit);
    }

    private Logger getLogger() {
        Logger logger = RSECorePlugin.getDefault().getLogger();
        return logger;
    }

    private void logException(Exception e) {
        this.getLogger().logError("unexpected exception", e);
    }
}

