/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.persistence;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.ArrayList;
import java.util.Set;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.internal.persistence.PFPersistenceLocation;

class PFMetadataLocation
implements PFPersistenceLocation {
    private File _baseFolder;

    public PFMetadataLocation(File baseFolder) {
        this._baseFolder = baseFolder;
    }

    public void ensure() {
        if (!this.exists()) {
            this._baseFolder.mkdirs();
        }
    }

    public boolean exists() {
        return this._baseFolder.exists();
    }

    public PFPersistenceLocation getChild(String childName) {
        File childFolder = new File(this._baseFolder, childName);
        return new PFMetadataLocation(childFolder);
    }

    public PFPersistenceLocation[] getChildren() {
        File[] members = this._baseFolder.listFiles();
        if (members == null) {
            members = new File[]{};
        }
        ArrayList<PFMetadataLocation> children = new ArrayList<PFMetadataLocation>(members.length);
        int i = 0;
        while (i < members.length) {
            File member = members[i];
            if (member.isDirectory()) {
                PFMetadataLocation child = new PFMetadataLocation(member);
                children.add(child);
            }
            ++i;
        }
        PFPersistenceLocation[] result = new PFPersistenceLocation[children.size()];
        children.toArray(result);
        return result;
    }

    public InputStream getContents() {
        FileInputStream stream = null;
        File contentsFile = this.getContentsFile();
        try {
            stream = new FileInputStream(contentsFile);
        }
        catch (FileNotFoundException e) {
            this.logException(e);
        }
        return stream;
    }

    public URI getLocator() {
        return this._baseFolder.toURI();
    }

    public String getName() {
        return this._baseFolder.getName();
    }

    public boolean hasContents() {
        return this.getContentsFile().exists();
    }

    public void keepChildren(Set keepSet) {
        File[] children = this._baseFolder.listFiles();
        if (children == null) {
            children = new File[]{};
        }
        int i = 0;
        while (i < children.length) {
            File child = children[i];
            if (!keepSet.contains(child.getName())) {
                this.deleteFile(child);
            }
            ++i;
        }
    }

    public void setContents(InputStream stream) {
        this.ensure();
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(this.getContentsFile());
            byte[] buffer = new byte[1000];
            int n = stream.read(buffer);
            while (n > 0) {
                ((OutputStream)out).write(buffer, 0, n);
                n = stream.read(buffer);
            }
        }
        catch (FileNotFoundException e) {
            this.logException(e);
        }
        catch (IOException e) {
            this.logException(e);
        }
        if (out != null) {
            try {
                ((OutputStream)out).close();
            }
            catch (IOException e) {
                this.logException(e);
            }
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            this.logException(e);
        }
    }

    private void deleteFile(File file) {
        if (file.exists()) {
            if (file.isDirectory()) {
                File[] children = file.listFiles();
                int i = 0;
                while (i < children.length) {
                    File child = children[i];
                    this.deleteFile(child);
                    ++i;
                }
            }
            file.delete();
        }
    }

    private File getContentsFile() {
        File contentsFile = new File(this._baseFolder, "node.properties");
        return contentsFile;
    }

    private void logException(Exception e) {
        RSECorePlugin.getDefault().getLogger().logError("unexpected exception", e);
    }
}

