/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.files.ftp;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPClientConfig;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.commons.net.ftp.parser.FTPFileEntryParserFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.rse.core.model.IPropertySet;
import org.eclipse.rse.internal.services.files.ftp.FTPHostFile;
import org.eclipse.rse.internal.services.files.ftp.FTPServiceResources;
import org.eclipse.rse.internal.services.files.ftp.IFTPService;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigFactory;
import org.eclipse.rse.internal.services.files.ftp.parser.IFTPClientConfigProxy;
import org.eclipse.rse.services.Mutex;
import org.eclipse.rse.services.clientserver.FileTypeMatcher;
import org.eclipse.rse.services.clientserver.NamePatternMatcher;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.clientserver.messages.IndicatorException;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.AbstractFileService;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.files.IHostFile;
import org.eclipse.rse.services.files.RemoteFileCancelledException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.services.files.RemoteFolderNotEmptyException;

public class FTPService
extends AbstractFileService
implements IFileService,
IFTPService {
    private FTPClient _ftpClient;
    private FTPFile[] _ftpFiles;
    private Mutex _commandMutex = new Mutex();
    private String _userHome;
    private transient String _hostName;
    private transient String _userId;
    private transient String _password;
    private transient int _portNumber;
    private transient String _controlEncoding;
    private OutputStream _ftpLoggingOutputStream;
    private IPropertySet _ftpPropertySet;
    private Exception _exception;
    private boolean _isBinaryFileType = true;
    private boolean _isPassiveDataConnectionMode = false;
    private IFTPClientConfigFactory _entryParserFactory;
    private IFTPClientConfigProxy _clientConfigProxy;
    private String _fCachePreviousParent;
    private long _fCachePreviousTimestamp;
    private Map _fCachePreviousFiles = new HashMap();
    private static long FTP_STATCACHE_TIMEOUT = 200L;

    public void setPropertySet(IPropertySet ftpPropertySet) {
        this._ftpPropertySet = ftpPropertySet;
    }

    public String getName() {
        return FTPServiceResources.FTP_File_Service_Name;
    }

    public String getDescription() {
        return FTPServiceResources.FTP_File_Service_Description;
    }

    public void setHostName(String hostname) {
        this._hostName = hostname;
    }

    public void setPortNumber(int portNumber) {
        this._portNumber = portNumber;
    }

    public void setUserId(String userId) {
        this._userId = userId;
    }

    public void setPassword(String password) {
        this._password = password;
    }

    public void setLoggingStream(OutputStream ftpLoggingOutputStream) {
        this._ftpLoggingOutputStream = ftpLoggingOutputStream;
    }

    public void setFTPClientConfigFactory(IFTPClientConfigFactory entryParserFactory) {
        this._entryParserFactory = entryParserFactory;
    }

    public void setControlEncoding(String encoding) {
        this._controlEncoding = encoding;
    }

    protected String checkEncoding(String s) throws SystemMessageException {
        String encoding = this._controlEncoding != null ? this._controlEncoding : this.getFTPClient().getControlEncoding();
        try {
            byte[] bytes = s.getBytes(encoding);
            String decoded = new String(bytes, encoding);
            if (!s.equals(decoded)) {
                int i = 0;
                int lmax = Math.min(s.length(), decoded.length());
                while (i < lmax && s.charAt(i) == decoded.charAt(i)) {
                    ++i;
                }
                char sbad = s.charAt(i);
                String msg = "Cannot express character '" + sbad + "'(0x" + Integer.toHexString(sbad) + ") with " + "encoding \"" + encoding + "\". ";
                msg = String.valueOf(msg) + "Please specify a different encoding in host properties.";
                throw new UnsupportedEncodingException(msg);
            }
            return s;
        }
        catch (UnsupportedEncodingException e) {
            try {
                SystemMessage msg = new SystemMessage("RSE", "F", "9999", 'E', e.getMessage(), "");
                throw new SystemMessageException(msg);
            }
            catch (IndicatorException indicatorException) {
                throw new RemoteFileIOException((Exception)e);
            }
        }
    }

    public void connect() throws RemoteFileSecurityException, IOException {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
            if (this._controlEncoding != null) {
                this._ftpClient.setControlEncoding(this._controlEncoding);
            }
        }
        if (this._ftpLoggingOutputStream != null) {
            this._ftpClient.registerSpyStream(this._ftpLoggingOutputStream);
        }
        if (this._portNumber == 0) {
            this._ftpClient.connect(this._hostName);
        } else {
            this._ftpClient.connect(this._hostName, this._portNumber);
        }
        int userReply = this._ftpClient.user(this._userId);
        if (FTPReply.isPositiveIntermediate((int)userReply)) {
            String newLine = System.getProperty("line.separator");
            this._ftpClient.registerSpyStream(null);
            this._ftpLoggingOutputStream.write(("PASS ******" + newLine).getBytes());
            int passReply = this._ftpClient.pass(this._password);
            this._ftpLoggingOutputStream.write((String.valueOf(this._ftpClient.getReplyString()) + newLine).getBytes());
            if (this._ftpLoggingOutputStream != null) {
                this._ftpClient.registerSpyStream(this._ftpLoggingOutputStream);
            }
            if (!FTPReply.isPositiveCompletion((int)passReply)) {
                String lastMessage = this._ftpClient.getReplyString();
                this.disconnect();
                throw new RemoteFileSecurityException(new Exception(lastMessage));
            }
        } else if (!FTPReply.isPositiveCompletion((int)userReply)) {
            String lastMessage = this._ftpClient.getReplyString();
            this.disconnect();
            throw new RemoteFileSecurityException(new Exception(lastMessage));
        }
        String systemName = this._ftpClient.getSystemName();
        this._ftpClient.setParserFactory((FTPFileEntryParserFactory)this._entryParserFactory);
        this._clientConfigProxy = this._entryParserFactory.getFTPClientConfig(this._ftpPropertySet.getPropertyValue("parser"), systemName);
        if (this._clientConfigProxy != null) {
            this._ftpClient.configure(this._clientConfigProxy.getFTPClientConfig());
        } else {
            this._ftpClient.configure(new FTPClientConfig("UNIX"));
        }
        if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("true")) {
            this._ftpClient.enterLocalPassiveMode();
            this._isPassiveDataConnectionMode = true;
        } else {
            this._ftpClient.enterLocalActiveMode();
            this._isPassiveDataConnectionMode = false;
        }
        this._ftpClient.setFileType(2);
        this._isBinaryFileType = true;
        this._userHome = this._ftpClient.printWorkingDirectory();
        if (this._userHome.indexOf(58) != -1 && this._userHome.indexOf(93) != -1) {
            this._userHome = this._userHome.replaceAll(":\\[", "/");
            this._userHome = String.valueOf('/') + this._userHome.substring(0, this._userHome.lastIndexOf(93));
        }
        this.clearCache(null);
    }

    public void disconnect() {
        this.clearCache(null);
        try {
            try {
                this.getFTPClient().logout();
                this._ftpClient = null;
            }
            catch (IOException iOException) {
                this._ftpClient = null;
            }
        }
        finally {
            this._ftpClient = null;
        }
    }

    public FTPClient getFTPClient() {
        if (this._ftpClient == null) {
            this._ftpClient = new FTPClient();
            if (this._controlEncoding != null) {
                this._ftpClient.setControlEncoding(this._controlEncoding);
            }
        }
        if (this._hostName != null) {
            try {
                this._ftpClient.sendNoOp();
            }
            catch (IOException iOException) {
                try {
                    this.connect();
                }
                catch (Exception exception) {}
            }
        }
        this.setDataConnectionMode();
        return this._ftpClient;
    }

    private FTPClient cloneFTPClient(boolean isBinary) throws IOException {
        FTPClient ftpClient = new FTPClient();
        boolean ok = false;
        try {
            ftpClient.setControlEncoding(this._ftpClient.getControlEncoding());
            ftpClient.connect(this._ftpClient.getRemoteAddress());
            ftpClient.login(this._userId, this._password);
            if (this._clientConfigProxy != null) {
                ftpClient.configure(this._clientConfigProxy.getFTPClientConfig());
            } else {
                ftpClient.configure(new FTPClientConfig("UNIX"));
            }
            if (this._isPassiveDataConnectionMode) {
                ftpClient.enterLocalPassiveMode();
            }
            if (isBinary) {
                ftpClient.setFileType(2);
            } else {
                ftpClient.setFileType(0);
            }
            ftpClient.registerSpyStream(this._ftpLoggingOutputStream);
            ok = true;
        }
        catch (Throwable throwable) {
            if (!ok) {
                try {
                    ftpClient.disconnect();
                }
                catch (Throwable throwable2) {}
            }
            throw throwable;
        }
        if (!ok) {
            try {
                ftpClient.disconnect();
            }
            catch (Throwable throwable) {}
        }
        return ftpClient;
    }

    public IHostFile getFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        return this.getFileInternal(remoteParent, fileName, monitor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected FTPHostFile getFileInternal(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        Object result;
        remoteParent = this.checkEncoding(remoteParent);
        fileName = this.checkEncoding(fileName);
        if (monitor != null && monitor.isCanceled()) {
            throw new RemoteFileCancelledException();
        }
        Map map = this._fCachePreviousFiles;
        synchronized (map) {
            long diff;
            if ((this._fCachePreviousParent == null ? remoteParent == null : this._fCachePreviousParent.equals(remoteParent)) && (result = this._fCachePreviousFiles.get(fileName)) != null && (diff = System.currentTimeMillis() - this._fCachePreviousTimestamp) < FTP_STATCACHE_TIMEOUT) {
                return (FTPHostFile)result;
            }
        }
        FTPHostFile file = null;
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                this._ftpClient = this.getFTPClient();
                if (!this._ftpClient.changeWorkingDirectory(remoteParent)) {
                    throw new RemoteFileIOException(new Exception(this._ftpClient.getReplyString()));
                }
                if (!this.listFiles(monitor)) {
                    throw new RemoteFileCancelledException();
                }
                result = this._fCachePreviousFiles;
                synchronized (result) {
                    block22: {
                        this.cacheFiles(remoteParent);
                        Object o = this._fCachePreviousFiles.get(fileName);
                        if (o == null) break block22;
                        FTPHostFile fTPHostFile = (FTPHostFile)o;
                        return fTPHostFile;
                    }
                    try {
                        if (!this.isCaseSensitive()) {
                            int i = 0;
                            while (i < this._ftpFiles.length) {
                                String tempName = this._ftpFiles[i].getName();
                                if (tempName.equalsIgnoreCase(fileName)) {
                                    file = (FTPHostFile)this._fCachePreviousFiles.get(tempName);
                                    break;
                                }
                                ++i;
                            }
                        }
                        // MONITOREXIT @DISABLED, blocks:[1, 4, 5, 21, 7] lbl44 : MonitorExitStatement: MONITOREXIT : result /* !! */ 
                        if (file == null) {
                            file = new FTPHostFile(remoteParent, fileName, false, false, 0L, 0L, false);
                        }
                    }
                    catch (Exception e) {
                        throw new RemoteFileIOException(e);
                    }
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return file;
    }

    public boolean isConnected() {
        boolean isConnected = false;
        if (this._ftpClient != null) {
            isConnected = this._ftpClient.isConnected();
        }
        return isConnected;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected IHostFile[] internalFetch(String parentPath, String fileFilter, int fileType, IProgressMonitor monitor) throws SystemMessageException {
        parentPath = this.checkEncoding(parentPath);
        if (monitor != null && monitor.isCanceled()) {
            throw new RemoteFileCancelledException();
        }
        ArrayList<FTPHostFile> results = new ArrayList<FTPHostFile>();
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    if (fileFilter == null) {
                        fileFilter = "*";
                    }
                    NamePatternMatcher filematcher = null;
                    if (fileFilter.endsWith(",")) {
                        String[] types = fileFilter.split(",");
                        filematcher = new FileTypeMatcher(types, true);
                    } else {
                        filematcher = new NamePatternMatcher(fileFilter, true, true);
                    }
                    this._ftpClient = this.getFTPClient();
                    if (!this._ftpClient.changeWorkingDirectory(parentPath)) {
                        throw new RemoteFileIOException(new Exception(this._ftpClient.getReplyString()));
                    }
                    if (!this.listFiles(monitor)) {
                        throw new RemoteFileCancelledException();
                    }
                    Map map = this._fCachePreviousFiles;
                    synchronized (map) {
                        this.cacheFiles(parentPath);
                        int i = 0;
                        while (i < this._ftpFiles.length) {
                            if (this._ftpFiles[i] != null) {
                                String rawListLine = String.valueOf(this._ftpFiles[i].getRawListing()) + System.getProperty("line.separator");
                                this._ftpLoggingOutputStream.write(rawListLine.getBytes());
                                String name = this._ftpFiles[i].getName();
                                FTPHostFile f = (FTPHostFile)this._fCachePreviousFiles.get(name);
                                if (this.isRightType(fileType, f) && !name.equals(".") && !name.equals("..")) {
                                    if (f.isDirectory() && fileType != 2) {
                                        results.add(f);
                                    } else if (filematcher.matches(name)) {
                                        results.add(f);
                                    }
                                }
                            }
                            ++i;
                        }
                    }
                    this._ftpLoggingOutputStream.write(System.getProperty("line.separator").getBytes());
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return results.toArray(new IHostFile[results.size()]);
    }

    private char getSeparator() {
        return PathUtility.getSeparator((String)this._userHome).charAt(0);
    }

    public boolean upload(File localFile, String remoteParent, String remoteFile, boolean isBinary, String srcEncoding, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        boolean retValue;
        block23: {
            retValue = true;
            remoteParent = this.checkEncoding(remoteParent);
            remoteFile = this.checkEncoding(remoteFile);
            if (monitor != null) {
                if (monitor.isCanceled()) {
                    throw new RemoteFileCancelledException();
                }
            } else {
                monitor = new NullProgressMonitor();
            }
            MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
            progressMonitor.init(0, localFile.getName(), remoteFile, localFile.length());
            FileInputStream input = null;
            OutputStream output = null;
            try {
                try {
                    if (!this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) break block23;
                    try {
                        FTPClient ftpClient = this.getFTPClient();
                        this.clearCache(remoteParent);
                        ftpClient.changeWorkingDirectory(remoteParent);
                        this.setFileType(isBinary);
                        input = new FileInputStream(localFile);
                        output = ftpClient.storeFileStream(remoteFile);
                        if (output != null) {
                            int readCount;
                            long bytes = 0L;
                            byte[] buffer = new byte[4096];
                            while ((readCount = input.read(buffer)) > 0) {
                                bytes += (long)readCount;
                                output.write(buffer, 0, readCount);
                                progressMonitor.count(readCount);
                                if (monitor == null || !monitor.isCanceled()) continue;
                                retValue = false;
                                break;
                            }
                            if (retValue) {
                                output.flush();
                            }
                        } else {
                            throw new Exception(ftpClient.getReplyString());
                        }
                        output.close();
                        output = null;
                        ftpClient.completePendingCommand();
                        if (!retValue) {
                            ftpClient.deleteFile(remoteFile);
                        }
                    }
                    finally {
                        this._commandMutex.release();
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        finally {
                            if (output != null) {
                                output.close();
                            }
                        }
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                progressMonitor.end();
            }
        }
        return retValue;
    }

    public boolean upload(InputStream stream, String remoteParent, String remoteFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        boolean retValue = true;
        remoteParent = this.checkEncoding(remoteParent);
        remoteFile = this.checkEncoding(remoteFile);
        try {
            int readCount;
            BufferedInputStream bis = new BufferedInputStream(stream);
            File tempFile = File.createTempFile("ftpup", "temp");
            FileOutputStream os = new FileOutputStream(tempFile);
            BufferedOutputStream bos = new BufferedOutputStream(os);
            byte[] buffer = new byte[4096];
            while ((readCount = bis.read(buffer)) > 0) {
                bos.write(buffer, 0, readCount);
                if (monitor == null || !monitor.isCanceled()) continue;
                retValue = false;
                break;
            }
            bos.close();
            if (retValue) {
                retValue = this.upload(tempFile, remoteParent, remoteFile, isBinary, "", hostEncoding, monitor);
            }
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return retValue;
    }

    public boolean download(String remoteParent, String remoteFile, File localFile, boolean isBinary, String hostEncoding, IProgressMonitor monitor) throws SystemMessageException {
        boolean retValue;
        block22: {
            retValue = true;
            if (monitor != null && monitor.isCanceled()) {
                throw new RemoteFileCancelledException();
            }
            IHostFile remoteHostFile = this.getFile(remoteParent, remoteFile, monitor);
            MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
            progressMonitor.init(0, remoteFile, localFile.getName(), remoteHostFile.getSize());
            OutputStream output = null;
            InputStream input = null;
            try {
                try {
                    if (!this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) break block22;
                    try {
                        FTPClient ftpClient = this.getFTPClient();
                        ftpClient.changeWorkingDirectory(remoteParent);
                        this.setFileType(isBinary);
                        input = ftpClient.retrieveFileStream(remoteFile);
                        if (input != null) {
                            int readCount;
                            if (!localFile.exists()) {
                                File localParentFile = localFile.getParentFile();
                                if (!localParentFile.exists()) {
                                    localParentFile.mkdirs();
                                }
                                localFile.createNewFile();
                            }
                            output = new FileOutputStream(localFile);
                            byte[] buffer = new byte[4096];
                            while ((readCount = input.read(buffer)) > 0) {
                                output.write(buffer, 0, readCount);
                                progressMonitor.count(readCount);
                                if (monitor == null || !monitor.isCanceled()) continue;
                                retValue = false;
                                break;
                            }
                            if (retValue) {
                                output.flush();
                            }
                            input.close();
                            input = null;
                            ftpClient.completePendingCommand();
                            break block22;
                        }
                        throw new RemoteFileIOException(new Exception(ftpClient.getReplyString()));
                    }
                    finally {
                        this._commandMutex.release();
                        try {
                            if (input != null) {
                                input.close();
                            }
                        }
                        finally {
                            if (output != null) {
                                output.close();
                            }
                        }
                    }
                }
                catch (FileNotFoundException e) {
                    throw new RemoteFileIOException((Exception)e);
                }
                catch (IOException e) {
                    throw new RemoteFileIOException((Exception)e);
                }
            }
            finally {
                progressMonitor.end();
            }
        }
        return retValue;
    }

    public IHostFile getUserHome() {
        if (this._userHome == null) {
            return null;
        }
        return new FTPHostFile("", this._userHome, true, true, 0L, 0L, true);
    }

    public IHostFile[] getRoots(IProgressMonitor monitor) {
        IHostFile[] hostFile = this._userHome.startsWith("/") ? new IHostFile[]{new FTPHostFile(null, "/", true, true, 0L, 0L, true)} : new IHostFile[]{new FTPHostFile(null, this._userHome, true, true, 0L, 0L, true)};
        return hostFile;
    }

    public boolean delete(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        boolean hasSucceeded = false;
        remoteParent = this.checkEncoding(remoteParent);
        fileName = this.checkEncoding(fileName);
        MyProgressMonitor progressMonitor = new MyProgressMonitor(monitor);
        progressMonitor.init(String.valueOf(FTPServiceResources.FTP_File_Service_Deleting_Task) + fileName, 1);
        IHostFile file = this.getFile(remoteParent, fileName, monitor);
        boolean isFile = file.isFile();
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    this.clearCache(remoteParent);
                    hasSucceeded = FTPReply.isPositiveCompletion((int)ftpClient.cwd(remoteParent));
                    if (hasSucceeded) {
                        hasSucceeded = isFile ? ftpClient.deleteFile(fileName) : ftpClient.removeDirectory(fileName);
                    }
                    if (!hasSucceeded) {
                        throw new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + fileName + ")");
                    }
                    progressMonitor.worked(1);
                }
                catch (Exception e) {
                    if (isFile) {
                        throw new RemoteFileIOException(e);
                    }
                    throw new RemoteFolderNotEmptyException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        progressMonitor.end();
        return hasSucceeded;
    }

    public boolean rename(String remoteParent, String oldName, String newName, IProgressMonitor monitor) throws SystemMessageException {
        boolean success = false;
        remoteParent = this.checkEncoding(remoteParent);
        oldName = this.checkEncoding(oldName);
        newName = this.checkEncoding(newName);
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    this.clearCache(remoteParent);
                    if (!ftpClient.changeWorkingDirectory(remoteParent)) {
                        throw new RemoteFileIOException(new Exception(ftpClient.getReplyString()));
                    }
                    success = ftpClient.rename(oldName, newName);
                    if (!success) {
                        throw new Exception(ftpClient.getReplyString());
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return success;
    }

    public boolean rename(String remoteParent, String oldName, String newName, IHostFile oldFile, IProgressMonitor monitor) {
        boolean hasSucceeded = false;
        oldFile.renameTo(newName);
        return hasSucceeded;
    }

    public boolean move(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        boolean success = false;
        srcParent = this.checkEncoding(srcParent);
        srcName = this.checkEncoding(srcName);
        tgtParent = this.checkEncoding(tgtParent);
        tgtName = this.checkEncoding(tgtName);
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    String source = this.concat(srcParent, srcName);
                    String target = this.concat(tgtParent, tgtName);
                    this.clearCache(srcParent);
                    this.clearCache(tgtParent);
                    success = ftpClient.rename(source, target);
                    if (!success) {
                        throw new Exception(ftpClient.getReplyString());
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileIOException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return success;
    }

    public IHostFile createFolder(String remoteParent, String folderName, IProgressMonitor monitor) throws SystemMessageException {
        remoteParent = this.checkEncoding(remoteParent);
        folderName = this.checkEncoding(folderName);
        if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    FTPClient ftpClient = this.getFTPClient();
                    this.clearCache(remoteParent);
                    if (!ftpClient.changeWorkingDirectory(remoteParent)) {
                        throw new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + remoteParent + ")");
                    }
                    if (!ftpClient.makeDirectory(folderName)) {
                        throw new RemoteFileIOException(new Exception(String.valueOf(ftpClient.getReplyString()) + " (" + folderName + ")"));
                    }
                }
                catch (Exception e) {
                    throw new RemoteFileSecurityException(e);
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return this.getFile(remoteParent, folderName, monitor);
    }

    public IHostFile createFile(String remoteParent, String fileName, IProgressMonitor monitor) throws SystemMessageException {
        remoteParent = this.checkEncoding(remoteParent);
        fileName = this.checkEncoding(fileName);
        try {
            File tempFile = File.createTempFile("ftp", "temp");
            tempFile.deleteOnExit();
            boolean success = this.upload(tempFile, remoteParent, fileName, this._isBinaryFileType, null, null, monitor);
            if (!success) {
                throw new RemoteFileIOException(new Exception(this.getFTPClient().getReplyString()));
            }
        }
        catch (Exception e) {
            throw new RemoteFileSecurityException(e);
        }
        return this.getFile(remoteParent, fileName, monitor);
    }

    public boolean copy(String srcParent, String srcName, String tgtParent, String tgtName, IProgressMonitor monitor) throws SystemMessageException {
        throw new RemoteFileIOException(new Exception(FTPServiceResources.FTP_File_Service_Copy_Not_Supported));
    }

    public boolean copyBatch(String[] srcParents, String[] srcNames, String tgtParent, IProgressMonitor monitor) throws SystemMessageException {
        boolean hasSucceeded = false;
        int i = 0;
        while (i < srcNames.length) {
            hasSucceeded = this.copy(srcParents[i], srcNames[i], tgtParent, srcNames[i], monitor);
            if (!hasSucceeded) break;
            ++i;
        }
        return hasSucceeded;
    }

    public void initService(IProgressMonitor monitor) {
    }

    public void uninitService(IProgressMonitor monitor) {
    }

    public boolean isCaseSensitive() {
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private boolean listFiles(IProgressMonitor monitor) throws Exception {
        boolean result = true;
        this._exception = null;
        Thread listThread = new Thread(new Runnable(){

            public void run() {
                try {
                    FTPService.this._ftpFiles = null;
                    if (FTPService.this._clientConfigProxy != null) {
                        FTPService.this._ftpFiles = FTPService.this._ftpClient.listFiles(FTPService.this._clientConfigProxy.getListCommandModifiers());
                    } else {
                        FTPService.this._ftpFiles = FTPService.this._ftpClient.listFiles();
                    }
                }
                catch (IOException e) {
                    FTPService.this._exception = e;
                }
            }
        });
        if (monitor == null) {
            listThread.start();
            listThread.join();
            if (this._exception == null) return result;
            throw new RemoteFileIOException(this._exception);
        }
        if (monitor.isCanceled()) return false;
        listThread.start();
        while (!monitor.isCanceled() && listThread.isAlive()) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (!monitor.isCanceled()) return result;
        if (!listThread.isAlive()) return result;
        Thread killThread = listThread;
        listThread = null;
        killThread.interrupt();
        this._ftpClient.completePendingCommand();
        throw new RemoteFileIOException(this._exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheFiles(String parentPath) {
        Map map = this._fCachePreviousFiles;
        synchronized (map) {
            this._fCachePreviousFiles.clear();
            this._fCachePreviousTimestamp = System.currentTimeMillis();
            this._fCachePreviousParent = parentPath;
            int i = 0;
            while (i < this._ftpFiles.length) {
                if (this._ftpFiles[i] != null) {
                    FTPHostFile f = new FTPHostFile(parentPath, this._ftpFiles[i]);
                    String name = f.getName();
                    if (f.isLink() && name.indexOf(46) < 0) {
                        f.setIsDirectory(true);
                    }
                    this._fCachePreviousFiles.put(name, f);
                }
                ++i;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clearCache(String parentPath) {
        Map map = this._fCachePreviousFiles;
        synchronized (map) {
            if (parentPath == null || parentPath.equals(this._fCachePreviousParent)) {
                this._fCachePreviousFiles.clear();
            }
        }
    }

    public boolean setLastModified(String parent, String name, long timestamp, IProgressMonitor monitor) throws SystemMessageException {
        return false;
    }

    public boolean setReadOnly(String parent, String name, boolean readOnly, IProgressMonitor monitor) throws SystemMessageException {
        boolean result = false;
        FTPHostFile file = this.getFileInternal(parent, name, monitor);
        int userPermissions = file.getUserPermissions();
        int groupPermissions = file.getGroupPermissions();
        int otherPermissions = file.getOtherPermissions();
        int oldPermissions = userPermissions * 100 + groupPermissions * 10 + otherPermissions;
        if (readOnly) {
            userPermissions &= 5;
            groupPermissions &= 5;
            otherPermissions &= 5;
        } else {
            userPermissions |= 2;
        }
        int newPermissions = userPermissions * 100 + groupPermissions * 10 + otherPermissions;
        if (newPermissions == oldPermissions) {
            result = true;
        } else if (this._commandMutex.waitForLock(monitor, Long.MAX_VALUE)) {
            try {
                try {
                    this.clearCache(parent);
                    result = this._ftpClient.sendSiteCommand("CHMOD " + newPermissions + " " + file.getAbsolutePath());
                }
                catch (IOException iOException) {
                    result = false;
                    this._commandMutex.release();
                }
            }
            finally {
                this._commandMutex.release();
            }
        }
        return result;
    }

    public InputStream getInputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        if (monitor != null && monitor.isCanceled()) {
            throw new RemoteFileCancelledException();
        }
        FTPBufferedInputStream stream = null;
        try {
            FTPClient ftpClient = this.cloneFTPClient(isBinary);
            ftpClient.changeWorkingDirectory(remoteParent);
            stream = new FTPBufferedInputStream(ftpClient.retrieveFileStream(remoteFile), ftpClient);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return stream;
    }

    public OutputStream getOutputStream(String remoteParent, String remoteFile, boolean isBinary, IProgressMonitor monitor) throws SystemMessageException {
        remoteParent = this.checkEncoding(remoteParent);
        remoteFile = this.checkEncoding(remoteFile);
        if (monitor != null && monitor.isCanceled()) {
            throw new RemoteFileCancelledException();
        }
        FTPBufferedOutputStream stream = null;
        try {
            FTPClient ftpClient = this.cloneFTPClient(isBinary);
            this.clearCache(remoteParent);
            ftpClient.changeWorkingDirectory(remoteParent);
            stream = new FTPBufferedOutputStream(ftpClient.storeFileStream(remoteFile), ftpClient);
        }
        catch (Exception e) {
            throw new RemoteFileIOException(e);
        }
        return stream;
    }

    private void setDataConnectionMode() {
        if (this._ftpPropertySet != null) {
            if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("true") && !this._isPassiveDataConnectionMode) {
                this._ftpClient.enterLocalPassiveMode();
                this._isPassiveDataConnectionMode = true;
            } else if (this._ftpPropertySet.getPropertyValue("passive").equalsIgnoreCase("false") && this._isPassiveDataConnectionMode) {
                this._ftpClient.enterLocalActiveMode();
                this._isPassiveDataConnectionMode = false;
            }
        }
    }

    private void setFileType(boolean isBinaryFileType) throws IOException {
        if (!isBinaryFileType && this._isBinaryFileType) {
            this._ftpClient.setFileType(0);
            this._isBinaryFileType = isBinaryFileType;
        } else if (isBinaryFileType && !this._isBinaryFileType) {
            this._ftpClient.setFileType(2);
            this._isBinaryFileType = isBinaryFileType;
        }
    }

    protected String concat(String parentDir, String fileName) {
        StringBuffer path = new StringBuffer(parentDir);
        if (!parentDir.endsWith(String.valueOf(this.getSeparator()))) {
            path.append(this.getSeparator());
        }
        path.append(fileName);
        return path.toString();
    }

    private static class FTPBufferedInputStream
    extends BufferedInputStream {
        private FTPClient client;

        public FTPBufferedInputStream(InputStream in, FTPClient client) {
            super(in);
            this.client = client;
        }

        public FTPBufferedInputStream(InputStream in, int size, FTPClient client) {
            super(in, size);
            this.client = client;
        }

        public void close() throws IOException {
            super.close();
            this.client.completePendingCommand();
            this.client.logout();
        }
    }

    private class FTPBufferedOutputStream
    extends BufferedOutputStream {
        private FTPClient client;

        public FTPBufferedOutputStream(OutputStream out, FTPClient client) {
            super(out);
            this.client = client;
        }

        public FTPBufferedOutputStream(OutputStream out, int size, FTPClient client) {
            super(out, size);
            this.client = client;
        }

        public void close() throws IOException {
            super.close();
            this.client.completePendingCommand();
            this.client.logout();
        }
    }

    private class MyProgressMonitor {
        private IProgressMonitor fMonitor;
        private double fWorkPercentFactor;
        private Long fMaxWorkKB;
        private long fWorkToDate;

        public MyProgressMonitor(IProgressMonitor monitor) {
            this.fMonitor = monitor;
        }

        public void init(int op, String src, String dest, long max) {
            String srcFile;
            this.fWorkPercentFactor = 1.0 / (double)max;
            this.fMaxWorkKB = new Long(max / 1024L);
            this.fWorkToDate = 0L;
            String desc = srcFile = new Path(src).lastSegment();
            this.fMonitor.beginTask(desc, (int)max);
        }

        public void init(String label, int max) {
            this.fMonitor.beginTask(label, max);
        }

        public boolean count(long count) {
            this.fWorkToDate += count;
            Long workToDateKB = new Long(this.fWorkToDate / 1024L);
            Double workPercent = new Double(this.fWorkPercentFactor * (double)this.fWorkToDate);
            String subDesc = MessageFormat.format(FTPServiceResources.FTP_File_Service_Monitor_Format, workToDateKB, this.fMaxWorkKB, workPercent);
            this.fMonitor.subTask(subDesc);
            this.fMonitor.worked((int)count);
            return !this.fMonitor.isCanceled();
        }

        public void worked(int work) {
            this.fMonitor.worked(work);
        }

        public void end() {
            this.fMonitor.done();
        }
    }
}

