/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.services.telnet.shell;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.util.regex.Pattern;
import org.apache.commons.net.telnet.TelnetClient;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.internal.services.telnet.ITelnetSessionProvider;
import org.eclipse.rse.internal.services.telnet.shell.TelnetShellOutputReader;
import org.eclipse.rse.internal.services.telnet.shell.TelnetShellWriterThread;
import org.eclipse.rse.services.clientserver.PathUtility;
import org.eclipse.rse.services.shells.AbstractHostShell;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IHostShellOutputReader;

public class TelnetHostShell
extends AbstractHostShell
implements IHostShell {
    public static final String SHELL_INVOCATION = ">";
    private ITelnetSessionProvider fSessionProvider;
    private TelnetShellOutputReader fStdoutHandler;
    private TelnetShellOutputReader fStderrHandler;
    private TelnetShellWriterThread fShellWriter;
    private TelnetClient fTelnetClient;
    private static final Pattern cdCommands = Pattern.compile("\\A\\s*(cd|chdir|ls)\\b");

    public TelnetHostShell(ITelnetSessionProvider sessionProvider, String initialWorkingDirectory, String commandToRun, String encoding, String[] environment) {
        block7: {
            try {
                this.fSessionProvider = sessionProvider;
                this.fTelnetClient = this.fSessionProvider.makeNewTelnetClient((IProgressMonitor)new NullProgressMonitor());
                this.fStdoutHandler = encoding != null ? new TelnetShellOutputReader(this, new BufferedReader(new InputStreamReader(this.fTelnetClient.getInputStream(), encoding)), false) : new TelnetShellOutputReader(this, new BufferedReader(new InputStreamReader(this.fTelnetClient.getInputStream())), false);
                this.fStderrHandler = new TelnetShellOutputReader(this, null, true);
                OutputStream outputStream = this.fTelnetClient.getOutputStream();
                PrintWriter outputWriter = new PrintWriter(outputStream);
                this.fShellWriter = new TelnetShellWriterThread(outputWriter);
                if (initialWorkingDirectory != null && initialWorkingDirectory.length() > 0 && !initialWorkingDirectory.equals(".") && !initialWorkingDirectory.equals("Command Shell")) {
                    this.writeToShell("cd " + PathUtility.enQuoteUnix((String)initialWorkingDirectory));
                } else if (SHELL_INVOCATION.equals(commandToRun)) {
                    this.writeToShell(this.getPromptCommand());
                } else if (commandToRun != null && commandToRun.length() > 0) {
                    this.writeToShell(commandToRun);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                if (this.fShellWriter == null) break block7;
                this.fShellWriter.stopThread();
                this.fShellWriter = null;
            }
        }
    }

    public String getPromptCommand() {
        return "echo $PWD'>'";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void exit() {
        block7: {
            if (this.fShellWriter.isAlive()) {
                this.fShellWriter.stopThread();
            }
            try {
                if (this.fTelnetClient == null) break block7;
                TelnetClient telnetClient = this.fTelnetClient;
                synchronized (telnetClient) {
                    if (this.fTelnetClient.isConnected()) {
                        this.fTelnetClient.disconnect();
                    }
                }
            }
            catch (IOException iOException) {}
        }
    }

    public IHostShellOutputReader getStandardOutputReader() {
        return this.fStdoutHandler;
    }

    public IHostShellOutputReader getStandardErrorReader() {
        return this.fStderrHandler;
    }

    public boolean isActive() {
        if (this.fTelnetClient != null && this.fTelnetClient.isConnected() && !this.fStdoutHandler.isFinished()) {
            return true;
        }
        this.exit();
        return false;
    }

    public void writeToShell(String command) {
        if (this.isActive()) {
            if ("#break".equals(command)) {
                command = "\u0003";
            } else if (cdCommands.matcher(command).find()) {
                command = String.valueOf(command) + "\r\n" + this.getPromptCommand();
            }
            if (!this.fShellWriter.sendCommand(command)) {
                this.exit();
                this.isActive();
            }
        }
    }
}

