/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.processes.shell.linux;

import java.io.IOException;
import java.io.InputStream;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.processes.servicesubsystem.IProcessServiceSubSystem;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "org.eclipse.rse.subsystems.processes.shell.linux";
    public static String DONE_MARKUP_STRING = "--RSE:donedonedone:--";
    public static final String CMD_DELIMITER = ";";
    private static final String SHELL_EXIT_CMD = " exit ";
    private static final String SHELL_ECHO_CMD = " echo ";
    private static Activator plugin;

    public Activator() {
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    public static String getUniqueIdentifier() {
        if (Activator.getDefault() == null) {
            return PLUGIN_ID;
        }
        return Activator.getDefault().getBundle().getSymbolicName();
    }

    public static void log(IStatus status) {
        Activator.getDefault().getLog().log(status);
    }

    public static void logErrorMessage(String message) {
        Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 4, message, null));
    }

    public static void log(Throwable e) {
        Activator.log((IStatus)new Status(4, Activator.getUniqueIdentifier(), 4, e.getMessage(), e));
    }

    public static String formatShellCommand(String cmd) {
        if (cmd == null || cmd.equals("")) {
            return cmd;
        }
        StringBuffer formattedCommand = new StringBuffer();
        formattedCommand.append(cmd).append(CMD_DELIMITER);
        formattedCommand.append(SHELL_ECHO_CMD).append(DONE_MARKUP_STRING);
        formattedCommand.append(CMD_DELIMITER).append(SHELL_EXIT_CMD);
        return formattedCommand.toString();
    }

    public static IShellService getShellService(IHost host) {
        IShellServiceSubSystem ss = Activator.getShellServiceSubSystem(host);
        if (ss != null) {
            return ss.getShellService();
        }
        return null;
    }

    public static IShellServiceSubSystem getShellServiceSubSystem(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            if (subSystems[i] instanceof IShellServiceSubSystem) {
                return (IShellServiceSubSystem)subSystems[i];
            }
            ++i;
        }
        return null;
    }

    public static IProcessServiceSubSystem getProcessServiceSubSystem(IHost host) {
        if (host == null) {
            return null;
        }
        ISubSystem[] subSystems = host.getSubSystems();
        int i = 0;
        while (subSystems != null && i < subSystems.length) {
            if (subSystems[i] instanceof IProcessServiceSubSystem) {
                return (IProcessServiceSubSystem)subSystems[i];
            }
            ++i;
        }
        return null;
    }

    public static String getErrorMessage(InputStream errStream) {
        StringBuffer errBuf = new StringBuffer();
        byte[] bytes = null;
        int numOfBytesRead = 0;
        try {
            int available = errStream.available();
            while (available > 0) {
                bytes = new byte[available];
                numOfBytesRead = errStream.read(bytes);
                if (numOfBytesRead <= -1) break;
                errBuf.append(new String(bytes, 0, numOfBytesRead));
                available = errStream.available();
            }
            return errBuf.toString();
        }
        catch (IOException e) {
            Activator.log(e);
            return null;
        }
    }
}

