/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManager;
import org.eclipse.rse.core.filters.ISystemFilterPoolReferenceManagerProvider;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.internal.ui.filters.SystemFilterPoolDialogOutputs;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterNewFilterPoolWizard;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterPoolWizardDialog;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterPoolWizardInterface;
import org.eclipse.rse.internal.ui.filters.dialogs.SystemFilterWorkWithFilterPoolsDialog;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.ISystemWizardAction;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.filters.actions.SystemFilterAbstractFilterPoolWizardAction;
import org.eclipse.swt.widgets.Shell;

public class SystemFilterNewFilterPoolAction
extends SystemFilterAbstractFilterPoolWizardAction
implements ISystemWizardAction {
    private SystemFilterWorkWithFilterPoolsDialog wwdialog = null;

    public SystemFilterNewFilterPoolAction(Shell parent) {
        this(parent, (SystemFilterWorkWithFilterPoolsDialog)null);
    }

    public SystemFilterNewFilterPoolAction(Shell parent, SystemFilterWorkWithFilterPoolsDialog wwdialog) {
        super(parent, RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.newfilterpool_wizIcon"), SystemResources.ACTION_NEWFILTERPOOL_LABEL, SystemResources.ACTION_NEWFILTERPOOL_TOOLTIP);
        this.wwdialog = wwdialog;
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.new");
    }

    protected void init() {
        super.init();
        this.dlgInputs.prompt = SystemResources.RESID_NEWFILTERPOOL_PAGE1_DESCRIPTION;
        this.dlgInputs.title = SystemResources.RESID_NEWFILTERPOOL_PAGE1_TITLE;
        this.dlgInputs.poolNamePrompt = SystemResources.RESID_FILTERPOOLNAME_LABEL;
        this.dlgInputs.poolNameTip = SystemResources.RESID_FILTERPOOLNAME_TIP;
        this.dlgInputs.poolMgrNamePrompt = SystemResources.RESID_FILTERPOOLMANAGERNAME_LABEL;
        this.dlgInputs.poolMgrNameTip = SystemResources.RESID_FILTERPOOLMANAGERNAME_TIP;
    }

    public boolean checkObjectType(Object selectedObject) {
        if (selectedObject instanceof SystemSimpleContentElement) {
            selectedObject = ((SystemSimpleContentElement)selectedObject).getData();
        }
        boolean enable = selectedObject instanceof ISystemFilterPoolReferenceManagerProvider || selectedObject instanceof ISystemFilterPoolManager || selectedObject instanceof ISystemFilterPool;
        return enable;
    }

    public SystemFilterPoolWizardInterface getFilterPoolWizard() {
        return new SystemFilterNewFilterPoolWizard();
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemFilterPoolWizardDialog wizardDlg = (SystemFilterPoolWizardDialog)dlg;
        SystemFilterPoolDialogOutputs dlgOutput = wizardDlg.getFilterPoolDialogOutputs();
        return dlgOutput;
    }

    public void doOKprocessing(Object dlgValue) {
        ISystemFilterPoolReferenceManagerProvider sfprmp;
        SystemFilterPoolDialogOutputs dlgOutput = (SystemFilterPoolDialogOutputs)dlgValue;
        if (dlgOutput.newPool != null && this.wwdialog != null) {
            this.wwdialog.addNewFilterPool(this.getShell(), dlgOutput.newPool);
        } else if (dlgOutput.newPool != null && (sfprmp = this.getReferenceManagerProviderSelection()) != null) {
            ISystemFilterPoolReferenceManager sfprm = sfprmp.getSystemFilterPoolReferenceManager();
            sfprm.addReferenceToSystemFilterPool(dlgOutput.newPool);
        }
    }

    public ISystemFilterPoolManager[] getFilterPoolManagers() {
        if (this.wwdialog != null) {
            return this.wwdialog.getFilterPoolManagers();
        }
        return super.getFilterPoolManagers();
    }

    public int getFilterPoolManagerNameSelectionIndex() {
        if (this.wwdialog != null) {
            return this.wwdialog.getFilterPoolManagerSelection();
        }
        return super.getFilterPoolManagerNameSelectionIndex();
    }
}

