/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.actions;

import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableContext;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.ISystemProfileManager;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.internal.core.model.SystemProfileManager;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.actions.ISystemCopyTargetSelectionCallback;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemSimpleContentElement;
import org.eclipse.rse.ui.dialogs.SystemSimpleCopyDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public abstract class SystemBaseCopyAction
extends SystemBaseDialogAction
implements IRunnableWithProgress,
ISystemCopyTargetSelectionCallback {
    protected ISystemProfileManager mgr;
    protected ISystemRegistry sr;
    protected String[] oldNames;
    protected String[] newNames;
    protected Object[] oldObjects;
    protected Object targetContainer;
    protected boolean copiedOk = true;
    protected Exception runException = null;
    protected int mode = 0;
    protected int runCount = 0;
    public static final int MODE_COPY = 0;
    public static final int MODE_MOVE = 1;

    public SystemBaseCopyAction(Shell parent, int mode) {
        this(parent, mode == 0 ? SystemResources.ACTION_COPY_LABEL : SystemResources.ACTION_MOVE_LABEL, mode);
    }

    public SystemBaseCopyAction(Shell parent, String label, int mode) {
        super(label, mode == 0 ? PlatformUI.getWorkbench().getSharedImages().getImageDescriptor("IMG_TOOL_COPY") : RSEUIPlugin.getDefault().getImageDescriptor("org.eclipse.rse.ui.moveIcon"), parent);
        this.mode = mode;
        this.mgr = SystemProfileManager.getDefault();
        this.sr = RSECorePlugin.getTheSystemRegistry();
        this.allowOnMultipleSelection(true);
        this.setProcessAllSelections(true);
        this.setContextMenuGroup("group.reorganize");
    }

    protected void reset() {
        this.oldNames = null;
        this.newNames = null;
        this.oldObjects = null;
        this.targetContainer = null;
        this.copiedOk = true;
        this.runException = null;
    }

    protected Dialog createDialog(Shell parent) {
        ++this.runCount;
        if (this.runCount > 1) {
            this.reset();
        }
        SystemSimpleCopyDialog copyDlg = new SystemSimpleCopyDialog(parent, this.getPromptString(), this.mode, this, this.getTreeModel(), this.getTreeInitialSelection());
        IStructuredSelection sel = this.getSelection();
        if (sel.size() == 1) {
            String singleTitle = null;
            singleTitle = this.mode == 0 ? SystemResources.RESID_COPY_SINGLE_TITLE : SystemResources.RESID_MOVE_SINGLE_TITLE;
            if (!singleTitle.startsWith("Missing")) {
                copyDlg.setTitle(singleTitle);
            }
        }
        return copyDlg;
    }

    protected abstract String[] getOldNames();

    protected abstract Object[] getOldObjects();

    protected String getPromptString() {
        if (this.mode == 0) {
            return SystemResources.RESID_COPY_PROMPT;
        }
        return SystemResources.RESID_MOVE_PROMPT;
    }

    protected abstract SystemSimpleContentElement getTreeModel();

    protected abstract SystemSimpleContentElement getTreeInitialSelection();

    public boolean isValidTargetParent(SystemSimpleContentElement selectedElement) {
        return !selectedElement.hasChildren();
    }

    protected Object getDialogValue(Dialog dlg) {
        this.targetContainer = this.getTargetContainer(dlg);
        if (this.targetContainer != null) {
            boolean okToProceed = this.preCheckForCollision();
            if (!okToProceed) {
                return null;
            }
            IRunnableContext runnableContext = this.getRunnableContext();
            try {
                SystemMessage completeMsg;
                runnableContext.run(false, false, (IRunnableWithProgress)this);
                if (this.copiedOk && (completeMsg = this.getCompletionMessage(this.targetContainer, this.oldNames, this.newNames)) != null) {
                    SystemMessageDialog msgDlg = new SystemMessageDialog(this.getShell(), completeMsg);
                    msgDlg.open();
                }
            }
            catch (InvocationTargetException exc) {
                this.showOperationMessage((Exception)exc.getTargetException(), this.getShell());
            }
            catch (Exception exc) {
                this.showOperationMessage(exc, this.getShell());
            }
        }
        return null;
    }

    protected IRunnableContext getRunnableContext() {
        IRunnableContext irc = RSEUIPlugin.getTheSystemRegistryUI().getRunnableContext();
        if (irc == null) {
            irc = new ProgressMonitorDialog(this.getShell());
        }
        return irc;
    }

    protected Object getTargetContainer(Dialog dlg) {
        SystemSimpleCopyDialog cpyDlg = (SystemSimpleCopyDialog)dlg;
        Object targetContainer = null;
        if (!cpyDlg.wasCancelled()) {
            targetContainer = cpyDlg.getTargetContainer();
        }
        return targetContainer;
    }

    protected boolean preCheckForCollision() {
        boolean ok = true;
        this.oldNames = this.getOldNames();
        this.oldObjects = this.getOldObjects();
        int steps = this.oldObjects.length;
        String oldName = null;
        Object oldObject = null;
        int idx = 0;
        while (ok && idx < steps) {
            oldName = this.oldNames[idx];
            oldObject = this.oldObjects[idx];
            ok = this.preCheckForCollision(this.getShell(), this.targetContainer, oldObject, oldName);
            ++idx;
        }
        return ok;
    }

    protected boolean preCheckForCollision(Shell shell, Object targetContainer, Object oldObject, String oldName) {
        return true;
    }

    public void copyComplete() {
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        SystemMessage msg = this.getCopyingMessage();
        this.runException = null;
        try {
            int steps = this.oldObjects.length;
            monitor.beginTask(msg.getLevelOneText(), steps);
            this.copiedOk = true;
            String oldName = null;
            String newName = null;
            Object oldObject = null;
            this.newNames = new String[this.oldNames.length];
            int idx = 0;
            while (this.copiedOk && idx < steps) {
                oldName = this.oldNames[idx];
                oldObject = this.oldObjects[idx];
                monitor.subTask(this.getCopyingMessage(oldName).getLevelOneText());
                newName = this.checkForCollision(this.getShell(), monitor, this.targetContainer, oldObject, oldName);
                this.copiedOk = newName == null ? false : this.doCopy(this.targetContainer, oldObject, newName, monitor);
                this.newNames[idx] = newName;
                monitor.worked(1);
                ++idx;
            }
            monitor.done();
        }
        catch (InterruptedException exc) {
            monitor.done();
            this.runException = exc;
            throw (InterruptedException)this.runException;
        }
        catch (Exception exc) {
            monitor.done();
            this.runException = new InvocationTargetException(exc);
            throw (InvocationTargetException)this.runException;
        }
        if (this.copiedOk) {
            this.copyComplete();
        }
    }

    protected abstract String checkForCollision(Shell var1, IProgressMonitor var2, Object var3, Object var4, String var5);

    protected SystemMessage getCopyingMessage() {
        if (this.mode == 0) {
            return RSEUIPlugin.getPluginMessage("RSEG1115");
        }
        return RSEUIPlugin.getPluginMessage("RSEG1116");
    }

    protected SystemMessage getCopyingMessage(String oldName) {
        SystemMessage msg = null;
        msg = this.mode == 0 ? RSEUIPlugin.getPluginMessage("RSEG1117") : RSEUIPlugin.getPluginMessage("RSEG1118");
        msg.makeSubstitution((Object)oldName);
        return msg;
    }

    protected abstract boolean doCopy(Object var1, Object var2, String var3, IProgressMonitor var4) throws Exception;

    public SystemMessage getCompletionMessage(Object targetContainer, String[] oldNames, String[] newNames) {
        return null;
    }

    protected void showOperationMessage(Exception exc, Shell shell) {
        if (exc instanceof InterruptedException) {
            this.showOperationCancelledMessage(shell);
        } else if (exc instanceof InvocationTargetException) {
            this.showOperationErrorMessage(shell, ((InvocationTargetException)exc).getTargetException());
        } else {
            this.showOperationErrorMessage(shell, exc);
        }
    }

    protected void showOperationErrorMessage(Shell shell, Throwable exc) {
        if (exc instanceof SystemMessageException) {
            this.showOperationErrorMessage(shell, (SystemMessageException)exc);
        } else {
            String msg = exc.getMessage();
            if (msg == null || exc instanceof ClassCastException) {
                msg = exc.getClass().getName();
            }
            SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage("RSEG1066").makeSubstitution((Object)msg));
            msgDlg.setException(exc);
            msgDlg.open();
        }
    }

    protected void showOperationErrorMessage(Shell shell, SystemMessageException exc) {
        SystemMessage msg = exc.getSystemMessage();
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, msg);
        msgDlg.open();
    }

    protected void showOperationCancelledMessage(Shell shell) {
        SystemMessageDialog msgDlg = new SystemMessageDialog(shell, RSEUIPlugin.getPluginMessage("RSEG1067"));
        msgDlg.open();
    }
}

