/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui.widgets.services;

import org.eclipse.rse.core.model.DummyHost;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.IDelegatingConnectorService;
import org.eclipse.rse.core.subsystems.IServerLauncherProperties;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.services.IService;
import org.eclipse.rse.ui.widgets.services.ConnectorServiceElement;
import org.eclipse.rse.ui.widgets.services.PropertyElement;
import org.eclipse.rse.ui.widgets.services.PropertySetServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceServiceElement;

public class FactoryServiceElement
extends ServiceElement {
    private IServiceSubSystemConfiguration _factory;
    private ServiceElement[] _children;

    public FactoryServiceElement(IHost host, IServiceSubSystemConfiguration factory) {
        super(host, null);
        this._factory = factory;
    }

    public String getName() {
        return this._factory.getId();
    }

    public String getDescription() {
        return this._factory.getDescription();
    }

    public IServiceSubSystemConfiguration getFactory() {
        return this._factory;
    }

    public IConnectorService getConnectorService() {
        IHost host = this.getHost();
        IConnectorService connectorService = this._factory.getConnectorService(host);
        return connectorService;
    }

    public IService getService() {
        IHost host = this.getHost();
        IService service = this._factory.getService(host);
        return service;
    }

    public ServiceElement[] getChildren() {
        if (this._children == null) {
            IHost host = this.getHost();
            ServiceServiceElement serviceElement = new ServiceServiceElement(host, this, this.getService());
            IConnectorService connectorService = this.getConnectorService();
            if (connectorService != null && !(connectorService instanceof IDelegatingConnectorService)) {
                IServerLauncherProperties sl;
                this._children = new ServiceElement[2];
                this._children[0] = serviceElement;
                this._children[1] = new ConnectorServiceElement(host, (ServiceElement)this, connectorService);
                if (host instanceof DummyHost && (sl = connectorService.getRemoteServerLauncherProperties()) == null) {
                    sl = this._factory.createServerLauncher(connectorService);
                    connectorService.setRemoteServerLauncherProperties(sl);
                }
            } else {
                this._children = new ServiceElement[1];
                this._children[0] = serviceElement;
            }
        }
        return this._children;
    }

    public boolean hasChildren() {
        return true;
    }

    public boolean hasPropertySets() {
        return false;
    }

    public PropertySetServiceElement[] getPropertySets() {
        return null;
    }

    public boolean hasProperties() {
        return false;
    }

    public PropertyElement[] getProperties() {
        return null;
    }

    public void commit() {
        if (this._isSelected) {
            ServiceElement[] children = this.getChildren();
            int i = 0;
            while (i < children.length) {
                children[i].commit();
                ++i;
            }
        }
    }

    public void revert() {
        ServiceElement[] children = this.getChildren();
        int i = 0;
        while (i < children.length) {
            children[i].revert();
            ++i;
        }
    }
}

