/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.dstore.security;

import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.rse.internal.dstore.security.ImageRegistry;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class UniversalSecurityPlugin
extends AbstractUIPlugin {
    private static final String KEYSTORE = "dstorekeystore.dat";
    private static UniversalSecurityPlugin inst;
    public static final String PLUGIN_ID = "org.eclipse.rse.dstore.security";

    public UniversalSecurityPlugin() {
        if (inst == null) {
            inst = this;
        }
    }

    public static UniversalSecurityPlugin getDefault() {
        return inst;
    }

    public static String getPluginId() {
        return PLUGIN_ID;
    }

    public static String getKeyStoreLocation() {
        Bundle bundle = Platform.getBundle((String)PLUGIN_ID);
        return Platform.getStateLocation((Bundle)bundle).append(KEYSTORE).toOSString();
    }

    public static String getKeyStorePassword() {
        return "dstore";
    }

    public static String getWorkspaceName() {
        IPath workspace = Platform.getLocation();
        int nr = workspace.segmentCount();
        String workspaceName = workspace.segment(nr - 1);
        return workspaceName;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.savePluginPreferences();
        ImageRegistry.shutdown();
    }

    public static Shell getActiveWorkbenchShell() {
        return UniversalSecurityPlugin.getActiveWorkbenchWindow().getShell();
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return UniversalSecurityPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public void log(IStatus status) {
        this.getLog().log(status);
    }

    public void log(Throwable e) {
        this.log((IStatus)new Status(4, PLUGIN_ID, 4, "Error", e));
    }
}

