/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.subsystems.processes.shell.linux;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.Activator;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.LinuxHostProcess;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.LinuxProcessHelper;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.LinuxShellProcessResources;
import org.eclipse.rse.internal.subsystems.processes.shell.linux.WaiterJob;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.clientserver.processes.IHostProcess;
import org.eclipse.rse.services.clientserver.processes.IHostProcessFilter;
import org.eclipse.rse.services.processes.AbstractProcessService;
import org.eclipse.rse.services.shells.HostShellProcessAdapter;
import org.eclipse.rse.services.shells.IHostShell;
import org.eclipse.rse.services.shells.IShellService;
import org.eclipse.rse.subsystems.shells.core.subsystems.servicesubsystem.IShellServiceSubSystem;

public class LinuxShellProcessService
extends AbstractProcessService {
    private static String COMMAND_GET_SIGNAL_TYPES = "kill -l";
    private static String COMMAND_GET_PROCESSES = "cat /proc/[0-9]*/status";
    private static String COMMAND_KILL_PROCESSES = "kill ";
    private String[] statusTypes;
    private LinuxProcessHelper linuxProcessHelper;
    private IHost host;

    public LinuxShellProcessService(IHost host) {
        this.host = host;
    }

    public String[] getSignalTypes() {
        if (this.statusTypes == null) {
            this.statusTypes = this.internalGetSignalTypes();
        }
        return this.statusTypes;
    }

    public boolean kill(long PID, String signal, IProgressMonitor monitor) throws SystemMessageException {
        String signalString = signal.equals("default") ? "" : "-" + signal;
        IShellService shellService = Activator.getShellService(this.host);
        IHostShell hostShell = shellService.launchShell("", null, (IProgressMonitor)new NullProgressMonitor());
        hostShell.writeToShell(this.getKillCommand(PID, signalString));
        HostShellProcessAdapter p = null;
        try {
            p = new HostShellProcessAdapter(hostShell);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (p != null) {
                p.destroy();
            }
            return false;
        }
        String errMsg = Activator.getErrorMessage(p.getErrorStream());
        if (errMsg.trim().equals("")) {
            return true;
        }
        Activator.logErrorMessage(errMsg.toString());
        return false;
    }

    public IHostProcess[] listAllProcesses(IHostProcessFilter filter, IProgressMonitor monitor) throws SystemMessageException {
        IShellServiceSubSystem ss;
        if (filter.getUsername().equals("${user.id}") && this.host != null && (ss = Activator.getShellServiceSubSystem(this.host)) != null) {
            String connectionUserId = ss.getConnectorService().getUserId();
            filter.setUsername(connectionUserId);
        }
        if (monitor != null) {
            monitor.beginTask(LinuxShellProcessResources.LinuxRemoteProcessService_monitor_fetchProcesses, 100);
        }
        IShellService shellService = Activator.getShellService(this.host);
        IHostShell hostShell = shellService.launchShell("", null, (IProgressMonitor)new NullProgressMonitor());
        hostShell.writeToShell(this.getProcessesCommand());
        HostShellProcessAdapter p = null;
        try {
            p = new HostShellProcessAdapter(hostShell);
        }
        catch (Exception e) {
            e.printStackTrace();
            if (p != null) {
                p.destroy();
            }
            return null;
        }
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        LinuxHostProcess hostProcess = null;
        ArrayList<LinuxHostProcess> hostProcessList = new ArrayList<LinuxHostProcess>();
        try {
            boolean allows;
            String nextLine;
            while ((nextLine = bufferReader.readLine()) != null && !nextLine.equals(Activator.DONE_MARKUP_STRING)) {
                if (hostProcess == null || LinuxHostProcess.isNewRecord(nextLine)) {
                    if (hostProcess != null && (allows = filter.allows(hostProcess.getStatusLine()))) {
                        hostProcessList.add(hostProcess);
                    }
                    hostProcess = new LinuxHostProcess(this.linuxProcessHelper);
                }
                hostProcess.processLine(nextLine);
                if (this.progressWorked(monitor, 1)) break;
            }
            if (hostProcess != null && (allows = filter.allows(hostProcess.getStatusLine()))) {
                hostProcessList.add(hostProcess);
            }
            bufferReader.close();
        }
        catch (IOException e) {
            Activator.log(e);
        }
        WaiterJob waiter = new WaiterJob((Process)p);
        waiter.schedule();
        return hostProcessList.toArray(new IHostProcess[hostProcessList.size()]);
    }

    public String getDescription() {
        return LinuxShellProcessResources.LinuxRemoteProcessService_description;
    }

    public String getName() {
        return LinuxShellProcessResources.LinuxRemoteProcessService_name;
    }

    public void initService(IProgressMonitor monitor) {
        super.initService(monitor);
        this.linuxProcessHelper = new LinuxProcessHelper();
        this.linuxProcessHelper.populateUsernames(this.host);
    }

    private boolean progressWorked(IProgressMonitor monitor, int work) {
        boolean cancelRequested = false;
        if (monitor != null) {
            monitor.worked(work);
            cancelRequested = monitor.isCanceled();
        }
        return cancelRequested;
    }

    protected String[] internalGetSignalTypes() {
        IShellService shellService = Activator.getShellService(this.host);
        Process p = null;
        try {
            IHostShell hostShell = shellService.launchShell("", null, (IProgressMonitor)new NullProgressMonitor());
            hostShell.writeToShell(this.getSignalTypesCommand());
            p = new HostShellProcessAdapter(hostShell);
        }
        catch (Exception e) {
            Activator.log(e);
            if (p != null) {
                p.destroy();
            }
            return null;
        }
        BufferedReader bufferReader = new BufferedReader(new InputStreamReader(p.getInputStream()));
        String line = null;
        ArrayList<String> lines = null;
        try {
            StringBuffer output = new StringBuffer();
            while ((line = bufferReader.readLine()) != null && !line.equals(Activator.DONE_MARKUP_STRING)) {
                output = output.append(line);
            }
            bufferReader.close();
            if (output.length() > 0) {
                StringTokenizer st = new StringTokenizer(output.toString());
                lines = new ArrayList<String>();
                while (st.hasMoreTokens()) {
                    String token = st.nextToken().trim();
                    if (!token.matches("([A-Z]*)")) continue;
                    lines.add(token);
                }
            }
        }
        catch (IOException e) {
            Activator.log(e);
        }
        WaiterJob waiter = new WaiterJob(p);
        waiter.schedule();
        if (lines != null && lines.size() > 0) {
            return lines.toArray(new String[lines.size()]);
        }
        Activator.logErrorMessage(LinuxShellProcessResources.LinuxRemoteProcessService_getSignalTypes_empty);
        return null;
    }

    protected String getSignalTypesCommand() {
        return Activator.formatShellCommand(COMMAND_GET_SIGNAL_TYPES);
    }

    protected String getProcessesCommand() {
        return Activator.formatShellCommand(COMMAND_GET_PROCESSES);
    }

    protected String getKillCommand(long PID, String signalString) {
        String cmdLine = String.valueOf(COMMAND_KILL_PROCESSES) + signalString + " " + PID;
        return Activator.formatShellCommand(cmdLine);
    }
}

