/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.actions;

import java.util.ArrayList;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.model.ISystemRegistry;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.widgets.Shell;

public class SystemConnectAllSubSystemsAction
extends SystemBaseAction {
    private ISystemRegistry sr = null;

    public SystemConnectAllSubSystemsAction(Shell shell) {
        super(SystemResources.ACTION_CONNECT_ALL_LABEL, SystemResources.ACTION_CONNECT_ALL_TOOLTIP, shell);
        this.allowOnMultipleSelection(false);
        this.setContextMenuGroup("group.connection");
        this.sr = RSECorePlugin.getTheSystemRegistry();
    }

    public boolean checkObjectType(Object obj) {
        return obj instanceof IHost && !this.sr.areAllSubSystemsConnected((IHost)obj);
    }

    public void run() {
        IHost conn = (IHost)this.getFirstSelection();
        ConnectAllJob job = new ConnectAllJob(conn);
        job.schedule();
    }

    public class ConnectAllJob
    extends Job {
        private IHost _connection;

        public ConnectAllJob(IHost connection) {
            super(SystemResources.ACTION_CONNECT_ALL_LABEL);
            this._connection = connection;
        }

        public IStatus run(IProgressMonitor monitor) {
            ArrayList<IConnectorService> failedSystems = new ArrayList<IConnectorService>();
            try {
                ISubSystem[] subsystems = this._connection.getSubSystems();
                int i = 0;
                while (i < subsystems.length) {
                    ISubSystem subsystem = subsystems[i];
                    IConnectorService system = subsystem.getConnectorService();
                    if (!subsystem.isConnected() && subsystem.getSubSystemConfiguration().supportsSubSystemConnect() && !failedSystems.contains(system)) {
                        try {
                            subsystem.connect(monitor, false);
                        }
                        catch (SystemMessageException e) {
                            failedSystems.add(system);
                            SystemMessageDialog.displayMessage(e);
                        }
                        catch (Exception e) {
                            failedSystems.add(system);
                            if (e instanceof InterruptedException || e instanceof OperationCanceledException) break;
                            SystemBasePlugin.logError(e.getLocalizedMessage() != null ? e.getLocalizedMessage() : e.getClass().getName(), e);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception exception) {}
            if (failedSystems.size() > 0) {
                return Status.CANCEL_STATUS;
            }
            return Status.OK_STATUS;
        }
    }
}

