/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.ui;

import org.eclipse.rse.ui.ISystemMassager;

public class MassagerRemoveQuotes
implements ISystemMassager {
    private String quoteChar;
    private String charToEscape;
    private String escapeChar;
    private boolean mustBeQuoted;

    public MassagerRemoveQuotes() {
        this('\'', '\'', '\'', true);
    }

    public MassagerRemoveQuotes(char quoteChar, char charToEscape, char escapeChar, boolean mustBeQuoted) {
        this.quoteChar = String.valueOf(quoteChar);
        this.charToEscape = String.valueOf(charToEscape);
        this.escapeChar = String.valueOf(escapeChar);
        this.mustBeQuoted = mustBeQuoted;
    }

    public String massage(String text) {
        boolean islegal;
        String strippedText = text;
        if (this.mustBeQuoted) {
            if (!this.isQuoted(text)) {
                return text;
            }
            strippedText = this.stripQuotes(text);
        }
        if (islegal = this.isLegalString(strippedText)) {
            return this.deQuote(strippedText);
        }
        return text;
    }

    protected boolean isQuoted(String text) {
        return text.startsWith(this.quoteChar) && text.endsWith(this.quoteChar);
    }

    protected boolean isLegalString(String text) {
        if (this.charToEscape.equals(this.escapeChar)) {
            return this.doForwardChecking(text);
        }
        return this.doBackwardChecking(text);
    }

    private boolean doForwardChecking(String text) {
        int index = text.indexOf(this.charToEscape);
        while (index != -1) {
            if (index == text.length() - 1 || text.charAt(index + 1) != this.escapeChar.charAt(0)) {
                return false;
            }
            index = text.indexOf(this.charToEscape, index + 2);
        }
        return true;
    }

    private boolean doBackwardChecking(String text) {
        int index = text.indexOf(this.charToEscape);
        while (index != -1) {
            if (index == 0 || text.charAt(index - 1) != this.escapeChar.charAt(0)) {
                return false;
            }
            index = text.indexOf(this.charToEscape, index + 1);
        }
        return true;
    }

    private String stripQuotes(String text) {
        if (this.isQuoted(text)) {
            text = text.substring(1, text.length() - 1);
        }
        return text;
    }

    private String deQuote(String text) {
        if (this.charToEscape.equals(this.escapeChar)) {
            return this.doForwardDeQuote(text);
        }
        return this.doBackwardDeQuote(text);
    }

    private String doForwardDeQuote(String text) {
        int index = text.indexOf(this.charToEscape);
        while (index != -1) {
            text = String.valueOf(text.substring(0, index)) + text.substring(index + 1);
            index = text.indexOf(this.charToEscape, index + 2);
        }
        return text;
    }

    private String doBackwardDeQuote(String text) {
        int index = text.indexOf(this.charToEscape);
        while (index != -1) {
            text = String.valueOf(text.substring(0, index - 1)) + text.substring(index);
            index = text.indexOf(this.charToEscape, index + 1);
        }
        return text;
    }
}

