/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.ui.propertypages;

import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.rse.core.filters.ISystemFilterPool;
import org.eclipse.rse.core.filters.ISystemFilterPoolReference;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.internal.ui.SystemPropertyResources;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.propertypages.SystemBasePropertyPage;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;

public class SystemFilterPoolPropertyPage
extends SystemBasePropertyPage {
    protected Label labelType;
    protected Label labelName;
    protected Label labelProfile;
    protected Label labelReferenceCount;
    protected Label labelRelatedConnection;
    protected String errorMessage;
    protected boolean initDone = false;

    protected Control createContentArea(Composite parent) {
        this.noDefaultAndApplyButton();
        Composite composite_prompts = SystemWidgetHelpers.createComposite(parent, 2);
        this.labelType = this.createLabeledLabel(composite_prompts, SystemResources.RESID_PP_PROPERTIES_TYPE_LABEL, SystemResources.RESID_PP_PROPERTIES_TYPE_TOOLTIP);
        this.labelType.setText(SystemResources.RESID_FILTERPOOL_TYPE_VALUE);
        this.labelName = this.createLabeledLabel(composite_prompts, SystemResources.RESID_FILTERPOOL_NAME_LABEL, SystemResources.RESID_FILTERPOOL_NAME_TOOLTIP);
        this.labelProfile = this.createLabeledLabel(composite_prompts, SystemResources.RESID_FILTERPOOL_PROFILE_LABEL, SystemResources.RESID_FILTERPOOL_PROFILE_TOOLTIP);
        this.labelReferenceCount = this.createLabeledLabel(composite_prompts, SystemResources.RESID_FILTERPOOL_REFERENCECOUNT_LABEL, SystemResources.RESID_FILTERPOOL_REFERENCECOUNT_TOOLTIP);
        this.labelRelatedConnection = this.createLabeledLabel(composite_prompts, SystemResources.RESID_FILTERPOOL_RELATEDCONNECTION_LABEL, SystemResources.RESID_FILTERPOOL_RELATEDCONNECTION_TOOLTIP);
        if (!this.initDone) {
            this.doInitializeFields();
        }
        return composite_prompts;
    }

    protected boolean verifyPageContents() {
        return true;
    }

    protected ISystemFilterPool getFilterPool() {
        IAdaptable element = this.getElement();
        if (element instanceof ISystemFilterPool) {
            return (ISystemFilterPool)element;
        }
        return ((ISystemFilterPoolReference)element).getReferencedFilterPool();
    }

    protected void doInitializeFields() {
        this.initDone = true;
        ISystemFilterPool pool = this.getFilterPool();
        this.labelName.setText(pool.getName());
        ISubSystemConfiguration ssFactory = (ISubSystemConfiguration)pool.getProvider();
        String profileName = ssFactory.getSystemProfile(pool).getName();
        this.labelProfile.setText(profileName);
        this.labelReferenceCount.setText(Integer.toString(pool.getReferenceCount()));
        if (pool.getOwningParentName() == null) {
            this.labelRelatedConnection.setText(SystemPropertyResources.RESID_TERM_NOTAPPLICABLE);
        } else {
            this.labelRelatedConnection.setText(pool.getOwningParentName());
        }
    }
}

