/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.useractions.files.uda;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.rse.internal.useractions.UserActionsResources;
import org.eclipse.rse.internal.useractions.ui.uda.ISystemUDTypeEditPaneTypesSelector;
import org.eclipse.rse.internal.useractions.ui.uda.SystemUDAResources;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileFilterString;
import org.eclipse.rse.ui.SystemWidgetHelpers;
import org.eclipse.rse.ui.messages.ISystemMessageLine;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IFileEditorMapping;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.FileEditorMappingContentProvider;
import org.eclipse.ui.dialogs.FileEditorMappingLabelProvider;

public class UDTypesEditorFiles
implements ISystemUDTypeEditPaneTypesSelector,
ICheckStateListener {
    public static final String NO_EXTENSION_PLACEHOLDER = ".null";
    private CheckboxTableViewer typesSelectionList;
    private Label definedTypesLabel;
    private Text userDefinedText;
    private Label nonEditableVerbage;
    private Composite typesComposite;
    private List inpTypes;
    private IFileEditorMapping[] currentInput;
    private int currentDomain;
    private boolean ignoreModifyEvents = false;
    private static final int LIST_HEIGHT = 150;
    private static final int LIST_WIDTH = 50;
    private static final String TYPE_DELIMITER = ",";
    private Vector listeners = new Vector();

    public UDTypesEditorFiles(Composite comp, int nbrColumns) {
        if (nbrColumns == 2) {
            this.definedTypesLabel = SystemWidgetHelpers.createLabeledLabel((Composite)comp, (String)SystemUDAResources.RESID_UDT_FILES_DEFINEDTYPES_LABEL, (String)SystemUDAResources.RESID_UDT_FILES_DEFINEDTYPES_TOOLTIP, (boolean)true);
        }
        this.nonEditableVerbage = SystemWidgetHelpers.createVerbiage((Composite)comp, (String)"", (int)nbrColumns, (boolean)false, (int)350);
        this.nonEditableVerbage.setVisible(false);
        this.typesComposite = SystemWidgetHelpers.createTightComposite((Composite)comp, (int)1);
        this.typesComposite.setToolTipText(SystemUDAResources.RESID_UDT_FILES_TYPESGROUP_TOOLTIP);
        ((GridData)this.typesComposite.getLayoutData()).horizontalSpan = nbrColumns;
        nbrColumns = 1;
        if (this.definedTypesLabel == null) {
            this.definedTypesLabel = SystemWidgetHelpers.createLabeledLabel((Composite)this.typesComposite, (String)SystemUDAResources.RESID_UDT_FILES_DEFINEDTYPES_LABEL, (String)SystemUDAResources.RESID_UDT_FILES_DEFINEDTYPES_TOOLTIP, (boolean)true);
        }
        this.definedTypesLabel.setForeground(this.definedTypesLabel.getDisplay().getSystemColor(16));
        Table table = new Table(this.typesComposite, 2080);
        table.setToolTipText(SystemUDAResources.RESID_UDT_FILES_TYPESGROUP_TOOLTIP);
        this.typesSelectionList = new CheckboxTableViewer(table);
        GridData data = new GridData(1808);
        data.horizontalSpan = nbrColumns;
        data.heightHint = 150;
        data.widthHint = 50;
        this.typesSelectionList.getTable().setLayoutData((Object)data);
        this.typesSelectionList.setLabelProvider((IBaseLabelProvider)FileEditorMappingLabelProvider.INSTANCE);
        this.typesSelectionList.setContentProvider((IContentProvider)FileEditorMappingContentProvider.INSTANCE);
        this.addSelectionButtons(this.typesComposite);
        Composite userComp = this.createUserEntryGroup(this.typesComposite);
        ((GridData)userComp.getLayoutData()).horizontalSpan = nbrColumns;
        this.initializeViewer();
        this.typesSelectionList.addCheckStateListener((ICheckStateListener)this);
    }

    public void setDomain(int domain) {
        this.currentDomain = domain;
    }

    public void setMessageLine(ISystemMessageLine msgLine) {
    }

    public int getDomain() {
        return this.currentDomain;
    }

    public void setTypes(String types) {
        if (types == null) {
            this.setTypes((String[])null);
        } else {
            this.setTypes(RemoteFileFilterString.parseTypes((String)types));
            this.setDefinedTypesText(types);
        }
    }

    private void setDefinedTypesText(String types) {
        this.definedTypesLabel.setText(" " + types);
        this.definedTypesLabel.setToolTipText(types);
    }

    private void clearDefinedTypesText() {
        this.definedTypesLabel.setText("");
        this.definedTypesLabel.setToolTipText("");
    }

    private void setTypes(String[] types) {
        this.clearTypes();
        if (types != null) {
            this.inpTypes = Arrays.asList(types);
            this.ignoreModifyEvents = true;
            this.checkInitialSelections();
            this.ignoreModifyEvents = false;
        }
    }

    public void clearTypes() {
        this.ignoreModifyEvents = true;
        this.inpTypes = null;
        this.typesSelectionList.setAllChecked(false);
        this.clearDefinedTypesText();
        this.userDefinedText.setText("");
        this.ignoreModifyEvents = false;
    }

    public String getTypes() {
        return RemoteFileFilterString.getTypesString((String[])this.getTypesAsArray());
    }

    public String[] getTypesAsArray() {
        List selectedEntries = this.getSelectedTypes();
        String[] seldArray = new String[selectedEntries.size()];
        int idx = 0;
        while (idx < seldArray.length) {
            seldArray[idx] = (String)selectedEntries.get(idx);
            ++idx;
        }
        return seldArray;
    }

    public void addModifyListener(ModifyListener listener) {
        this.listeners.add(listener);
    }

    public void removeModifyListener(ModifyListener listener) {
        this.listeners.remove(listener);
    }

    public SystemMessage validate() {
        if (this.typesSelectionList == null) {
            return null;
        }
        if (!this.areTypesSelected()) {
            return new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1190", 4, UserActionsResources.MSG_VALIDATE_UDTTYPES_EMPTY, UserActionsResources.MSG_VALIDATE_UDTTYPES_EMPTY_DETAILS);
        }
        return this.validateUserDefinedTypes();
    }

    public SystemMessage validateUserDefinedTypes() {
        String filename = this.userDefinedText.getText().trim();
        if (filename.length() == 0) {
            return null;
        }
        int index = filename.indexOf(46);
        if (index == filename.length() - 1 && (index == 0 || index == 1 && filename.charAt(0) == '*')) {
            return new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1191", 4, UserActionsResources.MSG_VALIDATE_UDTTYPES_NOTVALID, UserActionsResources.MSG_VALIDATE_UDTTYPES_NOTVALID_DETAILS);
        }
        int startScan = 0;
        if (filename.startsWith("*.")) {
            startScan = 2;
        }
        if ((index = filename.indexOf(42, startScan)) > -1) {
            if (filename.length() == 1) {
                return new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1191", 4, UserActionsResources.MSG_VALIDATE_UDTTYPES_NOTVALID, UserActionsResources.MSG_VALIDATE_UDTTYPES_NOTVALID_DETAILS);
            }
            if (index != 0 || filename.charAt(1) != '.') {
                return new SimpleSystemMessage("org.eclipse.rse.useractions", "RSEG1191", 4, UserActionsResources.MSG_VALIDATE_UDTTYPES_NOTVALID, UserActionsResources.MSG_VALIDATE_UDTTYPES_NOTVALID_DETAILS);
            }
        }
        return null;
    }

    public Control getControl() {
        return this.typesSelectionList.getControl();
    }

    public void setEnabled(boolean enable) {
        this.typesSelectionList.getControl().setEnabled(enable);
        this.userDefinedText.setEnabled(enable);
    }

    public void setEditable(boolean editable, String vendor) {
        this.typesComposite.setVisible(editable);
        if (editable) {
            this.nonEditableVerbage.setVisible(false);
        } else {
            this.nonEditableVerbage.setVisible(true);
            if (vendor.equals("IBM")) {
                this.nonEditableVerbage.setText(SystemUDAResources.RESID_UDT_IBM_VERBAGE);
            } else {
                String verbage = SystemUDAResources.RESID_UDT_VENDOR_VERBAGE;
                verbage = SystemMessage.sub((String)verbage, (String)"%1", (String)vendor);
                this.nonEditableVerbage.setText(verbage);
            }
        }
    }

    private void fireModifiedEvent() {
        Event event = new Event();
        event.widget = this.getControl();
        event.type = 24;
        event.data = this;
        ModifyEvent mEvent = new ModifyEvent(event);
        int idx = 0;
        while (idx < this.listeners.size()) {
            ModifyListener l = (ModifyListener)this.listeners.elementAt(idx);
            l.modifyText(mEvent);
            ++idx;
        }
        this.setDefinedTypesText(this.getTypes());
    }

    public void checkStateChanged(CheckStateChangedEvent event) {
        if (!this.ignoreModifyEvents) {
            this.fireModifiedEvent();
        }
        this.ignoreModifyEvents = false;
    }

    private void addSelectionButtons(Composite composite) {
    }

    protected static Button createPushButton(Composite group, String label, String tooltip) {
        Button button = UDTypesEditorFiles.createPushButton(group, label);
        button.setToolTipText(tooltip);
        return button;
    }

    public static Button createPushButton(Composite group, String label) {
        Button button = new Button(group, 8);
        button.setText(label);
        GridData data = new GridData(768);
        button.setLayoutData((Object)data);
        return button;
    }

    private void addUserDefinedEntries(List result) {
        StringTokenizer tokenizer = new StringTokenizer(this.userDefinedText.getText(), TYPE_DELIMITER);
        while (tokenizer.hasMoreTokens()) {
            String currentExtension = tokenizer.nextToken().trim();
            if (currentExtension.equals("")) continue;
            if (currentExtension.startsWith("*.")) {
                result.add(currentExtension.substring(2));
                continue;
            }
            if (currentExtension.startsWith(".")) {
                result.add(currentExtension.substring(1));
                continue;
            }
            result.add(currentExtension);
        }
    }

    private void checkInitialSelections() {
        if (this.inpTypes == null || this.inpTypes.size() == 0) {
            return;
        }
        IFileEditorMapping[] editorMappings = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        ArrayList<String> selectedMappings = new ArrayList<String>();
        int i = 0;
        while (i < editorMappings.length) {
            IFileEditorMapping mapping = editorMappings[i];
            if (this.inpTypes.contains(mapping.getLabel())) {
                this.typesSelectionList.setChecked((Object)mapping, true);
                selectedMappings.add(mapping.getLabel());
            } else if (mapping.getName().equals("*")) {
                if (this.inpTypes.contains(mapping.getExtension())) {
                    this.typesSelectionList.setChecked((Object)mapping, true);
                    selectedMappings.add(mapping.getExtension());
                }
            } else if (mapping.getExtension().equals("") && this.inpTypes.contains(String.valueOf(mapping.getName()) + NO_EXTENSION_PLACEHOLDER)) {
                this.typesSelectionList.setChecked((Object)mapping, true);
                selectedMappings.add(String.valueOf(mapping.getName()) + NO_EXTENSION_PLACEHOLDER);
            }
            ++i;
        }
        Iterator initialIterator = this.inpTypes.iterator();
        StringBuffer entries = new StringBuffer();
        while (initialIterator.hasNext()) {
            String nextExtension = (String)initialIterator.next();
            if (selectedMappings.contains(nextExtension)) continue;
            entries.append(nextExtension);
            entries.append(',');
        }
        this.userDefinedText.setText(entries.toString());
    }

    private Composite createUserEntryGroup(Composite parent) {
        int nbrColumns = 2;
        Composite composite = SystemWidgetHelpers.createFlushComposite((Composite)parent, (int)nbrColumns);
        this.userDefinedText = SystemWidgetHelpers.createLabeledTextField((Composite)composite, null, (String)SystemUDAResources.RESID_UDT_FILES_USERTYPES_LABEL, (String)SystemUDAResources.RESID_UDT_FILES_USERTYPES_TOOLTIP);
        this.userDefinedText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                if (!UDTypesEditorFiles.this.ignoreModifyEvents) {
                    UDTypesEditorFiles.this.fireModifiedEvent();
                }
                UDTypesEditorFiles.this.ignoreModifyEvents = false;
            }
        });
        SystemWidgetHelpers.setHelp((Control)this.userDefinedText, (String)"org.eclipse.rse.ui.wwnt0002");
        return composite;
    }

    private IFileEditorMapping[] getInput() {
        if (this.currentInput == null) {
            this.currentInput = PlatformUI.getWorkbench().getEditorRegistry().getFileEditorMappings();
        }
        return this.currentInput;
    }

    private void initializeViewer() {
        this.typesSelectionList.setInput((Object)this.getInput());
    }

    protected List getSelectedTypes() {
        IFileEditorMapping[] children = this.getInput();
        ArrayList<String> list = new ArrayList<String>();
        int i = 0;
        while (i < children.length) {
            IFileEditorMapping element = children[i];
            if (this.typesSelectionList.getChecked((Object)element)) {
                if (element.getName().equals("*")) {
                    list.add(element.getExtension());
                } else if (element.getExtension().equals("")) {
                    list.add(String.valueOf(element.getName()) + NO_EXTENSION_PLACEHOLDER);
                } else {
                    list.add(element.getLabel());
                }
            }
            ++i;
        }
        this.addUserDefinedEntries(list);
        return list;
    }

    protected boolean areTypesSelected() {
        IFileEditorMapping[] children = this.getInput();
        int i = 0;
        while (i < children.length) {
            IFileEditorMapping element = children[i];
            if (this.typesSelectionList.getChecked((Object)element)) {
                return true;
            }
            ++i;
        }
        String udtText = this.userDefinedText.getText().trim();
        return udtText.length() != 0;
    }
}

