/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.importexport.files;

import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.rse.internal.importexport.files.IRemoteFileExportDescriptionReader;
import org.eclipse.rse.internal.importexport.files.RemoteExportWizard;
import org.eclipse.rse.internal.importexport.files.RemoteFileExportData;
import org.eclipse.rse.internal.importexport.files.RemoteFileImportExportActionDelegate;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.swt.widgets.Shell;
import org.xml.sax.SAXException;

public class RemoteFileOpenExportWizardActionDelegate
extends RemoteFileImportExportActionDelegate {
    public void run(IAction action) {
        Shell parent = this.getShell();
        RemoteFileExportData exportData = null;
        IFile file = this.getDescriptionFile(this.getSelection());
        if (file == null) {
            SystemBasePlugin.logError((String)"No description file found");
            return;
        }
        try {
            exportData = this.readRemoteFileExportData(file);
        }
        catch (CoreException e) {
            SystemBasePlugin.logError((String)("Error occured trying to read description file" + file.getFullPath()), (Throwable)e);
            return;
        }
        catch (IOException e) {
            SystemBasePlugin.logError((String)("Error occured trying to read description file" + file.getFullPath()), (Throwable)e);
            return;
        }
        catch (SAXException e) {
            SystemBasePlugin.logError((String)("Error occured trying to read description file" + file.getFullPath()), (Throwable)e);
            return;
        }
        if (exportData == null) {
            SystemBasePlugin.logError((String)"No export data");
            return;
        }
        RemoteExportWizard wizard = new RemoteExportWizard();
        wizard.init(this.getWorkbench(), exportData);
        WizardDialog dialog = new WizardDialog(parent, (IWizard)wizard);
        dialog.create();
        dialog.open();
    }

    private RemoteFileExportData readRemoteFileExportData(IFile description) throws CoreException, IOException, SAXException {
        Assert.isLegal((boolean)description.isAccessible());
        Assert.isNotNull((Object)description.getFileExtension());
        Assert.isLegal((boolean)description.getFileExtension().equals("rexpfd"));
        RemoteFileExportData exportData = new RemoteFileExportData();
        IRemoteFileExportDescriptionReader reader = null;
        try {
            reader = exportData.createExportDescriptionReader(description.getContents());
            reader.read(exportData);
        }
        finally {
            if (reader != null) {
                reader.close();
            }
        }
        return exportData;
    }
}

