/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.subsystems.files.scp;

import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IConnectorService;
import org.eclipse.rse.core.subsystems.ISubSystem;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorService;
import org.eclipse.rse.internal.connectorservice.ssh.SshConnectorServiceManager;
import org.eclipse.rse.internal.services.ssh.ISshService;
import org.eclipse.rse.internal.services.ssh.ISshSessionProvider;
import org.eclipse.rse.internal.subsystems.files.scp.ScpFileAdapter;
import org.eclipse.rse.internal.subsystems.files.scp.ScpFileService;
import org.eclipse.rse.services.clientserver.SystemSearchString;
import org.eclipse.rse.services.files.IFileService;
import org.eclipse.rse.services.search.IHostSearchResultConfiguration;
import org.eclipse.rse.services.search.IHostSearchResultSet;
import org.eclipse.rse.services.search.ISearchService;
import org.eclipse.rse.subsystems.files.core.ILanguageUtilityFactory;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystemConfiguration;
import org.eclipse.rse.subsystems.files.core.subsystems.IHostFileToRemoteFileAdapter;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ScpFileSubSystemConfiguration
extends FileServiceSubSystemConfiguration {
    protected IHostFileToRemoteFileAdapter _hostFileAdapter;

    public ScpFileSubSystemConfiguration() {
        this.setIsUnixStyle(true);
    }

    public ISubSystem createSubSystemInternal(IHost host) {
        IConnectorService connectorService = this.getConnectorService(host);
        IFileService fileService = this.getFileService(host);
        FileServiceSubSystem subsys = new FileServiceSubSystem(host, connectorService, fileService, this.getHostFileAdapter(), this.getSearchService(host));
        return subsys;
    }

    public IFileService createFileService(IHost host) {
        SshConnectorService connectorService = (SshConnectorService)this.getConnectorService(host);
        return new ScpFileService((ISshSessionProvider)connectorService);
    }

    public IHostFileToRemoteFileAdapter getHostFileAdapter() {
        if (this._hostFileAdapter == null) {
            this._hostFileAdapter = new ScpFileAdapter();
        }
        return this._hostFileAdapter;
    }

    public ILanguageUtilityFactory getLanguageUtilityFactory(IRemoteFileSubSystem arg0) {
        return null;
    }

    public IConnectorService getConnectorService(IHost host) {
        return SshConnectorServiceManager.getInstance().getConnectorService(host, this.getServiceImplType());
    }

    public Class<?> getServiceImplType() {
        return ISshService.class;
    }

    public boolean supportsArchiveManagement() {
        return false;
    }

    public boolean supportsFileTypes() {
        return false;
    }

    public boolean supportsSearch() {
        return false;
    }

    public ISearchService createSearchService(IHost arg0) {
        return null;
    }

    public IHostSearchResultConfiguration createSearchConfiguration(IHost arg0, IHostSearchResultSet arg1, Object arg2, SystemSearchString arg3) {
        return null;
    }
}

