/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.connectorservice.wince;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.BasicConnectorService;
import org.eclipse.rse.internal.connectorservice.wince.Messages;
import org.eclipse.rse.internal.services.wince.IRapiSessionProvider;
import org.eclipse.tm.rapi.IRapiDesktop;
import org.eclipse.tm.rapi.IRapiDevice;
import org.eclipse.tm.rapi.IRapiEnumDevices;
import org.eclipse.tm.rapi.IRapiSession;
import org.eclipse.tm.rapi.Rapi;
import org.eclipse.tm.rapi.RapiException;

public class WinCEConnectorService
extends BasicConnectorService
implements IRapiSessionProvider {
    IRapiDesktop desktop = null;
    IRapiEnumDevices enumDevices = null;
    IRapiDevice device = null;
    IRapiSession session = null;

    public WinCEConnectorService(IHost host) {
        super(Messages.WinCEConnectorService_0, Messages.WinCEConnectorService_1, host, 0);
    }

    protected void internalConnect(IProgressMonitor monitor) throws Exception {
        this.fireCommunicationsEvent(1);
        Rapi.initialize((int)0);
        try {
            this.desktop = IRapiDesktop.getInstance();
            this.enumDevices = this.desktop.enumDevices();
            this.device = this.enumDevices.next();
            this.session = this.device.createSession();
            this.session.init();
        }
        catch (RapiException re) {
            throw new Exception("Cannot connect to the remote device (" + re.getMessage() + ")", re);
        }
    }

    protected void internalDisconnect(IProgressMonitor monitor) throws Exception {
        this.fireCommunicationsEvent(3);
        if (this.session != null) {
            this.session.uninit();
            this.session.release();
            this.session = null;
        }
        if (this.device != null) {
            this.device.release();
            this.device = null;
        }
        if (this.enumDevices != null) {
            this.enumDevices.release();
            this.enumDevices = null;
        }
        if (this.desktop != null) {
            this.desktop.release();
            this.desktop = null;
        }
    }

    public boolean isConnected() {
        if (this.device != null) {
            try {
                return this.device.isConnected();
            }
            catch (RapiException rapiException) {}
        }
        return false;
    }

    public IRapiSession getSession() {
        return this.session;
    }
}

