/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.internal.files.ui.actions;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.util.NLS;
import org.eclipse.rse.core.RSECorePlugin;
import org.eclipse.rse.core.events.ISystemResourceChangeEvent;
import org.eclipse.rse.core.events.SystemResourceChangeEvent;
import org.eclipse.rse.core.subsystems.SubSystem;
import org.eclipse.rse.files.ui.dialogs.FileDialogFactory;
import org.eclipse.rse.files.ui.dialogs.ISaveAsDialog;
import org.eclipse.rse.files.ui.resources.SystemEditableRemoteFile;
import org.eclipse.rse.internal.files.ui.FileResources;
import org.eclipse.rse.internal.ui.SystemResources;
import org.eclipse.rse.services.clientserver.messages.CommonMessages;
import org.eclipse.rse.services.clientserver.messages.SimpleSystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessage;
import org.eclipse.rse.services.clientserver.messages.SystemMessageException;
import org.eclipse.rse.services.files.RemoteFileIOException;
import org.eclipse.rse.services.files.RemoteFileSecurityException;
import org.eclipse.rse.subsystems.files.core.SystemIFileProperties;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.SystemBasePlugin;
import org.eclipse.rse.ui.actions.SystemBaseAction;
import org.eclipse.rse.ui.dialogs.SystemPromptDialog;
import org.eclipse.rse.ui.messages.SystemMessageDialog;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.part.FileEditorInput;

public class SystemUploadConflictAction
extends SystemBaseAction
implements Runnable {
    private IFile _tempFile;
    private IRemoteFile _remoteFile;

    public SystemUploadConflictAction(Shell shell, IFile tempFile, IRemoteFile remoteFile, boolean remoteNewer) {
        super(FileResources.RESID_CONFLICT_SAVE_TITLE, shell);
        this._tempFile = tempFile;
        this._remoteFile = remoteFile;
    }

    public void run() {
        SystemIFileProperties properties = new SystemIFileProperties((IResource)this._tempFile);
        UploadConflictDialog cnfDialog = new UploadConflictDialog(SystemBasePlugin.getActiveWorkbenchShell(), this._remoteFile.getName());
        if (cnfDialog.open() == 0) {
            if (cnfDialog.getOverwriteRemote()) {
                BackgroundUploadJob ujob = new BackgroundUploadJob();
                ujob.schedule();
            } else if (cnfDialog.getOverwriteLocal()) {
                BackgroundDownloadJob djob = new BackgroundDownloadJob();
                djob.schedule();
            } else if (cnfDialog.getSaveas()) {
                IRemoteFile remoteFile = cnfDialog.getSaveasLocation();
                BackgroundSaveasJob sjob = new BackgroundSaveasJob(remoteFile);
                sjob.schedule();
            }
        } else {
            properties.setDirty(true);
        }
    }

    private class BackgroundDownloadJob
    extends Job {
        public BackgroundDownloadJob() {
            super("Download");
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IRemoteFileSubSystem fs = SystemUploadConflictAction.this._remoteFile.getParentRemoteFileSubSystem();
                SystemIFileProperties properties = new SystemIFileProperties((IResource)SystemUploadConflictAction.this._tempFile);
                String srcEncoding = RemoteFileUtility.getSourceEncoding((IFile)SystemUploadConflictAction.this._tempFile);
                fs.download(SystemUploadConflictAction.this._remoteFile, SystemUploadConflictAction.this._tempFile.getLocation().makeAbsolute().toOSString(), srcEncoding, monitor);
                properties.setRemoteFileTimeStamp(SystemUploadConflictAction.this._remoteFile.getLastModified());
                properties.setDirty(false);
                properties.setUsedBinaryTransfer(SystemUploadConflictAction.this._remoteFile.isBinary());
            }
            catch (SystemMessageException e) {
                Display.getDefault().asyncExec(new Runnable(this, e){
                    final /* synthetic */ BackgroundDownloadJob this$1;
                    private final /* synthetic */ SystemMessageException val$e;
                    {
                        this.this$1 = backgroundDownloadJob;
                        this.val$e = systemMessageException;
                    }

                    public void run() {
                        SystemMessageDialog.displayMessage((SystemMessageException)this.val$e);
                    }
                });
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            return Status.OK_STATUS;
        }
    }

    private class BackgroundSaveasJob
    extends Job {
        private IRemoteFile _saveasFile;

        public BackgroundSaveasJob(IRemoteFile saveasFile) {
            super("Save as");
            this._saveasFile = saveasFile;
        }

        public IStatus run(IProgressMonitor monitor) {
            if (this._saveasFile != null) {
                IRemoteFileSubSystem fs = this._saveasFile.getParentRemoteFileSubSystem();
                try {
                    if (!this._saveasFile.exists()) {
                        this._saveasFile = fs.createFile(this._saveasFile, monitor);
                    }
                }
                catch (SystemMessageException e) {
                    SystemBasePlugin.logError((String)"Error in performSaveAs", (Throwable)e);
                    SimpleSystemMessage message = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG8002", 4, CommonMessages.MSG_ERROR_UNEXPECTED);
                    SystemMessageDialog dialog = new SystemMessageDialog(SystemBasePlugin.getActiveWorkbenchShell(), (SystemMessage)message);
                    SubSystem subSystem = (SubSystem)fs;
                    subSystem.getClass();
                    SubSystem.SystemMessageDialogRunnable runnable = new SubSystem.SystemMessageDialogRunnable(subSystem, dialog);
                    Display.getDefault().asyncExec((Runnable)runnable);
                }
                try {
                    String srcEncoding = RemoteFileUtility.getSourceEncoding((IFile)SystemUploadConflictAction.this._tempFile);
                    fs.upload(SystemUploadConflictAction.this._tempFile.getLocation().makeAbsolute().toOSString(), this._saveasFile, srcEncoding, monitor);
                    SystemIFileProperties properties = new SystemIFileProperties((IResource)SystemUploadConflictAction.this._tempFile);
                    properties.setRemoteFileTimeStamp(0L);
                    properties.setDirty(false);
                }
                catch (SystemMessageException systemMessageException) {}
                ReopenAction reopen = new ReopenAction(SystemUploadConflictAction.this._tempFile, this._saveasFile);
                Display.getDefault().asyncExec((Runnable)reopen);
            }
            return Status.OK_STATUS;
        }
    }

    private class BackgroundUploadJob
    extends Job {
        public BackgroundUploadJob() {
            super("Upload");
        }

        public IStatus run(IProgressMonitor monitor) {
            try {
                IRemoteFileSubSystem fs = SystemUploadConflictAction.this._remoteFile.getParentRemoteFileSubSystem();
                SystemIFileProperties properties = new SystemIFileProperties((IResource)SystemUploadConflictAction.this._tempFile);
                SystemUploadConflictAction.this._remoteFile = fs.getRemoteFileObject(SystemUploadConflictAction.this._remoteFile.getAbsolutePath(), monitor);
                String srcEncoding = RemoteFileUtility.getSourceEncoding((IFile)SystemUploadConflictAction.this._tempFile);
                fs.upload(SystemUploadConflictAction.this._tempFile.getLocation().makeAbsolute().toOSString(), SystemUploadConflictAction.this._remoteFile, srcEncoding, monitor);
                SystemUploadConflictAction.this._remoteFile.markStale(true);
                SystemUploadConflictAction.this._remoteFile = fs.getRemoteFileObject(SystemUploadConflictAction.this._remoteFile.getAbsolutePath(), monitor);
                long ts = SystemUploadConflictAction.this._remoteFile.getLastModified();
                properties.setRemoteFileTimeStamp(ts);
                properties.setDirty(false);
            }
            catch (RemoteFileSecurityException remoteFileSecurityException) {
            }
            catch (RemoteFileIOException remoteFileIOException) {
            }
            catch (Exception exception) {}
            return Status.OK_STATUS;
        }
    }

    public class CloseEditorAction
    implements Runnable {
        public IEditorPart _editor;

        public CloseEditorAction(IEditorPart editor) {
            this._editor = editor;
        }

        public void run() {
            SystemBasePlugin.getActiveWorkbenchWindow().getActivePage().closeEditor(this._editor, false);
        }
    }

    public class ReopenAction
    implements Runnable {
        private IRemoteFile _saveasFile;

        public ReopenAction(IFile tempFile, IRemoteFile saveasFile) {
            this._saveasFile = saveasFile;
        }

        private IEditorPart getEditorFor(IFile tempFile) {
            FileEditorInput finput;
            IEditorPart editor;
            IEditorInput input;
            IWorkbenchPage page;
            IWorkbenchWindow window = SystemBasePlugin.getActiveWorkbenchWindow();
            if (window != null && (page = window.getActivePage()) != null && (input = (editor = page.getActiveEditor()).getEditorInput()) instanceof FileEditorInput && (finput = (FileEditorInput)input).getFile().getFullPath().equals((Object)tempFile.getFullPath())) {
                return editor;
            }
            return null;
        }

        public void run() {
            try {
                this._saveasFile = this._saveasFile.getParentRemoteFileSubSystem().getRemoteFileObject(this._saveasFile.getAbsolutePath(), (IProgressMonitor)new NullProgressMonitor());
                RSECorePlugin.getTheSystemRegistry().fireEvent((ISystemResourceChangeEvent)new SystemResourceChangeEvent((Object)this._saveasFile.getParentRemoteFile(), 82, null));
            }
            catch (SystemMessageException e) {
                e.printStackTrace();
            }
            IEditorPart editor = this.getEditorFor(SystemUploadConflictAction.this._tempFile);
            if (editor != null) {
                editor.getEditorSite().getId();
                SystemEditableRemoteFile edit = new SystemEditableRemoteFile(this._saveasFile);
                try {
                    edit.download(SystemUploadConflictAction.this.getShell());
                    edit.addAsListener();
                    edit.setLocalResourceProperties();
                    edit.openEditor();
                    CloseEditorAction closeAction = new CloseEditorAction(editor);
                    Display.getDefault().asyncExec((Runnable)closeAction);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    private class UploadConflictDialog
    extends SystemPromptDialog
    implements SelectionListener {
        private Button _overwriteLocalButton;
        private Button _overwriteRemoteButton;
        private Button _saveasButton;
        private Button _browseButton;
        private Text _saveasFileEntry;
        private boolean _overwriteLocal;
        private boolean _overwriteRemote;
        private boolean _saveas;
        private SystemMessage _errorMessage;
        private IRemoteFile _saveasLocation;
        private String _uploadFile;

        public UploadConflictDialog(Shell shell, String file) {
            super(shell, FileResources.RESID_CONFLICT_SAVE_TITLE);
            this._uploadFile = file;
        }

        protected void buttonPressed(int buttonId) {
            this.setReturnCode(buttonId);
            this._overwriteLocal = this._overwriteLocalButton.getSelection();
            this._overwriteRemote = this._overwriteRemoteButton.getSelection();
            this._saveas = this._saveasButton.getSelection();
            this.close();
        }

        public boolean getOverwriteLocal() {
            return this._overwriteLocal;
        }

        public boolean getOverwriteRemote() {
            return this._overwriteRemote;
        }

        public boolean getSaveas() {
            return this._saveas;
        }

        public IRemoteFile getSaveasLocation() {
            return this._saveasLocation;
        }

        public Control createInner(Composite parent) {
            Image image = this.getShell().getDisplay().getSystemImage(4);
            Composite c = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.numColumns = 1;
            c.setLayout((Layout)layout);
            c.setLayoutData((Object)new GridData(1808));
            Composite m = new Composite(c, 0);
            GridLayout mlayout = new GridLayout();
            mlayout.numColumns = 2;
            m.setLayout((Layout)mlayout);
            m.setLayoutData((Object)new GridData(4, 128, true, false));
            Label label = new Label(m, 0);
            image.setBackground(label.getBackground());
            label.setImage(image);
            label.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
            Text text = new Text(m, 66);
            text.setEditable(false);
            text.setText(NLS.bind((String)FileResources.RESID_CONFLICT_SAVE_MESSAGE, (Object)this._uploadFile));
            GridData textData = new GridData(4, 0x1000000, true, false);
            text.setLayoutData((Object)textData);
            Composite options = new Composite(c, 0);
            GridLayout olayout = new GridLayout();
            olayout.numColumns = 1;
            options.setLayout((Layout)olayout);
            options.setLayoutData((Object)new GridData(1808));
            this._overwriteLocalButton = new Button(options, 16);
            this._overwriteLocalButton.setText(FileResources.RESID_CONFLICT_SAVE_REPLACELOCAL);
            this._overwriteLocalButton.addSelectionListener((SelectionListener)this);
            this._overwriteRemoteButton = new Button(options, 16);
            this._overwriteRemoteButton.setText(FileResources.RESID_CONFLICT_SAVE_OVERWRITEREMOTE);
            this._overwriteRemoteButton.addSelectionListener((SelectionListener)this);
            this._saveasButton = new Button(options, 16);
            this._saveasButton.setText(FileResources.RESID_CONFLICT_SAVE_SAVETODIFFERENT);
            this._saveasButton.addSelectionListener((SelectionListener)this);
            this._saveasButton.setSelection(true);
            Composite s = new Composite(options, 0);
            GridLayout slayout = new GridLayout();
            slayout.numColumns = 2;
            s.setLayout((Layout)slayout);
            s.setLayoutData((Object)new GridData(1808));
            this._saveasFileEntry = new Text(s, 2048);
            this._saveasFileEntry.setEnabled(true);
            GridData fileEntryData = new GridData(1808);
            fileEntryData.widthHint = 100;
            this._saveasFileEntry.setLayoutData((Object)fileEntryData);
            this._saveasFileEntry.setEditable(true);
            this._browseButton = new Button(s, 8);
            this._browseButton.setText(SystemResources.BUTTON_BROWSE);
            this._browseButton.addSelectionListener((SelectionListener)this);
            this._browseButton.setEnabled(true);
            this.enableOkButton(false);
            this._errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1032", 4, FileResources.MSG_VALIDATE_PATH_EMPTY, FileResources.MSG_VALIDATE_PATH_EMPTY_DETAILS);
            this.setErrorMessage(this._errorMessage);
            this.setHelp();
            return c;
        }

        public void widgetSelected(SelectionEvent e) {
            if (this._saveasButton.getSelection()) {
                this._browseButton.setEnabled(true);
                this._saveasFileEntry.setEnabled(true);
                if (this._saveasLocation != null) {
                    this._errorMessage = null;
                    this.setErrorMessage(this._errorMessage);
                    this.enableOkButton(true);
                } else {
                    this.enableOkButton(false);
                    this._errorMessage = new SimpleSystemMessage("org.eclipse.rse.files.ui", "RSEG1032", 4, FileResources.MSG_VALIDATE_PATH_EMPTY, FileResources.MSG_VALIDATE_PATH_EMPTY_DETAILS);
                    this.setErrorMessage(this._errorMessage);
                }
            } else {
                this._browseButton.setEnabled(false);
                this._saveasFileEntry.setEnabled(false);
                this.enableOkButton(true);
                this._errorMessage = null;
                this.setErrorMessage(this._errorMessage);
            }
            if (e.getSource() == this._browseButton) {
                ISaveAsDialog dlg = FileDialogFactory.makeSaveAsDialog(this.getShell());
                dlg.setMultipleSelectionMode(false);
                if (SystemUploadConflictAction.this._remoteFile != null) {
                    Object output;
                    dlg.setPreSelection(SystemUploadConflictAction.this._remoteFile);
                    if (dlg.open() == 0 && (output = dlg.getOutputObject()) instanceof IRemoteFile) {
                        IRemoteFile toCreate = (IRemoteFile)output;
                        try {
                            this._errorMessage = null;
                            this._saveasLocation = toCreate;
                            this._saveasFileEntry.setText(toCreate.getAbsolutePath());
                            this.enableOkButton(this._errorMessage == null);
                            this.setErrorMessage(this._errorMessage);
                        }
                        catch (Exception exception) {}
                    }
                }
            }
        }

        public void widgetDefaultSelected(SelectionEvent e) {
        }

        protected Control getInitialFocusControl() {
            this.enableOkButton(true);
            return this._overwriteLocalButton;
        }

        private void setHelp() {
            this.setHelp("org.eclipse.rse.ui.scdl0000");
        }
    }
}

