/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.dstore.security.preference;

import java.security.cert.X509Certificate;
import java.util.Date;
import org.eclipse.rse.dstore.security.preference.Element;

public class X509CertificateElement
extends Element {
    public static int CERT_NAME = 0;
    public static int CERT_UNIT = 1;
    public static int CERT_ORGANIZATION = 2;
    public static int CERT_CITY = 3;
    public static int CERT_PROVINCE = 4;
    public static int CERT_COUNTRY = 5;
    private X509Certificate _cert;

    public X509CertificateElement(String alias, String value, X509Certificate cert) {
        super(alias, value);
        this._cert = cert;
    }

    public String getType() {
        return this._cert.getType();
    }

    public String getVersion() {
        return "V." + this._cert.getVersion();
    }

    private String[] parse(String full) {
        StringBuffer result = new StringBuffer();
        char[] chars = full.toCharArray();
        boolean inQuotes = false;
        int i = 0;
        while (i < chars.length) {
            int c = chars[i];
            if (c == 34) {
                inQuotes = !inQuotes;
            } else if (c == 44 && !inQuotes) {
                c = 59;
            }
            result.append((char)c);
            ++i;
        }
        return result.toString().split(";");
    }

    private String extract(String full, int index) {
        String[] pairs = this.parse(full);
        String match = pairs[index].split("=")[1];
        return match;
    }

    public String getIssuerDN() {
        String full = this._cert.getIssuerDN().getName();
        return full;
    }

    public String getIssuerName() {
        String full = this._cert.getIssuerDN().getName();
        return this.extract(full, CERT_NAME);
    }

    public String getIssuerUnit() {
        String full = this._cert.getIssuerDN().getName();
        return this.extract(full, CERT_UNIT);
    }

    public String getIssuerOrg() {
        String full = this._cert.getIssuerDN().getName();
        return this.extract(full, CERT_ORGANIZATION);
    }

    public String getIssuerCity() {
        String full = this._cert.getIssuerDN().getName();
        return this.extract(full, CERT_CITY);
    }

    public String getIssuerProvince() {
        String full = this._cert.getIssuerDN().getName();
        return this.extract(full, CERT_PROVINCE);
    }

    public String getIssuerCountry() {
        String full = this._cert.getIssuerDN().getName();
        return this.extract(full, CERT_COUNTRY);
    }

    public String getSubjectDN() {
        String full = this._cert.getSubjectDN().getName();
        return full;
    }

    public String getSubjectName() {
        String full = this._cert.getSubjectDN().getName();
        return this.extract(full, CERT_NAME);
    }

    public String getSubjectUnit() {
        String full = this._cert.getSubjectDN().getName();
        return this.extract(full, CERT_UNIT);
    }

    public String getSubjectOrg() {
        String full = this._cert.getSubjectDN().getName();
        return this.extract(full, CERT_ORGANIZATION);
    }

    public String getSubjectCity() {
        String full = this._cert.getSubjectDN().getName();
        return this.extract(full, CERT_CITY);
    }

    public String getSubjectProvince() {
        String full = this._cert.getSubjectDN().getName();
        return this.extract(full, CERT_PROVINCE);
    }

    public String getSubjectCountry() {
        String full = this._cert.getSubjectDN().getName();
        return this.extract(full, CERT_COUNTRY);
    }

    public String getNotBefore() {
        return this._cert.getNotBefore().toString();
    }

    public String getNotAfter() {
        return this._cert.getNotAfter().toString();
    }

    public String getExpirationDate() {
        Date date = this._cert.getNotAfter();
        return date.toString();
    }

    public String getSigAlgName() {
        return this._cert.getSigAlgName();
    }

    public String getSerialNumber() {
        return this._cert.getSerialNumber().toString();
    }

    public String getAlgorithm() {
        return this._cert.getPublicKey().getAlgorithm();
    }

    public String getFormat() {
        return this._cert.getPublicKey().getFormat();
    }

    public Object getCert() {
        return this._cert;
    }
}

