/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.actions;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.files.ui.FileResources;
import org.eclipse.rse.files.ui.ISystemAddFileListener;
import org.eclipse.rse.files.ui.dialogs.SystemRemoteFileDialog;
import org.eclipse.rse.subsystems.files.core.model.RemoteFileUtility;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFile;
import org.eclipse.rse.subsystems.files.core.subsystems.IRemoteFileSubSystem;
import org.eclipse.rse.ui.actions.SystemBaseDialogAction;
import org.eclipse.rse.ui.dialogs.SystemRemoteResourceDialog;
import org.eclipse.rse.ui.validators.IValidatorRemoteSelection;
import org.eclipse.rse.ui.view.SystemActionViewerFilter;
import org.eclipse.swt.widgets.Shell;

public class SystemRemoteFileSelectAction
extends SystemBaseDialogAction {
    private String[] systemTypes;
    private IHost systemConnection;
    private IHost outputConnection;
    private IRemoteFile preSelection;
    private String rootFolderAbsPath;
    private String message;
    private String treeTip;
    private String dlgTitle;
    private boolean showPropertySheet = false;
    private boolean showPropertySheetDetailsButtonInitialState;
    private boolean showPropertySheetDetailsButton = false;
    private boolean multipleSelectionMode = false;
    private boolean onlyConnection = false;
    private IValidatorRemoteSelection selectionValidator;
    private SystemActionViewerFilter customViewerFilter = null;

    public SystemRemoteFileSelectAction(Shell shell) {
        this(shell, FileResources.ACTION_SELECT_DIRECTORY_LABEL, FileResources.ACTION_SELECT_DIRECTORY_TOOLTIP);
    }

    public SystemRemoteFileSelectAction(Shell shell, String label, String tooltip) {
        super(label, tooltip, null, shell);
        super.setNeedsProgressMonitor(true);
    }

    public void setDialogTitle(String title) {
        this.dlgTitle = title;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setSelectionTreeToolTipText(String tip) {
        this.treeTip = tip;
    }

    public void setHost(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = true;
    }

    public void setDefaultConnection(IHost conn) {
        this.systemConnection = conn;
        this.onlyConnection = false;
    }

    public void setSystemTypes(String[] systemTypes) {
        this.systemTypes = systemTypes;
    }

    public void setSystemType(String systemType) {
        if (systemType == null) {
            this.setSystemTypes(null);
        } else {
            this.setSystemTypes(new String[]{systemType});
        }
    }

    public void setShowNewConnectionPrompt(boolean show) {
    }

    public void setRootFolder(IHost connection, String folderAbsolutePath) {
        this.systemConnection = connection;
        this.rootFolderAbsPath = folderAbsolutePath;
        IRemoteFileSubSystem ss = RemoteFileUtility.getFileSubSystem((IHost)connection);
        if (ss != null) {
            try {
                IRemoteFile rootFolder = ss.getRemoteFileObject(this.rootFolderAbsPath);
                if (rootFolder != null) {
                    this.setPreSelection(rootFolder);
                }
            }
            catch (Exception exception) {}
        }
        this.onlyConnection = true;
    }

    public void setRootFolder(IRemoteFile rootFolder) {
        this.setRootFolder(rootFolder.getSystemConnection(), rootFolder.getAbsolutePath());
    }

    public void setPreSelection(IRemoteFile selection) {
        this.preSelection = selection;
    }

    public void enableAddMode(ISystemAddFileListener caller) {
    }

    public void enableAddMode(ISystemAddFileListener caller, String addLabel, String addToolTipText) {
        this.enableAddMode(caller);
    }

    public void setShowPropertySheet(boolean show) {
        this.showPropertySheet = show;
    }

    public void setShowPropertySheet(boolean show, boolean initialState) {
        this.setShowPropertySheet(show);
        if (show) {
            this.showPropertySheetDetailsButton = true;
            this.showPropertySheetDetailsButtonInitialState = initialState;
        }
    }

    public void setMultipleSelectionMode(boolean multiple) {
        this.multipleSelectionMode = multiple;
    }

    public void setAllowForMultipleParents(boolean multiple) {
    }

    public void setSelectionValidator(IValidatorRemoteSelection selectionValidator) {
        this.selectionValidator = selectionValidator;
    }

    public IRemoteFile getSelectedFile() {
        Object o = this.getValue();
        if (o instanceof IRemoteFile[]) {
            return ((IRemoteFile[])o)[0];
        }
        if (o instanceof IRemoteFile) {
            return (IRemoteFile)o;
        }
        return null;
    }

    public IRemoteFile[] getSelectedFiles() {
        Object o = this.getValue();
        if (o instanceof IRemoteFile[]) {
            return (IRemoteFile[])o;
        }
        if (o instanceof IRemoteFile) {
            return new IRemoteFile[]{(IRemoteFile)o};
        }
        if (o instanceof Object[]) {
            Object[] objs = (Object[])o;
            IRemoteFile[] files = new IRemoteFile[objs.length];
            int i = 0;
            while (i < objs.length) {
                files[i] = (IRemoteFile)objs[i];
                ++i;
            }
            return files;
        }
        return new IRemoteFile[0];
    }

    public Object[] getSelectedObjects() {
        Object remoteObject = this.getValue();
        if (remoteObject == null) {
            return null;
        }
        if (remoteObject instanceof Object[]) {
            return (Object[])remoteObject;
        }
        if (remoteObject instanceof IRemoteFile[]) {
            return (Object[])remoteObject;
        }
        if (remoteObject != null) {
            return new Object[]{remoteObject};
        }
        return null;
    }

    public IHost getSelectedConnection() {
        return this.outputConnection;
    }

    protected SystemRemoteResourceDialog createRemoteResourceDialog(Shell shell, String title) {
        return new SystemRemoteFileDialog(shell, title);
    }

    protected SystemRemoteResourceDialog createRemoteResourceDialog(Shell shell) {
        return new SystemRemoteFileDialog(shell);
    }

    protected Dialog createDialog(Shell shell) {
        SystemRemoteResourceDialog dlg = null;
        dlg = this.dlgTitle == null ? this.createRemoteResourceDialog(shell) : this.createRemoteResourceDialog(shell, this.dlgTitle);
        if (this.customViewerFilter != null) {
            dlg.setCustomViewerFilter(this.customViewerFilter);
        }
        dlg.setMultipleSelectionMode(this.multipleSelectionMode);
        if (this.message != null) {
            dlg.setMessage(this.message);
        }
        if (this.treeTip != null) {
            dlg.setSelectionTreeToolTipText(this.treeTip);
        }
        if (this.systemConnection != null) {
            dlg.setDefaultSystemConnection(this.systemConnection, this.onlyConnection);
        }
        if (this.systemTypes != null) {
            dlg.setSystemTypes(this.systemTypes);
        }
        if (this.preSelection != null) {
            dlg.setPreSelection((Object)this.preSelection);
        }
        if (this.showPropertySheet) {
            if (this.showPropertySheetDetailsButton) {
                dlg.setShowPropertySheet(true, this.showPropertySheetDetailsButtonInitialState);
            } else {
                dlg.setShowPropertySheet(true);
            }
        }
        if (this.selectionValidator != null) {
            dlg.setSelectionValidator(this.selectionValidator);
        }
        return dlg;
    }

    protected Object getDialogValue(Dialog dlg) {
        SystemRemoteResourceDialog ourDlg = (SystemRemoteResourceDialog)dlg;
        Object outputObject = null;
        this.outputConnection = null;
        if (!ourDlg.wasCancelled()) {
            outputObject = this.multipleSelectionMode ? ourDlg.getSelectedObjects() : ourDlg.getSelectedObject();
            this.outputConnection = ourDlg.getSelectedConnection();
        }
        return outputObject;
    }

    public void setCustomViewerFilter(SystemActionViewerFilter filter) {
        this.customViewerFilter = filter;
    }
}

