/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.rse.files.ui.propertypages;

import java.util.ArrayList;
import org.eclipse.rse.core.model.IHost;
import org.eclipse.rse.core.subsystems.IServiceSubSystemConfiguration;
import org.eclipse.rse.core.subsystems.ISubSystemConfiguration;
import org.eclipse.rse.model.SystemRegistry;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.FileServiceSubSystem;
import org.eclipse.rse.subsystems.files.core.servicesubsystem.IFileServiceSubSystemConfiguration;
import org.eclipse.rse.ui.RSEUIPlugin;
import org.eclipse.rse.ui.propertypages.ServicesPropertyPage;
import org.eclipse.rse.ui.widgets.services.FactoryServiceElement;
import org.eclipse.rse.ui.widgets.services.ServiceElement;

public class FileServicesPropertyPage
extends ServicesPropertyPage {
    private IFileServiceSubSystemConfiguration _currentFactory;

    protected FileServiceSubSystem getFileServiceSubSystem() {
        return (FileServiceSubSystem)this.getElement();
    }

    protected ServiceElement[] getServiceElements() {
        FileServiceSubSystem subSystem = this.getFileServiceSubSystem();
        IHost host = subSystem.getHost();
        this._currentFactory = (IFileServiceSubSystemConfiguration)subSystem.getParentRemoteFileSubSystemConfiguration();
        IFileServiceSubSystemConfiguration[] factories = this.getFileServiceSubSystemFactories(host.getSystemType());
        ServiceElement[] elements = new ServiceElement[factories.length];
        int i = 0;
        while (i < factories.length) {
            IFileServiceSubSystemConfiguration factory = factories[i];
            elements[i] = new FactoryServiceElement(host, (IServiceSubSystemConfiguration)factory);
            if (factory == this._currentFactory) {
                elements[i].setSelected(true);
            }
            ++i;
        }
        return elements;
    }

    protected IFileServiceSubSystemConfiguration[] getFileServiceSubSystemFactories(String systemType) {
        ArrayList<ISubSystemConfiguration> results = new ArrayList<ISubSystemConfiguration>();
        SystemRegistry sr = RSEUIPlugin.getTheSystemRegistry();
        ISubSystemConfiguration[] factories = sr.getSubSystemConfigurationsBySystemType(systemType);
        int i = 0;
        while (i < factories.length) {
            ISubSystemConfiguration factory = factories[i];
            if (factory instanceof IFileServiceSubSystemConfiguration) {
                results.add(factory);
            }
            ++i;
        }
        return results.toArray(new IFileServiceSubSystemConfiguration[results.size()]);
    }

    protected IServiceSubSystemConfiguration getCurrentServiceSubSystemConfiguration() {
        return this._currentFactory;
    }

    public void setSubSystemConfiguration(ISubSystemConfiguration factory) {
        this._currentFactory = (IFileServiceSubSystemConfiguration)factory;
    }
}

